/*
 * Decompiled with CFR 0.152.
 */
package gov.fnal.srm.util;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.globus.util.GlobusURL;

public class Report {
    public static final int OK_RC = 0;
    public static final int ERROR_RC = 1;
    public static final int FILE_EXISTS_RC = 2;
    public static final int PERMISSION_RC = 3;
    public static final int MAX_RC_VALUE = 3;
    public static final String INITIAL_ERROR = "copy did not complete or status unknown";
    GlobusURL[] from;
    GlobusURL[] to;
    int[] rc;
    String[] error;
    int length;
    private File reportFile;

    public Report(GlobusURL[] from, GlobusURL[] to, String reportFileName) {
        if (from == null || to == null) {
            throw new NullPointerException("from url array and to url array should not be null");
        }
        if (reportFileName != null) {
            this.reportFile = new File(reportFileName);
            try {
                if (this.reportFile.exists() ? !this.reportFile.canWrite() : !this.reportFile.createNewFile()) {
                    throw new IllegalArgumentException(" can not write into report file : " + reportFileName);
                }
            }
            catch (IOException ioe) {
                throw new IllegalArgumentException(" can not write into report file : " + reportFileName + " : " + ioe);
            }
        }
        this.from = from;
        this.to = to;
        this.length = from.length;
        if (to.length != this.length) {
            throw new IllegalArgumentException("legths of from and to archives should be the same");
        }
        this.rc = new int[this.length];
        this.error = new String[this.length];
        for (int i = 0; i < this.length; ++i) {
            this.rc[i] = 1;
            this.error[i] = INITIAL_ERROR;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.length; ++i) {
            sb.append(this.from[i].getURL());
            sb.append(' ');
            sb.append(this.to[i].getURL());
            sb.append(' ');
            sb.append(this.rc[i]);
            if (this.rc[i] != 0) {
                sb.append(' ');
                sb.append(this.error[i].replace('\n', ' '));
            }
            sb.append('\n');
        }
        return sb.toString();
    }

    public void setStatusBySourceUrl(GlobusURL srcURL, int returnCode, String errorDscr) {
        if (!this.isValidRC(returnCode)) {
            throw new IllegalArgumentException("illegal return code value : " + returnCode);
        }
        for (int i = 0; i < this.length; ++i) {
            if (!srcURL.getURL().equals(this.from[i].getURL()) || !srcURL.getHost().equals(this.from[i].getHost()) || !srcURL.getProtocol().equals(this.from[i].getProtocol())) continue;
            this.rc[i] = returnCode;
            if (returnCode == 0) continue;
            this.error[i] = errorDscr;
        }
    }

    public void setStatusByDestinationUrl(GlobusURL dstURL, int returnCode, String errorDscr) {
        if (!this.isValidRC(returnCode)) {
            throw new IllegalArgumentException("illegal return code value : " + returnCode);
        }
        for (int i = 0; i < this.length; ++i) {
            if (!dstURL.getURL().equals(this.to[i].getURL()) || !dstURL.getHost().equals(this.to[i].getHost()) || !dstURL.getProtocol().equals(this.to[i].getProtocol())) continue;
            this.rc[i] = returnCode;
            if (returnCode != 0) {
                this.error[i] = errorDscr;
            }
            return;
        }
        throw new IllegalArgumentException("record for dest=" + dstURL.getURL() + " not found");
    }

    public void setStatusBySourceDestinationUrl(GlobusURL srcURL, GlobusURL dstURL, int returnCode, String errorDscr) {
        if (!this.isValidRC(returnCode)) {
            throw new IllegalArgumentException("illegal return code value : " + returnCode);
        }
        for (int i = 0; i < this.length; ++i) {
            if (!dstURL.getURL().equals(this.to[i].getURL()) || !dstURL.getHost().equals(this.to[i].getHost()) || !dstURL.getProtocol().equals(this.to[i].getProtocol()) || !srcURL.getURL().equals(this.from[i].getURL()) || !srcURL.getHost().equals(this.from[i].getHost()) || !srcURL.getProtocol().equals(this.from[i].getProtocol())) continue;
            this.rc[i] = returnCode;
            if (returnCode != 0) {
                this.error[i] = errorDscr;
            }
            return;
        }
        throw new IllegalArgumentException("record for source=" + srcURL.getURL() + " and dest=" + dstURL.getURL() + " not found");
    }

    public boolean isValidRC(int rc) {
        return rc >= 0 && rc <= 3;
    }

    public void dumpReport() {
        if (this.reportFile != null) {
            try {
                FileWriter fw = new FileWriter(this.reportFile);
                fw.write(this.toString());
                fw.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public boolean everythingAllRight() {
        for (int i = 0; i < this.rc.length; ++i) {
            if (this.rc[i] == 0) continue;
            return false;
        }
        return true;
    }
}

