/*
 * Decompiled with CFR 0.152.
 */
package gov.fnal.srm.util;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.StringTokenizer;

public class CopyJobFileReader {
    private String[] sources;
    private String[] destinations;
    private int size;

    public CopyJobFileReader(String file) throws IOException {
        FileInputStream fin = new FileInputStream(file);
        BufferedReader in = new BufferedReader(new InputStreamReader(fin));
        HashSet<String[]> src_dest_set = new HashSet<String[]>();
        try {
            String origline;
            int line_num = 0;
            while ((origline = in.readLine()) != null) {
                ++line_num;
                String line = origline.trim();
                if (line.equals("") || line.startsWith("#")) continue;
                StringTokenizer st = new StringTokenizer(line);
                if (st.countTokens() != 2) {
                    throw new IOException("File format is incorect, line #" + line_num + ": " + origline);
                }
                String source = st.nextToken();
                String dest = st.nextToken();
                src_dest_set.add(new String[]{source, dest});
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        finally {
            in.close();
        }
        this.size = src_dest_set.size();
        String[][] src_dest_array = new String[src_dest_set.size()][];
        src_dest_set.toArray((T[])src_dest_array);
        this.sources = new String[this.size];
        this.destinations = new String[this.size];
        for (int i = 0; i < this.size; ++i) {
            this.sources[i] = src_dest_array[i][0];
            this.destinations[i] = src_dest_array[i][1];
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("# copy job file \n");
        for (int i = 0; i < this.size; ++i) {
            sb.append(this.sources[i]).append(' ').append(this.destinations[i]).append('\n');
        }
        return sb.toString();
    }

    public String[] getSources() {
        return this.sources;
    }

    public String[] getDestinations() {
        return this.destinations;
    }

    public int size() {
        return this.size;
    }

    public static final void main(String[] args) throws IOException {
        if (args == null || args.length != 1) {
            System.err.println("Usage: java gov.fnal.srm.util.CopyJobFileReader <file>");
            System.exit(1);
        }
        System.out.println(new CopyJobFileReader(args[0]).toString());
    }
}

