/*
 * Decompiled with CFR 0.152.
 */
package gov.fnal.srm.util;

import gov.fnal.srm.util.Configuration;
import gov.fnal.srm.util.CopyJob;
import gov.fnal.srm.util.SRMDispatcher;
import gov.fnal.srm.util.ShellCommandExecuter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashSet;
import org.dcache.srm.Logger;
import org.dcache.srm.security.SslGsiSocketFactory;
import org.dcache.srm.util.GridftpClient;
import org.globus.util.GlobusURL;
import org.ietf.jgss.GSSCredential;

public class Copier
implements Runnable {
    private final HashSet<CopyJob> copy_jobs = new HashSet();
    private boolean doneAddingJobs;
    private boolean stop;
    private Thread hook;
    private String urlcopy;
    private boolean debug = false;
    private Configuration configuration;
    private boolean completed;
    private boolean completed_successfully = true;
    private Exception error;
    private Logger logger;
    private long retry_timeout;
    private int retry_num;
    private int num_jobs = 0;
    private int num_completed_successfully = 0;
    private boolean dryRun;

    public final void say(String msg) {
        if (this.logger != null) {
            this.logger.log(msg.toString());
        }
    }

    public final void dsay(String msg) {
        if (this.logger != null) {
            this.logger.log(msg.toString());
        }
    }

    public final void esay(String err) {
        if (this.logger != null) {
            this.logger.elog(err.toString());
        }
    }

    public final void esay(Throwable t) {
        if (this.logger != null) {
            this.logger.elog(t.toString());
        }
    }

    public Copier(String urlcopy, Configuration configuration) {
        this.urlcopy = urlcopy;
        this.configuration = configuration;
        this.retry_num = configuration.getRetry_num();
        this.retry_timeout = configuration.getRetry_timeout();
        this.dryRun = configuration.isDryRun();
        this.logger = configuration.getLogger();
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCopyJob(CopyJob job) {
        Object object = this.copy_jobs;
        synchronized (object) {
            this.copy_jobs.add(job);
            ++this.num_jobs;
        }
        object = this;
        synchronized (object) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doneAddingJobs() {
        Object object = this.copy_jobs;
        synchronized (object) {
            this.doneAddingJobs = true;
        }
        object = this;
        synchronized (object) {
            this.notify();
        }
    }

    public synchronized void waitCompletion() throws Exception {
        if (this.completed) {
            if (!this.completed_successfully) {
                throw this.error;
            }
            if (this.num_completed_successfully != this.num_jobs) {
                throw new Exception("number of jobs = " + this.num_jobs + " successfully completed=" + this.num_completed_successfully);
            }
            return;
        }
        while (true) {
            try {
                this.wait();
            }
            catch (InterruptedException ie) {
                this.esay("waitCompletion is interrupted");
                this.notifyAll();
                throw ie;
            }
            if (this.completed) {
                if (!this.completed_successfully) {
                    throw this.error;
                }
                if (this.num_completed_successfully != this.num_jobs) {
                    throw new Exception("number of jobs = " + this.num_jobs + " successfully completed=" + this.num_completed_successfully);
                }
                return;
            }
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Copier copier = this;
        synchronized (copier) {
            this.stop = true;
            this.notifyAll();
        }
        while (!this.copy_jobs.isEmpty()) {
            CopyJob nextJob = this.copy_jobs.iterator().next();
            this.copy_jobs.remove(nextJob);
            nextJob.done(false, "stopped");
        }
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        Copier copier;
        if (Thread.currentThread() == this.hook) {
            this.cleanup();
            return;
        }
        this.hook = new Thread(this);
        Runtime.getRuntime().addShutdownHook(this.hook);
        while (true) {
            copier = this;
            // MONITORENTER : copier
            if (this.stop) {
                this.say("going to stop....");
                this.completed = true;
                this.completed_successfully = false;
                this.error = new Exception(" stopped ");
                this.notifyAll();
                // MONITOREXIT : copier
                return;
            }
            // MONITOREXIT : copier
            CopyJob nextJob = null;
            Object object = this.copy_jobs;
            // MONITORENTER : object
            if (this.copy_jobs.isEmpty()) {
                this.say("copy_jobs is empty");
            } else {
                this.say("copy_jobs is not empty");
            }
            if (this.doneAddingJobs && this.copy_jobs.isEmpty()) {
                this.say("stopping copier");
                Runtime.getRuntime().removeShutdownHook(this.hook);
                // MONITOREXIT : object
                break;
            }
            if (!this.copy_jobs.isEmpty()) {
                nextJob = this.copy_jobs.iterator().next();
            }
            // MONITOREXIT : object
            if (nextJob != null) {
                Copier copier2;
                boolean job_success = false;
                Exception job_error = null;
                int i = 0;
                while (true) {
                    try {
                        this.copy(nextJob);
                        job_success = true;
                        this.say("execution of " + nextJob + " completed");
                    }
                    catch (Exception e1) {
                        this.esay("copy failed with the error");
                        this.esay(e1);
                        if (i >= this.retry_num) throw e1;
                        ++i;
                        this.esay(" try again");
                        try {
                            this.esay("sleeping for " + this.retry_timeout * (long)i + " before retrying");
                            Thread.sleep(this.retry_timeout * (long)i);
                        }
                        catch (InterruptedException ie) {}
                        continue;
                    }
                    break;
                }
                try {
                    nextJob.done(job_success, job_error == null ? null : job_error.getMessage());
                }
                catch (Exception e) {
                    this.esay("setting File Request to \"Done\" failed");
                    this.esay(e);
                    if (this.doneAddingJobs && this.copy_jobs.isEmpty()) break;
                    copier2 = this;
                    // MONITORENTER : copier2
                    this.completed = true;
                    this.completed_successfully = false;
                    this.error = e;
                    this.notifyAll();
                    // MONITOREXIT : copier2
                    return;
                }
                catch (Exception e) {
                    try {
                        copier2 = this;
                        // MONITORENTER : copier2
                        job_error = e;
                        this.completed = true;
                        this.completed_successfully = false;
                        this.error = e;
                        this.notifyAll();
                        // MONITOREXIT : copier2
                    }
                    catch (Throwable throwable) {
                        try {
                            nextJob.done(job_success, job_error == null ? null : job_error.getMessage());
                            throw throwable;
                        }
                        catch (Exception e2) {
                            this.esay("setting File Request to \"Done\" failed");
                            this.esay(e2);
                            if (this.doneAddingJobs && this.copy_jobs.isEmpty()) break;
                            Copier copier3 = this;
                            // MONITORENTER : copier3
                            this.completed = true;
                            this.completed_successfully = false;
                            this.error = e2;
                            this.notifyAll();
                            // MONITOREXIT : copier3
                            return;
                        }
                    }
                    try {
                        nextJob.done(job_success, job_error == null ? null : job_error.getMessage());
                        return;
                    }
                    catch (Exception e3) {
                        this.esay("setting File Request to \"Done\" failed");
                        this.esay(e3);
                        if (this.doneAddingJobs && this.copy_jobs.isEmpty()) break;
                        Copier copier4 = this;
                        // MONITORENTER : copier4
                        this.completed = true;
                        this.completed_successfully = false;
                        this.error = e3;
                        this.notifyAll();
                        // MONITOREXIT : copier4
                        return;
                    }
                }
                HashSet<CopyJob> hashSet = this.copy_jobs;
                // MONITORENTER : hashSet
                this.copy_jobs.remove(nextJob);
                // MONITOREXIT : hashSet
                continue;
            }
            object = this;
            // MONITORENTER : object
            try {
                this.wait();
            }
            catch (InterruptedException ie) {
                this.completed = true;
                this.completed_successfully = false;
                this.error = new Exception(" copier was interrupted ");
                this.notifyAll();
                this.esay(" copier was interrupted");
                this.notify();
            }
        }
        copier = this;
        // MONITORENTER : copier
        this.completed = true;
        this.notifyAll();
        // MONITOREXIT : copier
    }

    public void copy(CopyJob job) throws Exception {
        GlobusURL from = job.getSource();
        GlobusURL to = job.getDestination();
        int totype = SRMDispatcher.getUrlType(to);
        if ((totype & 0x80) == 128) {
            String filename = from.getPath();
            int lastSlash = filename.lastIndexOf(47);
            if (lastSlash != -1) {
                filename = filename.substring(lastSlash);
            }
            to = new GlobusURL(to.getURL().concat(filename));
        }
        this.dsay("copying " + job);
        if (from.getProtocol().equals("dcap") || to.getProtocol().equals("dcap") || this.configuration.isUse_urlcopy_script()) {
            try {
                this.say("trying script copy");
                String[] script_protocols = null;
                try {
                    script_protocols = this.scriptCopyGetSupportedProtocols();
                    for (int i = 0; i < script_protocols.length; ++i) {
                        this.dsay(this.urlcopy + " supports " + script_protocols[i]);
                    }
                }
                catch (Exception e) {
                    this.esay("could not get supported protocols ");
                    script_protocols = null;
                }
                boolean from_protocol_supported = false;
                boolean to_protocol_supported = false;
                if (script_protocols != null) {
                    for (int i = 0; i < script_protocols.length; ++i) {
                        if (script_protocols[i].equals(from.getProtocol())) {
                            from_protocol_supported = true;
                        }
                        if (script_protocols[i].equals(to.getProtocol())) {
                            to_protocol_supported = true;
                        }
                        if (from_protocol_supported && to_protocol_supported) break;
                    }
                }
                if (from_protocol_supported && to_protocol_supported) {
                    this.scriptCopy(from, to);
                    return;
                }
            }
            catch (Exception e) {
                this.esay("script copy failed with " + e);
                this.esay("trying native java copy");
            }
        }
        if ((from.getProtocol().equals("gsiftp") || from.getProtocol().equals("gridftp")) && to.getProtocol().equals("file") || from.getProtocol().equals("file") && (to.getProtocol().equals("gsiftp") || to.getProtocol().equals("gridftp"))) {
            GSSCredential credential = null;
            credential = this.configuration.isUseproxy() ? SslGsiSocketFactory.createUserCredential((String)this.configuration.getX509_user_proxy()) : SslGsiSocketFactory.getServiceCredential((String)this.configuration.getX509_user_cert(), (String)this.configuration.getX509_user_key(), (int)0);
            this.javaGridFtpCopy(from, to, credential, this.logger);
            return;
        }
        URL fromURL = new URL(from.getURL());
        URL toURL = new URL(to.getURL());
        this.javaUrlCopy(fromURL, toURL);
    }

    public String[] scriptCopyGetSupportedProtocols() throws Exception {
        String command = this.urlcopy;
        command = command + " -get-protocols";
        return ShellCommandExecuter.executeAndReturnOutput(command, this.logger);
    }

    public void scriptCopy(GlobusURL from, GlobusURL to) throws Exception {
        int buffer_size;
        int tcp_buffer_size;
        String x509_cert_dir;
        String x509_cert;
        String x509_key;
        String x509_proxy;
        String command = this.urlcopy;
        if (this.debug) {
            command = command + " -debug true";
        }
        if ((x509_proxy = this.configuration.getX509_user_proxy()) != null) {
            command = command + " -x509_user_proxy " + x509_proxy;
        }
        if ((x509_key = this.configuration.getX509_user_key()) != null) {
            command = command + " -x509_user_key " + x509_key;
        }
        if ((x509_cert = this.configuration.getX509_user_cert()) != null) {
            command = command + " -x509_user_cert " + x509_cert;
        }
        if ((x509_cert_dir = this.configuration.getX509_user_trusted_certificates()) != null) {
            command = command + " -x509_user_certs_dir " + x509_cert_dir;
        }
        if ((tcp_buffer_size = this.configuration.getTcp_buffer_size()) > 0) {
            command = command + " -tcp_buffer_size " + tcp_buffer_size;
        }
        if ((buffer_size = this.configuration.getBuffer_size()) > 0) {
            command = command + " -buffer_size " + buffer_size;
        }
        command = command + " -src-protocol " + from.getProtocol();
        command = from.getProtocol().equals("file") ? command + " -src-host-port localhost" : command + " -src-host-port " + from.getHost() + ":" + from.getPort();
        command = command + " -src-path " + from.getPath() + " -dst-protocol " + to.getProtocol();
        command = to.getProtocol().equals("file") ? command + " -dst-host-port localhost" : command + " -dst-host-port " + to.getHost() + ":" + to.getPort();
        command = command + " -dst-path " + to.getPath();
        int rc = 0;
        if (!this.dryRun) {
            rc = ShellCommandExecuter.execute(command, this.logger);
        }
        if (rc == 0) {
            this.say(" successfuly copied " + from.getURL() + " to " + to.getURL());
            ++this.num_completed_successfully;
        } else {
            this.esay(" failed to copy " + from.getURL() + " to " + to.getURL());
            this.esay(this.urlcopy + " return code = " + rc);
            throw new Exception(this.urlcopy + " return code = " + rc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void javaGridFtpCopy(GlobusURL src_url, GlobusURL dst_url, GSSCredential credential, Logger logger) throws Exception {
        String serverMode = this.configuration.getServerMode();
        int numberOfStreams = this.configuration.getStreams_num();
        if ((src_url.getProtocol().equals("gsiftp") || src_url.getProtocol().equals("gridftp")) && dst_url.getProtocol().equals("file")) {
            boolean emode;
            boolean passive_server_mode = true;
            if (serverMode == null) {
                passive_server_mode = true;
            } else if (serverMode.equalsIgnoreCase("passive")) {
                passive_server_mode = true;
                if (numberOfStreams != 1) {
                    logger.elog("server_mode is specified as passive, setting number of streams to 1");
                    numberOfStreams = 1;
                }
            } else if (serverMode.equalsIgnoreCase("active")) {
                passive_server_mode = false;
            } else {
                throw new IllegalArgumentException("Unknown server_mode option specified \"" + serverMode + "\". Allowed options \"passive\" or \"active\"");
            }
            boolean bl = emode = numberOfStreams != 1;
            if (!this.dryRun) {
                GridftpClient client = new GridftpClient(src_url.getHost(), src_url.getPort(), this.configuration.getTcp_buffer_size(), this.configuration.getBuffer_size(), credential);
                client.setStreamsNum(numberOfStreams);
                client.setChecksum(this.configuration.getCksmType(), this.configuration.getCksmValue());
                try {
                    client.gridFTPRead(src_url.getPath(), dst_url.getPath(), emode, passive_server_mode);
                    ++this.num_completed_successfully;
                }
                finally {
                    client.close();
                }
            } else {
                ++this.num_completed_successfully;
            }
            return;
        }
        if (src_url.getProtocol().equals("file") && (dst_url.getProtocol().equals("gsiftp") || dst_url.getProtocol().equals("gridftp"))) {
            boolean emode;
            boolean passive_server_mode = true;
            if (serverMode == null) {
                passive_server_mode = true;
            } else if (serverMode.equalsIgnoreCase("passive")) {
                passive_server_mode = true;
            } else if (serverMode.equalsIgnoreCase("active")) {
                passive_server_mode = false;
                if (numberOfStreams != 1) {
                    logger.elog("server_mode is specified as active, setting number of streams to 1");
                    numberOfStreams = 1;
                }
            } else {
                throw new IllegalArgumentException("Unknown server_mode option specified \"" + serverMode + "\". Allowed options \"passive\" or \"active\"");
            }
            boolean bl = emode = numberOfStreams != 1;
            if (!this.dryRun) {
                GridftpClient client = new GridftpClient(dst_url.getHost(), dst_url.getPort(), this.configuration.getTcp_buffer_size(), this.configuration.getBuffer_size(), credential);
                client.setStreamsNum(numberOfStreams);
                client.setChecksum(this.configuration.getCksmType(), this.configuration.getCksmValue());
                try {
                    client.gridFTPWrite(src_url.getPath(), dst_url.getPath(), emode, this.configuration.getDoSendCheckSum(), passive_server_mode);
                    ++this.num_completed_successfully;
                }
                finally {
                    client.close();
                }
            } else {
                ++this.num_completed_successfully;
            }
            return;
        }
        throw new IllegalArgumentException("need file-gridftp or gridftp-file combo");
    }

    public void javaUrlCopy(URL from, URL to) throws Exception {
        int l;
        InputStream in = null;
        in = from.getProtocol().equals("file") ? new FileInputStream(from.getPath()) : from.openConnection().getInputStream();
        OutputStream out = null;
        if (to.getProtocol().equals("file")) {
            out = new FileOutputStream(to.getPath());
        } else {
            URLConnection to_connect = to.openConnection();
            to_connect.setDoInput(false);
            to_connect.setDoOutput(true);
            out = to_connect.getOutputStream();
        }
        int buffer_size = this.configuration.getBuffer_size();
        if (buffer_size <= 0) {
            buffer_size = 4096;
        }
        byte[] bytes = new byte[buffer_size];
        long total = 0L;
        while ((l = in.read(bytes)) != -1) {
            total += (long)l;
            out.write(bytes, 0, l);
        }
        this.say("successfuly copied " + total + " bytes from " + from + " to " + to);
        ++this.num_completed_successfully;
    }

    private void cleanup() {
        CopyJob[] jobs = new CopyJob[]{};
        if ((jobs = this.copy_jobs.toArray(jobs)) == null) {
            return;
        }
        for (int i = 0; i < jobs.length; ++i) {
            jobs[i].done(false, "stopped by cleanup");
        }
    }
}

