/*
 * Decompiled with CFR 0.152.
 */
package org.glite.voms.contact;

import org.apache.commons.lang.StringUtils;
import org.glite.voms.contact.PathNamingScheme;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;

class VOMSRequestFragment {
    private Document doc;
    DocumentFragment fragment;
    Element root;
    Element command;
    Element order;
    Element targets;
    Element lifetime;
    Element base64;
    Element version;

    public VOMSRequestFragment(Document document) {
        this.doc = document;
        this.fragment = document.createDocumentFragment();
        this.buildRootElement();
    }

    protected void buildRootElement() {
        this.root = this.doc.createElement("voms");
        this.fragment.appendChild(this.root);
    }

    private void appendTextChild(Element element, String string) {
        element.appendChild(this.doc.createTextNode(string));
    }

    private String buildCompatibleOrderString(String string) {
        Object[] objectArray = string.split(",");
        if (objectArray.length == 0) {
            return "";
        }
        for (int i = 0; i < objectArray.length; ++i) {
            if (!PathNamingScheme.isQualifiedRole(objectArray[i])) continue;
            objectArray[i] = PathNamingScheme.toOldQualifiedRoleSyntax((String)objectArray[i]);
        }
        return StringUtils.join((Object[])objectArray, (String)",");
    }

    void buildCommandElement(String string) {
        this.command = this.doc.createElement("command");
        this.appendTextChild(this.command, string);
        this.root.appendChild(this.command);
    }

    void buildOrderElement(String string) {
        this.order = this.doc.createElement("order");
        this.appendTextChild(this.order, this.buildCompatibleOrderString(string));
        this.root.appendChild(this.order);
    }

    void buildTargetsElement(String string) {
        this.targets = this.doc.createElement("targets");
        this.appendTextChild(this.targets, string);
        this.root.appendChild(this.targets);
    }

    void buildLifetime(long l) {
        this.buildLifetime(Long.toString(l));
    }

    void buildLifetime(String string) {
        this.lifetime = this.doc.createElement("lifetime");
        this.appendTextChild(this.lifetime, string);
        this.root.appendChild(this.lifetime);
    }

    void buildBase64() {
        this.base64 = this.doc.createElement("base64");
        this.appendTextChild(this.base64, "1");
        this.root.appendChild(this.base64);
    }

    void buildVersion() {
        this.version = this.doc.createElement("version");
        this.appendTextChild(this.version, "4");
        this.root.appendChild(this.version);
    }

    public DocumentFragment getFragment() {
        return this.fragment;
    }

    public void groupCommand(String string) {
        this.buildCommandElement("G" + string);
    }

    public void roleCommand(String string) {
        this.buildCommandElement("R" + string);
    }

    public void mappingCommand(String string, String string2) {
        this.buildCommandElement("B" + string + ":" + string2);
    }

    public void allCommand() {
        this.buildCommandElement("A");
    }

    public void listCommand() {
        this.buildCommandElement("N");
    }
}

