/*
 * Decompiled with CFR 0.152.
 */
package org.glite.voms.contact;

import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.glite.voms.contact.PathNamingScheme;
import org.glite.voms.contact.VOMSException;
import org.glite.voms.contact.VOMSRequestFragment;
import org.glite.voms.contact.VOMSRequestOptions;
import org.w3c.dom.Document;

public class VOMSRequestFactory {
    private static Logger log = Logger.getLogger(VOMSRequestFactory.class);
    private static VOMSRequestFactory instance = null;
    private String orderString;
    private String targetString;
    private long lifetime = 0L;
    protected DocumentBuilder docBuilder;

    public static VOMSRequestFactory instance() {
        if (instance == null) {
            instance = new VOMSRequestFactory();
        }
        return instance;
    }

    private VOMSRequestFactory() {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setIgnoringComments(true);
        documentBuilderFactory.setNamespaceAware(false);
        documentBuilderFactory.setValidating(false);
        try {
            this.docBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            log.fatal((Object)"Error configuring DOM document builder.");
            if (log.isDebugEnabled()) {
                log.debug((Object)parserConfigurationException.getMessage(), (Throwable)parserConfigurationException);
            }
            throw new VOMSException(parserConfigurationException);
        }
    }

    public long getLifetime() {
        return this.lifetime;
    }

    public void setLifetime(long l) {
        this.lifetime = l;
    }

    public String getOrderString() {
        return this.orderString;
    }

    public void setOrderString(String string) {
        this.orderString = string;
    }

    public String getTargetString() {
        return this.targetString;
    }

    public void setTargetString(String string) {
        this.targetString = string;
    }

    private void setOptionsForRequest(VOMSRequestFragment vOMSRequestFragment) {
        if (this.orderString != null && this.orderString != "") {
            vOMSRequestFragment.buildOrderElement(this.orderString);
        }
        if (this.targetString != null && this.targetString != "") {
            vOMSRequestFragment.buildTargetsElement(this.targetString);
        }
        vOMSRequestFragment.buildLifetime(this.lifetime);
    }

    private void loadOptions(VOMSRequestOptions vOMSRequestOptions) {
        this.lifetime = vOMSRequestOptions.getLifetime();
        this.setOrderString(vOMSRequestOptions.getOrdering());
        this.setTargetString(vOMSRequestOptions.getTargetsAsString());
    }

    public String buildRESTRequest(VOMSRequestOptions vOMSRequestOptions) {
        this.loadOptions(vOMSRequestOptions);
        if (vOMSRequestOptions.isRequestList()) {
            return "/generate-ac?fqans=all";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("/generate-ac?fqans=");
        if (vOMSRequestOptions.getRequestedFQANs().isEmpty()) {
            if (vOMSRequestOptions.getVoName() == null) {
                throw new VOMSException("No vo name specified for AC retrieval.");
            }
            String string = vOMSRequestOptions.getVoName();
            if (!string.startsWith("/")) {
                string = "/" + string;
            }
            stringBuilder.append(string);
        } else {
            List list = vOMSRequestOptions.getRequestedFQANs();
            Iterator iterator = list.iterator();
            boolean bl = true;
            while (iterator.hasNext()) {
                if (!bl) {
                    stringBuilder.append(",");
                }
                stringBuilder.append((String)iterator.next());
                bl = false;
            }
        }
        if (this.targetString != null && this.targetString.trim().length() != 0) {
            stringBuilder.append("&targets=");
            stringBuilder.append(this.targetString);
        }
        if (this.orderString != null && this.orderString.trim().length() != 0) {
            stringBuilder.append("&order=");
            stringBuilder.append(this.orderString);
        }
        stringBuilder.append("&lifetime=");
        stringBuilder.append(this.lifetime);
        log.debug((Object)("Generated request: " + stringBuilder.toString()));
        return stringBuilder.toString();
    }

    public Document buildRequest(VOMSRequestOptions vOMSRequestOptions) {
        this.loadOptions(vOMSRequestOptions);
        Document document = this.docBuilder.newDocument();
        VOMSRequestFragment vOMSRequestFragment = new VOMSRequestFragment(document);
        if (vOMSRequestOptions.isRequestList()) {
            vOMSRequestFragment.listCommand();
            this.setOptionsForRequest(vOMSRequestFragment);
            document.appendChild(vOMSRequestFragment.getFragment());
            return document;
        }
        if (vOMSRequestOptions.getRequestedFQANs().isEmpty()) {
            if (vOMSRequestOptions.getVoName() == null) {
                throw new VOMSException("No vo name specified for AC retrieval.");
            }
            String string = vOMSRequestOptions.getVoName();
            if (!string.startsWith("/")) {
                string = "/" + string;
            }
            vOMSRequestFragment.groupCommand(string);
            this.setOptionsForRequest(vOMSRequestFragment);
            document.appendChild(vOMSRequestFragment.getFragment());
            return document;
        }
        Iterator iterator = vOMSRequestOptions.getRequestedFQANs().iterator();
        vOMSRequestFragment.buildBase64();
        vOMSRequestFragment.buildVersion();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (string.equals("all")) {
                vOMSRequestFragment.allCommand();
                continue;
            }
            if (PathNamingScheme.isGroup(string)) {
                vOMSRequestFragment.groupCommand(string);
                continue;
            }
            if (PathNamingScheme.isRole(string)) {
                vOMSRequestFragment.roleCommand(PathNamingScheme.getRoleName(string));
                continue;
            }
            if (!PathNamingScheme.isQualifiedRole(string)) continue;
            vOMSRequestFragment.mappingCommand(PathNamingScheme.getGroupName(string), PathNamingScheme.getRoleName(string));
        }
        this.setOptionsForRequest(vOMSRequestFragment);
        document.appendChild(vOMSRequestFragment.getFragment());
        return document;
    }
}

