/*
 * Decompiled with CFR 0.152.
 */
package org.glite.voms.contact;

import java.security.Provider;
import java.security.Security;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import org.apache.log4j.Logger;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.glite.voms.PKIUtils;

class GSIVerifier
implements HostnameVerifier {
    private String name;
    private HostnameVerifier verifier;
    private static final Logger log = Logger.getLogger(GSIVerifier.class);

    public GSIVerifier(HostnameVerifier hostnameVerifier, String string) {
        this.name = string;
        this.verifier = hostnameVerifier;
    }

    public boolean verify(String string, SSLSession sSLSession) {
        boolean bl = false;
        if (!this.verifier.verify(string, sSLSession)) {
            try {
                X509Certificate x509Certificate = (X509Certificate)sSLSession.getPeerCertificates()[0];
                String string2 = PKIUtils.getOpenSSLFormatPrincipal(x509Certificate.getSubjectDN(), false);
                String string3 = PKIUtils.getOpenSSLFormatPrincipal(x509Certificate.getSubjectDN(), true);
                bl = PKIUtils.DNCompare(this.name, string2) || PKIUtils.DNCompare(this.name, string3);
                log.debug((Object)("result of DN verifier: " + bl));
            }
            catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
                log.debug((Object)"Unauthenticate peer.  Verify failed.");
                bl = false;
            }
        } else {
            bl = true;
            log.debug((Object)"Verified by default verifier");
        }
        return bl;
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

