/*
 * Decompiled with CFR 0.152.
 */
package org.glite.voms;

import java.io.FileInputStream;
import java.io.IOException;
import java.net.Socket;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.X509KeyManager;
import org.apache.log4j.Logger;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.glite.voms.FileCertReader;
import org.glite.voms.contact.UserCredentials;
import org.glite.voms.contact.VOMSException;

public class VOMSKeyManager
implements X509KeyManager {
    private X509KeyManager manager;
    public static final int TYPE_PKCS12 = 1;
    public static final int TYPE_PEM = 2;
    private static final Logger logger = Logger.getLogger(VOMSKeyManager.class);

    public VOMSKeyManager(String string, String string2, String string3) {
        this(string, string2, string3, 2);
    }

    public VOMSKeyManager(UserCredentials userCredentials) throws NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException, IOException, CertificateException {
        this.manager = null;
        if (userCredentials.getUserKey() == null) {
            throw new UnrecoverableKeyException("Passed Credential does not hold a private key!");
        }
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
        KeyStore keyStore = KeyStore.getInstance("JKS");
        keyStore.load(null, "".toCharArray());
        logger.debug((Object)"ABOUT to set key entry");
        keyStore.setKeyEntry("alias", userCredentials.getUserKey(), "".toCharArray(), userCredentials.getUserChain());
        logger.debug((Object)("STORETYPE: " + keyStore.getType()));
        keyManagerFactory.init(keyStore, "".toCharArray());
        this.manager = (X509KeyManager)keyManagerFactory.getKeyManagers()[0];
    }

    public VOMSKeyManager(String string, String string2, String string3, int n) {
        block14: {
            this.manager = null;
            FileInputStream fileInputStream = null;
            try {
                KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
                char[] cArray = string3.toCharArray();
                KeyStore keyStore = null;
                if (n == 2) {
                    keyStore = KeyStore.getInstance("JKS");
                    keyStore = this.load(string, string2, cArray);
                } else if (n == 1) {
                    keyStore = KeyStore.getInstance("PKCS12", "SunJSSE");
                    fileInputStream = new FileInputStream(string);
                    keyStore.load(fileInputStream, cArray);
                }
                if (keyStore != null) {
                    keyManagerFactory.init(keyStore, cArray);
                    this.manager = (X509KeyManager)keyManagerFactory.getKeyManagers()[0];
                    break block14;
                }
                throw new VOMSException("Cannot initialize VOMSKeyManager: ");
            }
            catch (Exception exception) {
                throw new VOMSException("Cannot initialize VOMSKeyManager: ", exception);
            }
            finally {
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }

    private KeyStore createKeyStore(String string, String string2, char[] cArray) throws CertificateException, IOException {
        FileCertReader fileCertReader = new FileCertReader();
        Certificate[] certificateArray = fileCertReader.readCerts(string).toArray(new X509Certificate[0]);
        PrivateKey privateKey = null;
        KeyStore keyStore = null;
        try {
            if (string2 == null) {
                throw new VOMSException("Cannot load the private key.");
            }
            privateKey = fileCertReader.readPrivateKey(string2);
        }
        catch (IOException iOException) {
            throw new VOMSException("Cannot load the private key.", iOException);
        }
        try {
            keyStore = KeyStore.getInstance("JKS");
            keyStore.setKeyEntry("alias", privateKey, cArray, certificateArray);
        }
        catch (KeyStoreException keyStoreException) {
            throw new VOMSException("Cannot load the key pair.", keyStoreException);
        }
        return keyStore;
    }

    private KeyStore load(String string, String string2, char[] cArray) throws CertificateException, IOException {
        KeyStore keyStore = null;
        keyStore = !string.equals(string2) ? this.createKeyStore(string, string2, cArray) : this.createKeyStore(string, string, cArray);
        return keyStore;
    }

    public String chooseClientAlias(String[] stringArray, Principal[] principalArray, Socket socket) {
        return this.manager.chooseClientAlias(stringArray, principalArray, socket);
    }

    public String chooseServerAlias(String string, Principal[] principalArray, Socket socket) {
        return this.manager.chooseServerAlias(string, principalArray, socket);
    }

    public X509Certificate[] getCertificateChain(String string) {
        return this.manager.getCertificateChain(string);
    }

    public String[] getClientAliases(String string, Principal[] principalArray) {
        return this.manager.getClientAliases(string, principalArray);
    }

    public String[] getServerAliases(String string, Principal[] principalArray) {
        return this.manager.getServerAliases(string, principalArray);
    }

    public PrivateKey getPrivateKey(String string) {
        return this.manager.getPrivateKey(string);
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

