/*
 * Decompiled with CFR 0.152.
 */
package org.glite.voms;

import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.Hashtable;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.security.auth.x500.X500Principal;
import org.apache.log4j.Logger;
import org.glite.voms.DirectoryList;
import org.glite.voms.FileCertReader;
import org.glite.voms.PKIStore;
import org.glite.voms.ac.ACTrustStore;

public final class BasicVOMSTrustStore
implements ACTrustStore {
    static Logger log = Logger.getLogger(BasicVOMSTrustStore.class);
    public static final String DEFAULT_TRUST_STORE_LISTING = PKIStore.DEFAULT_VOMSDIR;
    String trustedDirList = null;
    private Hashtable issuerCerts = new Hashtable();
    private long refreshPeriod = -1L;
    private Timer theTimer = null;

    public BasicVOMSTrustStore() {
        this(DEFAULT_TRUST_STORE_LISTING, 300000L);
    }

    public BasicVOMSTrustStore(String string, long l) {
        List list;
        if (l < 0L) {
            throw new IllegalArgumentException("refreshPeriod is negative");
        }
        try {
            list = new DirectoryList(string).getListing();
        }
        catch (IOException iOException) {
            list = null;
        }
        if (list == null || list.isEmpty()) {
            String string2 = "VOMS trust anchors " + string + " does not appear to exist";
            log.fatal((Object)string2);
            throw new IllegalArgumentException(string2);
        }
        this.trustedDirList = string;
        this.refreshPeriod = l;
        if (l == 0L) {
            this.refresh();
        }
        if (l > 0L) {
            this.theTimer = new Timer(true);
            this.theTimer.scheduleAtFixedRate((TimerTask)new Refreshener(), 0L, l);
        }
    }

    public String getDirList() {
        return this.trustedDirList;
    }

    public void stopRefresh() {
        if (this.theTimer != null) {
            this.theTimer.cancel();
        }
        this.theTimer = null;
    }

    public void refresh() {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Refreshing in-memory VOMS issuer cache from " + this.trustedDirList));
            }
            Hashtable<X500Principal, Vector<X509Certificate>> hashtable = new Hashtable<X500Principal, Vector<X509Certificate>>();
            Vector vector = new FileCertReader().readCerts(this.trustedDirList);
            for (X509Certificate x509Certificate : vector) {
                X500Principal x500Principal = x509Certificate.getSubjectX500Principal();
                Vector<X509Certificate> vector2 = (Vector<X509Certificate>)hashtable.get(x500Principal);
                if (vector2 == null) {
                    vector2 = new Vector<X509Certificate>();
                }
                vector2.add(x509Certificate);
                hashtable.put(x500Principal, vector2);
            }
            this.issuerCerts = hashtable;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Refreshing of in-memory VOMS issuer cache done. Read " + vector.size() + " certs"));
            }
        }
        catch (Exception exception) {
            log.error((Object)("Unexpected error while refreshing in-memory VOMS issuer cache from " + this.trustedDirList + " : " + exception.getMessage()));
        }
    }

    public X509Certificate[] getAACandidate(X500Principal x500Principal) {
        List list;
        if (this.refreshPeriod < 0L) {
            this.refresh();
        }
        if ((list = (List)this.issuerCerts.get(x500Principal)) != null) {
            return list.toArray(new X509Certificate[list.size()]);
        }
        return null;
    }

    private class Refreshener
    extends TimerTask {
        private Refreshener() {
        }

        public void run() {
            BasicVOMSTrustStore.this.refresh();
        }
    }
}

