#!/bin/sh
#
# script that updates SRM space manager schema 
#


[ -f /etc/default/dcache ] && . /etc/default/dcache       
[ -f /etc/dcache.env ] && . /etc/dcache.env               

if [ -z "$DCACHE_HOME" ]; then                            
DCACHE_HOME="/usr/share/dcache"                         
fi                                                        
if [ ! -d "$DCACHE_HOME" ]; then                          
echo "$DCACHE_HOME is not a directory"                  
exit 2                                                  
fi                                                        

DCACHE_CLASSPATH=${DCACHE_HOME}/classes/*                 
DCACHE_DEFAULTS=${DCACHE_HOME}/defaults                   
. ${DCACHE_HOME}/lib/loadConfig.sh

CLASSPATH="$(getProperty dcache.paths.classpath)" \
    ${JAVA} $(getProperty dcache.java.options) \
    diskCacheV111.services.space.Manager $*