#!/bin/sh
#
#  A simple shell wrapper around the NameSpaceProvider performance
#  testing tool.


[ -f /etc/default/dcache ] && . /etc/default/dcache       
[ -f /etc/dcache.env ] && . /etc/dcache.env               

if [ -z "$DCACHE_HOME" ]; then                            
DCACHE_HOME="/usr/share/dcache"                         
fi                                                        
if [ ! -d "$DCACHE_HOME" ]; then                          
echo "$DCACHE_HOME is not a directory"                  
exit 2                                                  
fi                                                        

DCACHE_CLASSPATH=${DCACHE_HOME}/classes/*                 
DCACHE_DEFAULTS=${DCACHE_HOME}/defaults                   
. ${DCACHE_HOME}/lib/loadConfig.sh

CLASSPATH="$(getProperty dcache.paths.classpath)" java \
   -Dlog=${DCACHE_LOG:-warn} \
   diskCacheV111.namespace.PerformanceTest "$@"
