#!/bin/sh
#
#  A simple wrapper around the PNFS-to-Chimera migration test tool.
#
#  To use this tool:
#
#  1. Make a file containing a list of the PNFS IDs of all
#     files you wish to test, something like:
#
#        pnfsDump -o files /tmp/all-files-in-PNFS -f
#
#     NB. pnfsDump must be run on the same machine as the PNFS dbserver
#     daemons.
#
#  2. Adjust /opt/d-cache/config/chimera-config.xml so it points to the
#     Chimera database or inform the comparator to use a different file.
#     This should only be necessary if Chimera database is not running
#     on localhost.
#
#  3. Run this script giving it the filename containing the PNFS IDs;
#     for example:
#
#        ./migration-check.sh /tmp/all-files-in-PNFS
#
#  4. the migration-check.sh will accept an option "-k".  Specifying
#     this option will prevent migration-check from halting on the
#     first error.
#
#  5. Use the "-h" option for further help.



[ -f /etc/default/dcache ] && . /etc/default/dcache       
[ -f /etc/dcache.env ] && . /etc/dcache.env               

if [ -z "$DCACHE_HOME" ]; then                            
DCACHE_HOME="/usr/share/dcache"                         
fi                                                        
if [ ! -d "$DCACHE_HOME" ]; then                          
echo "$DCACHE_HOME is not a directory"                  
exit 2                                                  
fi                                                        

DCACHE_CLASSPATH=${DCACHE_HOME}/classes/*                 
DCACHE_DEFAULTS=${DCACHE_HOME}/defaults                   
. ${DCACHE_HOME}/lib/loadConfig.sh

CLASSPATH="$(getProperty dcache.paths.classpath)" java \
    -Dlog=${DCACHE_LOG:-warn} \
    org.dcache.chimera.migration.Comparator "$@"
