/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml2.metadata.provider;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import org.opensaml.Configuration;
import org.opensaml.saml2.metadata.provider.HTTPMetadataProvider;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.io.Marshaller;
import org.opensaml.xml.io.MarshallingException;
import org.opensaml.xml.io.UnmarshallingException;
import org.opensaml.xml.util.XMLHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class FileBackedHTTPMetadataProvider
extends HTTPMetadataProvider {
    private final Logger log = LoggerFactory.getLogger(FileBackedHTTPMetadataProvider.class);
    private File metadataBackupFile;

    public FileBackedHTTPMetadataProvider(String metadataURL, int requestTimeout, String backingFilePath) throws MetadataProviderException {
        super(metadataURL, requestTimeout);
        this.metadataBackupFile = new File(backingFilePath);
        if (this.metadataBackupFile.exists()) {
            if (this.metadataBackupFile.isDirectory()) {
                throw new MetadataProviderException("Filepath " + backingFilePath + " is a directory and may not be used as a backing metadata file");
            }
            if (!this.metadataBackupFile.canRead()) {
                throw new MetadataProviderException("Filepath " + backingFilePath + " exists but can not be read by this user");
            }
            if (!this.metadataBackupFile.canWrite()) {
                throw new MetadataProviderException("Filepath " + backingFilePath + " exists but can not be written to by this user");
            }
        } else {
            try {
                this.metadataBackupFile.createNewFile();
            }
            catch (IOException e) {
                this.log.error("Unable to create backing file " + backingFilePath, (Throwable)e);
                throw new MetadataProviderException("Unable to create backing file " + backingFilePath, e);
            }
        }
    }

    protected XMLObject fetchMetadata() throws IOException, UnmarshallingException {
        XMLObject metadata;
        try {
            metadata = super.fetchMetadata();
        }
        catch (Exception e) {
            this.log.warn("Unable to read metadata from remote server, attempting to read it from local backup", (Throwable)e);
            return this.getLocalMetadata();
        }
        this.log.debug("Writting retrieved metadata to backup file {}", (Object)this.metadataBackupFile.getAbsolutePath());
        try {
            this.writeMetadataToFile(metadata);
        }
        catch (Exception e) {
            this.log.error("Unable to write metadata to backup file", (Throwable)e);
            throw new IOException("Unable to write metadata to backup file: " + e.getMessage());
        }
        return metadata;
    }

    protected XMLObject getLocalMetadata() throws IOException, UnmarshallingException {
        if (!this.metadataBackupFile.exists() || !this.metadataBackupFile.canRead()) {
            throw new IOException("Unable to read metadata from backup file " + this.metadataBackupFile.getAbsolutePath());
        }
        return this.unmarshallMetadata(new FileInputStream(this.metadataBackupFile));
    }

    protected void writeMetadataToFile(XMLObject metadata) throws MetadataProviderException {
        if (!this.metadataBackupFile.canWrite()) {
            throw new MetadataProviderException("Unable to write to metadata backup file " + this.metadataBackupFile.getAbsolutePath());
        }
        try {
            Element metadataElement;
            if (metadata.getDOM() != null) {
                metadataElement = metadata.getDOM();
            } else {
                Marshaller marshaller = Configuration.getMarshallerFactory().getMarshaller(metadata);
                metadataElement = marshaller.marshall(metadata);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Converting DOM to a string");
            }
            XMLHelper.writeNode((Node)metadataElement, (Writer)new FileWriter(this.metadataBackupFile));
        }
        catch (IOException e) {
            this.log.error("Unable to write metadata to file " + this.metadataBackupFile.getAbsolutePath(), (Throwable)e);
            throw new MetadataProviderException("Unable to write metadata to file");
        }
        catch (MarshallingException e) {
            this.log.error("Unable to marshall metadata in order to write it to file", (Throwable)e);
            throw new MetadataProviderException("Unable to marshall metadata in order to write it to file");
        }
    }
}

