/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml2.metadata.provider;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.xml.namespace.QName;
import org.opensaml.common.SAMLObjectBuilder;
import org.opensaml.saml2.metadata.EntitiesDescriptor;
import org.opensaml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml2.metadata.RoleDescriptor;
import org.opensaml.saml2.metadata.provider.BaseMetadataProvider;
import org.opensaml.saml2.metadata.provider.MetadataFilter;
import org.opensaml.saml2.metadata.provider.MetadataProvider;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.opensaml.saml2.metadata.provider.ObservableMetadataProvider;
import org.opensaml.xml.Configuration;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.XMLObjectBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChainingMetadataProvider
extends BaseMetadataProvider
implements ObservableMetadataProvider {
    private final Logger log = LoggerFactory.getLogger(ChainingMetadataProvider.class);
    private ArrayList<ObservableMetadataProvider.Observer> observers = new ArrayList();
    private ArrayList<MetadataProvider> providers = new ArrayList();
    private ReadWriteLock providerLock = new ReentrantReadWriteLock(true);

    public List<MetadataProvider> getProviders() {
        return Collections.unmodifiableList(this.providers);
    }

    public void setProviders(List<MetadataProvider> newProviders) throws MetadataProviderException {
        this.providers.clear();
        for (MetadataProvider provider : newProviders) {
            this.addMetadataProvider(provider);
        }
    }

    public void addMetadataProvider(MetadataProvider newProvider) throws MetadataProviderException {
        if (newProvider != null) {
            newProvider.setRequireValidMetadata(this.requireValidMetadata());
            if (newProvider instanceof ObservableMetadataProvider) {
                ((ObservableMetadataProvider)newProvider).getObservers().add(new ContainedProviderObserver());
            }
            this.providers.add(newProvider);
        }
    }

    public void removeMetadataProvider(MetadataProvider provider) {
        this.providers.remove(provider);
    }

    @Override
    public void setRequireValidMetadata(boolean requireValidMetadata) {
        super.setRequireValidMetadata(requireValidMetadata);
        Lock writeLock = this.providerLock.writeLock();
        writeLock.lock();
        for (MetadataProvider provider : this.providers) {
            provider.setRequireValidMetadata(requireValidMetadata);
        }
        writeLock.unlock();
    }

    @Override
    public MetadataFilter getMetadataFilter() {
        this.log.warn("Attempt to access unsupported MetadataFilter property on ChainingMetadataProvider");
        return null;
    }

    @Override
    public void setMetadataFilter(MetadataFilter newFilter) throws MetadataProviderException {
        throw new UnsupportedOperationException("Metadata filter is not allowed on ChainingMetadataProvider");
    }

    @Override
    public XMLObject getMetadata() throws MetadataProviderException {
        XMLObjectBuilderFactory builderFactory = Configuration.getBuilderFactory();
        SAMLObjectBuilder builder = (SAMLObjectBuilder)builderFactory.getBuilder(EntitiesDescriptor.DEFAULT_ELEMENT_NAME);
        EntitiesDescriptor metadataRoot = (EntitiesDescriptor)builder.buildObject();
        Lock readLock = this.providerLock.readLock();
        readLock.lock();
        try {
            for (MetadataProvider provider : this.providers) {
                XMLObject providerMetadata = provider.getMetadata();
                if (providerMetadata instanceof EntitiesDescriptor) {
                    metadataRoot.getEntitiesDescriptors().add((EntitiesDescriptor)providerMetadata);
                    continue;
                }
                if (!(providerMetadata instanceof EntityDescriptor)) continue;
                metadataRoot.getEntityDescriptors().add((EntityDescriptor)providerMetadata);
            }
        }
        catch (MetadataProviderException e) {
            throw e;
        }
        finally {
            readLock.unlock();
        }
        return metadataRoot;
    }

    @Override
    public EntitiesDescriptor getEntitiesDescriptor(String name) throws MetadataProviderException {
        Lock readLock = this.providerLock.readLock();
        readLock.lock();
        EntitiesDescriptor descriptor = null;
        try {
            for (MetadataProvider provider : this.providers) {
                this.log.debug("Checking child metadata provider for entities descriptor with name: {}", (Object)name);
                descriptor = provider.getEntitiesDescriptor(name);
                if (descriptor == null) continue;
                break;
            }
        }
        catch (MetadataProviderException e) {
            throw e;
        }
        finally {
            readLock.unlock();
        }
        return descriptor;
    }

    @Override
    public EntityDescriptor getEntityDescriptor(String entityID) throws MetadataProviderException {
        Lock readLock = this.providerLock.readLock();
        readLock.lock();
        EntityDescriptor descriptor = null;
        try {
            for (MetadataProvider provider : this.providers) {
                this.log.debug("Checking child metadata provider for entity descriptor with entity ID: {}", (Object)entityID);
                descriptor = provider.getEntityDescriptor(entityID);
                if (descriptor == null) continue;
                break;
            }
        }
        catch (MetadataProviderException e) {
            throw e;
        }
        finally {
            readLock.unlock();
        }
        return descriptor;
    }

    @Override
    public List<RoleDescriptor> getRole(String entityID, QName roleName) throws MetadataProviderException {
        EntityDescriptor entityMetadata = this.getEntityDescriptor(entityID);
        if (entityMetadata == null) {
            return null;
        }
        return entityMetadata.getRoleDescriptors(roleName);
    }

    @Override
    public RoleDescriptor getRole(String entityID, QName roleName, String supportedProtocol) throws MetadataProviderException {
        EntityDescriptor entityMetadata = this.getEntityDescriptor(entityID);
        if (entityMetadata == null) {
            return null;
        }
        List<RoleDescriptor> roles = entityMetadata.getRoleDescriptors(roleName, supportedProtocol);
        if (roles != null && !roles.isEmpty()) {
            return roles.get(0);
        }
        return null;
    }

    @Override
    public List<ObservableMetadataProvider.Observer> getObservers() {
        return this.observers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void emitChangeEvent() {
        ArrayList<ObservableMetadataProvider.Observer> arrayList = this.observers;
        synchronized (arrayList) {
            for (ObservableMetadataProvider.Observer observer : this.observers) {
                if (observer == null) continue;
                observer.onEvent(this);
            }
        }
    }

    private class ContainedProviderObserver
    implements ObservableMetadataProvider.Observer {
        private ContainedProviderObserver() {
        }

        public void onEvent(MetadataProvider provider) {
            ChainingMetadataProvider.this.emitChangeEvent();
        }
    }
}

