/*
 * Decompiled with CFR 0.152.
 */
package jas.util;

import jas.util.Finishable;
import jas.util.HasNextPages;
import jas.util.JASWizard;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JPanel;

public abstract class JASWizardPage
extends JPanel
implements KeyListener {
    private JASWizardPage m_prev = null;
    private JASWizard m_wizard;
    private JASWizardPage[] m_nextWizardPages = null;
    private final boolean m_isFinishable = this instanceof Finishable;
    private final boolean m_hasNextPages = this instanceof HasNextPages;
    static int pageNumber = 0;
    private String m_number;

    public JASWizardPage(LayoutManager lm) {
        super(lm);
    }

    final JASWizardPage getPrev() {
        return this.m_prev;
    }

    final void addTo(Container c, JASWizard wizard, JASWizardPage prev) {
        this.m_number = String.valueOf(pageNumber++);
        c.add(this.m_number, this);
        if (this.m_hasNextPages) {
            this.m_nextWizardPages = ((HasNextPages)((Object)this)).getNextWizardPages();
            if (this.m_nextWizardPages != null) {
                for (int i = 0; i < this.m_nextWizardPages.length; ++i) {
                    if (this.m_nextWizardPages[i] == null) continue;
                    this.m_nextWizardPages[i].addTo(c, wizard, this);
                }
            }
        }
        this.m_wizard = wizard;
        this.m_prev = prev;
    }

    protected boolean getNextEnabled() {
        return this.m_hasNextPages;
    }

    protected boolean getFinishEnabled() {
        return this.m_isFinishable;
    }

    protected void doEnable() {
        this.m_wizard.setNextEnabled(this.getNextEnabled());
        this.m_wizard.setFinishEnabled(this.getFinishEnabled());
        this.m_wizard.doPrevEnabled();
        if (this.m_isFinishable && this.m_hasNextPages) {
            this.m_wizard.setDefaultButton();
        }
    }

    final void clear() {
        if (this.m_hasNextPages) {
            for (int i = 0; i < this.m_nextWizardPages.length; ++i) {
                if (this.m_nextWizardPages[i] == null) continue;
                this.m_nextWizardPages[i].clear();
            }
            this.m_nextWizardPages = null;
        }
        this.m_prev = null;
        this.m_wizard = null;
    }

    public String toString() {
        return this.m_number;
    }

    protected void dispose() {
        this.m_wizard.dispose();
    }

    final void doCancel() {
        if (this.m_nextWizardPages != null) {
            for (int i = 0; i < this.m_nextWizardPages.length; ++i) {
                if (this.m_nextWizardPages[i] == null) continue;
                this.m_nextWizardPages[i].doCancel();
            }
        }
        this.onCancel();
    }

    public void onCancel() {
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() != 10) {
            this.doEnable();
        }
    }

    final boolean isFinishable() {
        return this.m_isFinishable;
    }

    final boolean hasNextPages() {
        return this.m_hasNextPages;
    }

    public void beforeShowing() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doBusy(Runnable run) {
        this.m_wizard.setToWaitCursor();
        try {
            run.run();
        }
        finally {
            this.m_wizard.setToDefaultCursor();
        }
    }

    protected void handleError(String message, Throwable t) {
        this.m_wizard.handleError(message, t);
    }

    public void keyTyped(KeyEvent e) {
    }
}

