/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.srm.v2_2;

import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.Remote;
import java.util.HashSet;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.rpc.ServiceException;
import org.apache.axis.AxisFault;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.client.Service;
import org.apache.axis.client.Stub;
import org.dcache.srm.v2_2.ISRM;
import org.dcache.srm.v2_2.SRMService;
import org.dcache.srm.v2_2.SrmSoapBindingStub;

public class SRMServiceLocator
extends Service
implements SRMService {
    private String srm_address = "https://localhost:8443/ogsa/services/srm";
    private String srmWSDDServiceName = "srm";
    private HashSet ports = null;

    public SRMServiceLocator() {
    }

    public SRMServiceLocator(EngineConfiguration config) {
        super(config);
    }

    public SRMServiceLocator(String wsdlLoc, QName sName) throws ServiceException {
        super(wsdlLoc, sName);
    }

    @Override
    public String getsrmAddress() {
        return this.srm_address;
    }

    public String getsrmWSDDServiceName() {
        return this.srmWSDDServiceName;
    }

    public void setsrmWSDDServiceName(String name) {
        this.srmWSDDServiceName = name;
    }

    @Override
    public ISRM getsrm() throws ServiceException {
        URL endpoint;
        try {
            endpoint = new URL(this.srm_address);
        }
        catch (MalformedURLException e) {
            throw new ServiceException((Throwable)e);
        }
        return this.getsrm(endpoint);
    }

    @Override
    public ISRM getsrm(URL portAddress) throws ServiceException {
        try {
            SrmSoapBindingStub _stub = new SrmSoapBindingStub(portAddress, this);
            _stub.setPortName(this.getsrmWSDDServiceName());
            return _stub;
        }
        catch (AxisFault e) {
            return null;
        }
    }

    public void setsrmEndpointAddress(String address) {
        this.srm_address = address;
    }

    public Remote getPort(Class serviceEndpointInterface) throws ServiceException {
        try {
            if (ISRM.class.isAssignableFrom(serviceEndpointInterface)) {
                SrmSoapBindingStub _stub = new SrmSoapBindingStub(new URL(this.srm_address), this);
                _stub.setPortName(this.getsrmWSDDServiceName());
                return _stub;
            }
        }
        catch (Throwable t) {
            throw new ServiceException(t);
        }
        throw new ServiceException("There is no stub implementation for the interface:  " + (serviceEndpointInterface == null ? "null" : serviceEndpointInterface.getName()));
    }

    public Remote getPort(QName portName, Class serviceEndpointInterface) throws ServiceException {
        if (portName == null) {
            return this.getPort(serviceEndpointInterface);
        }
        String inputPortName = portName.getLocalPart();
        if ("srm".equals(inputPortName)) {
            return this.getsrm();
        }
        Remote _stub = this.getPort(serviceEndpointInterface);
        ((Stub)_stub).setPortName(portName);
        return _stub;
    }

    public QName getServiceName() {
        return new QName("http://srm.lbl.gov/StorageResourceManager", "SRMService");
    }

    public Iterator getPorts() {
        if (this.ports == null) {
            this.ports = new HashSet();
            this.ports.add(new QName("http://srm.lbl.gov/StorageResourceManager", "srm"));
        }
        return this.ports.iterator();
    }

    public void setEndpointAddress(String portName, String address) throws ServiceException {
        if (!"srm".equals(portName)) {
            throw new ServiceException(" Cannot set Endpoint Address for Unknown Port" + portName);
        }
        this.setsrmEndpointAddress(address);
    }

    public void setEndpointAddress(QName portName, String address) throws ServiceException {
        this.setEndpointAddress(portName.getLocalPart(), address);
    }
}

