/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.srm.util;

import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.zip.Adler32;
import org.dcache.srm.util.OptionMap;
import org.globus.ftp.Buffer;
import org.globus.ftp.DataChannelAuthentication;
import org.globus.ftp.DataSink;
import org.globus.ftp.DataSource;
import org.globus.ftp.GridFTPClient;
import org.globus.ftp.HostPort;
import org.globus.ftp.Options;
import org.globus.ftp.RetrieveOptions;
import org.globus.ftp.exception.ClientException;
import org.globus.ftp.exception.FTPReplyParseException;
import org.globus.ftp.exception.ServerException;
import org.globus.ftp.exception.UnexpectedReplyCodeException;
import org.globus.ftp.vanilla.Reply;
import org.globus.gsi.GlobusCredential;
import org.globus.gsi.GlobusCredentialException;
import org.globus.gsi.gssapi.GlobusGSSCredentialImpl;
import org.globus.util.GlobusURL;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GridftpClient {
    private static final Logger logger = LoggerFactory.getLogger(GridftpClient.class);
    private static final int FirstByteTimeout = 3600;
    private static final int NextByteTimeout = 600;
    private final GridFTPClient _client;
    private final String _host;
    private String _cksmType;
    private String _cksmValue;
    private int _streamsNum = 10;
    private int _tcpBufferSize = 0x100000;
    private int _bufferSize = 0x100000;
    private volatile IDiskDataSourceSink _current_source_sink;
    private long _last_transfer_time = System.currentTimeMillis();
    private long _transferred = 0L;
    private boolean _closed = false;
    private static List<String> cksmTypeList = Arrays.asList("ADLER32", "MD5", "MD4");
    private static final char[] __map = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public GridftpClient(String host, int port, int tcpBufferSize, GSSCredential cred) throws IOException, ServerException, ClientException, GlobusCredentialException, GSSException {
        this(host, port, tcpBufferSize, 0, cred);
    }

    public GridftpClient(String host, int port, int tcpBufferSize, int bufferSize, GSSCredential cred) throws IOException, ServerException, ClientException, GlobusCredentialException, GSSException {
        if (bufferSize > 0) {
            this._bufferSize = bufferSize;
            logger.debug("memory buffer size is set to " + bufferSize);
        }
        if (tcpBufferSize > 0) {
            this._tcpBufferSize = tcpBufferSize;
            logger.debug("tcp buffer size is set to " + tcpBufferSize);
        }
        if (cred == null) {
            GlobusCredential gcred = GlobusCredential.getDefaultCredential();
            cred = new GlobusGSSCredentialImpl(gcred, 1);
        }
        this._host = host;
        logger.debug("connecting to " + this._host + " on port " + port);
        this._client = new GridFTPClient(this._host, port);
        this._client.setLocalTCPBufferSize(this._tcpBufferSize);
        logger.debug("gridFTPClient tcp buffer size is set to " + this._tcpBufferSize);
        this._client.authenticate(cred);
        this._client.setType(1);
    }

    public long getLastTransferTime() {
        IDiskDataSourceSink source_sink = this._current_source_sink;
        if (source_sink != null) {
            this._last_transfer_time = source_sink.getLast_transfer_time();
        }
        return this._last_transfer_time;
    }

    public long getTransfered() {
        IDiskDataSourceSink source_sink = this._current_source_sink;
        if (source_sink != null) {
            this._transferred = source_sink.getTransfered();
        }
        return this._transferred;
    }

    public static long getAdler32(ReadableByteChannel fileChannel) throws IOException {
        Adler32 java_addler = new Adler32();
        byte[] buffer = new byte[4096];
        ByteBuffer bb = ByteBuffer.wrap(buffer);
        while (true) {
            bb.clear();
            int rc = fileChannel.read(bb);
            if (rc <= 0) break;
            java_addler.update(buffer, 0, rc);
        }
        return java_addler.getValue();
    }

    public static String getCksmValue(ReadableByteChannel fileChannel, String type) throws IOException, NoSuchAlgorithmException {
        if (type.equalsIgnoreCase("adler32")) {
            return GridftpClient.long32bitToHexString(GridftpClient.getAdler32(fileChannel));
        }
        MessageDigest md = MessageDigest.getInstance(type);
        ByteBuffer bb = ByteBuffer.allocate(4096);
        while (true) {
            bb.clear();
            int rc = fileChannel.read(bb);
            if (rc <= 0) break;
            bb.flip();
            md.update(bb);
        }
        return GridftpClient.printbytes(md.digest());
    }

    public String list(String directory, boolean serverPassive) throws IOException, ClientException, ServerException {
        this.setCommonOptions(false, serverPassive);
        this._client.changeDir(directory);
        if (serverPassive) {
            this._client.setPassive();
            this._client.setLocalActive();
        } else {
            this._client.setLocalPassive();
            this._client.setActive();
        }
        final ByteArrayOutputStream received = new ByteArrayOutputStream(1000);
        DataSink sink = new DataSink(){

            public void write(Buffer buffer) throws IOException {
                received.write(buffer.getBuffer(), 0, buffer.getLength());
            }

            public void close() throws IOException {
            }
        };
        this._client.list(" ", " ", sink);
        return received.toString();
    }

    public long getSize(String ftppath) throws IOException, ServerException {
        return this._client.getSize(ftppath);
    }

    private void setCommonOptions(boolean emode, boolean passive_server_mode) throws IOException, ClientException, ServerException {
        if (this._client.isFeatureSupported("DCAU")) {
            this._client.setDataChannelAuthentication(DataChannelAuthentication.NONE);
        }
        logger.debug("set local data channel authentication mode to None");
        this._client.setLocalNoDataChannelAuthentication();
        if (emode) {
            this._client.setMode(3);
            logger.debug("parallelism: " + this._streamsNum);
            this._client.setOptions((Options)new RetrieveOptions(this._streamsNum));
        } else {
            this._client.setMode(1);
            logger.debug("stream mode transfer");
            if (!this._client.isFeatureSupported("GETPUT")) {
                if (passive_server_mode) {
                    logger.debug("server is passive");
                    HostPort serverHostPort = this._client.setPassive();
                    logger.debug("serverHostPort=" + serverHostPort.getHost() + ":" + serverHostPort.getPort());
                    this._client.setLocalActive();
                } else {
                    logger.debug("server is active");
                    this._client.setLocalPassive();
                    this._client.setActive();
                }
            }
        }
        this._client.setClientWaitParams(Integer.MAX_VALUE, 1000);
    }

    private void sendNCSAWaitCommand() throws IOException, ServerException, FTPReplyParseException, UnexpectedReplyCodeException {
        logger.debug(" sending wait command to ncsa host " + this._host);
        Reply reply = this._client.quote("SITE WAIT");
        logger.debug("Reply is " + reply);
        if (Reply.isPositiveCompletion((Reply)reply)) {
            logger.debug("sending wait command successful");
        } else {
            logger.error("WARNING: sending wait command failed");
        }
    }

    public void setChecksum(String cksmType, String cksmValue) {
        this._cksmType = cksmType;
        this._cksmValue = cksmValue;
    }

    public String getChecksumValue() {
        return this._cksmValue;
    }

    public String getChecksumType() {
        return this._cksmType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void gridFTPRead(String sourcepath, String destinationfilepath, boolean emode, boolean passive_server_mode) throws FileNotFoundException, IOException, ClientException, ServerException, FTPReplyParseException, UnexpectedReplyCodeException, InterruptedException, NoSuchAlgorithmException {
        FileChannel fileChannel = null;
        try {
            fileChannel = new RandomAccessFile(destinationfilepath, "rw").getChannel();
            this.gridFTPRead(sourcepath, fileChannel, emode, passive_server_mode);
        }
        finally {
            try {
                if (fileChannel != null) {
                    fileChannel.close();
                }
            }
            catch (IOException e) {
                logger.error(" closing of file " + destinationfilepath + " failed", (Throwable)e);
            }
        }
    }

    public void gridFTPRead(String sourcepath, FileChannel fileChannel, boolean emode, boolean passive_server_mode) throws IOException, ClientException, ServerException, FTPReplyParseException, UnexpectedReplyCodeException, InterruptedException, NoSuchAlgorithmException {
        DiskDataSourceSink sink = new DiskDataSourceSink(fileChannel, this._bufferSize, false);
        this.gridFTPRead(sourcepath, sink, emode, passive_server_mode);
    }

    public void gridFTPRead(String sourcepath, IDiskDataSourceSink sink, boolean emode) throws IOException, ClientException, ServerException, FTPReplyParseException, UnexpectedReplyCodeException, InterruptedException, NoSuchAlgorithmException {
        this.gridFTPRead(sourcepath, sink, emode, true);
    }

    public void gridFTPRead(String sourcepath, IDiskDataSourceSink sink, boolean emode, boolean passive_server_mode) throws IOException, ClientException, ServerException, FTPReplyParseException, UnexpectedReplyCodeException, InterruptedException, NoSuchAlgorithmException {
        logger.debug("gridFTPRead started");
        this.setCommonOptions(emode, passive_server_mode);
        if (this._host.toLowerCase().indexOf("ncsa") != -1) {
            this.sendNCSAWaitCommand();
        }
        boolean read = false;
        long size = this._client.getSize(sourcepath);
        this._current_source_sink = sink;
        TransferThread getter = new TransferThread(this._client, sourcepath, sink, emode, passive_server_mode, true, size);
        getter.start();
        getter.waitCompletion(3600, 600);
        if (size - sink.getTransfered() > 0L) {
            logger.error("we wrote less then file size!!!");
            throw new IOException("we wrote less then file size!!!");
        }
        if (size - sink.getTransfered() < 0L) {
            logger.error("we wrote more then file size!!!");
            throw new IOException("we wrote more then file size!!!");
        }
        logger.debug("gridFTPWrite() wrote " + sink.getTransfered() + "bytes");
        try {
            if (this._cksmType != null) {
                this.verifyCksmValue(this._current_source_sink, sourcepath);
            }
        }
        catch (ChecksumNotSupported ex) {
            logger.error("Checksum is not supported:" + ex.toString());
        }
        catch (ChecksumValueFormatException cvfe) {
            logger.error("Checksum format is not valid:" + cvfe.toString());
        }
        this.getTransfered();
        this.getLastTransferTime();
        this._current_source_sink = null;
    }

    public void gridFTPWrite(String sourcefilepath, String destinationpath, boolean emode, boolean use_chksum) throws InterruptedException, ClientException, ServerException, IOException, NoSuchAlgorithmException {
        this.gridFTPWrite(sourcefilepath, destinationpath, emode, use_chksum, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void gridFTPWrite(String sourcefilepath, String destinationpath, boolean emode, boolean use_chksum, boolean passive_server_mode) throws InterruptedException, ClientException, ServerException, IOException, NoSuchAlgorithmException {
        FileChannel fileChannel = null;
        try {
            fileChannel = new RandomAccessFile(sourcefilepath, "r").getChannel();
            this.gridFTPWrite(fileChannel, destinationpath, emode, use_chksum, passive_server_mode);
        }
        finally {
            try {
                if (fileChannel != null) {
                    fileChannel.close();
                }
            }
            catch (IOException ioe) {
                logger.error(" closing of file " + sourcefilepath + " failed", (Throwable)ioe);
            }
        }
    }

    public void gridFTPWrite(FileChannel fileChannel, String destinationpath, boolean emode, boolean use_chksum) throws InterruptedException, ClientException, ServerException, IOException, NoSuchAlgorithmException {
        this.gridFTPWrite(fileChannel, destinationpath, emode, use_chksum, true);
    }

    public void gridFTPWrite(FileChannel fileChannel, String destinationpath, boolean emode, boolean use_chksum, boolean passive_server_mode) throws InterruptedException, ClientException, ServerException, IOException, NoSuchAlgorithmException {
        fileChannel.position(0L);
        DiskDataSourceSink source = new DiskDataSourceSink(fileChannel, this._bufferSize, true);
        this.gridFTPWrite(source, destinationpath, emode, use_chksum, passive_server_mode);
    }

    public void gridFTPWrite(IDiskDataSourceSink source, String destinationpath, boolean emode, boolean use_chksum) throws InterruptedException, ClientException, ServerException, IOException, NoSuchAlgorithmException {
        this.gridFTPWrite(source, destinationpath, emode, use_chksum, true);
    }

    public void gridFTPWrite(IDiskDataSourceSink source, String destinationpath, boolean emode, boolean use_chksum, boolean passive_server_mode) throws InterruptedException, ClientException, ServerException, IOException, NoSuchAlgorithmException {
        logger.debug("gridFTPWrite started, destination path is " + destinationpath);
        this.setCommonOptions(emode, passive_server_mode);
        if (use_chksum || this._cksmType != null) {
            this.sendCksmValue(source);
        }
        this._current_source_sink = source;
        long diskFileLength = source.length();
        TransferThread putter = new TransferThread(this._client, destinationpath, source, emode, passive_server_mode, false, diskFileLength);
        putter.start();
        putter.waitCompletion(3600, 600);
        if (diskFileLength > source.getTransfered()) {
            logger.error("we read less then file size!!!");
            throw new IOException("we read less then file size!!!");
        }
        if (diskFileLength < source.getTransfered()) {
            logger.error("we read more then file size!!!");
            throw new IOException("we read more then file size!!!");
        }
        logger.debug("gridFTPWrite() wrote " + source.getTransfered() + "bytes");
        this.getTransfered();
        this.getLastTransferTime();
        this._current_source_sink = null;
    }

    private void sendCksmValue(IDiskDataSourceSink source) throws IOException, NoSuchAlgorithmException, ClientException, ServerException {
        String commonCksumAlogorithm = this.getCommonChecksumAlgorithm();
        if (commonCksumAlogorithm == null) {
            return;
        }
        try {
            if (commonCksumAlogorithm.equals(this._cksmType) && this._cksmValue != null) {
                this._client.setChecksum(this._cksmType, this._cksmValue);
            } else {
                String checkusValue = source.getCksmValue(commonCksumAlogorithm);
                this._client.setChecksum(commonCksumAlogorithm, checkusValue);
            }
        }
        catch (Exception ex) {
            logger.debug("Was not able to send checksum value:" + ex.toString());
        }
    }

    public String getCommonChecksumAlgorithm() throws IOException, ClientException, ServerException {
        if (!this._client.isFeatureSupported("CKSUM")) {
            return null;
        }
        List algorithms = this._client.getSupportedCksumAlgorithms();
        if (this._cksmType == null || this._cksmType.equals("negotiate")) {
            ArrayList<String> supportedByClientAndServer = new ArrayList<String>(cksmTypeList);
            supportedByClientAndServer.retainAll(algorithms);
            if (supportedByClientAndServer.isEmpty()) {
                return null;
            }
            return (String)supportedByClientAndServer.get(0);
        }
        if (algorithms.contains(this._cksmType)) {
            return this._cksmType;
        }
        return null;
    }

    public Checksum negotiateCksm(String path) throws IOException, ServerException, ClientException, ChecksumNotSupported, ChecksumValueFormatException {
        String commonAlgorithm = this.getCommonChecksumAlgorithm();
        if (commonAlgorithm == null) {
            throw new ChecksumNotSupported("Checksum is not supported : couldn't negotiate type value", 0);
        }
        String serverCksmValue = this._client.getChecksum(commonAlgorithm, path);
        return new Checksum(commonAlgorithm, serverCksmValue);
    }

    private void verifyCksmValue(IDiskDataSourceSink source, String remotePath) throws IOException, ServerException, ClientException, NoSuchAlgorithmException, ChecksumNotSupported, ChecksumValueFormatException {
        if (this._cksmType == null) {
            throw new IllegalArgumentException("verifyCksmValue: expected cksm type");
        }
        Checksum serverChecksum = this._cksmType.equals("negotiate") ? this.negotiateCksm(remotePath) : new Checksum(this._cksmType, this._client.getChecksum(this._cksmType, remotePath));
        if (this._cksmValue == null) {
            this._cksmValue = source.getCksmValue(serverChecksum.type);
        }
        if (!this._cksmValue.equals(serverChecksum.value)) {
            throw new IOException("Server side checksum:" + serverChecksum.value + " does not match client side checksum:" + this._cksmValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException, ServerException {
        GridftpClient gridftpClient = this;
        synchronized (gridftpClient) {
            if (this._closed) {
                return;
            }
            this._closed = true;
        }
        logger.debug("closing client : " + this._client);
        try {
            this._client.close(false);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        logger.debug("closed client");
    }

    protected void finalize() {
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getStreamsNum() {
        return this._streamsNum;
    }

    public void setStreamsNum(int streamsNum) {
        this._streamsNum = streamsNum;
    }

    public int getTcpBufferSize() {
        return this._tcpBufferSize;
    }

    public void setTcpBufferSize(int tcpBufferSize) throws ClientException {
        if (tcpBufferSize > 0) {
            this._tcpBufferSize = tcpBufferSize;
            this._client.setLocalTCPBufferSize(tcpBufferSize);
        }
    }

    public int getBufferSize() {
        return this._bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this._bufferSize = bufferSize;
    }

    public static void setSupportedChecksumTypes(String[] types) {
        cksmTypeList = new ArrayList<String>();
        for (String algorithm : types) {
            cksmTypeList.add(algorithm.toUpperCase());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void main(String[] args) throws Exception {
        if (args.length < 5 || args.length > 11) {
            System.err.println("usage:\n       gridftpcopy <source gridftp/file url> <dest gridftp/file url>  \n                     <memoryBufferSize> <tcpBufferSize> <parallel streams>\n                     <use emode(true or false)> [ <send checksum (true or false)>] [ <server-mode(active or passive)> ] \n                     [--checksumType=<value>] [--checksumValue=<value>] [--checksumPrint=true|false]\n  example:       gridftpcopy gsiftp://host1:2811//file1 file://localhost//tmp/file1 4194304 4194304 11 true false");
            System.exit(1);
            return;
        }
        String source = args[0];
        String dest = args[1];
        int bs = Integer.parseInt(args[2]);
        int tcp_bs = Integer.parseInt(args[3]);
        int streams = Integer.parseInt(args[4]);
        boolean emode = true;
        String server_mode = "active";
        if (args.length > 5) {
            emode = args[5].equals("true");
        }
        if (!emode && args.length >= 8) {
            server_mode = args[7];
        }
        boolean send_checksum = true;
        if (args.length > 6) {
            send_checksum = args[6].equalsIgnoreCase("true");
        }
        OptionMap<String> sMap = new OptionMap<String>(new OptionMap.StringFactory(), args);
        String chsmType = sMap.get("checksumType");
        String chsmValue = sMap.get("checksumValue");
        String cksmPrint = sMap.get("checksumPrint");
        GlobusURL src_url = new GlobusURL(source);
        GlobusURL dst_url = new GlobusURL(dest);
        GSSCredential credential = null;
        if ((src_url.getProtocol().equals("gsiftp") || src_url.getProtocol().equals("gridftp")) && dst_url.getProtocol().equals("file")) {
            GridftpClient client = new GridftpClient(src_url.getHost(), src_url.getPort(), tcp_bs, bs, credential);
            client.setStreamsNum(streams);
            client.setChecksum(chsmType, chsmValue);
            try {
                client.gridFTPRead(src_url.getPath(), dst_url.getPath(), emode, server_mode.equalsIgnoreCase("passive"));
            }
            finally {
                client.close();
            }
            return;
        }
        if (src_url.getProtocol().equals("file") && (dst_url.getProtocol().equals("gsiftp") || dst_url.getProtocol().equals("gridftp"))) {
            GridftpClient client = new GridftpClient(dst_url.getHost(), dst_url.getPort(), tcp_bs, bs, credential);
            client.setStreamsNum(streams);
            try {
                client.setChecksum(chsmType, chsmValue);
                client.gridFTPWrite(src_url.getPath(), dst_url.getPath(), emode, send_checksum, server_mode.equalsIgnoreCase("passive"));
            }
            finally {
                client.close();
            }
            return;
        }
        System.err.println("only \"file to gridftp\" and \"gridftp to file\" transfers are supported");
        System.exit(1);
    }

    public static String long32bitToHexString(long value) {
        value |= 0x100000000L;
        String svalue = Long.toHexString(value &= 0x1FFFFFFFFL);
        if ((svalue = svalue.substring(1)).length() != 8) {
            throw new IllegalStateException("32 bit integer hext string  length is not 8 bytes");
        }
        return svalue;
    }

    public static String printbytes(byte[] bs) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < bs.length; ++i) {
            GridftpClient.byteToHexString(bs[i], sb);
        }
        return sb.toString();
    }

    private static void byteToHexString(byte b, StringBuilder sb) {
        int x = b < 0 ? 256 + b : b;
        sb.append(__map[b >> 4 & 0xF]);
        sb.append(__map[b & 0xF]);
    }

    private class DiskDataSourceSink
    implements IDiskDataSourceSink {
        private final FileChannel _fileChannel;
        private final int _buf_size;
        private volatile long _last_transfer_time = System.currentTimeMillis();
        private long _transferred = 0L;
        private final boolean _source;

        public DiskDataSourceSink(FileChannel fileChannel, int buf_size, boolean source) {
            this._fileChannel = fileChannel;
            this._buf_size = buf_size;
            this._source = source;
        }

        public synchronized void write(Buffer buffer) throws IOException {
            if (this._source) {
                String error = "DiskDataSourceSink is source and write is called";
                logger.error(error);
                throw new IllegalStateException(error);
            }
            this._last_transfer_time = System.currentTimeMillis();
            int read = buffer.getLength();
            long offset = buffer.getOffset();
            if (offset >= 0L) {
                this._fileChannel.position(offset);
            }
            ByteBuffer bb = ByteBuffer.wrap(buffer.getBuffer(), 0, buffer.getLength());
            this._fileChannel.write(bb);
            this._transferred += (long)read;
        }

        public void close() throws IOException {
            logger.debug("DiskDataSink.close() called");
            this._last_transfer_time = System.currentTimeMillis();
        }

        public long totalSize() throws IOException {
            return this._source ? this._fileChannel.size() : -1L;
        }

        @Override
        public long getLast_transfer_time() {
            return this._last_transfer_time;
        }

        @Override
        public synchronized long getTransfered() {
            return this._transferred;
        }

        public synchronized Buffer read() throws IOException {
            if (!this._source) {
                String error = "DiskDataSourceSink is sink and read is called";
                logger.error(error);
                throw new IllegalStateException(error);
            }
            this._last_transfer_time = System.currentTimeMillis();
            byte[] bytes = new byte[this._buf_size];
            ByteBuffer bb = ByteBuffer.wrap(bytes);
            int read = this._fileChannel.read(bb);
            if (read == -1) {
                return null;
            }
            Buffer buffer = new Buffer(bytes, read, this._transferred);
            this._transferred += (long)read;
            return buffer;
        }

        @Override
        public long getAdler32() throws IOException {
            long adler32 = GridftpClient.getAdler32(this._fileChannel);
            this._fileChannel.position(0L);
            return adler32;
        }

        @Override
        public String getCksmValue(String type) throws IOException, NoSuchAlgorithmException {
            String v = GridftpClient.getCksmValue(this._fileChannel, type);
            this._fileChannel.position(0L);
            return v;
        }

        @Override
        public long length() throws IOException {
            return this._fileChannel.size();
        }
    }

    public static interface IDiskDataSourceSink
    extends DataSink,
    DataSource {
        public long getAdler32() throws IOException;

        public String getCksmValue(String var1) throws IOException, NoSuchAlgorithmException;

        public long getLast_transfer_time();

        public long getTransfered();

        public long length() throws IOException;
    }

    public static class ChecksumValueFormatException
    extends Exception {
        public ChecksumValueFormatException(String msg) {
            super(msg);
        }
    }

    public static class ChecksumNotSupported
    extends Exception {
        private int code;

        public ChecksumNotSupported(String msg, int code) {
            super(msg);
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }
    }

    public static class Checksum {
        public String type;
        public String value;

        public Checksum(String type, String value) {
            this.type = type;
            this.value = value;
        }
    }

    private class TransferThread
    implements Runnable {
        private boolean _done = false;
        private final boolean _emode;
        private final boolean _passive_server_mode;
        private final GridFTPClient _client;
        private Exception _throwable;
        private final String _path;
        private final IDiskDataSourceSink _source_sink;
        private final boolean _read;
        private long _size;
        private Thread _runner;

        public TransferThread(GridFTPClient client, String path, IDiskDataSourceSink source_sink, boolean emode, boolean passive_server_mode, boolean read, long size) {
            this._client = client;
            this._path = path;
            this._source_sink = source_sink;
            this._emode = emode;
            this._passive_server_mode = passive_server_mode;
            this._read = read;
            this._size = size;
        }

        public void start() {
            this._runner = new Thread(this);
            this._runner.start();
        }

        public void waitCompletion(int FirstByteTimeout, int NextByteTimeout) throws InterruptedException, ClientException, ServerException, IOException {
            long timeout = (long)FirstByteTimeout * 1000L;
            logger.debug("waiting for completion of transfer");
            boolean timedout = false;
            boolean interrupted = false;
            try {
                while (true) {
                    this.waitCompleteion(timeout);
                    if (this.isDone()) break;
                    if (System.currentTimeMillis() - this._source_sink.getLast_transfer_time() > timeout) {
                        timedout = true;
                        break;
                    }
                    timeout = (long)NextByteTimeout * 1000L;
                }
            }
            catch (InterruptedException ie) {
                this._runner.interrupt();
                interrupted = true;
            }
            if (timedout || interrupted) {
                this._runner.interrupt();
                String error = "transfer timedout or interrupted";
                logger.error(error);
                throw new InterruptedException(error);
            }
            if (this.getThrowable() != null) {
                Exception e = this.getThrowable();
                logger.error(" transfer exception", (Throwable)e);
                if (e instanceof ClientException) {
                    throw (ClientException)e;
                }
                if (e instanceof ServerException) {
                    throw (ServerException)e;
                }
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                throw new RuntimeException("Unexpected exception", e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void waitCompleteion() throws InterruptedException {
            while (true) {
                TransferThread transferThread = this;
                synchronized (transferThread) {
                    this.wait(1000L);
                    if (this._done) {
                        return;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void waitCompleteion(long timeout) throws InterruptedException {
            TransferThread transferThread = this;
            synchronized (transferThread) {
                this.wait(timeout);
            }
        }

        public synchronized void done() {
            this._done = true;
            this.notifyAll();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                if (this._read) {
                    logger.debug("starting a transfer from " + this._path);
                    if (this._client.isFeatureSupported("GETPUT")) {
                        this._client.get2(this._path, this._emode ? false : this._passive_server_mode, (DataSink)this._source_sink, null);
                    } else {
                        this._client.get(this._path, (DataSink)this._source_sink, null);
                    }
                } else {
                    logger.debug("starting a transfer to " + this._path);
                    if (this._client.isFeatureSupported("GETPUT")) {
                        this._client.put2(this._path, this._emode ? true : this._passive_server_mode, (DataSource)this._source_sink, null);
                    } else {
                        this._client.put(this._path, (DataSource)this._source_sink, null);
                    }
                }
            }
            catch (IOException e) {
                logger.error(e.toString());
                this._throwable = e;
            }
            catch (ServerException e) {
                logger.error(e.toString());
                this._throwable = e;
            }
            catch (ClientException e) {
                logger.error(e.toString());
                this._throwable = e;
            }
            finally {
                this.done();
            }
        }

        public synchronized boolean isDone() {
            return this._done;
        }

        public Exception getThrowable() {
            return this._throwable;
        }
    }
}

