/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.srm.util;

import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ArgParser {
    private static final int INT_OPTION_TYPE = 0;
    private static final int STRING_OPTION_TYPE = 1;
    private static final int VOID_OPTION_TYPE = 2;
    private Hashtable general_options = new Hashtable();
    private Hashtable command_options = new Hashtable();
    private String[] argv;
    private Hashtable option_list = new Hashtable();
    private String command_name;
    private Vector arguments = new Vector();
    private String[] commands;
    private boolean parsed;
    private boolean usecommand;

    private ArgParser() {
    }

    public ArgParser(String[] argv, String[] commands) {
        this.argv = argv;
        if (commands != null && commands.length > 0) {
            this.commands = commands;
            this.usecommand = true;
        }
    }

    public ArgParser(String[] argv) {
        this.argv = argv;
        this.usecommand = false;
    }

    public void addIntegerOption(String command, String name, String description, int min_value, int max_value) throws IllegalArgumentException {
        if (!this.usecommand && command != null) {
            throw new IllegalArgumentException(" try to specify a command option for an unexisting command " + command);
        }
        if (this.parsed) {
            throw new IllegalArgumentException("command line has been already parsed");
        }
        ArgOption option = new ArgOption();
        option.command = command;
        option.name = name;
        option.min_val = min_value;
        option.max_val = max_value;
        option.type = 0;
        option.description = description;
        if (command == null) {
            this.option_list.put(name, option);
        } else {
            this.option_list.put(command + " " + name, option);
        }
    }

    public void addStringOption(String command, String name, String description) throws IllegalArgumentException {
        if (!this.usecommand && command != null) {
            throw new IllegalArgumentException(" try to specify a command option for an unexisting command " + command);
        }
        if (this.parsed) {
            throw new IllegalArgumentException("command line has been already parsed");
        }
        ArgOption option = new ArgOption();
        option.command = command;
        option.name = name;
        option.type = 1;
        option.description = description;
        if (command == null) {
            this.option_list.put(name, option);
        } else {
            this.option_list.put(command + " " + name, option);
        }
    }

    public void addVoidOption(String command, String name, String description) throws IllegalArgumentException {
        if (!this.usecommand && command != null) {
            throw new IllegalArgumentException(" try to specify a command option for an unexisting command " + command);
        }
        if (this.parsed) {
            throw new IllegalArgumentException("command line has been already parsed");
        }
        ArgOption option = new ArgOption();
        option.command = command;
        option.name = name;
        option.type = 2;
        option.description = description;
        if (command == null) {
            this.option_list.put(name, option);
        } else {
            this.option_list.put(command + " " + name, option);
        }
    }

    public void parse() throws IllegalArgumentException {
        if (this.parsed) {
            throw new IllegalArgumentException("command line has been already parsed");
        }
        String option_value = null;
        boolean general_option = true;
        for (int i = 0; i < this.argv.length; ++i) {
            option_value = null;
            if (this.argv[i].charAt(0) == '-') {
                String option_name;
                int equals_index = this.argv[i].indexOf(61);
                if (equals_index == 0) {
                    throw new IllegalArgumentException("command line parse exception, invalid option: " + this.argv[i]);
                }
                if (equals_index > 0) {
                    option_name = this.argv[i].substring(1, equals_index);
                    option_value = this.argv[i].substring(equals_index + 1);
                } else {
                    option_name = this.argv[i].substring(1);
                }
                ArgOption option = general_option ? (ArgOption)this.option_list.get(option_name) : (ArgOption)this.option_list.get(this.command_name + " " + option_name);
                if (option == null) {
                    throw new IllegalArgumentException("command line parse exception, unrecognized option: " + this.argv[i]);
                }
                if (general_option && option.command != null) {
                    throw new IllegalArgumentException("command line parse exception, missplased command " + option.command + " option: " + this.argv[i]);
                }
                if (!general_option && option.command == null) {
                    throw new IllegalArgumentException("command line parse exception, missplased general option: " + this.argv[i]);
                }
                ArgOption new_option = option.copy();
                if (new_option.type == 1) {
                    if (option_value == null || option_value.equals("")) {
                        throw new IllegalArgumentException("command line parse exception, option value is not specified: " + this.argv[i]);
                    }
                    new_option.string_option_value = option_value;
                } else if (new_option.type == 0) {
                    if (option_value == null) {
                        throw new IllegalArgumentException("command line parse exception, option value is not specified: " + this.argv[i]);
                    }
                    try {
                        new_option.int_option_value = Integer.parseInt(option_value);
                    }
                    catch (NumberFormatException nfe) {
                        throw new IllegalArgumentException("command line parse exception, invalid option value: " + this.argv[i] + "\n error:" + nfe.getMessage());
                    }
                    if (new_option.int_option_value < new_option.min_val || new_option.int_option_value > new_option.max_val) {
                        throw new IllegalArgumentException("command line parse exception, invalid option value: " + this.argv[i] + "\n error: value is outside range [" + new_option.min_val + "," + new_option.max_val + "]");
                    }
                }
                if (general_option) {
                    this.general_options.put(option_name, new_option);
                    continue;
                }
                this.command_options.put(this.command_name + " " + option_name, new_option);
                continue;
            }
            if (general_option && this.usecommand) {
                for (int j = 0; j < this.commands.length; ++j) {
                    if (!this.argv[i].equals(this.commands[j])) continue;
                    this.command_name = this.argv[i];
                    break;
                }
                if (this.command_name == null) {
                    throw new IllegalArgumentException("command line parse exception, invalid command name: " + this.argv[i]);
                }
                general_option = false;
                continue;
            }
            this.arguments.add(this.argv[i]);
        }
        if (this.command_name == null && this.usecommand) {
            throw new IllegalArgumentException("command line parse exception, command name not specified ");
        }
        this.parsed = true;
    }

    public boolean isOptionSet(String command, String name) throws IllegalArgumentException {
        if (!this.parsed) {
            throw new IllegalArgumentException("command line hasn't been parsed yet");
        }
        if (command == null) {
            return this.general_options.containsKey(name);
        }
        return this.command_options.containsKey(command + " " + name);
    }

    private ArgOption getOption(String command, String name) throws IllegalArgumentException {
        ArgOption option;
        if (!this.parsed) {
            throw new IllegalArgumentException("command line hasn't been parsed yet");
        }
        if (command == null) {
            option = (ArgOption)this.general_options.get(name);
            if (option == null) {
                throw new IllegalArgumentException("option " + name + " is not set");
            }
        } else {
            option = (ArgOption)this.command_options.get(command + " " + name);
            if (option == null) {
                throw new IllegalArgumentException("option " + name + " for command " + command + " is not set");
            }
        }
        return option;
    }

    public String stringOptionValue(String command, String name) throws IllegalArgumentException {
        ArgOption option = this.getOption(command, name);
        if (option.type != 1) {
            throw new IllegalArgumentException("option is not a string option");
        }
        return option.string_option_value;
    }

    public int intOptionValue(String command, String name) throws IllegalArgumentException {
        ArgOption option = this.getOption(command, name);
        if (option.type != 0) {
            throw new IllegalArgumentException("option is not a string option");
        }
        return option.int_option_value;
    }

    public String getCommand() throws IllegalArgumentException {
        if (!this.parsed) {
            throw new IllegalArgumentException("command line hasn't been parsed yet");
        }
        return this.command_name;
    }

    public String[] getCommandArguments() throws IllegalArgumentException {
        if (!this.parsed) {
            throw new IllegalArgumentException("command line hasn't been parsed yet");
        }
        String[] rc = new String[this.arguments.size()];
        this.arguments.toArray(rc);
        return rc;
    }

    public String usage() {
        StringBuffer sb = new StringBuffer();
        sb.append("Usage: srm [general-options] ");
        if (this.commands != null) {
            sb.append("command [command-options-and-arguments]\n");
        }
        sb.append("  where general-options are:\n");
        Object[] keys = new String[this.option_list.size()];
        Enumeration e = this.option_list.keys();
        int i = 0;
        while (e.hasMoreElements()) {
            keys[i++] = (String)e.nextElement();
        }
        Arrays.sort(keys);
        for (i = 0; i < keys.length; ++i) {
            Object key = keys[i];
            if (((String)key).indexOf(32) != -1) continue;
            ArgOption option = (ArgOption)this.option_list.get(key);
            ArgParser.optionToSB(sb, option);
        }
        if (this.commands != null) {
            sb.append("  command :\n");
            for (i = 0; i < this.commands.length; ++i) {
                sb.append("    ").append(this.commands[i]).append('\n');
            }
            sb.append("--help-command <command-name> for command details");
        }
        return sb.toString();
    }

    public String usage(String command) {
        int i;
        for (i = 0; i < this.commands.length && !this.commands[i].equals(command); ++i) {
        }
        if (i == this.commands.length) {
            return "unknown comand " + command + ", srm --help for felp";
        }
        StringBuffer sb = new StringBuffer();
        sb.append(command);
        sb.append(" usage: srm [general-options] " + command + " [options-and-arguments]\n");
        sb.append("  where options-and-arguments are:\n");
        Enumeration e = this.option_list.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (key.indexOf(32) == -1 || !key.startsWith(command + ' ')) continue;
            ArgOption option = (ArgOption)this.option_list.get(key);
            if (option == null) {
                sb.append("ERROR: option for the key \"" + key + "\" is null");
                continue;
            }
            ArgParser.optionToSB(sb, option);
        }
        return sb.toString();
    }

    private static void optionToSB(StringBuffer sb, ArgOption option) {
        sb.append("      -").append(option.name);
        if (option.type == 0) {
            sb.append("=<int-value> where ").append(option.min_val);
            sb.append(" is less than <int-value>, and <int-value> is less thavin ").append(option.max_val);
        } else if (option.type == 1) {
            sb.append("=<string-value>");
        }
        if (option.description != null && !option.description.equalsIgnoreCase("description")) {
            sb.append("\n\t\t").append(option.description);
        }
        sb.append('\n');
    }

    private class ArgOption {
        String command;
        String name;
        int type;
        int min_val;
        int max_val;
        String string_option_value;
        int int_option_value;
        String description;

        private ArgOption() {
        }

        protected Object clone() {
            ArgOption the_clone;
            try {
                the_clone = (ArgOption)super.clone();
            }
            catch (CloneNotSupportedException cnse) {
                the_clone = new ArgOption();
            }
            the_clone.command = this.command;
            the_clone.name = this.name;
            the_clone.type = this.type;
            the_clone.min_val = this.min_val;
            the_clone.max_val = this.max_val;
            the_clone.string_option_value = this.string_option_value;
            the_clone.int_option_value = this.int_option_value;
            the_clone.description = this.description;
            return the_clone;
        }

        ArgOption copy() {
            return (ArgOption)this.clone();
        }
    }
}

