/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.srm.unixfs;

import java.util.HashSet;
import java.util.Iterator;
import org.dcache.srm.unixfs.UserAuthBase;

public class UserAuthRecord
extends UserAuthBase {
    public HashSet principals;

    public UserAuthRecord(String user, boolean readOnly, int uid, int gid, String home, String root, String fsroot, HashSet principals) {
        super(user, readOnly, uid, gid, home, root, fsroot);
        this.principals = principals;
    }

    public UserAuthRecord() {
        super(null, true, -1, -1, "", "", "");
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.Username);
        if (this.ReadOnly) {
            sb.append(" read-only");
        } else {
            sb.append(" read-write");
        }
        sb.append(' ').append(this.UID).append(' ');
        sb.append(this.GID).append(' ');
        sb.append(this.Home).append(' ');
        sb.append(this.Root).append(' ');
        sb.append(this.FsRoot).append('\n');
        if (this.principals != null) {
            Iterator iter = this.principals.iterator();
            while (iter.hasNext()) {
                sb.append("  ").append(iter.next()).append('\n');
            }
        }
        return sb.toString();
    }

    public String toDetailedString() {
        StringBuffer sb = new StringBuffer(" User Authentication Record for ");
        sb.append(this.Username).append(" :\n");
        sb.append("      read-only = " + this.readOnlyStr() + "\n");
        sb.append("            UID = ").append(this.UID).append('\n');
        sb.append("            GID = ").append(this.GID).append('\n');
        sb.append("           Home = ").append(this.Home).append('\n');
        sb.append("           Root = ").append(this.Root).append('\n');
        sb.append("         FsRoot = ").append(this.FsRoot).append('\n');
        if (this.principals != null) {
            sb.append("         Secure Ids accepted by this user :\n");
            Iterator iter = this.principals.iterator();
            while (iter.hasNext()) {
                sb.append("    SecureId  = \"").append(iter.next()).append("\"\n");
            }
        }
        return sb.toString();
    }

    @Override
    public boolean isAnonymous() {
        return false;
    }

    @Override
    public boolean isWeak() {
        return false;
    }

    public boolean hasSecureIdentity(String p) {
        if (this.principals != null) {
            return this.principals.contains(p);
        }
        return false;
    }

    public boolean isValid() {
        return this.Username != null;
    }

    public void addSecureIdentity(String id) {
        this.principals.add(id);
    }

    public void addSecureIdentities(HashSet ids) {
        ids.toArray(new String[0]);
        this.principals.addAll(ids);
    }

    public void removeSecureIdentities(HashSet ids) {
        ids.toArray(new String[0]);
        this.principals.removeAll(ids);
    }
}

