/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.srm.server;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.Collection;
import javax.naming.InitialContext;
import org.dcache.commons.stats.RequestCounters;
import org.dcache.commons.stats.RequestExecutionTimeGauges;
import org.dcache.srm.AbstractStorageElement;
import org.dcache.srm.SRM;
import org.dcache.srm.SRMAuthorizationException;
import org.dcache.srm.SRMUser;
import org.dcache.srm.request.RequestCredential;
import org.dcache.srm.server.SrmAuthorizer;
import org.dcache.srm.server.SrmDCacheConnector;
import org.dcache.srm.server.UserCredential;
import org.dcache.srm.util.Configuration;
import org.dcache.srm.util.JDC;
import org.dcache.srm.v2_2.ISRM;
import org.dcache.srm.v2_2.SrmAbortFilesRequest;
import org.dcache.srm.v2_2.SrmAbortFilesResponse;
import org.dcache.srm.v2_2.SrmAbortRequestRequest;
import org.dcache.srm.v2_2.SrmAbortRequestResponse;
import org.dcache.srm.v2_2.SrmBringOnlineRequest;
import org.dcache.srm.v2_2.SrmBringOnlineResponse;
import org.dcache.srm.v2_2.SrmChangeSpaceForFilesRequest;
import org.dcache.srm.v2_2.SrmChangeSpaceForFilesResponse;
import org.dcache.srm.v2_2.SrmCheckPermissionRequest;
import org.dcache.srm.v2_2.SrmCheckPermissionResponse;
import org.dcache.srm.v2_2.SrmCopyRequest;
import org.dcache.srm.v2_2.SrmCopyResponse;
import org.dcache.srm.v2_2.SrmExtendFileLifeTimeInSpaceRequest;
import org.dcache.srm.v2_2.SrmExtendFileLifeTimeInSpaceResponse;
import org.dcache.srm.v2_2.SrmExtendFileLifeTimeRequest;
import org.dcache.srm.v2_2.SrmExtendFileLifeTimeResponse;
import org.dcache.srm.v2_2.SrmGetPermissionRequest;
import org.dcache.srm.v2_2.SrmGetPermissionResponse;
import org.dcache.srm.v2_2.SrmGetRequestSummaryRequest;
import org.dcache.srm.v2_2.SrmGetRequestSummaryResponse;
import org.dcache.srm.v2_2.SrmGetRequestTokensRequest;
import org.dcache.srm.v2_2.SrmGetRequestTokensResponse;
import org.dcache.srm.v2_2.SrmGetSpaceMetaDataRequest;
import org.dcache.srm.v2_2.SrmGetSpaceMetaDataResponse;
import org.dcache.srm.v2_2.SrmGetSpaceTokensRequest;
import org.dcache.srm.v2_2.SrmGetSpaceTokensResponse;
import org.dcache.srm.v2_2.SrmGetTransferProtocolsRequest;
import org.dcache.srm.v2_2.SrmGetTransferProtocolsResponse;
import org.dcache.srm.v2_2.SrmLsRequest;
import org.dcache.srm.v2_2.SrmLsResponse;
import org.dcache.srm.v2_2.SrmMkdirRequest;
import org.dcache.srm.v2_2.SrmMkdirResponse;
import org.dcache.srm.v2_2.SrmMvRequest;
import org.dcache.srm.v2_2.SrmMvResponse;
import org.dcache.srm.v2_2.SrmPingRequest;
import org.dcache.srm.v2_2.SrmPingResponse;
import org.dcache.srm.v2_2.SrmPrepareToGetRequest;
import org.dcache.srm.v2_2.SrmPrepareToGetResponse;
import org.dcache.srm.v2_2.SrmPrepareToPutRequest;
import org.dcache.srm.v2_2.SrmPrepareToPutResponse;
import org.dcache.srm.v2_2.SrmPurgeFromSpaceRequest;
import org.dcache.srm.v2_2.SrmPurgeFromSpaceResponse;
import org.dcache.srm.v2_2.SrmPutDoneRequest;
import org.dcache.srm.v2_2.SrmPutDoneResponse;
import org.dcache.srm.v2_2.SrmReleaseFilesRequest;
import org.dcache.srm.v2_2.SrmReleaseFilesResponse;
import org.dcache.srm.v2_2.SrmReleaseSpaceRequest;
import org.dcache.srm.v2_2.SrmReleaseSpaceResponse;
import org.dcache.srm.v2_2.SrmReserveSpaceRequest;
import org.dcache.srm.v2_2.SrmReserveSpaceResponse;
import org.dcache.srm.v2_2.SrmResumeRequestRequest;
import org.dcache.srm.v2_2.SrmResumeRequestResponse;
import org.dcache.srm.v2_2.SrmRmRequest;
import org.dcache.srm.v2_2.SrmRmResponse;
import org.dcache.srm.v2_2.SrmRmdirRequest;
import org.dcache.srm.v2_2.SrmRmdirResponse;
import org.dcache.srm.v2_2.SrmSetPermissionRequest;
import org.dcache.srm.v2_2.SrmSetPermissionResponse;
import org.dcache.srm.v2_2.SrmStatusOfBringOnlineRequestRequest;
import org.dcache.srm.v2_2.SrmStatusOfBringOnlineRequestResponse;
import org.dcache.srm.v2_2.SrmStatusOfChangeSpaceForFilesRequestRequest;
import org.dcache.srm.v2_2.SrmStatusOfChangeSpaceForFilesRequestResponse;
import org.dcache.srm.v2_2.SrmStatusOfCopyRequestRequest;
import org.dcache.srm.v2_2.SrmStatusOfCopyRequestResponse;
import org.dcache.srm.v2_2.SrmStatusOfGetRequestRequest;
import org.dcache.srm.v2_2.SrmStatusOfGetRequestResponse;
import org.dcache.srm.v2_2.SrmStatusOfLsRequestRequest;
import org.dcache.srm.v2_2.SrmStatusOfLsRequestResponse;
import org.dcache.srm.v2_2.SrmStatusOfPutRequestRequest;
import org.dcache.srm.v2_2.SrmStatusOfPutRequestResponse;
import org.dcache.srm.v2_2.SrmStatusOfReserveSpaceRequestRequest;
import org.dcache.srm.v2_2.SrmStatusOfReserveSpaceRequestResponse;
import org.dcache.srm.v2_2.SrmStatusOfUpdateSpaceRequestRequest;
import org.dcache.srm.v2_2.SrmStatusOfUpdateSpaceRequestResponse;
import org.dcache.srm.v2_2.SrmSuspendRequestRequest;
import org.dcache.srm.v2_2.SrmSuspendRequestResponse;
import org.dcache.srm.v2_2.SrmUpdateSpaceRequest;
import org.dcache.srm.v2_2.SrmUpdateSpaceResponse;
import org.dcache.srm.v2_2.TReturnStatus;
import org.dcache.srm.v2_2.TStatusCode;
import org.gridforum.jgss.ExtendedGSSContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SRMServerV2
implements ISRM {
    public Logger log;
    private SrmDCacheConnector srmConn;
    private SrmAuthorizer srmAuth = null;
    Configuration configuration;
    private AbstractStorageElement storage;
    private final RequestCounters<Class<?>> srmServerCounters;
    private final RequestExecutionTimeGauges<Class<?>> srmServerGauges;

    public SRMServerV2() throws RemoteException {
        try {
            this.log = LoggerFactory.getLogger((String)("logger.org.dcache.authorization." + this.getClass().getName()));
            InitialContext logctx = new InitialContext();
            String srmConfigFile = (String)logctx.lookup("java:comp/env/srmConfigFile");
            if (srmConfigFile == null) {
                String error = "name of srm config file is not specified";
                String error_details = "please insert the following xml codelet into web.xml\n <env-entry>\n  <env-entry-name>srmConfigFile</env-entry-name>\n   <env-entry-value>INSERT SRM CONFIG FILE NAME HERE</env-entry-value>\n  <env-entry-type>java.lang.String</env-entry-type>\n </env-entry>";
                this.log.error(error);
                this.log.error(error_details);
                throw new RemoteException(error);
            }
            this.srmConn = SrmDCacheConnector.getInstance(srmConfigFile);
            if (this.srmConn == null) {
                throw new RemoteException("Failed to get instance of srm.");
            }
            this.log.info(" initialize() got connector =" + this.srmConn);
            this.srmAuth = new SrmAuthorizer(this.srmConn);
            this.storage = this.srmConn.getSrm().getConfiguration().getStorage();
            this.srmServerCounters = this.srmConn.getSrm().getSrmServerV2Counters();
            this.srmServerGauges = this.srmConn.getSrm().getSrmServerV2Gauges();
        }
        catch (RemoteException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RemoteException("exception", e);
        }
    }

    private Object handleRequest(String requestName, Object request) throws RemoteException {
        long startTimeStamp = System.currentTimeMillis();
        JDC.createSession("v2:" + requestName + ":");
        Class<?> requestClass = request.getClass();
        try {
            Object response;
            Method handleGetResponseMethod;
            Object handler;
            RequestCredential requestCredential;
            UserCredential userCred;
            Object user;
            this.srmServerCounters.incrementRequests(requestClass);
            String capitalizedRequestName = Character.toUpperCase(requestName.charAt(0)) + requestName.substring(1);
            try {
                this.log.debug("Entering SRMServerV2." + requestName + "()");
                String authorizationID = null;
                try {
                    Method getAuthorizationID = requestClass.getMethod("getAuthorizationID", null);
                    if (getAuthorizationID != null) {
                        authorizationID = (String)getAuthorizationID.invoke(request, (Object[])null);
                        this.log.debug("SRMServerV2." + requestName + "() : authorization id" + authorizationID);
                    }
                }
                catch (Exception e) {
                    this.log.error("getting authorization id failed", (Throwable)e);
                }
                user = null;
                userCred = null;
                requestCredential = null;
                try {
                    userCred = this.srmAuth.getUserCredentials();
                    Collection<String> roles = SrmAuthorizer.getFQANsFromContext((ExtendedGSSContext)userCred.context);
                    String role = roles.isEmpty() ? null : (String)roles.toArray()[0];
                    this.log.debug("SRMServerV2." + requestName + "() : role is " + role);
                    requestCredential = this.srmAuth.getRequestCredential(userCred, role);
                    user = this.srmAuth.getRequestUser(requestCredential, null, userCred.context);
                }
                catch (SRMAuthorizationException sae) {
                    this.log.info("SRM Authorization failed: {}", (Object)sae.getMessage());
                    Object role = this.getFailedResponse(capitalizedRequestName, TStatusCode.SRM_AUTHENTICATION_FAILURE, "SRM Authentication failed");
                    this.srmServerGauges.update(requestClass, System.currentTimeMillis() - startTimeStamp);
                    JDC.clear();
                    return role;
                }
            }
            catch (Exception e) {
                this.log.error(" handleRequest: ", (Throwable)e);
                try {
                    user = this.getFailedResponse(capitalizedRequestName, TStatusCode.SRM_INTERNAL_ERROR, "internal error: " + e.getMessage());
                    return user;
                }
                catch (Exception ee) {
                    throw new RemoteException("SRMServerV2." + requestName + "() exception", e);
                }
            }
            this.log.debug("About to call SRMServerV2" + requestName + "()");
            try {
                Class<?> handlerClass = Class.forName("org.dcache.srm.handler." + capitalizedRequestName);
                Constructor<?> handlerConstructor = handlerClass.getConstructor(SRMUser.class, RequestCredential.class, requestClass, AbstractStorageElement.class, SRM.class, String.class);
                handler = handlerConstructor.newInstance(user, requestCredential, request, this.storage, this.srmConn.getSrm(), userCred.clientHost);
                handleGetResponseMethod = handlerClass.getMethod("getResponse", null);
            }
            catch (ClassNotFoundException e) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("handler discovery and dinamic load failed", (Throwable)e);
                } else {
                    this.log.info("handler discovery and dinamic load failed");
                }
                Object object = this.getFailedResponse(capitalizedRequestName, TStatusCode.SRM_NOT_SUPPORTED, "can not find a handler, not implemented");
                this.srmServerGauges.update(requestClass, System.currentTimeMillis() - startTimeStamp);
                JDC.clear();
                return object;
            }
            Object object = response = handleGetResponseMethod.invoke(handler, (Object[])null);
            return object;
        }
        finally {
            this.srmServerGauges.update(requestClass, System.currentTimeMillis() - startTimeStamp);
            JDC.clear();
        }
    }

    private Object getFailedResponse(String capitalizedRequestName, TStatusCode statusCode, String errorMessage) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Class<?> responseClass = Class.forName("org.dcache.srm.v2_2." + capitalizedRequestName + "Response");
        Constructor<?> responseConstructor = responseClass.getConstructor(null);
        Object response = responseConstructor.newInstance(null);
        try {
            TReturnStatus trs = new TReturnStatus(statusCode, errorMessage);
            Method setReturnStatus = responseClass.getMethod("setReturnStatus", TReturnStatus.class);
            setReturnStatus.invoke(response, trs);
        }
        catch (NoSuchMethodException nsme) {
            this.log.error("getFailedResponse invocation failed for " + capitalizedRequestName + "Response.setReturnStatus");
            if (capitalizedRequestName.equals("SrmPing")) {
                Class<?> handlerClass = Class.forName("org.dcache.srm.handler." + capitalizedRequestName);
                Method getFailedRespose = handlerClass.getMethod("getFailedResponse", String.class);
                return getFailedRespose.invoke(null, errorMessage);
            }
        }
        catch (Exception e) {
            this.log.error("getFailedResponse invocation failed", (Throwable)e);
            Method setStatusCode = responseClass.getMethod("setStatusCode", TStatusCode.class);
            Method setExplanation = responseClass.getMethod("setExplanation", String.class);
            setStatusCode.invoke(response, statusCode);
            setExplanation.invoke(response, errorMessage);
        }
        return response;
    }

    @Override
    public SrmReserveSpaceResponse srmReserveSpace(SrmReserveSpaceRequest srmReserveSpaceRequest) throws RemoteException {
        return (SrmReserveSpaceResponse)this.handleRequest("srmReserveSpace", srmReserveSpaceRequest);
    }

    @Override
    public SrmReleaseSpaceResponse srmReleaseSpace(SrmReleaseSpaceRequest srmReleaseSpaceRequest) throws RemoteException {
        return (SrmReleaseSpaceResponse)this.handleRequest("srmReleaseSpace", srmReleaseSpaceRequest);
    }

    @Override
    public SrmUpdateSpaceResponse srmUpdateSpace(SrmUpdateSpaceRequest srmUpdateSpaceRequest) throws RemoteException {
        return (SrmUpdateSpaceResponse)this.handleRequest("srmUpdateSpace", srmUpdateSpaceRequest);
    }

    @Override
    public SrmGetSpaceMetaDataResponse srmGetSpaceMetaData(SrmGetSpaceMetaDataRequest srmGetSpaceMetaDataRequest) throws RemoteException {
        return (SrmGetSpaceMetaDataResponse)this.handleRequest("srmGetSpaceMetaData", srmGetSpaceMetaDataRequest);
    }

    @Override
    public SrmSetPermissionResponse srmSetPermission(SrmSetPermissionRequest srmSetPermissionRequest) throws RemoteException {
        return (SrmSetPermissionResponse)this.handleRequest("srmSetPermission", srmSetPermissionRequest);
    }

    @Override
    public SrmCheckPermissionResponse srmCheckPermission(SrmCheckPermissionRequest srmCheckPermissionRequest) throws RemoteException {
        return (SrmCheckPermissionResponse)this.handleRequest("srmCheckPermission", srmCheckPermissionRequest);
    }

    @Override
    public SrmMkdirResponse srmMkdir(SrmMkdirRequest request) throws RemoteException {
        return (SrmMkdirResponse)this.handleRequest("srmMkdir", request);
    }

    @Override
    public SrmRmdirResponse srmRmdir(SrmRmdirRequest request) throws RemoteException {
        return (SrmRmdirResponse)this.handleRequest("srmRmdir", request);
    }

    @Override
    public SrmCopyResponse srmCopy(SrmCopyRequest request) throws RemoteException {
        return (SrmCopyResponse)this.handleRequest("srmCopy", request);
    }

    @Override
    public SrmRmResponse srmRm(SrmRmRequest request) throws RemoteException {
        return (SrmRmResponse)this.handleRequest("srmRm", request);
    }

    @Override
    public SrmLsResponse srmLs(SrmLsRequest srmLsRequest) throws RemoteException {
        return (SrmLsResponse)this.handleRequest("srmLs", srmLsRequest);
    }

    @Override
    public SrmMvResponse srmMv(SrmMvRequest request) throws RemoteException {
        return (SrmMvResponse)this.handleRequest("srmMv", request);
    }

    @Override
    public SrmPrepareToGetResponse srmPrepareToGet(SrmPrepareToGetRequest srmPrepareToGetRequest) throws RemoteException {
        return (SrmPrepareToGetResponse)this.handleRequest("srmPrepareToGet", srmPrepareToGetRequest);
    }

    @Override
    public SrmPrepareToPutResponse srmPrepareToPut(SrmPrepareToPutRequest srmPrepareToPutRequest) throws RemoteException {
        return (SrmPrepareToPutResponse)this.handleRequest("srmPrepareToPut", srmPrepareToPutRequest);
    }

    @Override
    public SrmReleaseFilesResponse srmReleaseFiles(SrmReleaseFilesRequest srmReleaseFilesRequest) throws RemoteException {
        return (SrmReleaseFilesResponse)this.handleRequest("srmReleaseFiles", srmReleaseFilesRequest);
    }

    @Override
    public SrmPutDoneResponse srmPutDone(SrmPutDoneRequest srmPutDoneRequest) throws RemoteException {
        return (SrmPutDoneResponse)this.handleRequest("srmPutDone", srmPutDoneRequest);
    }

    @Override
    public SrmAbortRequestResponse srmAbortRequest(SrmAbortRequestRequest srmAbortRequestRequest) throws RemoteException {
        return (SrmAbortRequestResponse)this.handleRequest("srmAbortRequest", srmAbortRequestRequest);
    }

    @Override
    public SrmAbortFilesResponse srmAbortFiles(SrmAbortFilesRequest srmAbortFilesRequest) throws RemoteException {
        return (SrmAbortFilesResponse)this.handleRequest("srmAbortFiles", srmAbortFilesRequest);
    }

    @Override
    public SrmSuspendRequestResponse srmSuspendRequest(SrmSuspendRequestRequest srmSuspendRequestRequest) throws RemoteException {
        return (SrmSuspendRequestResponse)this.handleRequest("srmSuspendRequest", srmSuspendRequestRequest);
    }

    @Override
    public SrmResumeRequestResponse srmResumeRequest(SrmResumeRequestRequest srmResumeRequestRequest) throws RemoteException {
        return (SrmResumeRequestResponse)this.handleRequest("srmResumeRequest", srmResumeRequestRequest);
    }

    @Override
    public SrmStatusOfGetRequestResponse srmStatusOfGetRequest(SrmStatusOfGetRequestRequest srmStatusOfGetRequestRequest) throws RemoteException {
        return (SrmStatusOfGetRequestResponse)this.handleRequest("srmStatusOfGetRequest", srmStatusOfGetRequestRequest);
    }

    @Override
    public SrmStatusOfPutRequestResponse srmStatusOfPutRequest(SrmStatusOfPutRequestRequest srmStatusOfPutRequestRequest) throws RemoteException {
        return (SrmStatusOfPutRequestResponse)this.handleRequest("srmStatusOfPutRequest", srmStatusOfPutRequestRequest);
    }

    @Override
    public SrmStatusOfCopyRequestResponse srmStatusOfCopyRequest(SrmStatusOfCopyRequestRequest request) throws RemoteException {
        return (SrmStatusOfCopyRequestResponse)this.handleRequest("srmStatusOfCopyRequest", request);
    }

    @Override
    public SrmGetRequestSummaryResponse srmGetRequestSummary(SrmGetRequestSummaryRequest srmGetRequestSummaryRequest) throws RemoteException {
        return (SrmGetRequestSummaryResponse)this.handleRequest("srmGetRequestSummary", srmGetRequestSummaryRequest);
    }

    @Override
    public SrmExtendFileLifeTimeResponse srmExtendFileLifeTime(SrmExtendFileLifeTimeRequest srmExtendFileLifeTimeRequest) throws RemoteException {
        return (SrmExtendFileLifeTimeResponse)this.handleRequest("srmExtendFileLifeTime", srmExtendFileLifeTimeRequest);
    }

    @Override
    public SrmStatusOfBringOnlineRequestResponse srmStatusOfBringOnlineRequest(SrmStatusOfBringOnlineRequestRequest srmStatusOfBringOnlineRequestRequest) throws RemoteException {
        return (SrmStatusOfBringOnlineRequestResponse)this.handleRequest("srmStatusOfBringOnlineRequest", srmStatusOfBringOnlineRequestRequest);
    }

    @Override
    public SrmBringOnlineResponse srmBringOnline(SrmBringOnlineRequest srmBringOnlineRequest) throws RemoteException {
        return (SrmBringOnlineResponse)this.handleRequest("srmBringOnline", srmBringOnlineRequest);
    }

    @Override
    public SrmExtendFileLifeTimeInSpaceResponse srmExtendFileLifeTimeInSpace(SrmExtendFileLifeTimeInSpaceRequest srmExtendFileLifeTimeInSpaceRequest) throws RemoteException {
        return (SrmExtendFileLifeTimeInSpaceResponse)this.handleRequest("srmExtendFileLifeTimeInSpace", srmExtendFileLifeTimeInSpaceRequest);
    }

    @Override
    public SrmStatusOfUpdateSpaceRequestResponse srmStatusOfUpdateSpaceRequest(SrmStatusOfUpdateSpaceRequestRequest srmStatusOfUpdateSpaceRequestRequest) throws RemoteException {
        return (SrmStatusOfUpdateSpaceRequestResponse)this.handleRequest("srmStatusOfUpdateSpaceRequest", srmStatusOfUpdateSpaceRequestRequest);
    }

    @Override
    public SrmPurgeFromSpaceResponse srmPurgeFromSpace(SrmPurgeFromSpaceRequest srmPurgeFromSpaceRequest) throws RemoteException {
        return (SrmPurgeFromSpaceResponse)this.handleRequest("srmPurgeFromSpace", srmPurgeFromSpaceRequest);
    }

    @Override
    public SrmPingResponse srmPing(SrmPingRequest srmPingRequest) throws RemoteException {
        return (SrmPingResponse)this.handleRequest("srmPing", srmPingRequest);
    }

    @Override
    public SrmGetPermissionResponse srmGetPermission(SrmGetPermissionRequest srmGetPermissionRequest) throws RemoteException {
        return (SrmGetPermissionResponse)this.handleRequest("srmGetPermission", srmGetPermissionRequest);
    }

    @Override
    public SrmStatusOfReserveSpaceRequestResponse srmStatusOfReserveSpaceRequest(SrmStatusOfReserveSpaceRequestRequest srmStatusOfReserveSpaceRequestRequest) throws RemoteException {
        return (SrmStatusOfReserveSpaceRequestResponse)this.handleRequest("srmStatusOfReserveSpaceRequest", srmStatusOfReserveSpaceRequestRequest);
    }

    @Override
    public SrmChangeSpaceForFilesResponse srmChangeSpaceForFiles(SrmChangeSpaceForFilesRequest srmChangeSpaceForFilesRequest) throws RemoteException {
        return (SrmChangeSpaceForFilesResponse)this.handleRequest("srmChangeSpaceForFiles", srmChangeSpaceForFilesRequest);
    }

    @Override
    public SrmGetTransferProtocolsResponse srmGetTransferProtocols(SrmGetTransferProtocolsRequest srmGetTransferProtocolsRequest) throws RemoteException {
        return (SrmGetTransferProtocolsResponse)this.handleRequest("srmGetTransferProtocols", srmGetTransferProtocolsRequest);
    }

    @Override
    public SrmGetRequestTokensResponse srmGetRequestTokens(SrmGetRequestTokensRequest srmGetRequestTokensRequest) throws RemoteException {
        return (SrmGetRequestTokensResponse)this.handleRequest("srmGetRequestTokens", srmGetRequestTokensRequest);
    }

    @Override
    public SrmGetSpaceTokensResponse srmGetSpaceTokens(SrmGetSpaceTokensRequest srmGetSpaceTokensRequest) throws RemoteException {
        return (SrmGetSpaceTokensResponse)this.handleRequest("srmGetSpaceTokens", srmGetSpaceTokensRequest);
    }

    @Override
    public SrmStatusOfChangeSpaceForFilesRequestResponse srmStatusOfChangeSpaceForFilesRequest(SrmStatusOfChangeSpaceForFilesRequestRequest srmStatusOfChangeSpaceForFilesRequestRequest) throws RemoteException {
        return (SrmStatusOfChangeSpaceForFilesRequestResponse)this.handleRequest("srmStatusOfChangeSpaceForFilesRequest", srmStatusOfChangeSpaceForFilesRequestRequest);
    }

    @Override
    public SrmStatusOfLsRequestResponse srmStatusOfLsRequest(SrmStatusOfLsRequestRequest srmStatusOfLsRequestRequest) throws RemoteException {
        return (SrmStatusOfLsRequestResponse)this.handleRequest("srmStatusOfLsRequest", srmStatusOfLsRequestRequest);
    }
}

