/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.srm.server;

import java.rmi.RemoteException;
import java.util.Collection;
import javax.naming.InitialContext;
import org.dcache.commons.stats.RequestCounters;
import org.dcache.commons.stats.RequestExecutionTimeGauges;
import org.dcache.srm.SRMAuthorizationException;
import org.dcache.srm.SRMUser;
import org.dcache.srm.client.ConvertUtil;
import org.dcache.srm.client.axis.FileMetaData;
import org.dcache.srm.client.axis.ISRM_PortType;
import org.dcache.srm.client.axis.RequestStatus;
import org.dcache.srm.request.RequestCredential;
import org.dcache.srm.server.SrmAuthorizer;
import org.dcache.srm.server.SrmDCacheConnector;
import org.dcache.srm.server.UserCredential;
import org.dcache.srm.util.JDC;
import org.gridforum.jgss.ExtendedGSSContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SRMServerV1
implements ISRM_PortType {
    public Logger log;
    private SrmDCacheConnector srmConn;
    private SrmAuthorizer srmAuth = null;
    private final RequestCounters<String> srmServerCounters;
    private final RequestExecutionTimeGauges<String> srmServerGauges;

    public SRMServerV1() throws RemoteException {
        try {
            this.log = LoggerFactory.getLogger((String)this.getClass().getName());
            InitialContext logctx = new InitialContext();
            String srmConfigFile = (String)logctx.lookup("java:comp/env/srmConfigFile");
            if (srmConfigFile == null) {
                String error = "name of srm config file is not specified";
                String error_details = "please insert the following xml codelet into web.xml\n <env-entry>\n  <env-entry-name>srmConfigFile</env-entry-name>\n   <env-entry-value>INSERT SRM CONFIG FILE NAME HERE</env-entry-value>\n  <env-entry-type>java.lang.String</env-entry-type>\n </env-entry>";
                this.log.error(error);
                this.log.error(error_details);
                throw new RemoteException(error);
            }
            this.srmConn = SrmDCacheConnector.getInstance(srmConfigFile);
            if (this.srmConn == null) {
                throw new RemoteException("Failed to get instance of srm.");
            }
            this.log.info(" initialize() got connector =" + this.srmConn);
            this.srmAuth = new SrmAuthorizer(this.srmConn);
            this.srmServerCounters = this.srmConn.getSrm().getSrmServerV1Counters();
            this.srmServerGauges = this.srmConn.getSrm().getSrmServerV1Gauges();
        }
        catch (RemoteException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RemoteException("exception", e);
        }
    }

    private void incrementRequest(String operation) {
        this.srmServerCounters.incrementRequests((Object)operation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RequestStatus put(String[] arg0, String[] arg1, long[] arg2, boolean[] arg3, String[] arg4) throws RemoteException {
        long startTimeStamp = System.currentTimeMillis();
        JDC.createSession("v1:srmput:");
        String methodName = "put";
        this.incrementRequest(methodName);
        try {
            RequestStatus response;
            diskCacheV111.srm.RequestStatus requestStatus;
            UserCredential userCred = null;
            SRMUser user = null;
            RequestCredential requestCredential = null;
            try {
                userCred = this.srmAuth.getUserCredentials();
                Collection<String> roles = SrmAuthorizer.getFQANsFromContext((ExtendedGSSContext)userCred.context);
                String role = roles.isEmpty() ? null : (String)roles.toArray()[0];
                this.log.debug("SRMServerV1.put() : role is " + role);
                requestCredential = this.srmAuth.getRequestCredential(userCred, role);
                user = this.srmAuth.getRequestUser(requestCredential, null, userCred.context);
            }
            catch (SRMAuthorizationException sae) {
                String msg = "SRM Authorization failed: " + sae.getMessage();
                this.log.error(msg);
                throw new RemoteException(msg);
            }
            try {
                requestStatus = this.srmConn.getSrm().put(user, requestCredential, arg0, arg1, arg2, arg3, arg4, userCred.clientHost);
            }
            catch (Exception e) {
                this.log.error(e.toString());
                throw new RemoteException("srm put failed", e);
            }
            RequestStatus requestStatus2 = response = ConvertUtil.RS2axisRS(requestStatus);
            return requestStatus2;
        }
        finally {
            this.srmServerGauges.update((Object)methodName, System.currentTimeMillis() - startTimeStamp);
            JDC.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RequestStatus get(String[] arg0, String[] arg1) throws RemoteException {
        long startTimeStamp = System.currentTimeMillis();
        JDC.createSession("v1:srmget:");
        String methodName = "get";
        this.incrementRequest(methodName);
        try {
            RequestStatus response;
            diskCacheV111.srm.RequestStatus requestStatus;
            UserCredential userCred = null;
            SRMUser user = null;
            RequestCredential requestCredential = null;
            try {
                userCred = this.srmAuth.getUserCredentials();
                Collection<String> roles = SrmAuthorizer.getFQANsFromContext((ExtendedGSSContext)userCred.context);
                String role = roles.isEmpty() ? null : (String)roles.toArray()[0];
                this.log.debug("SRMServerV1.get() : role is " + role);
                requestCredential = this.srmAuth.getRequestCredential(userCred, role);
                user = this.srmAuth.getRequestUser(requestCredential, null, userCred.context);
            }
            catch (SRMAuthorizationException sae) {
                String msg = "SRM Authorization failed: " + sae.getMessage();
                this.log.error(msg);
                throw new RemoteException(msg);
            }
            try {
                requestStatus = this.srmConn.getSrm().get(user, requestCredential, arg0, arg1, userCred.clientHost);
            }
            catch (Exception e) {
                this.log.error(e.toString());
                throw new RemoteException("srm get failed", e);
            }
            RequestStatus requestStatus2 = response = ConvertUtil.RS2axisRS(requestStatus);
            return requestStatus2;
        }
        finally {
            this.srmServerGauges.update((Object)methodName, System.currentTimeMillis() - startTimeStamp);
            JDC.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RequestStatus copy(String[] arg0, String[] arg1, boolean[] arg2) throws RemoteException {
        long startTimeStamp = System.currentTimeMillis();
        JDC.createSession("v1:srmcopy:");
        String methodName = "copy";
        this.incrementRequest(methodName);
        try {
            RequestStatus response;
            diskCacheV111.srm.RequestStatus requestStatus;
            UserCredential userCred = null;
            SRMUser user = null;
            RequestCredential requestCredential = null;
            try {
                userCred = this.srmAuth.getUserCredentials();
                Collection<String> roles = SrmAuthorizer.getFQANsFromContext((ExtendedGSSContext)userCred.context);
                String role = roles.isEmpty() ? null : (String)roles.toArray()[0];
                this.log.debug("SRMServerV1.copy() : role is " + role);
                requestCredential = this.srmAuth.getRequestCredential(userCred, role);
                user = this.srmAuth.getRequestUser(requestCredential, null, userCred.context);
            }
            catch (SRMAuthorizationException sae) {
                String msg = "SRM Authorization failed: " + sae.getMessage();
                this.log.error(msg);
                throw new RemoteException(msg);
            }
            try {
                requestStatus = this.srmConn.getSrm().copy(user, requestCredential, arg0, arg1, arg2, userCred.clientHost);
            }
            catch (Exception e) {
                this.log.error(e.toString());
                throw new RemoteException("srm put failed", e);
            }
            RequestStatus requestStatus2 = response = ConvertUtil.RS2axisRS(requestStatus);
            return requestStatus2;
        }
        finally {
            this.srmServerGauges.update((Object)methodName, System.currentTimeMillis() - startTimeStamp);
            JDC.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean ping() throws RemoteException {
        long startTimeStamp = System.currentTimeMillis();
        String methodName = "ping";
        this.incrementRequest(methodName);
        try {
            UserCredential userCred = null;
            SRMUser user = null;
            RequestCredential requestCredential = null;
            try {
                userCred = this.srmAuth.getUserCredentials();
                Collection<String> roles = SrmAuthorizer.getFQANsFromContext((ExtendedGSSContext)userCred.context);
                String role = roles.isEmpty() ? null : (String)roles.toArray()[0];
                this.log.debug("SRMServerV1.ping() : role is " + role);
                requestCredential = this.srmAuth.getRequestCredential(userCred, role);
                user = this.srmAuth.getRequestUser(requestCredential, null, userCred.context);
            }
            catch (SRMAuthorizationException sae) {
                String msg = "SRM Authorization failed: " + sae.getMessage();
                this.log.error(msg);
                throw new RemoteException(msg);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.srmServerGauges.update((Object)methodName, System.currentTimeMillis() - startTimeStamp);
        }
    }

    @Override
    public RequestStatus pin(String[] arg0) throws RemoteException {
        long startTimeStamp = System.currentTimeMillis();
        JDC.createSession("v1:srmpin:");
        String methodName = "pin";
        this.incrementRequest(methodName);
        try {
            UserCredential userCred = null;
            SRMUser user = null;
            RequestCredential requestCredential = null;
            try {
                userCred = this.srmAuth.getUserCredentials();
                Collection<String> roles = SrmAuthorizer.getFQANsFromContext((ExtendedGSSContext)userCred.context);
                String role = roles.isEmpty() ? null : (String)roles.toArray()[0];
                this.log.debug("SRMServerV1.pin() : role is " + role);
                requestCredential = this.srmAuth.getRequestCredential(userCred, role);
                user = this.srmAuth.getRequestUser(requestCredential, null, userCred.context);
            }
            catch (SRMAuthorizationException sae) {
                String msg = "SRM Authorization failed: " + sae.getMessage();
                this.log.error(msg);
                throw new RemoteException(msg);
            }
            throw new RemoteException("srm pin is not supported");
        }
        catch (Throwable throwable) {
            this.srmServerGauges.update((Object)methodName, System.currentTimeMillis() - startTimeStamp);
            JDC.clear();
            throw throwable;
        }
    }

    @Override
    public RequestStatus unPin(String[] arg0, int arg1) throws RemoteException {
        long startTimeStamp = System.currentTimeMillis();
        JDC.createSession("v1:srmunpin:");
        String methodName = "unPin";
        this.incrementRequest(methodName);
        try {
            UserCredential userCred = null;
            SRMUser user = null;
            RequestCredential requestCredential = null;
            try {
                userCred = this.srmAuth.getUserCredentials();
                Collection<String> roles = SrmAuthorizer.getFQANsFromContext((ExtendedGSSContext)userCred.context);
                String role = roles.isEmpty() ? null : (String)roles.toArray()[0];
                this.log.debug("SRMServerV1.unPin() : role is " + role);
                requestCredential = this.srmAuth.getRequestCredential(userCred, role);
                user = this.srmAuth.getRequestUser(requestCredential, null, userCred.context);
            }
            catch (SRMAuthorizationException sae) {
                String msg = "SRM Authorization failed: " + sae.getMessage();
                this.log.error(msg);
                throw new RemoteException(msg);
            }
            throw new RemoteException("srm unPin is not supported");
        }
        catch (Throwable throwable) {
            this.srmServerGauges.update((Object)methodName, System.currentTimeMillis() - startTimeStamp);
            JDC.clear();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RequestStatus setFileStatus(int arg0, int arg1, String arg2) throws RemoteException {
        long startTimeStamp = System.currentTimeMillis();
        JDC.createSession("v1:srmsetstatus:");
        String methodName = "setFileStatus";
        this.incrementRequest(methodName);
        try {
            RequestStatus response;
            diskCacheV111.srm.RequestStatus requestStatus;
            UserCredential userCred = null;
            SRMUser user = null;
            RequestCredential requestCredential = null;
            try {
                userCred = this.srmAuth.getUserCredentials();
                Collection<String> roles = SrmAuthorizer.getFQANsFromContext((ExtendedGSSContext)userCred.context);
                String role = roles.isEmpty() ? null : (String)roles.toArray()[0];
                this.log.debug("SRMServerV1.setFileStatus() : role is " + role);
                requestCredential = this.srmAuth.getRequestCredential(userCred, role);
                user = this.srmAuth.getRequestUser(requestCredential, null, userCred.context);
            }
            catch (SRMAuthorizationException sae) {
                String msg = "SRM Authorization failed: " + sae.getMessage();
                this.log.error(msg);
                throw new RemoteException(msg);
            }
            try {
                requestStatus = this.srmConn.getSrm().setFileStatus(user, requestCredential, arg0, arg1, arg2);
            }
            catch (Exception e) {
                this.log.error(e.toString());
                throw new RemoteException("srm setFileStatus failed", e);
            }
            RequestStatus requestStatus2 = response = ConvertUtil.RS2axisRS(requestStatus);
            return requestStatus2;
        }
        finally {
            this.srmServerGauges.update((Object)methodName, System.currentTimeMillis() - startTimeStamp);
            JDC.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RequestStatus getRequestStatus(int arg0) throws RemoteException {
        long startTimeStamp = System.currentTimeMillis();
        JDC.createSession("v1:srmgetstatus:");
        String methodName = "getRequestStatus";
        this.incrementRequest(methodName);
        try {
            RequestStatus response;
            diskCacheV111.srm.RequestStatus requestStatus;
            UserCredential userCred = null;
            SRMUser user = null;
            RequestCredential requestCredential = null;
            try {
                userCred = this.srmAuth.getUserCredentials();
                Collection<String> roles = SrmAuthorizer.getFQANsFromContext((ExtendedGSSContext)userCred.context);
                String role = roles.isEmpty() ? null : (String)roles.toArray()[0];
                this.log.debug("SRMServerV1.getRequestStatus() : role is " + role);
                requestCredential = this.srmAuth.getRequestCredential(userCred, role);
                user = this.srmAuth.getRequestUser(requestCredential, null, userCred.context);
            }
            catch (SRMAuthorizationException sae) {
                String msg = "SRM Authorization failed: " + sae.getMessage();
                this.log.error(msg);
                throw new RemoteException(msg);
            }
            try {
                requestStatus = this.srmConn.getSrm().getRequestStatus(user, requestCredential, arg0);
            }
            catch (Exception e) {
                this.log.error(e.toString());
                throw new RemoteException("srm getRequestStatus failed", e);
            }
            RequestStatus requestStatus2 = response = ConvertUtil.RS2axisRS(requestStatus);
            return requestStatus2;
        }
        finally {
            this.srmServerGauges.update((Object)methodName, System.currentTimeMillis() - startTimeStamp);
            JDC.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileMetaData[] getFileMetaData(String[] arg0) throws RemoteException {
        this.log.debug("Entering ISRMImpl.getFileMetaData");
        long startTimeStamp = System.currentTimeMillis();
        JDC.createSession("v1:srmgetFileMetaData:");
        String methodName = "mkPermanent";
        this.incrementRequest(methodName);
        try {
            diskCacheV111.srm.FileMetaData[] fmdArray;
            UserCredential userCred = null;
            SRMUser user = null;
            RequestCredential requestCredential = null;
            try {
                userCred = this.srmAuth.getUserCredentials();
                Collection<String> roles = SrmAuthorizer.getFQANsFromContext((ExtendedGSSContext)userCred.context);
                String role = roles.isEmpty() ? null : (String)roles.toArray()[0];
                this.log.debug("SRMServerV1.getFileMetadata() : role is " + role);
                requestCredential = this.srmAuth.getRequestCredential(userCred, role);
                user = this.srmAuth.getRequestUser(requestCredential, null, userCred.context);
            }
            catch (SRMAuthorizationException sae) {
                String msg = "SRM Authorization failed: " + sae.getMessage();
                this.log.error(msg);
                throw new RemoteException(msg);
            }
            this.log.debug("About to call getFileMetaData()");
            try {
                fmdArray = this.srmConn.getSrm().getFileMetaData(user, requestCredential, arg0);
            }
            catch (Exception e) {
                this.log.error(e.toString());
                throw new RemoteException("srm getFileMetaData failed", e);
            }
            FileMetaData[] response = ConvertUtil.FMDs2AxisFMDs(fmdArray);
            this.log.debug("About to return FileMetaData array ");
            FileMetaData[] fileMetaDataArray = response;
            return fileMetaDataArray;
        }
        finally {
            this.srmServerGauges.update((Object)methodName, System.currentTimeMillis() - startTimeStamp);
            JDC.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RequestStatus mkPermanent(String[] arg0) throws RemoteException {
        long startTimeStamp = System.currentTimeMillis();
        String methodName = "mkPermanent";
        this.incrementRequest(methodName);
        try {
            RequestStatus response;
            diskCacheV111.srm.RequestStatus requestStatus;
            UserCredential userCred = null;
            SRMUser user = null;
            RequestCredential requestCredential = null;
            try {
                userCred = this.srmAuth.getUserCredentials();
                Collection<String> roles = SrmAuthorizer.getFQANsFromContext((ExtendedGSSContext)userCred.context);
                String role = roles.isEmpty() ? null : (String)roles.toArray()[0];
                this.log.debug("SRMServerV1.mkPermanent() : role is " + role);
                requestCredential = this.srmAuth.getRequestCredential(userCred, role);
                user = this.srmAuth.getRequestUser(requestCredential, null, userCred.context);
            }
            catch (SRMAuthorizationException sae) {
                String msg = "SRM Authorization failed: " + sae.getMessage();
                this.log.error(msg);
                throw new RemoteException(msg);
            }
            try {
                requestStatus = this.srmConn.getSrm().mkPermanent(user, requestCredential, arg0);
            }
            catch (Exception e) {
                this.log.error(e.toString());
                throw new RemoteException("srm mkPermanent failed", e);
            }
            RequestStatus requestStatus2 = response = ConvertUtil.RS2axisRS(requestStatus);
            return requestStatus2;
        }
        finally {
            this.srmServerGauges.update((Object)methodName, System.currentTimeMillis() - startTimeStamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RequestStatus getEstGetTime(String[] arg0, String[] arg1) throws RemoteException {
        long startTimeStamp = System.currentTimeMillis();
        String methodName = "getEstGetTime";
        this.incrementRequest(methodName);
        try {
            RequestStatus response;
            diskCacheV111.srm.RequestStatus requestStatus;
            UserCredential userCred = null;
            SRMUser user = null;
            RequestCredential requestCredential = null;
            try {
                userCred = this.srmAuth.getUserCredentials();
                Collection<String> roles = SrmAuthorizer.getFQANsFromContext((ExtendedGSSContext)userCred.context);
                String role = roles.isEmpty() ? null : (String)roles.toArray()[0];
                this.log.debug("SRMServerV1.getEstGetTime() : role is " + role);
                requestCredential = this.srmAuth.getRequestCredential(userCred, role);
                user = this.srmAuth.getRequestUser(requestCredential, null, userCred.context);
            }
            catch (SRMAuthorizationException sae) {
                String msg = "SRM Authorization failed: " + sae.getMessage();
                this.log.error(msg);
                throw new RemoteException(msg);
            }
            try {
                requestStatus = this.srmConn.getSrm().getEstGetTime(user, requestCredential, arg0, arg1);
            }
            catch (Exception e) {
                this.log.error(e.toString());
                throw new RemoteException("srm getEstGetTime failed", e);
            }
            RequestStatus requestStatus2 = response = ConvertUtil.RS2axisRS(requestStatus);
            return requestStatus2;
        }
        finally {
            this.srmServerGauges.update((Object)methodName, System.currentTimeMillis() - startTimeStamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RequestStatus getEstPutTime(String[] arg0, String[] arg1, long[] arg2, boolean[] arg3, String[] arg4) throws RemoteException {
        long startTimeStamp = System.currentTimeMillis();
        String methodName = "getEstPutTime";
        this.incrementRequest(methodName);
        try {
            RequestStatus response;
            diskCacheV111.srm.RequestStatus requestStatus;
            UserCredential userCred = null;
            SRMUser user = null;
            RequestCredential requestCredential = null;
            try {
                userCred = this.srmAuth.getUserCredentials();
                Collection<String> roles = SrmAuthorizer.getFQANsFromContext((ExtendedGSSContext)userCred.context);
                String role = roles.isEmpty() ? null : (String)roles.toArray()[0];
                this.log.debug("SRMServerV1.getEstPutTime() : role is " + role);
                requestCredential = this.srmAuth.getRequestCredential(userCred, role);
                user = this.srmAuth.getRequestUser(requestCredential, null, userCred.context);
            }
            catch (SRMAuthorizationException sae) {
                String msg = "SRM Authorization failed: " + sae.getMessage();
                this.log.error(msg);
                throw new RemoteException(msg);
            }
            try {
                requestStatus = this.srmConn.getSrm().getEstPutTime(user, requestCredential, arg0, arg1, arg2, arg3, arg4);
            }
            catch (Exception e) {
                this.log.error(e.toString());
                throw new RemoteException("srm put failed", e);
            }
            RequestStatus requestStatus2 = response = ConvertUtil.RS2axisRS(requestStatus);
            return requestStatus2;
        }
        finally {
            this.srmServerGauges.update((Object)methodName, System.currentTimeMillis() - startTimeStamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void advisoryDelete(String[] arg0) throws RemoteException {
        long startTimeStamp = System.currentTimeMillis();
        JDC.createSession("v1:srmdelete:");
        String methodName = "advisoryDelete";
        this.incrementRequest(methodName);
        try {
            UserCredential userCred = null;
            SRMUser user = null;
            RequestCredential requestCredential = null;
            try {
                userCred = this.srmAuth.getUserCredentials();
                Collection<String> roles = SrmAuthorizer.getFQANsFromContext((ExtendedGSSContext)userCred.context);
                String role = roles.isEmpty() ? null : (String)roles.toArray()[0];
                this.log.debug("SRMServerV1.advisoryDelete() : role is " + role);
                requestCredential = this.srmAuth.getRequestCredential(userCred, role);
                user = this.srmAuth.getRequestUser(requestCredential, null, userCred.context);
            }
            catch (SRMAuthorizationException sae) {
                String msg = "SRM Authorization failed: " + sae.getMessage();
                this.log.error(msg);
                throw new RemoteException(msg);
            }
            try {
                this.srmConn.getSrm().advisoryDelete(user, requestCredential, arg0);
            }
            catch (Exception e) {
                this.log.error(e.toString());
                throw new RemoteException("srm advisoryDelete failed", e);
            }
        }
        finally {
            this.srmServerGauges.update((Object)methodName, System.currentTimeMillis() - startTimeStamp);
            JDC.clear();
        }
    }

    @Override
    public String[] getProtocols() throws RemoteException {
        long startTimeStamp = System.currentTimeMillis();
        String methodName = "getProtocols";
        this.incrementRequest(methodName);
        try {
            UserCredential userCred = null;
            SRMUser user = null;
            RequestCredential requestCredential = null;
            try {
                userCred = this.srmAuth.getUserCredentials();
                Collection<String> roles = SrmAuthorizer.getFQANsFromContext((ExtendedGSSContext)userCred.context);
                String role = roles.isEmpty() ? null : (String)roles.toArray()[0];
                this.log.debug("SRMServerV1.getProtocols() : role is " + role);
                requestCredential = this.srmAuth.getRequestCredential(userCred, role);
                user = this.srmAuth.getRequestUser(requestCredential, null, userCred.context);
            }
            catch (SRMAuthorizationException sae) {
                String msg = "SRM Authorization failed: " + sae.getMessage();
                this.log.error(msg);
                throw new RemoteException(msg);
            }
            try {
                String[] msg = this.srmConn.getSrm().getProtocols(user, requestCredential);
                return msg;
            }
            catch (Exception e) {
                this.log.error(e.toString());
                throw new RemoteException("srm getProtocols failed", e);
            }
        }
        finally {
            this.srmServerGauges.update((Object)methodName, System.currentTimeMillis() - startTimeStamp);
        }
    }
}

