/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.srm.scheduler;

import java.util.HashMap;
import java.util.Map;
import org.dcache.srm.request.BringOnlineFileRequest;
import org.dcache.srm.request.CopyRequest;
import org.dcache.srm.request.GetFileRequest;
import org.dcache.srm.request.LsFileRequest;
import org.dcache.srm.request.PutFileRequest;
import org.dcache.srm.request.ReserveSpaceRequest;
import org.dcache.srm.scheduler.Job;
import org.dcache.srm.scheduler.Scheduler;
import org.dcache.srm.util.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchedulerFactory {
    private static final Logger logger = LoggerFactory.getLogger(SchedulerFactory.class);
    private final Map<Class<? extends Job>, Scheduler> schedulerMap = new HashMap<Class<? extends Job>, Scheduler>();
    private static SchedulerFactory factory = null;

    private SchedulerFactory(Configuration config, String name) {
        Scheduler lsRequestScheduler = new Scheduler("ls_" + name);
        lsRequestScheduler.setMaxThreadQueueSize(config.getLsReqTQueueSize());
        lsRequestScheduler.setThreadPoolSize(config.getLsThreadPoolSize());
        lsRequestScheduler.setMaxWaitingJobNum(config.getLsMaxWaitingRequests());
        lsRequestScheduler.setMaxReadyQueueSize(config.getLsReadyQueueSize());
        lsRequestScheduler.setMaxReadyJobs(config.getLsMaxReadyJobs());
        lsRequestScheduler.setMaxNumberOfRetries(config.getLsMaxNumOfRetries());
        lsRequestScheduler.setRetryTimeout(config.getLsRetryTimeout());
        lsRequestScheduler.setMaxRunningByOwner(config.getLsMaxRunningBySameOwner());
        lsRequestScheduler.setPriorityPolicyPlugin(config.getLsPriorityPolicyPlugin());
        lsRequestScheduler.start();
        this.schedulerMap.put(LsFileRequest.class, lsRequestScheduler);
        Scheduler getRequestScheduler = new Scheduler("get_" + name);
        getRequestScheduler.setMaxThreadQueueSize(config.getGetReqTQueueSize());
        getRequestScheduler.setThreadPoolSize(config.getGetThreadPoolSize());
        getRequestScheduler.setMaxWaitingJobNum(config.getGetMaxWaitingRequests());
        getRequestScheduler.setMaxReadyQueueSize(config.getGetReadyQueueSize());
        getRequestScheduler.setMaxReadyJobs(config.getGetMaxReadyJobs());
        getRequestScheduler.setMaxNumberOfRetries(config.getGetMaxNumOfRetries());
        getRequestScheduler.setRetryTimeout(config.getGetRetryTimeout());
        getRequestScheduler.setMaxRunningByOwner(config.getGetMaxRunningBySameOwner());
        getRequestScheduler.setPriorityPolicyPlugin(config.getGetPriorityPolicyPlugin());
        getRequestScheduler.start();
        this.schedulerMap.put(GetFileRequest.class, getRequestScheduler);
        Scheduler bringOnlineRequestScheduler = new Scheduler("bring_online_" + name);
        bringOnlineRequestScheduler.setMaxThreadQueueSize(config.getBringOnlineReqTQueueSize());
        bringOnlineRequestScheduler.setThreadPoolSize(config.getBringOnlineThreadPoolSize());
        bringOnlineRequestScheduler.setMaxWaitingJobNum(config.getBringOnlineMaxWaitingRequests());
        bringOnlineRequestScheduler.setMaxReadyQueueSize(config.getBringOnlineReadyQueueSize());
        bringOnlineRequestScheduler.setMaxReadyJobs(config.getBringOnlineMaxReadyJobs());
        bringOnlineRequestScheduler.setMaxNumberOfRetries(config.getBringOnlineMaxNumOfRetries());
        bringOnlineRequestScheduler.setRetryTimeout(config.getBringOnlineRetryTimeout());
        bringOnlineRequestScheduler.setMaxRunningByOwner(config.getBringOnlineMaxRunningBySameOwner());
        bringOnlineRequestScheduler.setPriorityPolicyPlugin(config.getBringOnlinePriorityPolicyPlugin());
        bringOnlineRequestScheduler.start();
        this.schedulerMap.put(BringOnlineFileRequest.class, bringOnlineRequestScheduler);
        Scheduler putRequestScheduler = new Scheduler("put_" + name);
        putRequestScheduler.setMaxThreadQueueSize(config.getPutReqTQueueSize());
        putRequestScheduler.setThreadPoolSize(config.getPutThreadPoolSize());
        putRequestScheduler.setMaxWaitingJobNum(config.getPutMaxWaitingRequests());
        putRequestScheduler.setMaxReadyQueueSize(config.getPutReadyQueueSize());
        putRequestScheduler.setMaxReadyJobs(config.getPutMaxReadyJobs());
        putRequestScheduler.setMaxNumberOfRetries(config.getPutMaxNumOfRetries());
        putRequestScheduler.setRetryTimeout(config.getPutRetryTimeout());
        putRequestScheduler.setMaxRunningByOwner(config.getPutMaxRunningBySameOwner());
        putRequestScheduler.setPriorityPolicyPlugin(config.getPutPriorityPolicyPlugin());
        putRequestScheduler.start();
        this.schedulerMap.put(PutFileRequest.class, putRequestScheduler);
        Scheduler copyRequestScheduler = new Scheduler("copy_" + name);
        copyRequestScheduler.setMaxThreadQueueSize(config.getCopyReqTQueueSize());
        copyRequestScheduler.setThreadPoolSize(config.getCopyThreadPoolSize());
        copyRequestScheduler.setMaxWaitingJobNum(config.getCopyMaxWaitingRequests());
        copyRequestScheduler.setMaxNumberOfRetries(config.getCopyMaxNumOfRetries());
        copyRequestScheduler.setRetryTimeout(config.getCopyRetryTimeout());
        copyRequestScheduler.setMaxRunningByOwner(config.getCopyMaxRunningBySameOwner());
        copyRequestScheduler.setPriorityPolicyPlugin(config.getCopyPriorityPolicyPlugin());
        copyRequestScheduler.start();
        this.schedulerMap.put(CopyRequest.class, copyRequestScheduler);
        Scheduler reserveSpaceScheduler = new Scheduler("reserve_space" + name);
        reserveSpaceScheduler.start();
        this.schedulerMap.put(ReserveSpaceRequest.class, copyRequestScheduler);
    }

    public void shutdown() {
        for (Scheduler scheduler : this.schedulerMap.values()) {
            scheduler.stop();
        }
    }

    public static void initSchedulerFactory(Configuration config, String name) {
        SchedulerFactory.initSchedulerFactory(new SchedulerFactory(config, name));
    }

    public static synchronized void initSchedulerFactory(SchedulerFactory afactory) {
        if (afactory == null) {
            throw new NullPointerException(" factory argument is null");
        }
        if (factory != null) {
            throw new IllegalStateException("already initialized");
        }
        factory = afactory;
    }

    public static synchronized SchedulerFactory getSchedulerFactory() {
        if (factory == null) {
            throw new IllegalStateException("not initialized");
        }
        return factory;
    }

    public Scheduler getScheduler(Job job) {
        if (job == null) {
            throw new IllegalArgumentException("job is null");
        }
        return this.getScheduler(job.getClass());
    }

    public Scheduler getScheduler(Class<? extends Job> jobType) {
        Scheduler scheduler = this.schedulerMap.get(jobType);
        if (scheduler != null) {
            return scheduler;
        }
        throw new UnsupportedOperationException("Scheduler for class " + jobType + " is not supported");
    }
}

