/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.srm.request.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.dcache.srm.SRMUser;
import org.dcache.srm.request.Request;
import org.dcache.srm.request.ReserveSpaceRequest;
import org.dcache.srm.request.sql.DatabaseRequestStorage;
import org.dcache.srm.scheduler.Job;
import org.dcache.srm.util.Configuration;

public class ReserveSpaceRequestStorage
extends DatabaseRequestStorage {
    public static final String TABLE_NAME = "reservespacerequests";
    private static final String UPDATE_PREFIX = "UPDATE reservespacerequests SET NEXTJOBID=?, CREATIONTIME=?,  LIFETIME=?, STATE=?, ERRORMESSAGE=?, SCHEDULERID=?, SCHEDULERTIMESTAMP=?,NUMOFRETR=?,MAXNUMOFRETR=?,LASTSTATETRANSITIONTIME=? ";
    private static final String INSERT_SQL = "INSERT INTO reservespacerequests(    ID ,NEXTJOBID ,CREATIONTIME ,LIFETIME ,STATE ,ERRORMESSAGE ,SCHEDULERID ,SCHEDULERTIMESTAMP ,NUMOFRETR ,MAXNUMOFRETR ,LASTSTATETRANSITIONTIME,CREDENTIALID , RETRYDELTATIME , SHOULDUPDATERETRYDELTATIME ,DESCRIPTION ,CLIENTHOST ,STATUSCODE ,USERID ,SIZEINBYTES, RESERVATIONLIFETIME, SPACETOKEN, RETENTIONPOLICY, ACCESSLATENCY ) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    private static final String UPDATE_REQUEST_SQL = "UPDATE reservespacerequests SET NEXTJOBID=?, CREATIONTIME=?,  LIFETIME=?, STATE=?, ERRORMESSAGE=?, SCHEDULERID=?, SCHEDULERTIMESTAMP=?,NUMOFRETR=?,MAXNUMOFRETR=?,LASTSTATETRANSITIONTIME=? , CREDENTIALID=?, RETRYDELTATIME=?, SHOULDUPDATERETRYDELTATIME=?, DESCRIPTION=?, CLIENTHOST=?, STATUSCODE=?, USERID=?, SIZEINBYTES=?,  RESERVATIONLIFETIME=?,  SPACETOKEN=?,  RETENTIONPOLICY=?, ACCESSLATENCY=? WHERE ID=?";
    private static int ADDITIONAL_FIELDS_NUM = 5;

    @Override
    public PreparedStatement getCreateStatement(Connection connection, Job job) throws SQLException {
        ReserveSpaceRequest rsr = (ReserveSpaceRequest)job;
        String retentionPolicyValue = null;
        if (rsr.getRetentionPolicy() != null) {
            retentionPolicyValue = rsr.getRetentionPolicy().getValue();
        }
        String accessLatencyValue = null;
        if (rsr.getAccessLatency() != null) {
            accessLatencyValue = rsr.getAccessLatency().getValue();
        }
        PreparedStatement stmt = this.getPreparedStatement(connection, INSERT_SQL, rsr.getId(), rsr.getNextJobId(), rsr.getCreationTime(), rsr.getLifetime(), rsr.getState().getStateId(), rsr.getErrorMessage(), rsr.getSchedulerId(), rsr.getSchedulerTimeStamp(), rsr.getNumberOfRetries(), rsr.getMaxNumberOfRetries(), rsr.getLastStateTransitionTime(), rsr.getCredentialId(), rsr.getRetryDeltaTime(), rsr.isShould_updateretryDeltaTime() ? 0 : 1, rsr.getDescription(), rsr.getClient_host(), rsr.getStatusCodeString(), rsr.getUser().getId(), rsr.getSizeInBytes(), rsr.getSpaceReservationLifetime(), rsr.getSpaceToken(), retentionPolicyValue, accessLatencyValue);
        return stmt;
    }

    @Override
    public PreparedStatement getUpdateStatement(Connection connection, Job job) throws SQLException {
        ReserveSpaceRequest rsr = (ReserveSpaceRequest)job;
        String retentionPolicyValue = null;
        if (rsr.getRetentionPolicy() != null) {
            retentionPolicyValue = rsr.getRetentionPolicy().getValue();
        }
        String accessLatencyValue = null;
        if (rsr.getAccessLatency() != null) {
            accessLatencyValue = rsr.getAccessLatency().getValue();
        }
        PreparedStatement stmt = this.getPreparedStatement(connection, UPDATE_REQUEST_SQL, rsr.getNextJobId(), rsr.getCreationTime(), rsr.getLifetime(), rsr.getState().getStateId(), rsr.getErrorMessage(), rsr.getSchedulerId(), rsr.getSchedulerTimeStamp(), rsr.getNumberOfRetries(), rsr.getMaxNumberOfRetries(), rsr.getLastStateTransitionTime(), rsr.getCredentialId(), rsr.getRetryDeltaTime(), rsr.isShould_updateretryDeltaTime() ? 0 : 1, rsr.getDescription(), rsr.getClient_host(), rsr.getStatusCodeString(), rsr.getUser().getId(), rsr.getSizeInBytes(), rsr.getSpaceReservationLifetime(), rsr.getSpaceToken(), retentionPolicyValue, accessLatencyValue, rsr.getId());
        return stmt;
    }

    public ReserveSpaceRequestStorage(Configuration.DatabaseParameters configuration) throws SQLException {
        super(configuration);
    }

    @Override
    protected void _dbInit() throws SQLException {
    }

    @Override
    public String getRequestCreateTableFields() {
        return ",SIZEINBYTES  BIGINT ,RESERVATIONLIFETIME  BIGINT ,SPACETOKEN  VARCHAR(32672) ,RETENTIONPOLICY  VARCHAR(32672) ,ACCESSLATENCY  VARCHAR(32672) ";
    }

    @Override
    protected Request getRequest(Connection _con, Long ID, Long NEXTJOBID, long CREATIONTIME, long LIFETIME, int STATE, String ERRORMESSAGE, SRMUser user, String SCHEDULERID, long SCHEDULER_TIMESTAMP, int NUMOFRETR, int MAXNUMOFRETR, long LASTSTATETRANSITIONTIME, Long CREDENTIALID, int RETRYDELTATIME, boolean SHOULDUPDATERETRYDELTATIME, String DESCRIPTION, String CLIENTHOST, String STATUSCODE, ResultSet set, int next_index) throws SQLException {
        Job.JobHistory[] jobHistoryArray = this.getJobHistory(ID, _con);
        long SIZEINBYTES = set.getLong(next_index++);
        long RESERVATIONLIFETIME = set.getLong(next_index++);
        String SPACETOKEN = set.getString(next_index++);
        String RETENTIONPOLICY = set.getString(next_index++);
        String ACCESSLATENCY = set.getString(next_index++);
        return new ReserveSpaceRequest(ID, NEXTJOBID, CREATIONTIME, LIFETIME, STATE, ERRORMESSAGE, user, SCHEDULERID, SCHEDULER_TIMESTAMP, NUMOFRETR, MAXNUMOFRETR, LASTSTATETRANSITIONTIME, jobHistoryArray, CREDENTIALID, SIZEINBYTES, RESERVATIONLIFETIME, SPACETOKEN, RETENTIONPOLICY, ACCESSLATENCY, DESCRIPTION, CLIENTHOST, STATUSCODE);
    }

    @Override
    public String getTableName() {
        return TABLE_NAME;
    }

    public void getUpdateAssignements(Request request, StringBuffer sb) {
        if (request == null || !(request instanceof ReserveSpaceRequest)) {
            throw new IllegalArgumentException("Request is not ReserveSpaceRequest");
        }
        ReserveSpaceRequest r = (ReserveSpaceRequest)request;
        sb.append(", SIZEINBYTES = ").append(r.getSizeInBytes());
        sb.append(", RESERVATIONLIFETIME = ").append(r.getSpaceReservationLifetime());
        String spaceToken = r.getSpaceToken();
        if (spaceToken == null) {
            sb.append(", SPACETOKEN =NULL");
        } else {
            sb.append(", SPACETOKEN = '").append(spaceToken).append('\'');
        }
        if (r.getRetentionPolicy() == null) {
            sb.append(", RETENTIONPOLICY =NULL");
        } else {
            sb.append(", RETENTIONPOLICY = '").append(r.getRetentionPolicy().getValue()).append('\'');
        }
        if (r.getAccessLatency() == null) {
            sb.append(", ACCESSLATENCY =NULL");
        } else {
            sb.append(", ACCESSLATENCY = '").append(r.getAccessLatency().getValue()).append('\'');
        }
    }

    @Override
    protected int getMoreCollumnsNum() {
        return ADDITIONAL_FIELDS_NUM;
    }

    @Override
    public void getCreateList(Request request, StringBuffer sb) {
        if (request == null || !(request instanceof ReserveSpaceRequest)) {
            throw new IllegalArgumentException("request is not ReserveSpaceRequest");
        }
        ReserveSpaceRequest r = (ReserveSpaceRequest)request;
        sb.append(", ").append(r.getSizeInBytes());
        sb.append(", ").append(r.getSpaceReservationLifetime());
        if (r.getSpaceToken() == null) {
            sb.append(", NULL");
        } else {
            sb.append(", '").append(r.getSpaceToken()).append('\'');
        }
        if (r.getRetentionPolicy() == null) {
            sb.append(", NULL");
        } else {
            sb.append(", '").append(r.getRetentionPolicy().getValue()).append('\'');
        }
        if (r.getAccessLatency() == null) {
            sb.append(", NULL");
        } else {
            sb.append(", '").append(r.getAccessLatency().getValue()).append('\'');
        }
    }

    public void updateJob(Job job, Connection _con) throws SQLException {
    }

    @Override
    protected void __verify(int nextIndex, int columnIndex, String tableName, String columnName, int columnType) throws SQLException {
        if (columnIndex == nextIndex) {
            this.verifyLongType("SIZEINBYTES", columnIndex, tableName, columnName, columnType);
        } else if (columnIndex == nextIndex + 1) {
            this.verifyLongType("RESERVATIONLIFETIME", columnIndex, tableName, columnName, columnType);
        } else if (columnIndex == nextIndex + 2) {
            this.verifyStringType("SPACETOKEN", columnIndex, tableName, columnName, columnType);
        } else if (columnIndex == nextIndex + 3) {
            this.verifyStringType("RETENTIONPOLICY", columnIndex, tableName, columnName, columnType);
        } else if (columnIndex == nextIndex + 4) {
            this.verifyStringType("ACCESSLATENCY", columnIndex, tableName, columnName, columnType);
        }
    }
}

