/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.srm.request.sql;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Set;
import org.dcache.srm.SRMUser;
import org.dcache.srm.SRMUserPersistenceManager;
import org.dcache.srm.request.Request;
import org.dcache.srm.request.RequestStorage;
import org.dcache.srm.request.sql.DatabaseJobStorage;
import org.dcache.srm.scheduler.Job;
import org.dcache.srm.scheduler.State;
import org.dcache.srm.util.Configuration;

public abstract class DatabaseRequestStorage
extends DatabaseJobStorage
implements RequestStorage {
    SRMUserPersistenceManager srmUserPersistenceManager;
    private static int ADDITIONAL_FIELDS_NUM = 7;

    public DatabaseRequestStorage(Configuration.DatabaseParameters configuration) throws SQLException {
        super(configuration);
        this.srmUserPersistenceManager = configuration.getSrmUserPersistenceManager();
        if (this.srmUserPersistenceManager == null) {
            throw new IllegalArgumentException("srmUserPersistenceManager == null");
        }
    }

    public abstract String getRequestCreateTableFields();

    @Override
    public String getCreateTableFields() {
        return ", CREDENTIALID  BIGINT , RETRYDELTATIME  INTEGER , SHOULDUPDATERETRYDELTATIME  INT , DESCRIPTION  VARCHAR(32672) , CLIENTHOST  VARCHAR(32672) , STATUSCODE  VARCHAR(32672) , USERID  BIGINT " + this.getRequestCreateTableFields();
    }

    protected abstract Request getRequest(Connection var1, Long var2, Long var3, long var4, long var6, int var8, String var9, SRMUser var10, String var11, long var12, int var14, int var15, long var16, Long var18, int var19, boolean var20, String var21, String var22, String var23, ResultSet var24, int var25) throws SQLException;

    @Override
    protected final Job getJob(Connection _con, Long ID, Long NEXTJOBID, long CREATIONTIME, long LIFETIME, int STATE, String ERRORMESSAGE, String SCHEDULERID, long SCHEDULER_TIMESTAMP, int NUMOFRETR, int MAXNUMOFRETR, long LASTSTATETRANSITIONTIME, ResultSet set, int next_index) throws SQLException {
        Long CREDENTIALID = set.getLong(next_index++);
        int RETRYDELTATIME = set.getInt(next_index++);
        boolean SHOULDUPDATERETRYDELTATIME = set.getBoolean(next_index++);
        String DESCRIPTION = set.getString(next_index++);
        String CLIENTHOST = set.getString(next_index++);
        String STATUSCODE = set.getString(next_index++);
        SRMUser user = this.srmUserPersistenceManager.find(set.getLong(next_index++));
        return this.getRequest(_con, ID, NEXTJOBID, CREATIONTIME, LIFETIME, STATE, ERRORMESSAGE, user, SCHEDULERID, SCHEDULER_TIMESTAMP, NUMOFRETR, MAXNUMOFRETR, LASTSTATETRANSITIONTIME, CREDENTIALID, RETRYDELTATIME, SHOULDUPDATERETRYDELTATIME, DESCRIPTION, CLIENTHOST, STATUSCODE, set, next_index);
    }

    public abstract void getCreateList(Request var1, StringBuffer var2);

    public final void getCreateList(Job job, StringBuffer sb) {
        if (job == null || !(job instanceof Request)) {
            throw new IllegalArgumentException("job is not Request");
        }
        Request r = (Request)job;
        sb.append(", ").append(r.getCredentialId()).append(" ");
        sb.append(", ").append(r.getRetryDeltaTime());
        sb.append(", ").append(r.isShould_updateretryDeltaTime() ? 1 : 0);
        String DESCRIPTION = r.getDescription();
        if (DESCRIPTION == null) {
            sb.append(", NULL ");
        } else {
            sb.append(", '").append(DESCRIPTION).append('\'');
        }
        String CLIENTHOST = r.getClient_host();
        if (CLIENTHOST == null) {
            sb.append(", NULL ");
        } else {
            sb.append(", '").append(CLIENTHOST).append('\'');
        }
        String STATUSCODE = r.getStatusCodeString();
        if (STATUSCODE == null) {
            sb.append(", NULL ");
        } else {
            sb.append(", '").append(STATUSCODE).append('\'');
        }
        sb.append(", ").append(r.getUser().getId()).append(" ");
        this.getCreateList(r, sb);
    }

    public Set<Long> getActiveRequestIds(String schedulerid) throws SQLException {
        String condition = " SCHEDULERID='" + schedulerid + "' AND STATE !=" + State.DONE.getStateId() + " AND STATE !=" + State.CANCELED.getStateId() + " AND STATE !=" + State.FAILED.getStateId();
        return this.getJobIdsByCondition(condition);
    }

    public Set<Long> getActiveRequestIds(String schedulerid, SRMUser user, String description) throws SQLException {
        String condition = " SCHEDULERID='" + schedulerid + "' AND STATE !=" + State.DONE.getStateId() + " AND STATE !=" + State.CANCELED.getStateId() + " AND STATE !=" + State.FAILED.getStateId() + " AND USERID = '" + user.getId() + '\'';
        if (description != null) {
            condition = condition + " AND DESCRIPTION = '" + description + '\'';
        }
        return this.getJobIdsByCondition(condition);
    }

    public Set<Long> getLatestCompletedRequestIds(int maxNum) throws SQLException {
        return this.getJobIdsByCondition(" STATE =" + State.DONE.getStateId() + " OR STATE =" + State.CANCELED.getStateId() + " OR STATE = " + State.FAILED.getStateId() + " ORDER BY ID" + " LIMIT " + maxNum + " ");
    }

    public Set<Long> getLatestDoneRequestIds(int maxNum) throws SQLException {
        return this.getJobIdsByCondition("STATE =" + State.DONE.getStateId() + " ORDERED BY ID" + " LIMIT " + maxNum + " ");
    }

    public Set<Long> getLatestFailedRequestIds(int maxNum) throws SQLException {
        return this.getJobIdsByCondition("STATE !=" + State.FAILED.getStateId() + " ORDERED BY ID" + " LIMIT " + maxNum + " ");
    }

    public Set<Long> getLatestCanceledRequestIds(int maxNum) throws SQLException {
        return this.getJobIdsByCondition("STATE != " + State.CANCELED.getStateId() + " ORDERED BY ID" + " LIMIT " + maxNum + " ");
    }

    protected abstract void __verify(int var1, int var2, String var3, String var4, int var5) throws SQLException;

    @Override
    protected final void _verify(int nextIndex, int columnIndex, String tableName, String columnName, int columnType) throws SQLException {
        if (columnIndex == nextIndex) {
            this.verifyLongType("CREDENTIALID", columnIndex, tableName, columnName, columnType);
        } else if (columnIndex == nextIndex + 1) {
            this.verifyIntType("RETRYDELTATIME", columnIndex, tableName, columnName, columnType);
        } else if (columnIndex == nextIndex + 2) {
            this.verifyBooleanType("SHOULDUPDATERETRYDELTATIME", columnIndex, tableName, columnName, columnType);
        } else if (columnIndex == nextIndex + 3) {
            this.verifyStringType("DESCRIPTION", columnIndex, tableName, columnName, columnType);
        } else if (columnIndex == nextIndex + 4) {
            this.verifyStringType("CLIENTHOST", columnIndex, tableName, columnName, columnType);
        } else if (columnIndex == nextIndex + 5) {
            this.verifyStringType("STATUSCODE", columnIndex, tableName, columnName, columnType);
        } else if (columnIndex == nextIndex + 6) {
            this.verifyLongType("USERID", columnIndex, tableName, columnName, columnType);
        } else {
            this.__verify(nextIndex + 7, columnIndex, tableName, columnName, columnType);
        }
    }

    protected abstract int getMoreCollumnsNum();

    @Override
    protected final int getAdditionalColumnsNum() {
        return ADDITIONAL_FIELDS_NUM + this.getMoreCollumnsNum();
    }
}

