/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.srm.request.sql;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.dcache.srm.request.BringOnlineFileRequest;
import org.dcache.srm.request.BringOnlineRequest;
import org.dcache.srm.request.CopyFileRequest;
import org.dcache.srm.request.CopyRequest;
import org.dcache.srm.request.GetFileRequest;
import org.dcache.srm.request.GetRequest;
import org.dcache.srm.request.LsFileRequest;
import org.dcache.srm.request.LsRequest;
import org.dcache.srm.request.PutFileRequest;
import org.dcache.srm.request.PutRequest;
import org.dcache.srm.request.ReserveSpaceRequest;
import org.dcache.srm.request.sql.BringOnlineFileRequestStorage;
import org.dcache.srm.request.sql.BringOnlineRequestStorage;
import org.dcache.srm.request.sql.CopyFileRequestStorage;
import org.dcache.srm.request.sql.CopyRequestStorage;
import org.dcache.srm.request.sql.DatabaseJobStorage;
import org.dcache.srm.request.sql.GetFileRequestStorage;
import org.dcache.srm.request.sql.GetRequestStorage;
import org.dcache.srm.request.sql.LsFileRequestStorage;
import org.dcache.srm.request.sql.LsRequestStorage;
import org.dcache.srm.request.sql.PutFileRequestStorage;
import org.dcache.srm.request.sql.PutRequestStorage;
import org.dcache.srm.request.sql.ReserveSpaceRequestStorage;
import org.dcache.srm.scheduler.FinalStateOnlyJobStorageDecorator;
import org.dcache.srm.scheduler.Job;
import org.dcache.srm.scheduler.JobStorage;
import org.dcache.srm.scheduler.JobStorageFactory;
import org.dcache.srm.scheduler.NoopJobStorage;
import org.dcache.srm.scheduler.Scheduler;
import org.dcache.srm.scheduler.SchedulerFactory;
import org.dcache.srm.scheduler.State;
import org.dcache.srm.util.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseJobStorageFactory
extends JobStorageFactory {
    private static final Logger logger = LoggerFactory.getLogger(DatabaseJobStorageFactory.class);
    private static final NoopJobStorage noop = new NoopJobStorage();
    private final Map<Class<?>, JobStorage> jobStorageMap = new HashMap();

    private void add(Configuration.DatabaseParameters config, Class<?> entityClass, Class<? extends DatabaseJobStorage> storageClass) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        if (config.isDatabaseEnabled()) {
            JobStorage js = storageClass.getConstructor(Configuration.DatabaseParameters.class).newInstance(config);
            if (config.getStoreCompletedRequestsOnly()) {
                js = new FinalStateOnlyJobStorageDecorator(js);
            }
            this.jobStorageMap.put(entityClass, js);
        } else {
            this.jobStorageMap.put(entityClass, noop);
        }
    }

    public DatabaseJobStorageFactory(Configuration config) {
        try {
            this.add(config.getDatabaseParametersForBringOnline(), BringOnlineFileRequest.class, BringOnlineFileRequestStorage.class);
            this.add(config.getDatabaseParametersForBringOnline(), BringOnlineRequest.class, BringOnlineRequestStorage.class);
            this.add(config.getDatabaseParametersForCopy(), CopyFileRequest.class, CopyFileRequestStorage.class);
            this.add(config.getDatabaseParametersForCopy(), CopyRequest.class, CopyRequestStorage.class);
            this.add(config.getDatabaseParametersForPut(), PutFileRequest.class, PutFileRequestStorage.class);
            this.add(config.getDatabaseParametersForPut(), PutRequest.class, PutRequestStorage.class);
            this.add(config.getDatabaseParametersForGet(), GetFileRequest.class, GetFileRequestStorage.class);
            this.add(config.getDatabaseParametersForGet(), GetRequest.class, GetRequestStorage.class);
            this.add(config.getDatabaseParametersForList(), LsFileRequest.class, LsFileRequestStorage.class);
            this.add(config.getDatabaseParametersForList(), LsRequest.class, LsRequestStorage.class);
            this.add(config.getDatabaseParametersForReserve(), ReserveSpaceRequest.class, ReserveSpaceRequestStorage.class);
            for (JobStorage js : this.jobStorageMap.values()) {
                Job.registerJobStorage(js);
            }
            for (JobStorage js : this.jobStorageMap.values()) {
                try {
                    if (!(js instanceof DatabaseJobStorage)) continue;
                    ((DatabaseJobStorage)js).updatePendingJobs();
                }
                catch (Exception e) {
                    logger.error("updatePendingJobs failed", (Throwable)e);
                }
            }
            SchedulerFactory schedulerFactory = SchedulerFactory.getSchedulerFactory();
            for (Class<?> jobType : this.jobStorageMap.keySet()) {
                Scheduler scheduler;
                try {
                    scheduler = schedulerFactory.getScheduler(jobType);
                }
                catch (UnsupportedOperationException uoe) {
                    continue;
                }
                JobStorage djs = this.jobStorageMap.get(jobType);
                Set jobs = djs.getJobs(null, State.PENDING);
                for (Job job : jobs) {
                    scheduler.schedule(job);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("DatabaseJobStorageFactory intialization", e);
        }
    }

    @Override
    public JobStorage getJobStorage(Job job) {
        if (job == null) {
            throw new IllegalArgumentException("job is null");
        }
        return this.getJobStorage(job.getClass());
    }

    @Override
    public JobStorage getJobStorage(Class jobClass) {
        JobStorage js = this.jobStorageMap.get(jobClass);
        if (js != null) {
            return js;
        }
        throw new UnsupportedOperationException("JobStorage for class " + jobClass + " is not supported");
    }
}

