/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.srm.request.sql;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Set;
import org.dcache.srm.request.FileRequest;
import org.dcache.srm.request.sql.DatabaseJobStorage;
import org.dcache.srm.scheduler.Job;
import org.dcache.srm.scheduler.State;
import org.dcache.srm.util.Configuration;

public abstract class DatabaseFileRequestStorage
extends DatabaseJobStorage {
    private static int ADDITIONAL_FIELDS_NUM = 3;

    public DatabaseFileRequestStorage(Configuration.DatabaseParameters configuration) throws SQLException {
        super(configuration);
    }

    @Override
    protected void _dbInit() throws SQLException {
        String[] columns = new String[]{"REQUESTID"};
        this.createIndex(columns, this.getTableName().toLowerCase());
    }

    public abstract String getFileRequestCreateTableFields();

    public abstract String getRequestTableName();

    @Override
    public String getCreateTableFields() {
        return ",REQUESTID  BIGINT , CREDENTIALID  BIGINT , STATUSCODE  VARCHAR(32672) " + this.getFileRequestCreateTableFields();
    }

    protected abstract FileRequest getFileRequest(Connection var1, Long var2, Long var3, long var4, long var6, int var8, String var9, String var10, long var11, int var13, int var14, long var15, Long var17, Long var18, String var19, ResultSet var20, int var21) throws SQLException;

    @Override
    protected Job getJob(Connection _con, Long ID, Long NEXTJOBID, long CREATIONTIME, long LIFETIME, int STATE, String ERRORMESSAGE, String SCHEDULERID, long SCHEDULER_TIMESTAMP, int NUMOFRETR, int MAXNUMOFRETR, long LASTSTATETRANSITIONTIME, ResultSet set, int next_index) throws SQLException {
        Long REQUESTID = set.getLong(next_index++);
        Long CREDENTIALID = set.getLong(next_index++);
        String STATUSCODE = set.getString(next_index++);
        return this.getFileRequest(_con, ID, NEXTJOBID, CREATIONTIME, LIFETIME, STATE, ERRORMESSAGE, SCHEDULERID, SCHEDULER_TIMESTAMP, NUMOFRETR, MAXNUMOFRETR, LASTSTATETRANSITIONTIME, REQUESTID, CREDENTIALID, STATUSCODE, set, next_index);
    }

    @Override
    public abstract String getTableName();

    protected abstract void __verify(int var1, int var2, String var3, String var4, int var5) throws SQLException;

    @Override
    protected void _verify(int nextIndex, int columnIndex, String tableName, String columnName, int columnType) throws SQLException {
        if (columnIndex == nextIndex) {
            this.verifyLongType("REQUESTID", columnIndex, tableName, columnName, columnType);
        } else if (columnIndex == nextIndex + 1) {
            this.verifyLongType("CREDENTIALID", columnIndex, tableName, columnName, columnType);
        } else if (columnIndex == nextIndex + 2) {
            this.verifyStringType("STATUSCODE", columnIndex, tableName, columnName, columnType);
        } else {
            this.__verify(nextIndex + 3, columnIndex, tableName, columnName, columnType);
        }
    }

    protected abstract int getMoreCollumnsNum();

    @Override
    protected int getAdditionalColumnsNum() {
        return ADDITIONAL_FIELDS_NUM + this.getMoreCollumnsNum();
    }

    public Set<Long> getActiveFileRequestIds(String schedulerid) throws SQLException {
        String condition = " SCHEDULERID='" + schedulerid + "' AND STATE !=" + State.DONE.getStateId() + " AND STATE !=" + State.CANCELED.getStateId() + " AND STATE !=" + State.FAILED.getStateId();
        return this.getJobIdsByCondition(condition);
    }
}

