/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.srm.request.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import org.dcache.srm.SRMUser;
import org.dcache.srm.request.BringOnlineRequest;
import org.dcache.srm.request.ContainerRequest;
import org.dcache.srm.request.FileRequest;
import org.dcache.srm.request.sql.DatabaseContainerRequestStorage;
import org.dcache.srm.scheduler.Job;
import org.dcache.srm.util.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BringOnlineRequestStorage
extends DatabaseContainerRequestStorage {
    private static final Logger logger = LoggerFactory.getLogger(BringOnlineRequestStorage.class);
    public static final String TABLE_NAME = "bringonlinerequests";
    private static final String UPDATE_PREFIX = "UPDATE bringonlinerequests SET NEXTJOBID=?, CREATIONTIME=?,  LIFETIME=?, STATE=?, ERRORMESSAGE=?, SCHEDULERID=?, SCHEDULERTIMESTAMP=?,NUMOFRETR=?,MAXNUMOFRETR=?,LASTSTATETRANSITIONTIME=? ";
    private static final String INSERT_SQL = "INSERT INTO bringonlinerequests(    ID ,NEXTJOBID ,CREATIONTIME ,LIFETIME ,STATE ,ERRORMESSAGE ,SCHEDULERID ,SCHEDULERTIMESTAMP ,NUMOFRETR ,MAXNUMOFRETR ,LASTSTATETRANSITIONTIME,CREDENTIALID , RETRYDELTATIME , SHOULDUPDATERETRYDELTATIME ,DESCRIPTION ,CLIENTHOST ,STATUSCODE ,USERID  ) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    private static final String UPDATE_REQUEST_SQL = "UPDATE bringonlinerequests SET NEXTJOBID=?, CREATIONTIME=?,  LIFETIME=?, STATE=?, ERRORMESSAGE=?, SCHEDULERID=?, SCHEDULERTIMESTAMP=?,NUMOFRETR=?,MAXNUMOFRETR=?,LASTSTATETRANSITIONTIME=? , CREDENTIALID=?, RETRYDELTATIME=?, SHOULDUPDATERETRYDELTATIME=?, DESCRIPTION=?, CLIENTHOST=?, STATUSCODE=?, USERID=? WHERE ID=?";
    private static int ADDITIONAL_FIELDS = 0;
    private final String insertProtocols = "INSERT INTO " + this.getProtocolsTableName() + " (PROTOCOL, RequestID) " + " VALUES (?,?)";

    @Override
    public PreparedStatement getCreateStatement(Connection connection, Job job) throws SQLException {
        BringOnlineRequest bor = (BringOnlineRequest)job;
        PreparedStatement stmt = this.getPreparedStatement(connection, INSERT_SQL, bor.getId(), bor.getNextJobId(), bor.getCreationTime(), bor.getLifetime(), bor.getState().getStateId(), bor.getErrorMessage(), bor.getSchedulerId(), bor.getSchedulerTimeStamp(), bor.getNumberOfRetries(), bor.getMaxNumberOfRetries(), bor.getLastStateTransitionTime(), bor.getCredentialId(), bor.getRetryDeltaTime(), bor.isShould_updateretryDeltaTime() ? 0 : 1, bor.getDescription(), bor.getClient_host(), bor.getStatusCodeString(), bor.getUser().getId());
        return stmt;
    }

    @Override
    public PreparedStatement getUpdateStatement(Connection connection, Job job) throws SQLException {
        BringOnlineRequest bor = (BringOnlineRequest)job;
        PreparedStatement stmt = this.getPreparedStatement(connection, UPDATE_REQUEST_SQL, bor.getNextJobId(), bor.getCreationTime(), bor.getLifetime(), bor.getState().getStateId(), bor.getErrorMessage(), bor.getSchedulerId(), bor.getSchedulerTimeStamp(), bor.getNumberOfRetries(), bor.getMaxNumberOfRetries(), bor.getLastStateTransitionTime(), bor.getCredentialId(), bor.getRetryDeltaTime(), bor.isShould_updateretryDeltaTime() ? 0 : 1, bor.getDescription(), bor.getClient_host(), bor.getStatusCodeString(), bor.getUser().getId(), bor.getId());
        return stmt;
    }

    public BringOnlineRequestStorage(Configuration.DatabaseParameters configuration) throws SQLException {
        super(configuration);
    }

    private String getProtocolsTableName() {
        return this.getTableName() + "_protocols";
    }

    @Override
    public void dbInit1() throws SQLException {
        if (this.reanamed_old_table) {
            this.renameTable(this.getProtocolsTableName());
        }
        String protocolsTableName = this.getProtocolsTableName().toLowerCase();
        String createProtocolsTable = "CREATE TABLE " + protocolsTableName + " ( " + " PROTOCOL " + " VARCHAR(32672) " + "," + " RequestID " + " BIGINT " + ", " + " CONSTRAINT fk_" + this.getTableName() + "_PG FOREIGN KEY (RequestID) REFERENCES " + this.getTableName() + " (ID) " + " ON DELETE CASCADE" + " )";
        this.createTable(protocolsTableName, createProtocolsTable);
    }

    @Override
    public void getCreateList(ContainerRequest r, StringBuffer sb) {
    }

    @Override
    protected ContainerRequest getContainerRequest(Connection _con, Long ID, Long NEXTJOBID, long CREATIONTIME, long LIFETIME, int STATE, String ERRORMESSAGE, SRMUser user, String SCHEDULERID, long SCHEDULER_TIMESTAMP, int NUMOFRETR, int MAXNUMOFRETR, long LASTSTATETRANSITIONTIME, Long CREDENTIALID, int RETRYDELTATIME, boolean SHOULDUPDATERETRYDELTATIME, String DESCRIPTION, String CLIENTHOST, String STATUSCODE, FileRequest[] fileRequests, ResultSet set, int next_index) throws SQLException {
        String sql = "SELECT PROTOCOL FROM " + this.getProtocolsTableName() + "  WHERE RequestID=?";
        PreparedStatement statement = _con.prepareStatement(sql);
        statement.setLong(1, ID);
        logger.debug("executing: SELECT PROTOCOL FROM {} WHERE RequestID={} ", (Object)this.getProtocolsTableName(), (Object)ID);
        ResultSet fileIdsSet = statement.executeQuery();
        HashSet<String> utilset = new HashSet<String>();
        while (fileIdsSet.next()) {
            utilset.add(fileIdsSet.getString(1));
        }
        String[] protocols = utilset.toArray(new String[0]);
        statement.close();
        Job.JobHistory[] jobHistoryArray = this.getJobHistory(ID, _con);
        return new BringOnlineRequest(ID, NEXTJOBID, CREATIONTIME, LIFETIME, STATE, ERRORMESSAGE, user, SCHEDULERID, SCHEDULER_TIMESTAMP, NUMOFRETR, MAXNUMOFRETR, LASTSTATETRANSITIONTIME, jobHistoryArray, CREDENTIALID, fileRequests, RETRYDELTATIME, SHOULDUPDATERETRYDELTATIME, DESCRIPTION, CLIENTHOST, STATUSCODE, protocols);
    }

    @Override
    public String getRequestCreateTableFields() {
        return "";
    }

    @Override
    public String getTableName() {
        return TABLE_NAME;
    }

    @Override
    public PreparedStatement[] getAdditionalCreateStatements(Connection connection, Job job) throws SQLException {
        if (job == null || !(job instanceof BringOnlineRequest)) {
            throw new IllegalArgumentException("Request is not BringOnlineRequest");
        }
        BringOnlineRequest bor = (BringOnlineRequest)job;
        String[] protocols = bor.getProtocols();
        if (protocols == null) {
            return null;
        }
        PreparedStatement[] statements = new PreparedStatement[protocols.length];
        for (int i = 0; i < protocols.length; ++i) {
            statements[i] = this.getPreparedStatement(connection, this.insertProtocols, protocols[i], bor.getId());
        }
        return statements;
    }

    @Override
    public String getFileRequestsTableName() {
        return "bringonlinefilerequests";
    }

    @Override
    protected void __verify(int nextIndex, int columnIndex, String tableName, String columnName, int columnType) throws SQLException {
    }

    @Override
    protected int getMoreCollumnsNum() {
        return ADDITIONAL_FIELDS;
    }
}

