/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.srm.request;

import com.google.common.collect.ImmutableMap;
import org.dcache.srm.v2_2.TRetentionPolicy;

public enum RetentionPolicy {
    REPLICA(TRetentionPolicy.REPLICA),
    OUTPUT(TRetentionPolicy.OUTPUT),
    CUSTODIAL(TRetentionPolicy.CUSTODIAL);

    private final TRetentionPolicy _policy;
    private static final ImmutableMap<TRetentionPolicy, RetentionPolicy> MAP;
    private static final String ERROR_MESSAGE;

    private RetentionPolicy(TRetentionPolicy policy) {
        this._policy = policy;
    }

    public TRetentionPolicy toTRetentionPolicy() {
        return this._policy;
    }

    public static RetentionPolicy fromTRetentionPolicy(TRetentionPolicy policy) {
        if (policy == null) {
            return null;
        }
        return (RetentionPolicy)((Object)MAP.get((Object)policy));
    }

    public static RetentionPolicy fromString(String txt) throws IllegalArgumentException {
        try {
            TRetentionPolicy policy = TRetentionPolicy.fromString(txt);
            return RetentionPolicy.fromTRetentionPolicy(policy);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format(ERROR_MESSAGE, txt));
        }
    }

    static {
        StringBuilder sb = new StringBuilder();
        sb.append("Unknown RetentionPolicy: \"%s\".");
        sb.append(" Supported values :");
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (RetentionPolicy value : RetentionPolicy.values()) {
            builder.put((Object)value._policy, (Object)value);
            sb.append(" \"").append(value._policy).append("\"");
        }
        MAP = builder.build();
        ERROR_MESSAGE = sb.toString();
    }
}

