/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.srm.request;

import java.util.Date;
import org.apache.axis.types.UnsignedLong;
import org.dcache.srm.SRMInvalidRequestException;
import org.dcache.srm.SRMUser;
import org.dcache.srm.request.Request;
import org.dcache.srm.scheduler.FatalJobFailure;
import org.dcache.srm.scheduler.IllegalStateTransition;
import org.dcache.srm.scheduler.Job;
import org.dcache.srm.scheduler.NonFatalJobFailure;
import org.dcache.srm.scheduler.State;
import org.dcache.srm.v2_2.SrmReserveSpaceResponse;
import org.dcache.srm.v2_2.SrmStatusOfReserveSpaceRequestResponse;
import org.dcache.srm.v2_2.TAccessLatency;
import org.dcache.srm.v2_2.TRetentionPolicy;
import org.dcache.srm.v2_2.TRetentionPolicyInfo;
import org.dcache.srm.v2_2.TReturnStatus;
import org.dcache.srm.v2_2.TStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ReserveSpaceRequest
extends Request {
    private static final Logger logger = LoggerFactory.getLogger(ReserveSpaceRequest.class);
    private long sizeInBytes;
    private final TRetentionPolicy retentionPolicy;
    private final TAccessLatency accessLatency;
    private String spaceToken;
    private long spaceReservationLifetime;

    public ReserveSpaceRequest(Long requestCredentalId, SRMUser user, long lifetime, int maxNumberOfRetries, long sizeInBytes, long spaceReservationLifetime, TRetentionPolicy retentionPolicy, TAccessLatency accessLatency, String description, String clienthost) throws Exception {
        super(user, requestCredentalId, maxNumberOfRetries, 0L, lifetime, description, clienthost);
        this.sizeInBytes = sizeInBytes;
        this.retentionPolicy = retentionPolicy;
        this.accessLatency = accessLatency;
        this.spaceReservationLifetime = spaceReservationLifetime;
        this.updateMemoryCache();
        logger.debug("created");
    }

    public ReserveSpaceRequest(Long id, Long nextJobId, long creationTime, long lifetime, int stateId, String errorMessage, SRMUser user, String scheduelerId, long schedulerTimeStamp, int numberOfRetries, int maxNumberOfRetries, long lastStateTransitionTime, Job.JobHistory[] jobHistoryArray, Long requestCredentalId, long sizeInBytes, long spaceReservationLifetime, String spaceToken, String retentionPolicy, String accessLatency, String description, String clienthost, String statusCodeString) {
        super(id, nextJobId, creationTime, lifetime, stateId, errorMessage, user, scheduelerId, schedulerTimeStamp, numberOfRetries, maxNumberOfRetries, lastStateTransitionTime, jobHistoryArray, requestCredentalId, 0, false, description, clienthost, statusCodeString);
        this.sizeInBytes = sizeInBytes;
        this.spaceToken = spaceToken;
        this.retentionPolicy = retentionPolicy == null ? null : TRetentionPolicy.fromString(retentionPolicy);
        this.accessLatency = accessLatency == null ? null : TAccessLatency.fromString(accessLatency);
        this.spaceReservationLifetime = spaceReservationLifetime;
        logger.debug("restored");
    }

    @Override
    public void toString(StringBuilder sb, boolean longformat) {
        sb.append(" ReserveSpaceRequest ");
        sb.append(" id =").append(this.getId());
        sb.append(" created: ").append(this.getUser());
        sb.append(" spaceToken: ").append(this.getSpaceToken());
        sb.append(" state=").append((Object)this.getState());
        if (longformat) {
            sb.append("\ncredential: \"").append(this.getCredential()).append("\"\n");
            sb.append("\nsubmitted: ").append(new Date(this.getCreationTime()));
            sb.append("\nexpires: ").append(new Date(this.getCreationTime() + this.getLifetime()));
            sb.append("\nstatus code: ").append(this.getStatusCode());
            sb.append("\nerror message: ").append(this.getErrorMessage());
            sb.append('\n').append("   lifetime: ").append(this.getSpaceReservationLifetime());
            sb.append('\n').append("   AccessLatency: ").append(this.getAccessLatency());
            sb.append('\n').append("   RetentionPolicy: ").append(this.getRetentionPolicy());
            sb.append('\n').append("History of State Transitions: \n");
            sb.append(this.getHistory());
        }
    }

    @Override
    protected void stateChanged(State oldState) {
    }

    @Override
    public void run() throws NonFatalJobFailure, FatalJobFailure {
        try {
            SrmReserveSpaceCallbacks callbacks = new SrmReserveSpaceCallbacks(this.getId());
            this.getStorage().srmReserveSpace(this.getUser(), this.sizeInBytes, this.spaceReservationLifetime, this.retentionPolicy == null ? null : this.retentionPolicy.getValue(), this.accessLatency == null ? null : this.accessLatency.getValue(), this.getDescription(), callbacks);
            this.setState(State.ASYNCWAIT, "waiting Space Reservation completion");
        }
        catch (Exception e) {
            if (e instanceof NonFatalJobFailure) {
                throw (NonFatalJobFailure)e;
            }
            if (e instanceof FatalJobFailure) {
                throw (FatalJobFailure)e;
            }
            logger.error("can not reserve space: ");
            logger.error(e.toString());
            try {
                this.setState(State.FAILED, e.toString());
            }
            catch (IllegalStateTransition ist) {
                logger.error("Illegal State Transition : " + ist.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SrmStatusOfReserveSpaceRequestResponse getSrmStatusOfReserveSpaceRequestResponse() {
        this.rlock();
        try {
            SrmStatusOfReserveSpaceRequestResponse response = new SrmStatusOfReserveSpaceRequestResponse();
            response.setReturnStatus(this.getTReturnStatus());
            response.setRetentionPolicyInfo(new TRetentionPolicyInfo(this.retentionPolicy, this.accessLatency));
            response.setSpaceToken(this.getSpaceToken());
            response.setSizeOfTotalReservedSpace(new UnsignedLong(this.sizeInBytes));
            response.setSizeOfGuaranteedReservedSpace(new UnsignedLong(this.sizeInBytes));
            response.setLifetimeOfReservedSpace((int)(this.spaceReservationLifetime / 1000L));
            SrmStatusOfReserveSpaceRequestResponse srmStatusOfReserveSpaceRequestResponse = response;
            return srmStatusOfReserveSpaceRequestResponse;
        }
        finally {
            this.runlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SrmReserveSpaceResponse getSrmReserveSpaceResponse() {
        this.rlock();
        try {
            SrmReserveSpaceResponse response = new SrmReserveSpaceResponse();
            response.setReturnStatus(this.getTReturnStatus());
            response.setRetentionPolicyInfo(new TRetentionPolicyInfo(this.retentionPolicy, this.accessLatency));
            response.setRequestToken(String.valueOf(this.getId()));
            response.setSpaceToken(this.getSpaceToken());
            response.setSizeOfTotalReservedSpace(new UnsignedLong(this.sizeInBytes));
            response.setSizeOfGuaranteedReservedSpace(new UnsignedLong(this.sizeInBytes));
            response.setLifetimeOfReservedSpace((int)(this.spaceReservationLifetime / 1000L));
            SrmReserveSpaceResponse srmReserveSpaceResponse = response;
            return srmReserveSpaceResponse;
        }
        finally {
            this.runlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final TReturnStatus getTReturnStatus() {
        TStatusCode statusCode;
        State state;
        TReturnStatus status = new TReturnStatus();
        this.rlock();
        try {
            status.setExplanation(this.getErrorMessage());
            state = this.getState();
            statusCode = this.getStatusCode();
        }
        finally {
            this.runlock();
        }
        if (statusCode != null) {
            status.setStatusCode(statusCode);
        } else if (state == State.FAILED) {
            status.setStatusCode(TStatusCode.SRM_FAILURE);
        } else if (state == State.CANCELED) {
            status.setStatusCode(TStatusCode.SRM_ABORTED);
        } else if (state == State.DONE) {
            status.setStatusCode(TStatusCode.SRM_SUCCESS);
        } else {
            status.setStatusCode(TStatusCode.SRM_REQUEST_INPROGRESS);
        }
        return status;
    }

    public static ReserveSpaceRequest getRequest(Long requestId) throws SRMInvalidRequestException {
        return Job.getJob(requestId, ReserveSpaceRequest.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSizeInBytes() {
        this.rlock();
        try {
            long l = this.sizeInBytes;
            return l;
        }
        finally {
            this.runlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSizeInBytes(long sizeInBytes) {
        this.wlock();
        try {
            this.sizeInBytes = sizeInBytes;
        }
        finally {
            this.wunlock();
        }
    }

    public TRetentionPolicy getRetentionPolicy() {
        return this.retentionPolicy;
    }

    public TAccessLatency getAccessLatency() {
        return this.accessLatency;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSpaceToken() {
        this.rlock();
        try {
            String string = this.spaceToken;
            return string;
        }
        finally {
            this.runlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSpaceToken(String spaceToken) {
        this.wlock();
        try {
            this.spaceToken = spaceToken;
        }
        finally {
            this.wunlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSpaceReservationLifetime() {
        this.rlock();
        try {
            long l = this.spaceReservationLifetime;
            return l;
        }
        finally {
            this.runlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSpaceReservationLifetime(long spaceReservationLifetime) {
        this.wlock();
        try {
            this.spaceReservationLifetime = spaceReservationLifetime;
        }
        finally {
            this.wunlock();
        }
    }

    @Override
    public String getMethod() {
        return "srmReserveSpace";
    }

    private class SrmReserveSpaceCallbacks
    implements org.dcache.srm.SrmReserveSpaceCallbacks {
        Long requestJobId;

        public SrmReserveSpaceCallbacks(Long requestJobId) {
            this.requestJobId = requestJobId;
        }

        public ReserveSpaceRequest getReserveSpacetRequest() throws SRMInvalidRequestException {
            return Job.getJob(this.requestJobId, ReserveSpaceRequest.class);
        }

        @Override
        public void ReserveSpaceFailed(String reason) {
            ReserveSpaceRequest request;
            try {
                request = this.getReserveSpacetRequest();
            }
            catch (SRMInvalidRequestException ire) {
                logger.error(ire.toString());
                return;
            }
            try {
                request.setState(State.FAILED, reason);
            }
            catch (IllegalStateTransition ist) {
                logger.error("Illegal State Transition : " + ist.getMessage());
            }
            logger.error("ReserveSpace error: " + reason);
        }

        @Override
        public void NoFreeSpace(String reason) {
            ReserveSpaceRequest request;
            try {
                request = this.getReserveSpacetRequest();
            }
            catch (SRMInvalidRequestException ire) {
                logger.error(ire.toString());
                return;
            }
            try {
                request.setStateAndStatusCode(State.FAILED, reason, TStatusCode.SRM_NO_FREE_SPACE);
            }
            catch (IllegalStateTransition ist) {
                logger.error("Illegal State Transition : " + ist.getMessage());
            }
            logger.error("ReserveSpace failed (NoFreeSpace), no free space : " + reason);
        }

        @Override
        public void ReserveSpaceFailed(Exception e) {
            ReserveSpaceRequest request;
            try {
                request = this.getReserveSpacetRequest();
            }
            catch (SRMInvalidRequestException ire) {
                logger.error(ire.toString());
                return;
            }
            try {
                request.setState(State.FAILED, e.toString());
            }
            catch (IllegalStateTransition ist) {
                logger.error("Illegal State Transition : " + ist.getMessage());
            }
            logger.error("ReserveSpace exception: ", (Throwable)e);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void SpaceReserved(String spaceReservationToken, long reservedSpaceSize) {
            ReserveSpaceRequest request;
            try {
                request = this.getReserveSpacetRequest();
            }
            catch (SRMInvalidRequestException ire) {
                logger.error(ire.toString());
                return;
            }
            request.wlock();
            try {
                State state = request.getState();
                if (!State.isFinalState(state)) {
                    request.setSpaceToken(spaceReservationToken);
                    request.setSizeInBytes(reservedSpaceSize);
                    request.setState(State.DONE, "space reservation succeeded");
                }
            }
            catch (IllegalStateTransition ist) {
                logger.error("Illegal State Transition : " + ist.getMessage());
            }
            finally {
                ReserveSpaceRequest.this.wunlock();
            }
        }
    }
}

