/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.srm.request;

import diskCacheV111.srm.RequestFileStatus;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.SQLException;
import org.apache.axis.types.UnsignedLong;
import org.dcache.srm.FileMetaData;
import org.dcache.srm.PrepareToPutCallbacks;
import org.dcache.srm.ReleaseSpaceCallbacks;
import org.dcache.srm.SRMAuthorizationException;
import org.dcache.srm.SRMException;
import org.dcache.srm.SRMInvalidRequestException;
import org.dcache.srm.SRMUser;
import org.dcache.srm.SrmCancelUseOfSpaceCallbacks;
import org.dcache.srm.SrmReleaseSpaceCallbacks;
import org.dcache.srm.SrmReserveSpaceCallbacks;
import org.dcache.srm.SrmUseSpaceCallbacks;
import org.dcache.srm.request.FileRequest;
import org.dcache.srm.request.PutRequest;
import org.dcache.srm.scheduler.FatalJobFailure;
import org.dcache.srm.scheduler.IllegalStateTransition;
import org.dcache.srm.scheduler.Job;
import org.dcache.srm.scheduler.NonFatalJobFailure;
import org.dcache.srm.scheduler.Scheduler;
import org.dcache.srm.scheduler.State;
import org.dcache.srm.v2_2.TAccessLatency;
import org.dcache.srm.v2_2.TPutRequestFileStatus;
import org.dcache.srm.v2_2.TRetentionPolicy;
import org.dcache.srm.v2_2.TReturnStatus;
import org.dcache.srm.v2_2.TSURLReturnStatus;
import org.dcache.srm.v2_2.TStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PutFileRequest
extends FileRequest {
    private static final Logger logger = LoggerFactory.getLogger(PutFileRequest.class);
    private URI surl;
    private URI turl;
    private long size;
    private String fileId;
    private String parentFileId;
    private transient FileMetaData fmd;
    private transient FileMetaData parentFmd;
    private String spaceReservationId;
    private boolean weReservedSpace;
    private TAccessLatency accessLatency;
    private TRetentionPolicy retentionPolicy;
    private boolean spaceMarkedAsBeingUsed = false;
    private static final long serialVersionUID = 542933938646172116L;

    public PutFileRequest(Long requestId, Long requestCredentalId, String url, long size, long lifetime, int maxNumberOfRetires, String spaceReservationId, TRetentionPolicy retentionPolicy, TAccessLatency accessLatency) throws Exception {
        super(requestId, requestCredentalId, lifetime, maxNumberOfRetires);
        this.surl = URI.create(url);
        this.size = size;
        this.spaceReservationId = spaceReservationId;
        if (accessLatency != null) {
            this.accessLatency = accessLatency;
        }
        if (retentionPolicy != null) {
            this.retentionPolicy = retentionPolicy;
        }
        this.updateMemoryCache();
    }

    public PutFileRequest(Long id, Long nextJobId, long creationTime, long lifetime, int stateId, String errorMessage, String scheduelerId, long schedulerTimeStamp, int numberOfRetries, int maxNumberOfRetries, long lastStateTransitionTime, Job.JobHistory[] jobHistoryArray, Long requestId, Long requestCredentalId, String statusCodeString, String SURL2, String TURL, String fileId, String parentFileId, String spaceReservationId, long size, TRetentionPolicy retentionPolicy, TAccessLatency accessLatency) throws SQLException {
        super(id, nextJobId, creationTime, lifetime, stateId, errorMessage, scheduelerId, schedulerTimeStamp, numberOfRetries, maxNumberOfRetries, lastStateTransitionTime, jobHistoryArray, requestId, requestCredentalId, statusCodeString);
        this.surl = URI.create(SURL2);
        if (TURL != null && !TURL.equalsIgnoreCase("null")) {
            this.turl = URI.create(TURL);
        }
        if (fileId != null && !fileId.equalsIgnoreCase("null")) {
            this.fileId = fileId;
        }
        if (parentFileId != null && !parentFileId.equalsIgnoreCase("null")) {
            this.parentFileId = parentFileId;
        }
        this.spaceReservationId = spaceReservationId;
        this.size = size;
        this.accessLatency = accessLatency;
        this.retentionPolicy = retentionPolicy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String getFileId() {
        this.rlock();
        try {
            String string = this.fileId;
            return string;
        }
        finally {
            this.runlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setSize(long size) {
        this.wlock();
        try {
            this.size = size;
        }
        finally {
            this.wunlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long getSize() {
        this.rlock();
        try {
            long l = this.size;
            return l;
        }
        finally {
            this.runlock();
        }
    }

    private final void setTurl(String turl_string) throws URISyntaxException {
        this.setTurl(new URI(turl_string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final URI getSurl() {
        this.rlock();
        try {
            URI uRI = this.surl;
            return uRI;
        }
        finally {
            this.runlock();
        }
    }

    public final String getSurlString() {
        return this.getSurl().toASCIIString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTurlString() {
        this.wlock();
        try {
            State state = this.getState();
            if (this.getTurl() == null && (state == State.READY || state == State.TRANSFERRING)) {
                try {
                    this.setTurl(this.getTURL());
                }
                catch (SRMAuthorizationException srme) {
                    String error = srme.getMessage();
                    logger.error(error);
                    try {
                        this.setStateAndStatusCode(State.FAILED, error, TStatusCode.SRM_AUTHORIZATION_FAILURE);
                    }
                    catch (IllegalStateTransition ist) {
                        logger.warn("Illegal State Transition : " + ist.getMessage());
                    }
                }
                catch (Exception srme) {
                    String error = "can not obtain turl for file:" + srme;
                    logger.error(error.toString());
                    try {
                        this.setState(State.FAILED, error);
                    }
                    catch (IllegalStateTransition ist) {
                        logger.warn("Illegal State Transition : " + ist.getMessage());
                    }
                }
            }
            if (this.getTurl() != null) {
                String string = this.getTurl().toASCIIString();
                return string;
            }
        }
        finally {
            this.wunlock();
        }
        return null;
    }

    @Override
    public RequestFileStatus getRequestFileStatus() {
        RequestFileStatus rfs = new RequestFileStatus();
        rfs.fileId = this.getId().intValue();
        rfs.SURL = this.getSurlString();
        rfs.size = this.getSize();
        State state = this.getState();
        rfs.TURL = this.getTurlString();
        rfs.state = state == State.DONE ? "Done" : (state == State.READY ? "Ready" : (state == State.TRANSFERRING ? "Running" : (state == State.FAILED || state == State.CANCELED ? "Failed" : "Pending")));
        logger.debug(" returning requestFileStatus for " + this.toString());
        return rfs;
    }

    public TPutRequestFileStatus getTPutRequestFileStatus() throws SQLException, SRMInvalidRequestException {
        org.apache.axis.types.URI anSurl;
        TPutRequestFileStatus fileStatus = new TPutRequestFileStatus();
        fileStatus.setFileSize(new UnsignedLong(this.getSize()));
        try {
            anSurl = new org.apache.axis.types.URI(this.getSurlString());
        }
        catch (Exception e) {
            logger.error(e.toString());
            throw new SQLException("wrong surl format");
        }
        fileStatus.setSURL(anSurl);
        String turlstring = this.getTurlString();
        if (turlstring != null) {
            org.apache.axis.types.URI transferURL;
            try {
                transferURL = new org.apache.axis.types.URI(turlstring);
            }
            catch (Exception e) {
                logger.error(e.toString());
                throw new SQLException("wrong turl format");
            }
            fileStatus.setTransferURL(transferURL);
        }
        fileStatus.setEstimatedWaitTime(this.getRequest().getRetryDeltaTime());
        fileStatus.setRemainingPinLifetime((int)this.getRemainingLifetime() / 1000);
        TReturnStatus returnStatus = this.getReturnStatus();
        if (TStatusCode.SRM_SPACE_LIFETIME_EXPIRED.equals(returnStatus.getStatusCode())) {
            returnStatus.setStatusCode(TStatusCode.SRM_FAILURE);
        }
        returnStatus.setExplanation(this.getErrorMessage());
        fileStatus.setStatus(returnStatus);
        return fileStatus;
    }

    public TSURLReturnStatus getTSURLReturnStatus() throws SQLException {
        org.apache.axis.types.URI anSurl;
        try {
            anSurl = new org.apache.axis.types.URI(this.getSurlString());
        }
        catch (Exception e) {
            logger.error(e.toString());
            throw new SQLException("wrong surl format");
        }
        TReturnStatus returnStatus = this.getReturnStatus();
        if (TStatusCode.SRM_SPACE_LIFETIME_EXPIRED.equals(returnStatus.getStatusCode())) {
            returnStatus.setStatusCode(TStatusCode.SRM_FAILURE);
        }
        TSURLReturnStatus surlReturnStatus = new TSURLReturnStatus();
        surlReturnStatus.setSurl(anSurl);
        surlReturnStatus.setStatus(returnStatus);
        return surlReturnStatus;
    }

    private URI getTURL() throws SRMException, SQLException {
        PutRequest request = (PutRequest)this.getRequest();
        String firstDcapTurl = request.getFirstDcapTurl();
        if (firstDcapTurl == null) {
            URI turl = this.getStorage().getPutTurl(this.getUser(), this.getSurl(), request.getProtocols());
            if (turl.getScheme().equals("dcap")) {
                request.setFirstDcapTurl(turl.toString());
            }
            return turl;
        }
        return this.getStorage().getPutTurl(request.getUser(), this.getSurl(), URI.create(firstDcapTurl));
    }

    @Override
    public void toString(StringBuilder sb, boolean longformat) {
        sb.append(" PutFileRequest ");
        sb.append(" id:").append(this.getId());
        sb.append(" priority:").append(this.getPriority());
        sb.append(" creator priority:");
        try {
            sb.append(this.getUser().getPriority());
        }
        catch (SRMInvalidRequestException ire) {
            sb.append("Unknown");
        }
        State state = this.getState();
        sb.append(" state:").append((Object)state);
        if (longformat) {
            sb.append('\n').append("   SURL: ").append(this.getSurlString());
            sb.append('\n').append("   TURL: ").append(this.getTurlString());
            sb.append('\n').append("   size: ").append(this.getSize());
            sb.append('\n').append("   AccessLatency: ").append(this.getAccessLatency());
            sb.append('\n').append("   RetentionPolicy: ").append(this.getRetentionPolicy());
            sb.append('\n').append("   spaceReservation: ").append(this.getSpaceReservationId());
            sb.append('\n').append("   isReservedByUs: ").append(this.isWeReservedSpace());
            sb.append('\n').append("   isSpaceMarkedAsBeingUsed: ").append(this.isSpaceMarkedAsBeingUsed());
            sb.append('\n').append("   status code:").append(this.getStatusCode());
            sb.append('\n').append("   error message:").append(this.getErrorMessage());
            sb.append('\n').append("   History of State Transitions: \n");
            sb.append(this.getHistory());
        }
    }

    public void done() {
    }

    public void error() {
    }

    @Override
    public void run() throws NonFatalJobFailure, FatalJobFailure {
        this.addDebugHistoryEvent("run method is executed");
        try {
            if (this.getFileId() == null && this.getParentFileId() == null) {
                this.addDebugHistoryEvent("selecting transfer protocol");
                PutRequest request = PutFileRequest.getJob(this.requestId, PutRequest.class);
                String[] supportedProts = this.getStorage().supportedPutProtocols();
                boolean found_supp_prot = false;
                String[] requestProtocols = request.getProtocols();
                block4: for (String supportedProtocol : supportedProts) {
                    for (String requestProtocol : requestProtocols) {
                        if (!supportedProtocol.equals(requestProtocol)) continue;
                        found_supp_prot = true;
                        break block4;
                    }
                }
                if (!found_supp_prot) {
                    throw new FatalJobFailure("transfer protocols not supported");
                }
                PutCallbacks callbacks = new PutCallbacks(this.getId());
                this.setState(State.ASYNCWAIT, "calling Storage.prepareToPut()");
                this.getStorage().prepareToPut(this.getUser(), this.getSurl(), callbacks, ((PutRequest)this.getRequest()).isOverwrite());
                return;
            }
            long defaultSpaceReservationId = 0L;
            if (this.getParentFmd().spaceTokens != null && this.getParentFmd().spaceTokens.length > 0) {
                defaultSpaceReservationId = this.getParentFmd().spaceTokens[0];
            }
            if (this.getSpaceReservationId() == null && defaultSpaceReservationId != 0L && this.getRetentionPolicy() == null && this.getAccessLatency() == null) {
                StringBuffer sb = new StringBuffer();
                sb.append(defaultSpaceReservationId);
                this.spaceReservationId = sb.toString();
            }
            if (this.getConfiguration().isReserve_space_implicitely() && this.getSpaceReservationId() == null) {
                this.setState(State.ASYNCWAIT, "reserving space");
                long remaining_lifetime = this.lifetime - (System.currentTimeMillis() - this.creationTime);
                PutReserveSpaceCallbacks callbacks = new PutReserveSpaceCallbacks(this.getId());
                if (this.getRetentionPolicy() == null && this.getParentFmd() != null && this.getParentFmd().retentionPolicyInfo != null) {
                    this.setRetentionPolicy(this.getParentFmd().retentionPolicyInfo.getRetentionPolicy());
                }
                if (this.getAccessLatency() == null && this.getParentFmd() != null && this.getParentFmd().retentionPolicyInfo != null) {
                    this.setAccessLatency(this.getParentFmd().retentionPolicyInfo.getAccessLatency());
                }
                logger.debug("reserving space, size=" + (this.getSize() == 0L ? 1L : this.getSize()));
                this.getStorage().srmReserveSpace(this.getUser(), this.getSize() == 0L ? 1L : this.getSize(), remaining_lifetime, this.getRetentionPolicy() == null ? null : this.getRetentionPolicy().getValue(), this.getAccessLatency() == null ? null : this.getAccessLatency().getValue(), null, callbacks);
                return;
            }
            if (this.getSpaceReservationId() != null && !this.isSpaceMarkedAsBeingUsed()) {
                this.setState(State.ASYNCWAIT, "marking space as being used");
                long remaining_lifetime = this.lifetime - (System.currentTimeMillis() - this.creationTime);
                PutUseSpaceCallbacks callbacks = new PutUseSpaceCallbacks(this.getId());
                this.getStorage().srmMarkSpaceAsBeingUsed(this.getUser(), this.getSpaceReservationId(), this.getSurl(), this.getSize() == 0L ? 1L : this.getSize(), remaining_lifetime, ((PutRequest)this.getRequest()).isOverwrite(), callbacks);
                return;
            }
            logger.debug("run() returns, scheduler should bring file request into the ready state eventually");
            return;
        }
        catch (Exception e) {
            logger.error("can not prepare to put : ", (Throwable)e);
            String error = "can not prepare to put : " + e;
            try {
                this.setState(State.FAILED, error);
            }
            catch (IllegalStateTransition ist) {
                logger.warn("Illegal State Transition : " + ist.getMessage());
            }
            return;
        }
    }

    @Override
    protected void stateChanged(State oldState) {
        SRMUser user;
        State state = this.getState();
        logger.debug("State changed from " + (Object)((Object)oldState) + " to " + (Object)((Object)this.getState()));
        if (state == State.READY) {
            try {
                this.getRequest().resetRetryDeltaTime();
            }
            catch (SRMInvalidRequestException ire) {
                logger.error(ire.toString());
            }
        }
        try {
            user = this.getUser();
        }
        catch (SRMInvalidRequestException ire) {
            logger.error(ire.toString());
            return;
        }
        if (State.isFinalState(state)) {
            Object callbacks;
            logger.debug("space reservation is " + this.getSpaceReservationId());
            if (this.getSpaceReservationId() != null && this.isSpaceMarkedAsBeingUsed()) {
                callbacks = new PutCancelUseOfSpaceCallbacks(this.getId());
                this.getStorage().srmUnmarkSpaceAsBeingUsed(user, this.getSpaceReservationId(), this.getSurl(), (SrmCancelUseOfSpaceCallbacks)callbacks);
            }
            if (this.getSpaceReservationId() != null && this.isWeReservedSpace()) {
                logger.debug("storage.releaseSpace(" + this.getSpaceReservationId() + "\"");
                callbacks = new PutReleaseSpaceCallbacks(this.getId());
                this.getStorage().srmReleaseSpace(user, this.getSpaceReservationId(), null, (SrmReleaseSpaceCallbacks)callbacks);
            }
        }
        super.stateChanged(oldState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String getParentFileId() {
        this.rlock();
        try {
            String string = this.parentFileId;
            return string;
        }
        finally {
            this.runlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String getSpaceReservationId() {
        this.rlock();
        try {
            String string = this.spaceReservationId;
            return string;
        }
        finally {
            this.runlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setSpaceReservationId(String spaceReservationId) {
        this.wlock();
        try {
            this.spaceReservationId = spaceReservationId;
        }
        finally {
            this.wunlock();
        }
    }

    @Override
    public TReturnStatus getReturnStatus() {
        TReturnStatus returnStatus = new TReturnStatus();
        State state = this.getState();
        returnStatus.setExplanation(state.toString());
        if (this.getStatusCode() != null) {
            returnStatus.setStatusCode(this.getStatusCode());
        } else if (state == State.DONE) {
            returnStatus.setStatusCode(TStatusCode.SRM_SUCCESS);
        } else if (state == State.READY) {
            returnStatus.setStatusCode(TStatusCode.SRM_SPACE_AVAILABLE);
        } else if (state == State.TRANSFERRING) {
            returnStatus.setStatusCode(TStatusCode.SRM_REQUEST_INPROGRESS);
        } else if (state == State.FAILED) {
            returnStatus.setStatusCode(TStatusCode.SRM_FAILURE);
            returnStatus.setExplanation("FAILED: " + this.getErrorMessage());
        } else if (state == State.CANCELED) {
            returnStatus.setStatusCode(TStatusCode.SRM_ABORTED);
        } else if (state == State.TQUEUED) {
            returnStatus.setStatusCode(TStatusCode.SRM_REQUEST_QUEUED);
        } else if (state == State.RUNNING || state == State.RQUEUED || state == State.ASYNCWAIT) {
            returnStatus.setStatusCode(TStatusCode.SRM_REQUEST_INPROGRESS);
        } else {
            returnStatus.setStatusCode(TStatusCode.SRM_REQUEST_QUEUED);
        }
        return returnStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setFileId(String fileId) {
        this.wlock();
        try {
            this.fileId = fileId;
        }
        finally {
            this.wunlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setParentFileId(String parentFileId) {
        this.wlock();
        try {
            this.parentFileId = parentFileId;
        }
        finally {
            this.wunlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setSurl(URI surl) {
        this.wlock();
        try {
            this.surl = surl;
        }
        finally {
            this.wunlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final URI getTurl() {
        this.rlock();
        try {
            URI uRI = this.turl;
            return uRI;
        }
        finally {
            this.runlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setTurl(URI turl) {
        this.wlock();
        try {
            this.turl = turl;
        }
        finally {
            this.wunlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final FileMetaData getFmd() {
        this.rlock();
        try {
            FileMetaData fileMetaData = this.fmd;
            return fileMetaData;
        }
        finally {
            this.runlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void setFmd(FileMetaData fmd) {
        this.wlock();
        try {
            this.fmd = fmd;
        }
        finally {
            this.wunlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final FileMetaData getParentFmd() {
        this.rlock();
        try {
            FileMetaData fileMetaData = this.parentFmd;
            return fileMetaData;
        }
        finally {
            this.runlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void setParentFmd(FileMetaData parentFmd) {
        this.wlock();
        try {
            this.parentFmd = parentFmd;
        }
        finally {
            this.wunlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isWeReservedSpace() {
        this.rlock();
        try {
            boolean bl = this.weReservedSpace;
            return bl;
        }
        finally {
            this.runlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setWeReservedSpace(boolean weReservedSpace) {
        this.wlock();
        try {
            this.weReservedSpace = weReservedSpace;
        }
        finally {
            this.wunlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isSpaceMarkedAsBeingUsed() {
        this.rlock();
        try {
            boolean bl = this.spaceMarkedAsBeingUsed;
            return bl;
        }
        finally {
            this.runlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setSpaceMarkedAsBeingUsed(boolean spaceMarkedAsBeingUsed) {
        this.wlock();
        try {
            this.spaceMarkedAsBeingUsed = spaceMarkedAsBeingUsed;
        }
        finally {
            this.wunlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final TAccessLatency getAccessLatency() {
        this.rlock();
        try {
            TAccessLatency tAccessLatency = this.accessLatency;
            return tAccessLatency;
        }
        finally {
            this.runlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setAccessLatency(TAccessLatency accessLatency) {
        this.wlock();
        try {
            this.accessLatency = accessLatency;
        }
        finally {
            this.wunlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final TRetentionPolicy getRetentionPolicy() {
        this.rlock();
        try {
            TRetentionPolicy tRetentionPolicy = this.retentionPolicy;
            return tRetentionPolicy;
        }
        finally {
            this.runlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setRetentionPolicy(TRetentionPolicy retentionPolicy) {
        this.wlock();
        try {
            this.retentionPolicy = retentionPolicy;
        }
        finally {
            this.wunlock();
        }
    }

    @Override
    public long extendLifetime(long newLifetime) throws SRMException {
        long remainingLifetime = this.getRemainingLifetime();
        if (remainingLifetime >= newLifetime) {
            return remainingLifetime;
        }
        long requestLifetime = this.getRequest().extendLifetimeMillis(newLifetime);
        if (requestLifetime < newLifetime) {
            newLifetime = requestLifetime;
        }
        if (remainingLifetime >= newLifetime) {
            return remainingLifetime;
        }
        String spaceToken = this.getSpaceReservationId();
        if (!this.getConfiguration().isReserve_space_implicitely() || spaceToken == null || !this.isWeReservedSpace()) {
            return this.extendLifetimeMillis(newLifetime);
        }
        if (remainingLifetime >= (newLifetime = this.extendLifetimeMillis(newLifetime))) {
            return remainingLifetime;
        }
        SRMUser user = this.getUser();
        return this.getStorage().srmExtendReservationLifetime(user, spaceToken, newLifetime);
    }

    private static class TheReleaseSpaceCallbacks
    implements ReleaseSpaceCallbacks {
        Long fileRequestJobId;

        public TheReleaseSpaceCallbacks(Long fileRequestJobId) {
            this.fileRequestJobId = fileRequestJobId;
        }

        public PutFileRequest getPutFileRequest() throws SQLException, SRMInvalidRequestException {
            return Job.getJob(this.fileRequestJobId, PutFileRequest.class);
        }

        @Override
        public void Error(String error) {
            try {
                PutFileRequest fr = this.getPutFileRequest();
                fr.setSpaceReservationId(null);
                logger.error("TheReleaseSpaceCallbacks error: " + error);
            }
            catch (Exception e) {
                logger.error(e.toString());
            }
        }

        @Override
        public void Exception(Exception e) {
            try {
                PutFileRequest fr = this.getPutFileRequest();
                fr.setSpaceReservationId(null);
                logger.error("TheReleaseSpaceCallbacks exception", (Throwable)e);
            }
            catch (Exception e1) {
                logger.error(e1.toString());
            }
        }

        @Override
        public void Timeout() {
            try {
                PutFileRequest fr = this.getPutFileRequest();
                fr.setSpaceReservationId(null);
                logger.error("TheReleaseSpaceCallbacks Timeout");
            }
            catch (Exception e) {
                logger.error(e.toString());
            }
        }

        @Override
        public void SpaceReleased() {
            try {
                PutFileRequest fr = this.getPutFileRequest();
                logger.debug("TheReleaseSpaceCallbacks: SpaceReleased");
                fr.setSpaceReservationId(null);
            }
            catch (Exception e) {
                logger.error(e.toString());
            }
        }

        @Override
        public void ReleaseSpaceFailed(String reason) {
            try {
                PutFileRequest fr = this.getPutFileRequest();
                fr.setSpaceReservationId(null);
                logger.error("TheReleaseSpaceCallbacks error: " + reason + " ignoring, could have been all used up");
            }
            catch (Exception e) {
                logger.error(e.toString());
            }
        }
    }

    public static class PutCancelUseOfSpaceCallbacks
    implements SrmCancelUseOfSpaceCallbacks {
        Long fileRequestJobId;

        public PutFileRequest getPutFileRequest() throws SQLException, SRMInvalidRequestException {
            return Job.getJob(this.fileRequestJobId, PutFileRequest.class);
        }

        public PutCancelUseOfSpaceCallbacks(Long fileRequestJobId) {
            this.fileRequestJobId = fileRequestJobId;
        }

        @Override
        public void CancelUseOfSpaceFailed(Exception e) {
            try {
                PutFileRequest fr = this.getPutFileRequest();
                String error = e.toString();
                logger.error("PutCancelUseOfSpaceCallbacks exception", (Throwable)e);
            }
            catch (Exception e1) {
                logger.error(e1.toString());
            }
        }

        @Override
        public void CancelUseOfSpaceFailed(String reason) {
            try {
                PutFileRequest fr = this.getPutFileRequest();
                logger.error("PutCancelUseOfSpaceCallbacks error: " + reason);
            }
            catch (Exception e) {
                logger.error(e.toString());
            }
        }

        @Override
        public void UseOfSpaceSpaceCanceled() {
            try {
                PutFileRequest fr = this.getPutFileRequest();
                logger.debug("Umarked Space as Being Used");
            }
            catch (Exception e) {
                logger.error(e.toString());
            }
        }
    }

    public static class PutUseSpaceCallbacks
    implements SrmUseSpaceCallbacks {
        Long fileRequestJobId;

        public PutFileRequest getPutFileRequest() throws SQLException, SRMInvalidRequestException {
            return Job.getJob(this.fileRequestJobId, PutFileRequest.class);
        }

        public PutUseSpaceCallbacks(Long fileRequestJobId) {
            this.fileRequestJobId = fileRequestJobId;
        }

        @Override
        public void SrmUseSpaceFailed(Exception e) {
            try {
                PutFileRequest fr = this.getPutFileRequest();
                String error = e.toString();
                try {
                    fr.setState(State.FAILED, error);
                }
                catch (IllegalStateTransition ist) {
                    logger.warn("Illegal State Transition : " + ist.getMessage());
                }
                logger.error("PutUseSpaceCallbacks exception", (Throwable)e);
            }
            catch (Exception e1) {
                logger.error(e1.toString());
            }
        }

        @Override
        public void SrmUseSpaceFailed(String reason) {
            try {
                PutFileRequest fr = this.getPutFileRequest();
                try {
                    fr.setState(State.FAILED, reason);
                }
                catch (IllegalStateTransition ist) {
                    logger.warn("Illegal State Transition : " + ist.getMessage());
                }
                logger.error("PutUseSpaceCallbacks error: " + reason);
            }
            catch (Exception e) {
                logger.error(e.toString());
            }
        }

        @Override
        public void SrmNoFreeSpace(String reason) {
            try {
                PutFileRequest fr = this.getPutFileRequest();
                try {
                    fr.setStateAndStatusCode(State.FAILED, reason, TStatusCode.SRM_NO_FREE_SPACE);
                }
                catch (IllegalStateTransition ist) {
                    logger.warn("Illegal State Transition : " + ist.getMessage());
                }
                logger.error("PutUseSpaceCallbacks error: " + reason);
            }
            catch (Exception e) {
                logger.error(e.toString());
            }
        }

        @Override
        public void SrmReleased(String reason) {
            try {
                PutFileRequest fr = this.getPutFileRequest();
                try {
                    fr.setStateAndStatusCode(State.FAILED, reason, TStatusCode.SRM_NO_FREE_SPACE);
                }
                catch (IllegalStateTransition ist) {
                    logger.warn("Illegal State Transition : " + ist.getMessage());
                }
                logger.error("PutUseSpaceCallbacks error: " + reason);
            }
            catch (Exception e) {
                logger.error(e.toString());
            }
        }

        @Override
        public void SrmExpired(String reason) {
            try {
                PutFileRequest fr = this.getPutFileRequest();
                try {
                    fr.setStateAndStatusCode(State.FAILED, reason, TStatusCode.SRM_SPACE_LIFETIME_EXPIRED);
                }
                catch (IllegalStateTransition ist) {
                    logger.warn("Illegal State Transition : " + ist.getMessage());
                }
                logger.error("PutUseSpaceCallbacks error: " + reason);
            }
            catch (Exception e) {
                logger.error(e.toString());
            }
        }

        @Override
        public void SrmNotAuthorized(String reason) {
            try {
                PutFileRequest fr = this.getPutFileRequest();
                try {
                    fr.setStateAndStatusCode(State.FAILED, reason, TStatusCode.SRM_AUTHORIZATION_FAILURE);
                }
                catch (IllegalStateTransition ist) {
                    logger.warn("Illegal State Transition : " + ist.getMessage());
                }
                logger.error("PutUseSpaceCallbacks error: " + reason);
            }
            catch (Exception e) {
                logger.error(e.toString());
            }
        }

        @Override
        public void SpaceUsed() {
            try {
                PutFileRequest fr = this.getPutFileRequest();
                logger.debug("Space Marked as Being Used");
                State state = fr.getState();
                if (state == State.ASYNCWAIT) {
                    logger.debug("PutUseSpaceCallbacks Space Marked as Being Used for file " + fr.getSurlString());
                    fr.setSpaceMarkedAsBeingUsed(true);
                    Scheduler scheduler = Scheduler.getScheduler(fr.getSchedulerId());
                    try {
                        scheduler.schedule(fr);
                    }
                    catch (Exception ie) {
                        logger.error(ie.toString());
                    }
                }
            }
            catch (Exception e) {
                logger.error(e.toString());
            }
        }
    }

    public static class PutReleaseSpaceCallbacks
    implements SrmReleaseSpaceCallbacks {
        Long fileRequestJobId;

        public PutFileRequest getPutFileRequest() throws SQLException, SRMInvalidRequestException {
            return Job.getJob(this.fileRequestJobId, PutFileRequest.class);
        }

        public PutReleaseSpaceCallbacks(Long fileRequestJobId) {
            this.fileRequestJobId = fileRequestJobId;
        }

        @Override
        public void ReleaseSpaceFailed(Exception e) {
            try {
                PutFileRequest fr = this.getPutFileRequest();
                String error = e.toString();
                logger.error("PutReleaseSpaceCallbacks exception", (Throwable)e);
            }
            catch (Exception e1) {
                logger.error(e1.toString());
            }
        }

        @Override
        public void ReleaseSpaceFailed(String reason) {
            try {
                PutFileRequest fr = this.getPutFileRequest();
                logger.error("PutReleaseSpaceCallbacks error: " + reason);
            }
            catch (Exception e) {
                logger.error(e.toString());
            }
        }

        @Override
        public void SpaceReleased(String spaceReservationToken, long reservedSpaceSize) {
            try {
                PutFileRequest fr = this.getPutFileRequest();
                logger.debug("Space Released: spaceReservationToken:" + spaceReservationToken + " remaining space=" + reservedSpaceSize);
            }
            catch (Exception e) {
                logger.error(e.toString());
            }
        }
    }

    public static class PutReserveSpaceCallbacks
    implements SrmReserveSpaceCallbacks {
        Long fileRequestJobId;

        public PutFileRequest getPutFileRequest() throws SQLException, SRMInvalidRequestException {
            return Job.getJob(this.fileRequestJobId, PutFileRequest.class);
        }

        public PutReserveSpaceCallbacks(Long fileRequestJobId) {
            this.fileRequestJobId = fileRequestJobId;
        }

        @Override
        public void ReserveSpaceFailed(Exception e) {
            try {
                PutFileRequest fr = this.getPutFileRequest();
                String error = e.toString();
                try {
                    fr.setState(State.FAILED, error);
                }
                catch (IllegalStateTransition ist) {
                    logger.warn("Illegal State Transition : " + ist.getMessage());
                }
                logger.error("PutReserveSpaceCallbacks exception", (Throwable)e);
            }
            catch (Exception e1) {
                logger.error(e1.toString());
            }
        }

        @Override
        public void ReserveSpaceFailed(String reason) {
            try {
                PutFileRequest fr = this.getPutFileRequest();
                try {
                    fr.setState(State.FAILED, reason);
                }
                catch (IllegalStateTransition ist) {
                    logger.warn("Illegal State Transition : " + ist.getMessage());
                }
                logger.error("PutReserveSpaceCallbacks error: " + reason);
            }
            catch (Exception e) {
                logger.error(e.toString());
            }
        }

        @Override
        public void NoFreeSpace(String reason) {
            try {
                PutFileRequest fr = this.getPutFileRequest();
                try {
                    fr.setStateAndStatusCode(State.FAILED, reason, TStatusCode.SRM_NO_FREE_SPACE);
                }
                catch (IllegalStateTransition ist) {
                    logger.warn("Illegal State Transition : " + ist.getMessage());
                }
                logger.error("PutReserveSpaceCallbacks error: " + reason);
            }
            catch (Exception e) {
                logger.error(e.toString());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void SpaceReserved(String spaceReservationToken, long reservedSpaceSize) {
            try {
                State state;
                PutFileRequest fr = this.getPutFileRequest();
                logger.debug("Space Reserved: spaceReservationToken:" + spaceReservationToken);
                PutFileRequest putFileRequest = fr;
                synchronized (putFileRequest) {
                    state = fr.getState();
                }
                if (state == State.ASYNCWAIT) {
                    logger.debug("PutReserveSpaceCallbacks Space Reserved for file " + fr.getSurlString());
                    fr.setWeReservedSpace(true);
                    fr.setSpaceReservationId(spaceReservationToken);
                    Scheduler scheduler = Scheduler.getScheduler(fr.getSchedulerId());
                    try {
                        scheduler.schedule(fr);
                    }
                    catch (Exception ie) {
                        logger.error(ie.toString());
                    }
                }
            }
            catch (Exception e) {
                logger.error(e.toString());
            }
        }
    }

    private static class PutCallbacks
    implements PrepareToPutCallbacks {
        Long fileRequestJobId;

        public PutCallbacks(Long fileRequestJobId) {
            this.fileRequestJobId = fileRequestJobId;
        }

        public PutFileRequest getPutFileRequest() throws SRMInvalidRequestException {
            return Job.getJob(this.fileRequestJobId, PutFileRequest.class);
        }

        @Override
        public void DuplicationError(String reason) {
            try {
                PutFileRequest fr = this.getPutFileRequest();
                try {
                    fr.setStateAndStatusCode(State.FAILED, reason, TStatusCode.SRM_DUPLICATION_ERROR);
                }
                catch (IllegalStateTransition ist) {
                    logger.warn("Illegal State Transition : " + ist.getMessage());
                }
                logger.error("PutCallbacks error: " + reason);
            }
            catch (Exception e) {
                logger.error(e.toString());
            }
        }

        @Override
        public void Error(String error) {
            try {
                PutFileRequest fr = this.getPutFileRequest();
                try {
                    fr.setState(State.FAILED, error);
                }
                catch (IllegalStateTransition ist) {
                    logger.warn("Illegal State Transition : " + ist.getMessage());
                }
                logger.error("PutCallbacks error: " + error);
            }
            catch (Exception e) {
                logger.error(e.toString());
            }
        }

        @Override
        public void Exception(Exception e) {
            try {
                PutFileRequest fr = this.getPutFileRequest();
                String error = e.toString();
                try {
                    fr.setState(State.FAILED, error);
                }
                catch (IllegalStateTransition ist) {
                    logger.error("can not fail state:" + ist);
                }
                logger.error("PutCallbacks exception", (Throwable)e);
            }
            catch (Exception e1) {
                logger.error(e1.toString());
            }
        }

        @Override
        public void GetStorageInfoFailed(String reason) {
            try {
                PutFileRequest fr = this.getPutFileRequest();
                try {
                    fr.setState(State.FAILED, reason);
                }
                catch (IllegalStateTransition ist) {
                    logger.warn("Illegal State Transition : " + ist.getMessage());
                }
                logger.error("PutCallbacks error: " + reason);
            }
            catch (Exception e) {
                logger.error(e.toString());
            }
        }

        @Override
        public void StorageInfoArrived(String fileId, FileMetaData fmd, String parentFileId, FileMetaData parentFmd) {
            try {
                PutFileRequest fr = this.getPutFileRequest();
                logger.debug("StorageInfoArrived: FileId:" + fileId);
                State state = fr.getState();
                if (state == State.ASYNCWAIT) {
                    logger.debug("PutCallbacks StorageInfoArrived for file " + fr.getSurlString());
                    fr.setFileId(fileId);
                    fr.setFmd(fmd);
                    fr.setParentFileId(parentFileId);
                    fr.setParentFmd(parentFmd);
                    Scheduler scheduler = Scheduler.getScheduler(fr.getSchedulerId());
                    try {
                        scheduler.schedule(fr);
                    }
                    catch (Exception ie) {
                        logger.error(ie.toString());
                    }
                }
            }
            catch (Exception e) {
                logger.error(e.toString());
            }
        }

        @Override
        public void Timeout() {
            try {
                PutFileRequest fr = this.getPutFileRequest();
                try {
                    fr.setState(State.FAILED, "PutCallbacks Timeout");
                }
                catch (IllegalStateTransition ist) {
                    logger.warn("Illegal State Transition : " + ist.getMessage());
                }
                logger.error("PutCallbacks Timeout");
            }
            catch (Exception e) {
                logger.error(e.toString());
            }
        }

        @Override
        public void InvalidPathError(String reason) {
            try {
                PutFileRequest fr = this.getPutFileRequest();
                try {
                    fr.setStateAndStatusCode(State.FAILED, reason, TStatusCode.SRM_INVALID_PATH);
                }
                catch (IllegalStateTransition ist) {
                    logger.warn("Illegal State Transition : " + ist.getMessage());
                }
                logger.error("PutCallbacks error: " + reason);
            }
            catch (Exception e) {
                logger.error(e.toString());
            }
        }

        @Override
        public void AuthorizationError(String reason) {
            try {
                PutFileRequest fr = this.getPutFileRequest();
                try {
                    fr.setStateAndStatusCode(State.FAILED, reason, TStatusCode.SRM_AUTHORIZATION_FAILURE);
                }
                catch (IllegalStateTransition ist) {
                    logger.warn("Illegal State Transition : " + ist.getMessage());
                }
                logger.error("PutCallbacks error: " + reason);
            }
            catch (Exception e) {
                logger.error(e.toString());
            }
        }
    }
}

