/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.srm.request;

import com.google.common.collect.ImmutableMap;
import org.dcache.srm.v2_2.TOverwriteMode;

public enum OverwriteMode {
    NEVER(TOverwriteMode.NEVER),
    ALWAYS(TOverwriteMode.ALWAYS),
    WHEN_FILES_ARE_DIFFERENT(TOverwriteMode.WHEN_FILES_ARE_DIFFERENT);

    private final TOverwriteMode _mode;
    private static final ImmutableMap<TOverwriteMode, OverwriteMode> MAP;
    private static final String ERROR_MESSAGE;

    private OverwriteMode(TOverwriteMode mode) {
        this._mode = mode;
    }

    public TOverwriteMode toTOverwriteMode() {
        return this._mode;
    }

    public static OverwriteMode fromTOverwriteMode(TOverwriteMode mode) {
        if (mode == null) {
            return null;
        }
        return (OverwriteMode)((Object)MAP.get((Object)mode));
    }

    public static OverwriteMode fromString(String txt) throws IllegalArgumentException {
        try {
            TOverwriteMode mode = TOverwriteMode.fromString(txt);
            return OverwriteMode.fromTOverwriteMode(mode);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format(ERROR_MESSAGE, txt));
        }
    }

    static {
        StringBuilder sb = new StringBuilder();
        sb.append("Unknown OverwriteMode: \"%s\".");
        sb.append(" Supported values :");
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (OverwriteMode value : OverwriteMode.values()) {
            builder.put((Object)value._mode, (Object)value);
            sb.append(" \"").append(value._mode).append("\"");
        }
        MAP = builder.build();
        ERROR_MESSAGE = sb.toString();
    }
}

