/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.srm.request;

import diskCacheV111.srm.RequestFileStatus;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Comparator;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import java.util.List;
import org.apache.axis.types.UnsignedLong;
import org.dcache.srm.FileMetaData;
import org.dcache.srm.SRMAuthorizationException;
import org.dcache.srm.SRMException;
import org.dcache.srm.SRMInternalErrorException;
import org.dcache.srm.SRMInvalidPathException;
import org.dcache.srm.SRMInvalidRequestException;
import org.dcache.srm.SRMTooManyResultsException;
import org.dcache.srm.SRMUser;
import org.dcache.srm.request.FileRequest;
import org.dcache.srm.request.LsRequest;
import org.dcache.srm.scheduler.FatalJobFailure;
import org.dcache.srm.scheduler.IllegalStateTransition;
import org.dcache.srm.scheduler.Job;
import org.dcache.srm.scheduler.NonFatalJobFailure;
import org.dcache.srm.scheduler.State;
import org.dcache.srm.util.Permissions;
import org.dcache.srm.v2_2.ArrayOfString;
import org.dcache.srm.v2_2.ArrayOfTMetaDataPathDetail;
import org.dcache.srm.v2_2.TAccessLatency;
import org.dcache.srm.v2_2.TFileStorageType;
import org.dcache.srm.v2_2.TFileType;
import org.dcache.srm.v2_2.TGroupPermission;
import org.dcache.srm.v2_2.TMetaDataPathDetail;
import org.dcache.srm.v2_2.TPermissionMode;
import org.dcache.srm.v2_2.TRetentionPolicy;
import org.dcache.srm.v2_2.TRetentionPolicyInfo;
import org.dcache.srm.v2_2.TReturnStatus;
import org.dcache.srm.v2_2.TStatusCode;
import org.dcache.srm.v2_2.TUserPermission;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LsFileRequest
extends FileRequest {
    private static final Logger logger = LoggerFactory.getLogger(LsFileRequest.class);
    private static final String SFN_STRING = "SFN=";
    private URI surl;
    private TMetaDataPathDetail metaDataPathDetail;
    private static final Comparator<FileMetaData> DIRECTORY_LAST_ORDER = new Comparator<FileMetaData>(){

        @Override
        public int compare(FileMetaData f1, FileMetaData f2) {
            if (f1.isDirectory && f2.isRegular) {
                return 1;
            }
            if (f1.isRegular && f2.isDirectory) {
                return -1;
            }
            return 0;
        }
    };

    public LsFileRequest(Long requestId, Long requestCredentalId, org.apache.axis.types.URI url, long lifetime, int maxNumberOfRetries) throws Exception {
        super(requestId, requestCredentalId, lifetime, maxNumberOfRetries);
        this.surl = URI.create(url.toString());
        this.updateMemoryCache();
    }

    public LsFileRequest(Long id, Long nextJobId, long creationTime, long lifetime, int stateId, String errorMessage, String scheduelerId, long schedulerTimeStamp, int numberOfRetries, int maxNumberOfRetries, long lastStateTransitionTime, Job.JobHistory[] jobHistoryArray, Long requestId, Long requestCredentalId, String statusCodeString, String SURL2) throws SQLException {
        super(id, nextJobId, creationTime, lifetime, stateId, errorMessage, scheduelerId, schedulerTimeStamp, numberOfRetries, maxNumberOfRetries, lastStateTransitionTime, jobHistoryArray, requestId, requestCredentalId, statusCodeString);
        this.surl = URI.create(SURL2);
    }

    public String getPath(URI uri) {
        int i;
        String path = uri.getPath();
        String query = uri.getQuery();
        if (query != null && (i = query.indexOf(SFN_STRING)) != -1) {
            path = query.substring(i + SFN_STRING.length()).replaceAll("//*", "/");
        }
        return path;
    }

    public URI getSurl() {
        return this.surl;
    }

    public String getSurlString() {
        return this.surl.toString();
    }

    @Override
    public RequestFileStatus getRequestFileStatus() {
        RequestFileStatus rfs = new RequestFileStatus();
        State state = this.getState();
        rfs.state = state == State.DONE ? "Done" : (state == State.READY ? "Ready" : (state == State.TRANSFERRING ? "Running" : (state == State.FAILED || state == State.CANCELED ? "Failed" : "Pending")));
        return rfs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void run() throws NonFatalJobFailure, FatalJobFailure {
        try {
            LsRequest parent = (LsRequest)this.getRequest();
            long t0 = 0L;
            if (logger.isDebugEnabled()) {
                t0 = System.currentTimeMillis();
            }
            this.metaDataPathDetail = this.getMetaDataPathDetail(this.surl, 0, parent.getOffset(), parent.getCount(), parent.getNumOfLevels(), parent.getLongFormat());
            if (logger.isDebugEnabled()) {
                logger.debug("LsFileRequest.run(), TOOK " + (System.currentTimeMillis() - t0));
            }
            try {
                this.getRequest().resetRetryDeltaTime();
            }
            catch (SRMInvalidRequestException ire) {
                logger.error(ire.toString());
            }
            this.setState(State.DONE, State.DONE.toString());
        }
        catch (Exception e) {
            this.wlock();
            try {
                TReturnStatus status;
                String msg = e.getMessage();
                if (e instanceof SRMInternalErrorException) {
                    status = new TReturnStatus(TStatusCode.SRM_FAILURE, msg);
                    this.setStatusCode(TStatusCode.SRM_FAILURE);
                } else if (e instanceof SRMTooManyResultsException) {
                    status = new TReturnStatus(TStatusCode.SRM_TOO_MANY_RESULTS, msg);
                    this.setStatusCode(TStatusCode.SRM_TOO_MANY_RESULTS);
                } else if (e instanceof SRMAuthorizationException) {
                    status = new TReturnStatus(TStatusCode.SRM_AUTHORIZATION_FAILURE, msg);
                    this.setStatusCode(TStatusCode.SRM_AUTHORIZATION_FAILURE);
                } else if (e instanceof SRMInvalidPathException) {
                    status = new TReturnStatus(TStatusCode.SRM_INVALID_PATH, msg);
                    this.setStatusCode(TStatusCode.SRM_INVALID_PATH);
                } else {
                    if (e instanceof RuntimeException) {
                        logger.error(e.toString(), (Throwable)e);
                    }
                    status = new TReturnStatus(TStatusCode.SRM_FAILURE, msg);
                    this.setStatusCode(TStatusCode.SRM_FAILURE);
                }
                this.metaDataPathDetail = new TMetaDataPathDetail();
                this.metaDataPathDetail.setPath(this.getPath(this.surl));
                this.metaDataPathDetail.setStatus(status);
                this.setState(State.FAILED, e.toString());
            }
            catch (IllegalStateTransition ist) {
                logger.error("Illegal State Transition : " + ist.getMessage());
            }
            finally {
                this.wunlock();
            }
        }
    }

    @Override
    protected void stateChanged(State oldState) {
        logger.debug("State changed from " + (Object)((Object)oldState) + " to " + (Object)((Object)this.getState()));
        super.stateChanged(oldState);
    }

    @Override
    public TReturnStatus getReturnStatus() {
        TReturnStatus returnStatus = new TReturnStatus();
        State state = this.getState();
        returnStatus.setExplanation(state.toString());
        if (this.getStatusCode() != null) {
            returnStatus.setStatusCode(this.getStatusCode());
        } else if (state == State.DONE) {
            returnStatus.setStatusCode(TStatusCode.SRM_SUCCESS);
        } else if (state == State.READY) {
            returnStatus.setStatusCode(TStatusCode.SRM_SUCCESS);
        } else if (state == State.FAILED) {
            returnStatus.setStatusCode(TStatusCode.SRM_FAILURE);
            returnStatus.setExplanation("FAILED: " + this.getErrorMessage());
        } else if (state == State.CANCELED) {
            returnStatus.setStatusCode(TStatusCode.SRM_ABORTED);
        } else if (state == State.TQUEUED) {
            returnStatus.setStatusCode(TStatusCode.SRM_REQUEST_QUEUED);
        } else if (state == State.RUNNING || state == State.RQUEUED || state == State.ASYNCWAIT) {
            returnStatus.setStatusCode(TStatusCode.SRM_REQUEST_INPROGRESS);
        } else {
            returnStatus.setStatusCode(TStatusCode.SRM_REQUEST_QUEUED);
        }
        return returnStatus;
    }

    @Override
    public long extendLifetime(long newLifetime) throws SRMException {
        long remainingLifetime = this.getRemainingLifetime();
        if (remainingLifetime >= newLifetime) {
            return remainingLifetime;
        }
        long requestLifetime = this.getRequest().extendLifetimeMillis(newLifetime);
        return requestLifetime;
    }

    public TMetaDataPathDetail getMetaDataPathDetail() {
        return this.metaDataPathDetail;
    }

    public final TMetaDataPathDetail getMetaDataPathDetail(URI surl, int depth, long offset, long count, int recursionDepth, boolean longFormat) throws SRMException, URISyntaxException {
        FileMetaData fmd = this.getStorage().getFileMetaData(this.getUser(), surl, false);
        TMetaDataPathDetail aMetaDataPathDetail = this.convertFileMetaDataToTMetaDataPathDetail(surl, fmd, depth, longFormat);
        if (!((LsRequest)this.getRequest()).increaseResultsNumAndContinue()) {
            return aMetaDataPathDetail;
        }
        if (fmd.isDirectory && depth < recursionDepth) {
            if (recursionDepth == 1) {
                this.getMetaDataPathDetail(aMetaDataPathDetail, offset, count, longFormat);
            } else {
                this.getRecursiveMetaDataPathDetail(aMetaDataPathDetail, fmd, depth, offset, count, recursionDepth, longFormat);
            }
        }
        return aMetaDataPathDetail;
    }

    private void getMetaDataPathDetail(TMetaDataPathDetail metaDataPathDetail, long offset, long count, boolean longFormat) throws SRMException, URISyntaxException {
        URI surl = new URI(null, null, metaDataPathDetail.getPath(), null);
        List<FileMetaData> directoryList = this.getStorage().listDirectory(this.getUser(), surl, longFormat, (int)offset, (int)count);
        ((LsRequest)this.getRequest()).setCounter(offset);
        LinkedList<TMetaDataPathDetail> metadataPathDetailList = new LinkedList<TMetaDataPathDetail>();
        for (FileMetaData md : directoryList) {
            block5: {
                URI subpath = new URI(null, null, md.SURL, null);
                TMetaDataPathDetail dirMetaDataPathDetail = this.convertFileMetaDataToTMetaDataPathDetail(subpath, md, 1, longFormat);
                if (!((LsRequest)this.getRequest()).shouldSkipThisRecord()) {
                    metadataPathDetailList.add(dirMetaDataPathDetail);
                    try {
                        if (!((LsRequest)this.getRequest()).increaseResultsNumAndContinue()) {
                        }
                        break block5;
                    }
                    catch (SRMTooManyResultsException e) {
                        metaDataPathDetail.setStatus(new TReturnStatus(TStatusCode.SRM_FAILURE, e.getMessage()));
                    }
                    break;
                }
            }
            ((LsRequest)this.getRequest()).incrementGlobalEntryCounter();
        }
        metaDataPathDetail.setArrayOfSubPaths(new ArrayOfTMetaDataPathDetail(metadataPathDetailList.toArray(new TMetaDataPathDetail[0])));
    }

    private void getRecursiveMetaDataPathDetail(TMetaDataPathDetail metaDataPathDetail, FileMetaData fmd, int depth, long offset, long count, int recursionDepth, boolean longFormat) throws SRMException, URISyntaxException {
        if (!fmd.isDirectory || depth >= recursionDepth) {
            return;
        }
        URI surl = new URI(null, null, metaDataPathDetail.getPath(), null);
        List<FileMetaData> directoryList = offset == 0L ? this.getStorage().listDirectory(this.getUser(), surl, longFormat, 0, (int)count) : this.getStorage().listDirectory(this.getUser(), surl, false, 0, Integer.MAX_VALUE);
        Collections.sort(directoryList, DIRECTORY_LAST_ORDER);
        LinkedList<TMetaDataPathDetail> metadataPathDetailList = new LinkedList<TMetaDataPathDetail>();
        for (FileMetaData md : directoryList) {
            TMetaDataPathDetail dirMetaDataPathDetail;
            block17: {
                URI subpath = new URI(null, null, md.SURL, null);
                if (offset == 0L) {
                    dirMetaDataPathDetail = this.convertFileMetaDataToTMetaDataPathDetail(subpath, md, depth, longFormat);
                } else {
                    FileMetaData fileMetaData = md;
                    if (!((LsRequest)this.getRequest()).shouldSkipThisRecord()) {
                        if (longFormat) {
                            fileMetaData = this.getStorage().getFileMetaData(this.getUser(), subpath, false);
                        }
                        dirMetaDataPathDetail = this.convertFileMetaDataToTMetaDataPathDetail(subpath, fileMetaData, depth, longFormat);
                    } else {
                        dirMetaDataPathDetail = this.convertFileMetaDataToTMetaDataPathDetail(subpath, fileMetaData, depth, false);
                    }
                }
                if (!((LsRequest)this.getRequest()).shouldSkipThisRecord()) {
                    metadataPathDetailList.add(dirMetaDataPathDetail);
                    try {
                        if (!((LsRequest)this.getRequest()).increaseResultsNumAndContinue()) {
                        }
                        break block17;
                    }
                    catch (SRMTooManyResultsException e) {
                        metaDataPathDetail.setStatus(new TReturnStatus(TStatusCode.SRM_FAILURE, e.getMessage()));
                    }
                    break;
                }
            }
            ((LsRequest)this.getRequest()).incrementGlobalEntryCounter();
            if (!md.isDirectory) continue;
            try {
                this.getRecursiveMetaDataPathDetail(dirMetaDataPathDetail, md, depth + 1, offset, count, recursionDepth, longFormat);
            }
            catch (SRMException e) {
                TReturnStatus rs = new TReturnStatus();
                String msg = e.getMessage();
                rs.setExplanation(msg);
                if (e instanceof SRMAuthorizationException) {
                    rs.setStatusCode(TStatusCode.SRM_AUTHORIZATION_FAILURE);
                } else if (e instanceof SRMInvalidPathException) {
                    rs.setStatusCode(TStatusCode.SRM_INVALID_PATH);
                } else {
                    rs.setStatusCode(TStatusCode.SRM_FAILURE);
                }
                dirMetaDataPathDetail.setStatus(rs);
            }
        }
        metaDataPathDetail.setArrayOfSubPaths(new ArrayOfTMetaDataPathDetail(metadataPathDetailList.toArray(new TMetaDataPathDetail[0])));
    }

    public boolean canRead(SRMUser user, FileMetaData fmd) {
        int uid = Integer.parseInt(fmd.owner);
        int gid = Integer.parseInt(fmd.group);
        int permissions = fmd.permMode;
        if (permissions == 0) {
            return false;
        }
        if (Permissions.worldCanRead(permissions)) {
            return true;
        }
        if (uid == -1 || gid == -1) {
            return false;
        }
        if (user == null) {
            return false;
        }
        if (fmd.isGroupMember(user) && Permissions.groupCanRead(permissions)) {
            return true;
        }
        return fmd.isOwner(user) && Permissions.userCanRead(permissions);
    }

    public TPermissionMode maskToTPermissionMode(int permMask) {
        switch (permMask) {
            case 0: {
                return TPermissionMode.NONE;
            }
            case 1: {
                return TPermissionMode.X;
            }
            case 2: {
                return TPermissionMode.W;
            }
            case 3: {
                return TPermissionMode.WX;
            }
            case 4: {
                return TPermissionMode.R;
            }
            case 5: {
                return TPermissionMode.RX;
            }
            case 6: {
                return TPermissionMode.RW;
            }
            case 7: {
                return TPermissionMode.RWX;
            }
        }
        throw new IllegalArgumentException("illegal perm mask: " + permMask);
    }

    @Override
    public void toString(StringBuilder sb, boolean longformat) {
        sb.append(" LsFileRequest ");
        sb.append(" id:").append(this.getId());
        sb.append(" priority:").append(this.getPriority());
        sb.append(" creator priority:");
        try {
            sb.append(this.getUser().getPriority());
        }
        catch (SRMInvalidRequestException ire) {
            sb.append("Unknown");
        }
        State state = this.getState();
        sb.append(" state:").append((Object)state);
        if (longformat) {
            sb.append('\n').append("   SURL: ").append(this.getSurl());
            sb.append('\n').append("   status code:").append(this.getStatusCode());
            sb.append('\n').append("   error message:").append(this.getErrorMessage());
            sb.append('\n').append("   History of State Transitions: \n");
            sb.append(this.getHistory());
        }
    }

    private final TMetaDataPathDetail convertFileMetaDataToTMetaDataPathDetail(URI path, FileMetaData fmd, int depth, boolean verbose) throws SRMException {
        TMetaDataPathDetail metaDataPathDetail = new TMetaDataPathDetail();
        metaDataPathDetail.setPath(this.getPath(path));
        metaDataPathDetail.setLifetimeAssigned(-1);
        metaDataPathDetail.setLifetimeLeft(-1);
        metaDataPathDetail.setSize(new UnsignedLong(fmd.size));
        if (fmd.isDirectory) {
            metaDataPathDetail.setType(TFileType.DIRECTORY);
        } else if (fmd.isLink) {
            metaDataPathDetail.setType(TFileType.LINK);
        } else if (fmd.isRegular) {
            metaDataPathDetail.setType(TFileType.FILE);
        } else {
            logger.debug("file type is Unknown");
        }
        if (verbose) {
            TUserPermission userPermission = new TUserPermission();
            userPermission.setUserID(fmd.owner);
            int userPerm = fmd.permMode >> 6 & 7;
            userPermission.setMode(this.maskToTPermissionMode(userPerm));
            metaDataPathDetail.setOwnerPermission(userPermission);
            TGroupPermission groupPermission = new TGroupPermission();
            groupPermission.setGroupID(fmd.group);
            int groupPerm = fmd.permMode >> 3 & 7;
            groupPermission.setMode(this.maskToTPermissionMode(groupPerm));
            metaDataPathDetail.setGroupPermission(groupPermission);
            metaDataPathDetail.setOtherPermission(this.maskToTPermissionMode(fmd.permMode & 7));
            GregorianCalendar td = new GregorianCalendar();
            td.setTimeInMillis(fmd.creationTime);
            metaDataPathDetail.setCreatedAtTime(td);
            td = new GregorianCalendar();
            td.setTimeInMillis(fmd.lastModificationTime);
            metaDataPathDetail.setLastModificationTime(td);
            if (fmd.checksumType != null && fmd.checksumValue != null) {
                metaDataPathDetail.setCheckSumType(fmd.checksumType);
                metaDataPathDetail.setCheckSumValue(fmd.checksumValue);
            }
            metaDataPathDetail.setFileStorageType(TFileStorageType.PERMANENT);
            if (!fmd.isPermanent) {
                if (fmd.isPinned) {
                    metaDataPathDetail.setFileStorageType(TFileStorageType.DURABLE);
                } else {
                    metaDataPathDetail.setFileStorageType(TFileStorageType.VOLATILE);
                }
            }
            metaDataPathDetail.setFileLocality(fmd.locality);
            if (fmd.retentionPolicyInfo != null) {
                TAccessLatency al = fmd.retentionPolicyInfo.getAccessLatency();
                TRetentionPolicy rp = fmd.retentionPolicyInfo.getRetentionPolicy();
                metaDataPathDetail.setRetentionPolicyInfo(new TRetentionPolicyInfo(rp, al));
            }
            if (fmd.spaceTokens != null && fmd.spaceTokens.length > 0) {
                ArrayOfString arrayOfSpaceTokens = new ArrayOfString(new String[fmd.spaceTokens.length]);
                for (int st = 0; st < fmd.spaceTokens.length; ++st) {
                    StringBuffer spaceToken = new StringBuffer();
                    spaceToken.append(fmd.spaceTokens[st]);
                    arrayOfSpaceTokens.setStringArray(st, spaceToken.toString());
                }
                metaDataPathDetail.setArrayOfSpaceTokens(arrayOfSpaceTokens);
            }
        }
        TReturnStatus returnStatus = new TReturnStatus();
        returnStatus.setStatusCode(TStatusCode.SRM_SUCCESS);
        metaDataPathDetail.setStatus(returnStatus);
        return metaDataPathDetail;
    }
}

