/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.srm.request;

import com.google.common.collect.Lists;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.dcache.srm.SRMException;
import org.dcache.srm.SRMInvalidRequestException;
import org.dcache.srm.SRMProtocol;
import org.dcache.srm.SRMReleasedException;
import org.dcache.srm.SRMUser;
import org.dcache.srm.client.RemoteTurlGetterV1;
import org.dcache.srm.client.RemoteTurlGetterV2;
import org.dcache.srm.client.RemoteTurlPutterV1;
import org.dcache.srm.client.RemoteTurlPutterV2;
import org.dcache.srm.client.RequestFailedEvent;
import org.dcache.srm.client.TURLsArrivedEvent;
import org.dcache.srm.client.TURLsGetFailedEvent;
import org.dcache.srm.client.Transport;
import org.dcache.srm.client.TurlGetterPutter;
import org.dcache.srm.client.TurlGetterPutterV1;
import org.dcache.srm.qos.QOSPlugin;
import org.dcache.srm.qos.QOSPluginFactory;
import org.dcache.srm.qos.QOSTicket;
import org.dcache.srm.request.ContainerRequest;
import org.dcache.srm.request.CopyFileRequest;
import org.dcache.srm.request.FileRequest;
import org.dcache.srm.request.RequestCredential;
import org.dcache.srm.scheduler.FatalJobFailure;
import org.dcache.srm.scheduler.IllegalStateTransition;
import org.dcache.srm.scheduler.Job;
import org.dcache.srm.scheduler.NonFatalJobFailure;
import org.dcache.srm.scheduler.Scheduler;
import org.dcache.srm.scheduler.State;
import org.dcache.srm.util.OneToManyMap;
import org.dcache.srm.util.SrmUrl;
import org.dcache.srm.util.Tools;
import org.dcache.srm.v2_2.ArrayOfTCopyRequestFileStatus;
import org.dcache.srm.v2_2.SrmCopyResponse;
import org.dcache.srm.v2_2.SrmStatusOfCopyRequestResponse;
import org.dcache.srm.v2_2.TAccessLatency;
import org.dcache.srm.v2_2.TCopyRequestFileStatus;
import org.dcache.srm.v2_2.TFileStorageType;
import org.dcache.srm.v2_2.TOverwriteMode;
import org.dcache.srm.v2_2.TRequestType;
import org.dcache.srm.v2_2.TRetentionPolicy;
import org.dcache.srm.v2_2.TSURLReturnStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CopyRequest
extends ContainerRequest
implements PropertyChangeListener {
    private static final Logger logger = LoggerFactory.getLogger(CopyRequest.class);
    private boolean from_url_is_srm;
    private boolean to_url_is_srm;
    private boolean from_url_is_gsiftp;
    private boolean to_url_is_gsiftp;
    private boolean from_url_is_local;
    private boolean to_url_is_local;
    private SrmUrl[] from_urls;
    private SrmUrl[] to_urls;
    private int number_of_file_reqs;
    private String[] protocols;
    private SRMProtocol callerSrmProtocol;
    private SRMProtocol remoteSrmProtocol;
    private boolean remoteSrmGet;
    private TFileStorageType storageType;
    private final TRetentionPolicy targetRetentionPolicy;
    private final TAccessLatency targetAccessLatency;
    private final TOverwriteMode overwriteMode;
    private String targetSpaceToken;
    private final Transport clientTransport;
    private final transient OneToManyMap remoteSurlToFileReqIds = new OneToManyMap();
    private transient TurlGetterPutter getter_putter;
    private transient QOSPlugin qosPlugin = null;
    private volatile boolean processingDone = false;
    private static final long serialVersionUID = 7528188091894319055L;

    public CopyRequest(SRMUser user, Long requestCredentialId, String[] from_urls, String[] to_urls, String spaceToken, long lifetime, long max_update_period, int max_number_of_retries, SRMProtocol callerSrmProtocol, TFileStorageType storageType, TRetentionPolicy targetRetentionPolicy, TAccessLatency targetAccessLatency, String description, String client_host, TOverwriteMode overwriteMode) throws Exception {
        super(user, requestCredentialId, max_number_of_retries, max_update_period, lifetime, description, client_host);
        ArrayList<String> prot_list = new ArrayList<String>(4);
        if (this.getConfiguration().isUseGsiftpForSrmCopy()) {
            prot_list.add("gsiftp");
        }
        if (this.getConfiguration().isUseHttpForSrmCopy()) {
            prot_list.add("http");
        }
        if (this.getConfiguration().isUseDcapForSrmCopy()) {
            prot_list.add("dcap");
        }
        if (this.getConfiguration().isUseFtpForSrmCopy()) {
            prot_list.add("ftp");
        }
        this.clientTransport = this.getConfiguration().getClientTransport();
        this.protocols = prot_list.toArray(new String[0]);
        int reqs_num = from_urls.length;
        if (reqs_num != to_urls.length) {
            logger.error("Request createCopyRequest : unequal number of elements in url arrays");
            throw new IllegalArgumentException("unequal number of elements in url arrays");
        }
        ArrayList requests = Lists.newArrayListWithCapacity((int)reqs_num);
        for (int i = 0; i < reqs_num; ++i) {
            CopyFileRequest request = new CopyFileRequest(this.getId(), requestCredentialId, from_urls[i], to_urls[i], spaceToken, lifetime, max_number_of_retries);
            requests.add(request);
        }
        this.setFileRequests(requests);
        this.callerSrmProtocol = callerSrmProtocol;
        if (this.getConfiguration().getQosPluginClass() != null) {
            this.qosPlugin = QOSPluginFactory.createInstance(this.getConfiguration());
        }
        this.storageType = storageType;
        this.targetAccessLatency = targetAccessLatency;
        this.targetRetentionPolicy = targetRetentionPolicy;
        this.overwriteMode = overwriteMode;
        this.targetSpaceToken = spaceToken;
        this.updateMemoryCache();
        logger.debug("Request.createCopyRequest : created new request succesfully");
    }

    public CopyRequest(Long id, Long nextJobId, long creationTime, long lifetime, int stateId, String errorMessage, SRMUser user, String scheduelerId, long schedulerTimeStamp, int numberOfRetries, int maxNumberOfRetries, long lastStateTransitionTime, Job.JobHistory[] jobHistoryArray, Long credentialId, FileRequest[] fileRequest, int retryDeltaTime, boolean should_updateretryDeltaTime, String description, String client_host, String statusCodeString, TFileStorageType storageType, TRetentionPolicy targetRetentionPolicy, TAccessLatency targetAccessLatency) throws SQLException {
        super(id, nextJobId, creationTime, lifetime, stateId, errorMessage, user, scheduelerId, schedulerTimeStamp, numberOfRetries, maxNumberOfRetries, lastStateTransitionTime, jobHistoryArray, credentialId, fileRequest, retryDeltaTime, should_updateretryDeltaTime, description, client_host, statusCodeString);
        ArrayList<String> prot_list = new ArrayList<String>(4);
        if (this.getConfiguration().isUseGsiftpForSrmCopy()) {
            prot_list.add("gsiftp");
        }
        if (this.getConfiguration().isUseHttpForSrmCopy()) {
            prot_list.add("http");
        }
        if (this.getConfiguration().isUseDcapForSrmCopy()) {
            prot_list.add("dcap");
        }
        if (this.getConfiguration().isUseFtpForSrmCopy()) {
            prot_list.add("ftp");
        }
        this.clientTransport = this.getConfiguration().getClientTransport();
        this.protocols = prot_list.toArray(new String[0]);
        if (this.getConfiguration().getQosPluginClass() != null) {
            this.qosPlugin = QOSPluginFactory.createInstance(this.getConfiguration());
        }
        this.storageType = storageType;
        this.targetAccessLatency = targetAccessLatency;
        this.targetRetentionPolicy = targetRetentionPolicy;
        this.overwriteMode = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void proccessRequest() throws SQLException, Exception {
        logger.debug("Proccessing request");
        if (this.getNumOfFileRequest() == 0) {
            try {
                this.setState(State.FAILED, "Request contains zero file requests");
                return;
            }
            catch (IllegalStateTransition ist) {
                logger.error("Illegal State Transition : " + ist.getMessage());
            }
        }
        this.setNumber_of_file_reqs(this.getNumOfFileRequest());
        logger.debug("number_of_file_reqs = " + this.getNumber_of_file_reqs());
        this.wlock();
        try {
            List<FileRequest> requests = this.getFileRequests();
            this.from_urls = new SrmUrl[this.getNumber_of_file_reqs()];
            this.to_urls = new SrmUrl[this.getNumber_of_file_reqs()];
            for (int i = 0; i < this.getNumber_of_file_reqs(); ++i) {
                CopyFileRequest cfr = (CopyFileRequest)requests.get(i);
                this.from_urls[i] = new SrmUrl(cfr.getFromURL());
                this.to_urls[i] = new SrmUrl(cfr.getToURL());
            }
        }
        catch (MalformedURLException murle) {
            logger.error(murle.toString());
            try {
                this.setState(State.FAILED, murle.toString());
            }
            catch (IllegalStateTransition ist) {
                logger.error("Illegal State Transition : " + ist.getMessage());
            }
            return;
        }
        finally {
            this.wunlock();
        }
        this.identify();
        this.getTURLs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void identify() throws IOException, SRMException {
        this.wlock();
        try {
            int srm_port;
            for (int i = 1; i < this.getNumber_of_file_reqs(); ++i) {
                if (!this.from_urls[i].getProtocol().equals(this.from_urls[0].getProtocol()) || !this.from_urls[i].getHost().equals(this.from_urls[0].getHost()) || this.from_urls[i].getPort() != this.from_urls[0].getPort()) {
                    String err = "source url #" + i + " " + this.from_urls[i].getURL() + " and " + "source url #0" + this.from_urls[0].getURL() + " are not compartible";
                    logger.error(err);
                    throw new IOException(err);
                }
                if (this.to_urls[i].getProtocol().equals(this.to_urls[0].getProtocol()) && this.to_urls[i].getHost().equals(this.to_urls[0].getHost()) && this.to_urls[i].getPort() == this.to_urls[0].getPort()) continue;
                String err = "dest url #" + i + " " + this.to_urls[i].getURL() + " and " + "dest url #0" + this.to_urls[0].getURL() + " are not compartible";
                logger.error(err);
                throw new IOException(err);
            }
            this.from_url_is_srm = this.from_urls[0].getProtocol().equals("srm");
            this.to_url_is_srm = this.to_urls[0].getProtocol().equals("srm");
            this.from_url_is_gsiftp = this.from_urls[0].getProtocol().equals("gsiftp");
            this.to_url_is_gsiftp = this.to_urls[0].getProtocol().equals("gsiftp");
            if (this.isFrom_url_is_srm()) {
                int from_url_port;
                srm_port = this.getConfiguration().getPort();
                if (srm_port == (from_url_port = this.from_urls[0].getPort())) {
                    this.from_url_is_local = Tools.sameHost(this.getConfiguration().getSrmHosts(), this.from_urls[0].getHost());
                }
            } else {
                this.from_url_is_local = this.getStorage().isLocalTransferUrl(URI.create(this.from_urls[0].getURL()));
            }
            if (this.to_url_is_srm) {
                int to_url_port;
                srm_port = this.getConfiguration().getPort();
                if (srm_port == (to_url_port = this.to_urls[0].getPort())) {
                    this.to_url_is_local = Tools.sameHost(this.getConfiguration().getSrmHosts(), this.to_urls[0].getHost());
                }
            } else {
                this.to_url_is_local = this.getStorage().isLocalTransferUrl(URI.create(this.to_urls[0].getURL()));
            }
            logger.debug(" from_url_is_srm = " + this.from_url_is_srm);
            logger.debug(" to_url_is_srm = " + this.to_url_is_srm);
            logger.debug(" from_url_is_gsiftp = " + this.from_url_is_gsiftp);
            logger.debug(" to_url_is_gsiftp = " + this.to_url_is_gsiftp);
            logger.debug(" from_url_is_local = " + this.from_url_is_local);
            logger.debug(" to_url_is_local = " + this.to_url_is_local);
            if (!this.from_url_is_local && !this.to_url_is_local) {
                logger.error("both from and to url are not local srm");
                throw new IOException("both from and to url are not local srm");
            }
        }
        finally {
            this.wunlock();
        }
    }

    private void makeQosReservation(int i) throws MalformedURLException, SRMException {
        try {
            CopyFileRequest cfr = (CopyFileRequest)this.getFileRequests().get(i);
            RequestCredential credential = this.getCredential();
            QOSTicket qosTicket = this.getQosPlugin().createTicket(credential.getCredentialName(), this.getStorage().getFileMetaData((SRMUser)this.getUser(), (URI)cfr.getFrom_surl(), (boolean)false).size, this.getFrom_url(i).getURL(), this.getFrom_url(i).getPort(), this.getFrom_url(i).getPort(), this.getFrom_url(i).getProtocol(), this.getTo_url(i).getURL(), this.getTo_url(i).getPort(), this.getTo_url(i).getPort(), this.getTo_url(i).getProtocol());
            this.getQosPlugin().addTicket(qosTicket);
            if (this.getQosPlugin().submit()) {
                cfr.setQOSTicket(qosTicket);
                logger.debug("QOS Ticket Received " + this.getQosPlugin().toString());
            }
        }
        catch (Exception e) {
            logger.error("Could not create QOS reservation: " + e.getMessage());
        }
    }

    private void getTURLs() throws SRMException, IOException, InterruptedException, IllegalStateTransition, SQLException, FatalJobFailure {
        CopyFileRequest cfr;
        int i;
        logger.debug("getTURLS()");
        if (this.isFrom_url_is_srm() && !this.isFrom_url_is_local()) {
            if (this.getStorageType() != null && !this.storageType.equals(TFileStorageType.PERMANENT)) {
                throw new FatalJobFailure("TargetFileStorageType " + this.getStorageType() + " is not supported");
            }
            RequestCredential credential = this.getCredential();
            logger.debug("obtained credential=" + credential + " id=" + credential.getId());
            for (int i2 = 0; i2 < this.getNumber_of_file_reqs(); ++i2) {
                CopyFileRequest cfr2 = (CopyFileRequest)this.getFileRequests().get(i2);
                if (cfr2.getState() != State.PENDING || cfr2.getSchedulerId() != null) continue;
                if (cfr2.getFrom_turl() != null) {
                    Scheduler.getScheduler(this.schedulerId).schedule(cfr2);
                    continue;
                }
                this.remoteSurlToFileReqIds.put(this.getFrom_url(i2).getURL(), cfr2.getId());
                logger.debug("getTurlsArrived, setting local \"to\" path to " + cfr2.getToPath());
                cfr2.setLocal_to_path(cfr2.getToPath());
                cfr2.saveJob();
            }
            String[] remoteSurlsUniqueArray = this.remoteSurlToFileReqIds.keySet().toArray(new String[0]);
            for (int i3 = 0; i3 < remoteSurlsUniqueArray.length; ++i3) {
                logger.debug("remoteSurlsUniqueArray[" + i3 + "]=" + remoteSurlsUniqueArray[i3]);
            }
            this.setRemoteSrmGet(true);
            if (this.getCallerSrmProtocol() == null || this.getCallerSrmProtocol() == SRMProtocol.V1_1) {
                try {
                    this.setGetter_putter(new RemoteTurlGetterV1(this.getStorage(), credential, remoteSurlsUniqueArray, this.getProtocols(), this, this.getConfiguration().getCopyRetryTimeout(), 2, this.clientTransport));
                    this.getGetter_putter().getInitialRequest();
                    this.setRemoteSrmProtocol(SRMProtocol.V1_1);
                }
                catch (SRMException srme) {
                    logger.error("connecting to server using version 1.1 protocol failed, trying version 2.1.1");
                    this.setGetter_putter(new RemoteTurlGetterV2(this.getStorage(), credential, remoteSurlsUniqueArray, this.getProtocols(), this, this.getConfiguration().getCopyRetryTimeout(), 2, this.getRemainingLifetime(), this.clientTransport));
                    this.getGetter_putter().getInitialRequest();
                    this.setRemoteSrmProtocol(SRMProtocol.V2_1);
                }
            } else if (this.getCallerSrmProtocol() == SRMProtocol.V2_1) {
                try {
                    this.setGetter_putter(new RemoteTurlGetterV2(this.getStorage(), credential, remoteSurlsUniqueArray, this.getProtocols(), this, this.getConfiguration().getCopyRetryTimeout(), 2, this.getRemainingLifetime(), this.clientTransport));
                    this.getGetter_putter().getInitialRequest();
                    this.setRemoteSrmProtocol(SRMProtocol.V2_1);
                }
                catch (SRMException srme) {
                    logger.error("connecting to server using version 2.1.1 protocol failed, trying version 1.1");
                    this.setGetter_putter(new RemoteTurlGetterV1(this.getStorage(), credential, remoteSurlsUniqueArray, this.getProtocols(), this, this.getConfiguration().getCopyRetryTimeout(), 2, this.clientTransport));
                    this.getGetter_putter().getInitialRequest();
                    this.setRemoteSrmProtocol(SRMProtocol.V1_1);
                }
            } else {
                throw new FatalJobFailure("usupported srm protocol");
            }
            this.getGetter_putter().run();
            return;
        }
        if (this.isFrom_url_is_srm()) {
            for (i = 0; i < this.getNumber_of_file_reqs(); ++i) {
                cfr = (CopyFileRequest)this.getFileRequests().get(i);
                if (cfr.getState() != State.PENDING || cfr.getSchedulerId() != null || cfr.getLocal_from_path() != null) continue;
                logger.debug("getTurlsArrived, setting local \"from\" path to " + cfr.getFromPath());
                cfr.setLocal_from_path(cfr.getFromPath());
                cfr.saveJob();
            }
        } else {
            for (i = 0; i < this.getNumber_of_file_reqs(); ++i) {
                cfr = (CopyFileRequest)this.getFileRequests().get(i);
                if (cfr.getState() != State.PENDING || cfr.getSchedulerId() != null || cfr.getFrom_turl() != null) continue;
                logger.debug("getTurlsArrived, setting \"from\" turl to " + this.getFrom_url(i).getURL());
                cfr.setFrom_turl(URI.create(this.getFrom_url(i).getURL()));
                cfr.saveJob();
            }
        }
        if (this.isTo_url_is_srm() && this.isTo_url_is_local()) {
            for (i = 0; i < this.getNumber_of_file_reqs(); ++i) {
                cfr = (CopyFileRequest)this.getFileRequests().get(i);
                if (cfr.getState() != State.PENDING || cfr.getSchedulerId() != null) continue;
                logger.debug("getTurlsArrived, setting local \"to\" path to " + cfr.getToPath());
                cfr.setLocal_to_path(cfr.getToPath());
                cfr.saveJob();
                Scheduler.getScheduler(this.schedulerId).schedule(cfr);
            }
            return;
        }
        if (!this.isTo_url_is_srm()) {
            for (i = 0; i < this.getNumber_of_file_reqs(); ++i) {
                cfr = (CopyFileRequest)this.getFileRequests().get(i);
                if (cfr.getState() != State.PENDING || cfr.getSchedulerId() != null) continue;
                logger.debug("getTurlsArrived, setting remote \"to\" TURL to " + this.getTo_url(i).getURL());
                cfr.setTo_turl(URI.create(this.getTo_url(i).getURL()));
                cfr.saveJob();
                Scheduler.getScheduler(this.schedulerId).schedule(cfr);
            }
            return;
        }
        for (i = 0; i < this.getNumber_of_file_reqs(); ++i) {
            cfr = (CopyFileRequest)this.getFileRequests().get(i);
            if (cfr.getState() != State.PENDING || cfr.getSchedulerId() != null) continue;
            if (cfr.getTo_turl() != null) {
                Scheduler.getScheduler(this.schedulerId).schedule(cfr);
                continue;
            }
            this.remoteSurlToFileReqIds.put(this.getTo_url(i).getURL(), cfr.getId());
        }
        String[] remoteSurlsUniqueArray = this.remoteSurlToFileReqIds.keySet().toArray(new String[0]);
        int length = remoteSurlsUniqueArray.length;
        String[] dests = new String[length];
        long[] sizes = new long[length];
        for (int i4 = 0; i4 < length; ++i4) {
            Long fileRequestId = (Long)this.remoteSurlToFileReqIds.get(remoteSurlsUniqueArray[i4]);
            CopyFileRequest cfr3 = (CopyFileRequest)this.getFileRequest(fileRequestId);
            sizes[i4] = this.getStorage().getFileMetaData((SRMUser)this.getUser(), (URI)cfr3.getFrom_surl(), (boolean)false).size;
            logger.debug("getTURLs: local size  returned by storage.getFileMetaData is " + sizes[i4]);
            cfr3.setSize(sizes[i4]);
            dests[i4] = cfr3.getToURL();
            if (this.getQosPlugin() == null) continue;
            this.makeQosReservation(i4);
        }
        this.setRemoteSrmGet(false);
        RequestCredential credential = this.getCredential();
        if (this.getCallerSrmProtocol() == null || this.getCallerSrmProtocol() == SRMProtocol.V1_1) {
            try {
                this.setGetter_putter(new RemoteTurlPutterV1(this.getStorage(), credential, dests, sizes, this.getProtocols(), this, this.getConfiguration().getCopyRetryTimeout(), 2, this.clientTransport));
                this.getGetter_putter().getInitialRequest();
                this.setRemoteSrmProtocol(SRMProtocol.V1_1);
            }
            catch (SRMException srme) {
                logger.error("connecting to server using version 1.1 protocol failed, trying version 2.1.1");
                this.setGetter_putter(new RemoteTurlPutterV2(this.getStorage(), credential, dests, sizes, this.getProtocols(), this, this.getConfiguration().getCopyRetryTimeout(), 2, this.getRemainingLifetime(), this.getStorageType(), this.getTargetRetentionPolicy(), this.getTargetAccessLatency(), this.getOverwriteMode(), this.getTargetSpaceToken(), this.clientTransport));
                this.getGetter_putter().getInitialRequest();
                this.setRemoteSrmProtocol(SRMProtocol.V2_1);
            }
        } else if (this.getCallerSrmProtocol() == SRMProtocol.V2_1) {
            try {
                this.setGetter_putter(new RemoteTurlPutterV2(this.getStorage(), credential, dests, sizes, this.getProtocols(), this, this.getConfiguration().getCopyRetryTimeout(), 2, this.getRemainingLifetime(), this.getStorageType(), this.getTargetRetentionPolicy(), this.getTargetAccessLatency(), this.getOverwriteMode(), this.getTargetSpaceToken(), this.clientTransport));
                this.getGetter_putter().getInitialRequest();
                this.setRemoteSrmProtocol(SRMProtocol.V2_1);
            }
            catch (SRMException srme) {
                logger.error("connecting to server using version 2.1.1 protocol failed, trying version 1.1");
                this.setGetter_putter(new RemoteTurlPutterV1(this.getStorage(), credential, dests, sizes, this.getProtocols(), this, this.getConfiguration().getCopyRetryTimeout(), 2, this.clientTransport));
                this.getGetter_putter().getInitialRequest();
                this.setRemoteSrmProtocol(SRMProtocol.V1_1);
            }
        } else {
            throw new FatalJobFailure("usupported srm protocol");
        }
        this.getGetter_putter().run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void turlArrived(String SURL2, String TURL, String remoteRequestId, String remoteFileId, Long size) throws SQLException {
        OneToManyMap oneToManyMap = this.remoteSurlToFileReqIds;
        synchronized (oneToManyMap) {
            Set fileRequestSet = this.remoteSurlToFileReqIds.getValues(SURL2);
            if (fileRequestSet == null || fileRequestSet.isEmpty()) {
                logger.error("turlArrived for unknown SURL = " + SURL2 + " !!!!!!!");
                return;
            }
            Long[] cfr_ids = fileRequestSet.toArray(new Long[0]);
            Date now = new Date();
            long t = now.getTime();
            for (int i = 0; i < cfr_ids.length; ++i) {
                CopyFileRequest cfr = (CopyFileRequest)this.getFileRequest(cfr_ids[i]);
                if (this.getQosPlugin() != null && cfr.getQOSTicket() != null) {
                    this.getQosPlugin().sayStatus(cfr.getQOSTicket());
                }
                if (this.isFrom_url_is_srm() && !this.isFrom_url_is_local()) {
                    cfr.setFrom_turl(URI.create(TURL));
                } else {
                    cfr.setTo_turl(URI.create(TURL));
                }
                if (size != null) {
                    cfr.setSize(size);
                }
                cfr.setRemoteRequestId(remoteRequestId);
                cfr.setRemoteFileId(remoteFileId);
                cfr.saveJob();
                try {
                    String theShedulerId = this.schedulerId;
                    State file_state = cfr.getState();
                    if (theShedulerId != null && file_state != State.CANCELED && file_state != State.FAILED && file_state != State.DONE) {
                        Scheduler.getScheduler(theShedulerId).schedule(cfr);
                    }
                }
                catch (Exception e) {
                    logger.error(e.toString());
                    logger.error("failed to schedule CopyFileRequest " + cfr);
                    try {
                        cfr.setState(State.FAILED, "failed to schedule CopyFileRequest " + cfr + " rasaon: " + e);
                    }
                    catch (IllegalStateTransition ist) {
                        logger.error("Illegal State Transition : " + ist.getMessage());
                    }
                }
                this.remoteSurlToFileReqIds.remove(SURL2, cfr_ids[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void turlRetrievalFailed(String SURL2, String reason, String remoteRequestId, String remoteFileId) throws SQLException {
        OneToManyMap oneToManyMap = this.remoteSurlToFileReqIds;
        synchronized (oneToManyMap) {
            Set fileRequestSet = this.remoteSurlToFileReqIds.getValues(SURL2);
            if (fileRequestSet == null || fileRequestSet.isEmpty()) {
                logger.error("turlArrived for unknown SURL = " + SURL2);
                return;
            }
            Long[] cfr_ids = fileRequestSet.toArray(new Long[0]);
            for (int i = 0; i < cfr_ids.length; ++i) {
                CopyFileRequest cfr = (CopyFileRequest)this.getFileRequest(cfr_ids[i]);
                try {
                    String error = this.isFrom_url_is_srm() && !this.isFrom_url_is_local() ? "retrieval of \"from\" TURL failed with error " + reason : "retrieval of \"to\" TURL failed with error " + reason;
                    logger.error(error);
                    cfr.setState(State.FAILED, error);
                }
                catch (IllegalStateTransition ist) {
                    logger.error("Illegal State Transition : " + ist.getMessage());
                }
                cfr.saveJob();
                this.remoteSurlToFileReqIds.remove(SURL2, cfr_ids[i]);
            }
        }
        this.remoteFileRequestDone(SURL2, remoteRequestId, remoteFileId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void turlsRetrievalFailed(Object reason) throws SQLException {
        OneToManyMap oneToManyMap = this.remoteSurlToFileReqIds;
        synchronized (oneToManyMap) {
            String[] SURLs = this.remoteSurlToFileReqIds.keySet().toArray(new String[0]);
            for (int i = 0; i < SURLs.length; ++i) {
                String SURL2 = SURLs[i];
                Set fileRequestSet = this.remoteSurlToFileReqIds.getValues(SURL2);
                Long[] cfr_ids = fileRequestSet.toArray(new Long[0]);
                for (int j = 0; j < cfr_ids.length; ++j) {
                    CopyFileRequest cfr = (CopyFileRequest)this.getFileRequest(cfr_ids[j]);
                    try {
                        String error = this.isFrom_url_is_srm() && !this.isFrom_url_is_local() ? "retrieval of \"from\" TURL failed with error " + reason : "retrieval of \"to\" TURL failed with error " + reason;
                        logger.error(error);
                        cfr.setState(State.FAILED, error);
                    }
                    catch (IllegalStateTransition ist) {
                        logger.error("Illegal State Transition : " + ist.getMessage());
                    }
                    cfr.saveJob();
                    this.remoteSurlToFileReqIds.remove(SURL2, cfr_ids[j]);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remoteFileRequestDone(String SURL2, String remoteRequestIdString, String remoteFileIdString) {
        OneToManyMap oneToManyMap = this.remoteSurlToFileReqIds;
        synchronized (oneToManyMap) {
            try {
                if (this.getRemoteSrmProtocol() == SRMProtocol.V1_1) {
                    int remoteRequestId = Integer.parseInt(remoteRequestIdString);
                    int remoteFileId = Integer.parseInt(remoteFileIdString);
                    TurlGetterPutterV1.staticSetFileStatus(this.getCredential(), SURL2, remoteRequestId, remoteFileId, "Done", this.getConfiguration().getCopyRetryTimeout(), this.getConfiguration().getCopyMaxNumOfRetries(), this.clientTransport);
                } else if (this.getRemoteSrmProtocol() == SRMProtocol.V2_1) {
                    if (this.isRemoteSrmGet()) {
                        RemoteTurlGetterV2.staticReleaseFile(this.getCredential(), SURL2, remoteRequestIdString, this.getConfiguration().getCopyRetryTimeout(), this.getConfiguration().getCopyMaxNumOfRetries(), this.clientTransport);
                    } else {
                        RemoteTurlPutterV2.staticPutDone(this.getCredential(), SURL2, remoteRequestIdString, this.getConfiguration().getCopyRetryTimeout(), this.getConfiguration().getCopyMaxNumOfRetries(), this.clientTransport);
                    }
                } else {
                    logger.error("unknown or null callerSrmProtocol");
                }
            }
            catch (Exception e) {
                logger.error("set remote file status to done failed, surl = " + SURL2 + " requestId = " + remoteRequestIdString + " fileId = " + remoteFileIdString);
            }
        }
    }

    public final CopyFileRequest getFileRequestBySurls(String fromurl, String tourl) throws SQLException, SRMException {
        if (fromurl == null || tourl == null) {
            throw new SRMException("surl is null");
        }
        for (FileRequest request : this.getFileRequests()) {
            if (!((CopyFileRequest)request).getFromURL().equals(fromurl) || !((CopyFileRequest)request).getToURL().equals(tourl)) continue;
            return (CopyFileRequest)request;
        }
        throw new SRMException("file request for from url =" + fromurl + " and to url=" + tourl + " is not found");
    }

    @Override
    public String getMethod() {
        return "Copy";
    }

    public boolean shouldStopHandlerIfReady() {
        return true;
    }

    @Override
    public void run() throws NonFatalJobFailure, FatalJobFailure {
        if (this.isProcessingDone()) {
            return;
        }
        try {
            this.proccessRequest();
            boolean done = true;
            for (FileRequest request : this.getFileRequests()) {
                State state = request.getState();
                if (State.isFinalState(state)) continue;
                done = false;
            }
            this.setProcessingDone(true);
            if (done) {
                this.setState(State.DONE, "all file request completed");
            } else {
                this.setState(State.ASYNCWAIT, "waiting for files to complete");
            }
        }
        catch (FatalJobFailure fje) {
            throw fje;
        }
        catch (Exception e) {
            logger.error(e.toString());
            logger.error("throwing nonfatal exception for retry");
            throw new NonFatalJobFailure(e.toString());
        }
    }

    @Override
    protected void stateChanged(State oldState) {
        State state = this.getState();
        if (State.isFinalState(state)) {
            TurlGetterPutter a_getter_putter = this.getGetter_putter();
            if (a_getter_putter != null) {
                logger.debug("copyRequest getter_putter is non null, stopping");
                a_getter_putter.stop();
            }
            logger.debug("copy request state changed to " + (Object)((Object)state));
            for (FileRequest request : this.getFileRequests()) {
                try {
                    State fr_state = request.getState();
                    if (State.isFinalState(fr_state)) continue;
                    logger.debug("changing fr#" + request.getId() + " to " + (Object)((Object)state));
                    request.setState(state, "Request state changed, changing file state");
                }
                catch (IllegalStateTransition ist) {
                    logger.error("Illegal State Transition : " + ist.getMessage());
                }
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        logger.debug("propertyChange");
        try {
            if (evt instanceof TURLsArrivedEvent) {
                TURLsArrivedEvent tae = (TURLsArrivedEvent)evt;
                String SURL2 = tae.getSURL();
                String TURL = tae.getTURL();
                String remoteRequestId = tae.getRequestId();
                String remoteFileId = tae.getFileRequestId();
                Long size = tae.getSize();
                this.turlArrived(SURL2, TURL, remoteRequestId, remoteFileId, size);
            } else if (evt instanceof TURLsGetFailedEvent) {
                TURLsGetFailedEvent tgfe = (TURLsGetFailedEvent)evt;
                String SURL3 = tgfe.getSURL();
                String reason = tgfe.getReason();
                String remoteRequestId = tgfe.getRequestId();
                String remoteFileId = tgfe.getFileRequestId();
                this.turlRetrievalFailed(SURL3, reason, remoteRequestId, remoteFileId);
            } else if (evt instanceof RequestFailedEvent) {
                RequestFailedEvent rfe = (RequestFailedEvent)evt;
                Object reason = rfe.getReason();
                this.turlsRetrievalFailed(reason);
            }
        }
        catch (Exception e) {
            logger.error(e.toString());
        }
    }

    public void fileRequestCompleted() {
        this.resetRetryDeltaTime();
        if (this.isProcessingDone()) {
            try {
                boolean done = true;
                for (FileRequest request : this.getFileRequests()) {
                    State state = request.getState();
                    if (State.isFinalState(state)) continue;
                    done = false;
                }
                State state = this.getState();
                if (!State.isFinalState(state) && done) {
                    this.setState(State.DONE, "all files requests have completed ");
                }
            }
            catch (Exception e) {
                logger.error(e.toString());
                logger.error("setting to done anyway");
                try {
                    State state = this.getState();
                    if (!State.isFinalState(state)) {
                        this.setState(State.DONE, e.toString());
                    }
                }
                catch (IllegalStateTransition ist) {
                    logger.error("Illegal State Transition : " + ist.getMessage());
                }
            }
        }
    }

    public final SrmCopyResponse getSrmCopyResponse() throws SRMException, SQLException {
        SrmCopyResponse response = new SrmCopyResponse();
        response.setReturnStatus(this.getTReturnStatus());
        response.setRequestToken(this.getTRequestToken());
        ArrayOfTCopyRequestFileStatus arrayOfTCopyRequestFileStatus = new ArrayOfTCopyRequestFileStatus();
        arrayOfTCopyRequestFileStatus.setStatusArray(this.getArrayOfTCopyRequestFileStatuses(null, null));
        response.setArrayOfFileStatuses(arrayOfTCopyRequestFileStatus);
        return response;
    }

    private String getTRequestToken() {
        return this.getId().toString();
    }

    public final TCopyRequestFileStatus[] getArrayOfTCopyRequestFileStatuses(String[] fromurls, String[] tourls) throws SRMException, SQLException {
        if (fromurls != null && (tourls == null || fromurls.length != tourls.length)) {
            throw new SRMException("incompatible fromurls and tourls arrays");
        }
        int len = fromurls == null ? this.getNumOfFileRequest() : fromurls.length;
        TCopyRequestFileStatus[] copyRequestFileStatuses = new TCopyRequestFileStatus[len];
        if (fromurls == null) {
            for (int i = 0; i < len; ++i) {
                CopyFileRequest fr = (CopyFileRequest)this.getFileRequests().get(i);
                copyRequestFileStatuses[i] = fr.getTCopyRequestFileStatus();
            }
        } else {
            for (int i = 0; i < len; ++i) {
                CopyFileRequest fr = this.getFileRequestBySurls(fromurls[i], tourls[i]);
                copyRequestFileStatuses[i] = fr.getTCopyRequestFileStatus();
            }
        }
        return copyRequestFileStatuses;
    }

    public final SrmStatusOfCopyRequestResponse getSrmStatusOfCopyRequest() throws SRMException, SQLException {
        return this.getSrmStatusOfCopyRequest(null, null);
    }

    public final SrmStatusOfCopyRequestResponse getSrmStatusOfCopyRequest(String[] fromurls, String[] tourls) throws SRMException, SQLException {
        SrmStatusOfCopyRequestResponse response = new SrmStatusOfCopyRequestResponse();
        response.setReturnStatus(this.getTReturnStatus());
        ArrayOfTCopyRequestFileStatus arrayOfTCopyRequestFileStatus = new ArrayOfTCopyRequestFileStatus();
        arrayOfTCopyRequestFileStatus.setStatusArray(this.getArrayOfTCopyRequestFileStatuses(fromurls, tourls));
        response.setArrayOfFileStatuses(arrayOfTCopyRequestFileStatus);
        return response;
    }

    @Override
    public final FileRequest getFileRequestBySurl(URI surl) throws SQLException, SRMException {
        if (surl == null) {
            throw new SRMException("surl is null");
        }
        for (FileRequest request : this.getFileRequests()) {
            if (!((CopyFileRequest)request).getFrom_surl().equals(surl) && !((CopyFileRequest)request).getTo_surl().equals(surl)) continue;
            return request;
        }
        throw new SRMException("file request for url =" + surl + " is not found");
    }

    @Override
    public final TSURLReturnStatus[] getArrayOfTSURLReturnStatus(URI[] surls) throws SRMException, SQLException {
        TSURLReturnStatus[] surlLReturnStatuses;
        int len;
        if (surls == null) {
            len = this.getNumOfFileRequest();
            surlLReturnStatuses = new TSURLReturnStatus[len];
        } else {
            len = surls.length;
            surlLReturnStatuses = new TSURLReturnStatus[surls.length];
        }
        if (surls == null) {
            for (int i = 0; i < len; ++i) {
                CopyFileRequest fr = (CopyFileRequest)this.getFileRequests().get(i);
                surlLReturnStatuses[i] = fr.getTSURLReturnStatus(null);
            }
        } else {
            for (int i = 0; i < len; ++i) {
                CopyFileRequest fr = (CopyFileRequest)this.getFileRequestBySurl(surls[i]);
                surlLReturnStatuses[i] = fr.getTSURLReturnStatus(surls[i]);
            }
        }
        return surlLReturnStatuses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TRequestType getRequestType() {
        this.rlock();
        try {
            TRequestType tRequestType = TRequestType.COPY;
            return tRequestType;
        }
        finally {
            this.runlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TFileStorageType getStorageType() {
        this.rlock();
        try {
            TFileStorageType tFileStorageType = this.storageType;
            return tFileStorageType;
        }
        finally {
            this.runlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStorageType(TFileStorageType storageType) {
        this.wlock();
        try {
            this.storageType = storageType;
        }
        finally {
            this.wunlock();
        }
    }

    public TRetentionPolicy getTargetRetentionPolicy() {
        return this.targetRetentionPolicy;
    }

    public TAccessLatency getTargetAccessLatency() {
        return this.targetAccessLatency;
    }

    public TOverwriteMode getOverwriteMode() {
        return this.overwriteMode;
    }

    public boolean isOverwrite() {
        if (this.getConfiguration().isOverwrite()) {
            if (this.getOverwriteMode() == null) {
                return this.getConfiguration().isOverwrite_by_default();
            }
            return this.getOverwriteMode().equals(TOverwriteMode.ALWAYS);
        }
        return false;
    }

    @Override
    public long extendLifetimeMillis(long newLifetimeInMillis) throws SRMException {
        try {
            return super.extendLifetimeMillis(newLifetimeInMillis);
        }
        catch (SRMReleasedException releasedException) {
            throw new SRMInvalidRequestException(releasedException.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isFrom_url_is_srm() {
        this.rlock();
        try {
            boolean bl = this.from_url_is_srm;
            return bl;
        }
        finally {
            this.runlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isTo_url_is_srm() {
        this.rlock();
        try {
            boolean bl = this.to_url_is_srm;
            return bl;
        }
        finally {
            this.runlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isFrom_url_is_local() {
        this.rlock();
        try {
            boolean bl = this.from_url_is_local;
            return bl;
        }
        finally {
            this.runlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isTo_url_is_local() {
        this.rlock();
        try {
            boolean bl = this.to_url_is_local;
            return bl;
        }
        finally {
            this.runlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SrmUrl getFrom_url(int i) {
        this.rlock();
        try {
            SrmUrl srmUrl = this.from_urls[i];
            return srmUrl;
        }
        finally {
            this.runlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SrmUrl getTo_url(int i) {
        this.rlock();
        try {
            SrmUrl srmUrl = this.to_urls[i];
            return srmUrl;
        }
        finally {
            this.runlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getNumber_of_file_reqs() {
        this.rlock();
        try {
            int n = this.number_of_file_reqs;
            return n;
        }
        finally {
            this.runlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setNumber_of_file_reqs(int number_of_file_reqs) {
        this.wlock();
        try {
            this.number_of_file_reqs = number_of_file_reqs;
        }
        finally {
            this.wunlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getProtocols() {
        this.rlock();
        try {
            String[] stringArray = this.protocols;
            return stringArray;
        }
        finally {
            this.runlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SRMProtocol getCallerSrmProtocol() {
        this.rlock();
        try {
            SRMProtocol sRMProtocol = this.callerSrmProtocol;
            return sRMProtocol;
        }
        finally {
            this.runlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SRMProtocol getRemoteSrmProtocol() {
        this.rlock();
        try {
            SRMProtocol sRMProtocol = this.remoteSrmProtocol;
            return sRMProtocol;
        }
        finally {
            this.runlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setRemoteSrmProtocol(SRMProtocol remoteSrmProtocol) {
        this.wlock();
        try {
            this.remoteSrmProtocol = remoteSrmProtocol;
        }
        finally {
            this.wunlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isRemoteSrmGet() {
        this.rlock();
        try {
            boolean bl = this.remoteSrmGet;
            return bl;
        }
        finally {
            this.runlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setRemoteSrmGet(boolean remoteSrmGet) {
        this.wlock();
        try {
            this.remoteSrmGet = remoteSrmGet;
        }
        finally {
            this.wunlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getTargetSpaceToken() {
        this.rlock();
        try {
            String string = this.targetSpaceToken;
            return string;
        }
        finally {
            this.runlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TurlGetterPutter getGetter_putter() {
        this.rlock();
        try {
            TurlGetterPutter turlGetterPutter = this.getter_putter;
            return turlGetterPutter;
        }
        finally {
            this.runlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setGetter_putter(TurlGetterPutter getter_putter) {
        this.wlock();
        try {
            this.getter_putter = getter_putter;
        }
        finally {
            this.wunlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QOSPlugin getQosPlugin() {
        this.rlock();
        try {
            QOSPlugin qOSPlugin = this.qosPlugin;
            return qOSPlugin;
        }
        finally {
            this.runlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isProcessingDone() {
        this.rlock();
        try {
            boolean bl = this.processingDone;
            return bl;
        }
        finally {
            this.runlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setProcessingDone(boolean processingDone) {
        this.wlock();
        try {
            this.processingDone = processingDone;
        }
        finally {
            this.wunlock();
        }
    }
}

