/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.srm.request;

import com.google.common.collect.Lists;
import diskCacheV111.srm.RequestFileStatus;
import diskCacheV111.srm.RequestStatus;
import java.net.URI;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.dcache.commons.util.AtomicCounter;
import org.dcache.srm.SRMException;
import org.dcache.srm.SRMUser;
import org.dcache.srm.request.FileRequest;
import org.dcache.srm.request.Request;
import org.dcache.srm.scheduler.IllegalStateTransition;
import org.dcache.srm.scheduler.Job;
import org.dcache.srm.scheduler.State;
import org.dcache.srm.util.RequestStatusTool;
import org.dcache.srm.v2_2.TRequestSummary;
import org.dcache.srm.v2_2.TRequestType;
import org.dcache.srm.v2_2.TReturnStatus;
import org.dcache.srm.v2_2.TSURLReturnStatus;
import org.dcache.srm.v2_2.TStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ContainerRequest
extends Request {
    private static final Logger logger = LoggerFactory.getLogger(ContainerRequest.class);
    private String firstDcapTurl;
    private final List<FileRequest> fileRequests;
    protected final transient AtomicCounter _stateChangeCounter = new AtomicCounter();
    private static final long serialVersionUID = -5497111637295541321L;

    public ContainerRequest(SRMUser user, Long requestCredentalId, int max_number_of_retries, long max_update_period, long lifetime, String description, String client_host) {
        super(user, requestCredentalId, max_number_of_retries, max_update_period, lifetime, description, client_host);
        this.fileRequests = Lists.newArrayList();
    }

    protected ContainerRequest(Long id, Long nextJobId, long creationTime, long lifetime, int stateId, String errorMessage, SRMUser user, String scheduelerId, long schedulerTimeStamp, int numberOfRetries, int maxNumberOfRetries, long lastStateTransitionTime, Job.JobHistory[] jobHistoryArray, Long credentialId, FileRequest[] fileRequests, int retryDeltaTime, boolean should_updateretryDeltaTime, String description, String client_host, String statusCodeString) {
        super(id, nextJobId, creationTime, lifetime, stateId, errorMessage, user, scheduelerId, schedulerTimeStamp, numberOfRetries, maxNumberOfRetries, lastStateTransitionTime, jobHistoryArray, credentialId, retryDeltaTime, should_updateretryDeltaTime, description, client_host, statusCodeString);
        this.fileRequests = new ArrayList<FileRequest>(Arrays.asList(fileRequests));
    }

    public FileRequest getFileRequest(int fileRequestId) {
        this.rlock();
        try {
            for (FileRequest fileRequest : this.fileRequests) {
                if (fileRequest.getId() != (long)fileRequestId) continue;
                FileRequest fileRequest2 = fileRequest;
                return fileRequest2;
            }
            throw new IllegalArgumentException("FileRequest fileRequestId =" + fileRequestId + "does not belong to this Request");
        }
        finally {
            this.runlock();
        }
    }

    public final FileRequest getFileRequest(Long fileRequestId) {
        if (fileRequestId == null) {
            return null;
        }
        for (FileRequest fileRequest : this.fileRequests) {
            if (!fileRequest.getId().equals(fileRequestId)) continue;
            return fileRequest;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFileRequests(List<FileRequest> requests) {
        this.wlock();
        try {
            this.fileRequests.clear();
            this.fileRequests.addAll(requests);
        }
        finally {
            this.wunlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumOfFileRequest() {
        this.rlock();
        try {
            int n = this.fileRequests.size();
            return n;
        }
        finally {
            this.runlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFirstDcapTurl() {
        this.rlock();
        try {
            String string = this.firstDcapTurl;
            return string;
        }
        finally {
            this.runlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFirstDcapTurl(String s) {
        this.wlock();
        try {
            this.firstDcapTurl = s;
        }
        finally {
            this.wunlock();
        }
    }

    @Override
    public abstract String getMethod();

    private void getRequestStatusCalled() {
        this.scheduleIfRestored();
        for (FileRequest fr : this.fileRequests) {
            fr.scheduleIfRestored();
        }
        this.updateRetryDeltaTime();
    }

    public final RequestStatus getRequestStatus() {
        this.getRequestStatusCalled();
        RequestStatus rs = new RequestStatus();
        rs.requestId = this.getRequestNum();
        rs.errorMessage = this.getErrorMessage();
        if (rs.errorMessage == null) {
            rs.errorMessage = "";
        }
        int len = this.getNumOfFileRequest();
        rs.fileStatuses = new RequestFileStatus[len];
        boolean haveFailedRequests = false;
        boolean havePendingRequests = false;
        boolean haveRunningRequests = false;
        boolean haveReadyRequests = false;
        boolean haveDoneRequests = false;
        String fr_error = "";
        for (int i = 0; i < len; ++i) {
            FileRequest fr = this.fileRequests.get(i);
            fr.tryToReady();
            RequestFileStatus rfs = fr.getRequestFileStatus();
            if (rfs == null) {
                haveFailedRequests = true;
                fr_error = fr_error + "RequestFileStatus is null : fr.errorMessage= [ " + fr.getErrorMessage() + "]\n";
                continue;
            }
            rs.fileStatuses[i] = rfs;
            String state = rfs.state;
            if (state.equals("Pending")) {
                havePendingRequests = true;
                continue;
            }
            if (state.equals("Running")) {
                haveRunningRequests = true;
                continue;
            }
            if (state.equals("Ready")) {
                haveReadyRequests = true;
                continue;
            }
            if (state.equals("Done")) {
                haveDoneRequests = true;
                continue;
            }
            if (state.equals("Failed")) {
                haveFailedRequests = true;
                fr_error = fr_error + "RequestFileStatus#" + rfs.fileId + " failed with error:[ " + fr.getErrorMessage() + "]\n";
                continue;
            }
            logger.error("File Request state is unknown!!! state  == " + state);
            logger.error("fr is " + fr);
        }
        if (haveFailedRequests) {
            rs.errorMessage = rs.errorMessage + "\n" + fr_error;
        }
        if (havePendingRequests) {
            rs.state = "Pending";
        } else if (haveFailedRequests) {
            if (!haveRunningRequests && !haveReadyRequests) {
                rs.state = "Failed";
                try {
                    this.setState(State.FAILED, rs.errorMessage);
                    this.stopUpdating();
                }
                catch (IllegalStateTransition ist) {
                    logger.error("Illegal State Transition : " + ist.getMessage());
                }
            }
        } else if (haveRunningRequests || haveReadyRequests) {
            rs.state = "Active";
        } else if (haveDoneRequests) {
            try {
                this.setState(State.DONE, "All files are done");
                this.stopUpdating();
            }
            catch (IllegalStateTransition ist) {
                logger.error("Illegal State Transition : " + ist.getMessage());
            }
            rs.state = "Done";
        } else {
            logger.error("request state is unknown or no files in request!!!");
            this.stopUpdating();
            try {
                this.setState(State.FAILED, "request state is unknown or no files in request!!!");
            }
            catch (IllegalStateTransition ist) {
                logger.error("Illegal State Transition : " + ist.getMessage());
            }
            rs.state = "Failed";
        }
        if (!rs.state.equals("Failed")) {
            rs.errorMessage = "";
        }
        rs.type = this.getMethod();
        rs.retryDeltaTime = this.retryDeltaTime;
        rs.submitTime = new Date(this.getCreationTime());
        rs.finishTime = new Date(this.getCreationTime() + this.getLifetime());
        rs.startTime = new Date(System.currentTimeMillis() + (long)(this.retryDeltaTime * 1000));
        return rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TReturnStatus getTReturnStatus() {
        this.getRequestStatus();
        TReturnStatus status = new TReturnStatus();
        this.rlock();
        try {
            if (this.getStatusCode() != null) {
                status.setStatusCode(this.getStatusCode());
                logger.debug("getTReturnStatus() assigned status.statusCode : " + status.getStatusCode());
                status.setExplanation(this.getErrorMessage());
                logger.debug("getTReturnStatus() assigned status.explanation : " + status.getExplanation());
                TReturnStatus tReturnStatus = status;
                return tReturnStatus;
            }
        }
        finally {
            this.runlock();
        }
        int len = this.getNumOfFileRequest();
        if (len == 0) {
            status.setStatusCode(TStatusCode.SRM_INTERNAL_ERROR);
            status.setExplanation("Could not find (deserialize) files in the request, NumOfFileRequest is 0");
            logger.debug("assigned status.statusCode : " + status.getStatusCode());
            logger.debug("assigned status.explanation : " + status.getExplanation());
            return status;
        }
        int failed_req = 0;
        int failed_space_expired = 0;
        int failed_no_free_space = 0;
        int canceled_req = 0;
        int pending_req = 0;
        int running_req = 0;
        int ready_req = 0;
        int done_req = 0;
        int got_exception = 0;
        boolean failure = false;
        for (int i = 0; i < len; ++i) {
            FileRequest fr = this.fileRequests.get(i);
            TReturnStatus fileReqRS = fr.getReturnStatus();
            TStatusCode fileReqSC = fileReqRS.getStatusCode();
            logger.debug("getTReturnStatus() file[" + i + "] statusCode : " + fileReqSC);
            try {
                if (fileReqSC == TStatusCode.SRM_REQUEST_QUEUED) {
                    ++pending_req;
                    continue;
                }
                if (fileReqSC == TStatusCode.SRM_REQUEST_INPROGRESS) {
                    ++running_req;
                    continue;
                }
                if (fileReqSC == TStatusCode.SRM_FILE_PINNED || fileReqSC == TStatusCode.SRM_SPACE_AVAILABLE) {
                    ++ready_req;
                    continue;
                }
                if (fileReqSC == TStatusCode.SRM_SUCCESS || fileReqSC == TStatusCode.SRM_RELEASED) {
                    ++done_req;
                    continue;
                }
                if (fileReqSC == TStatusCode.SRM_ABORTED) {
                    ++canceled_req;
                    failure = true;
                    continue;
                }
                if (fileReqSC == TStatusCode.SRM_NO_FREE_SPACE) {
                    ++failed_no_free_space;
                    failure = true;
                    continue;
                }
                if (fileReqSC == TStatusCode.SRM_SPACE_LIFETIME_EXPIRED) {
                    ++failed_space_expired;
                    failure = true;
                    continue;
                }
                if (RequestStatusTool.isFailedFileRequestStatus(fileReqRS)) {
                    ++failed_req;
                    failure = true;
                    continue;
                }
                logger.error("File Request StatusCode is unknown!!! state  == " + (Object)((Object)fr.getState()));
                logger.error("fr is " + fr);
                continue;
            }
            catch (Exception e) {
                logger.error(e.toString());
                ++got_exception;
                failure = true;
            }
        }
        status.setExplanation(this.getErrorMessage());
        if (canceled_req == len) {
            status.setStatusCode(TStatusCode.SRM_ABORTED);
            logger.debug("assigned status.statusCode : " + status.getStatusCode());
            logger.debug("assigned status.explanation : " + status.getExplanation());
            return status;
        }
        if (failed_req == len || got_exception == len) {
            status.setStatusCode(TStatusCode.SRM_FAILURE);
            logger.debug("assigned status.statusCode : " + status.getStatusCode());
            logger.debug("assigned status.explanation : " + status.getExplanation());
            return status;
        }
        if (ready_req == len || done_req == len || ready_req + done_req == len) {
            if (failure) {
                status.setStatusCode(TStatusCode.SRM_PARTIAL_SUCCESS);
                logger.debug("assigned status.statusCode : " + status.getStatusCode());
                logger.debug("assigned status.explanation : " + status.getExplanation());
                return status;
            }
            status.setStatusCode(TStatusCode.SRM_SUCCESS);
            logger.debug("assigned status.statusCode : " + status.getStatusCode());
            logger.debug("assigned status.explanation : " + status.getExplanation());
            return status;
        }
        if (pending_req == len) {
            status.setStatusCode(TStatusCode.SRM_REQUEST_QUEUED);
            logger.debug("assigned status.statusCode : " + status.getStatusCode());
            logger.debug("assigned status.explanation : " + status.getExplanation());
            return status;
        }
        if (failed_no_free_space > 0) {
            status.setStatusCode(TStatusCode.SRM_NO_FREE_SPACE);
            logger.debug("assigned status.statusCode : " + status.getStatusCode());
            logger.debug("assigned status.explanation : " + status.getExplanation());
            return status;
        }
        if (failed_space_expired > 0) {
            status.setStatusCode(TStatusCode.SRM_SPACE_LIFETIME_EXPIRED);
            logger.debug("assigned status.statusCode : " + status.getStatusCode());
            logger.debug("assigned status.explanation : " + status.getExplanation());
            return status;
        }
        if (running_req > 0 || pending_req > 0) {
            status.setStatusCode(TStatusCode.SRM_REQUEST_INPROGRESS);
            logger.debug("assigned status.statusCode : " + status.getStatusCode());
            logger.debug("assigned status.explanation : " + status.getExplanation());
            return status;
        }
        if (failure) {
            if (ready_req > 0 || done_req > 0) {
                status.setStatusCode(TStatusCode.SRM_PARTIAL_SUCCESS);
                logger.debug("assigned status.statusCode : " + status.getStatusCode());
                logger.debug("assigned status.explanation : " + status.getExplanation());
                return status;
            }
            status.setStatusCode(TStatusCode.SRM_FAILURE);
            logger.debug("assigned status.statusCode : " + status.getStatusCode());
            logger.debug("assigned status.explanation : " + status.getExplanation());
            return status;
        }
        status.setStatusCode(TStatusCode.SRM_SUCCESS);
        logger.debug("assigned status.statusCode : " + status.getStatusCode());
        logger.debug("assigned status.explanation : " + status.getExplanation());
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TRequestSummary getRequestSummary() {
        TRequestSummary summary = new TRequestSummary();
        summary.setStatus(this.getTReturnStatus());
        summary.setRequestType(this.getRequestType());
        summary.setRequestToken(this.getId().toString());
        int total_num = this.getNumOfFileRequest();
        summary.setTotalNumFilesInRequest(total_num);
        int num_of_failed = 0;
        int num_of_completed = 0;
        int num_of_waiting = 0;
        for (int i = 0; i < total_num; ++i) {
            FileRequest fr;
            this.rlock();
            try {
                fr = this.fileRequests.get(i);
            }
            finally {
                this.runlock();
            }
            TReturnStatus fileReqRS = fr.getReturnStatus();
            TStatusCode fileReqSC = fileReqRS.getStatusCode();
            try {
                if (fileReqSC == TStatusCode.SRM_REQUEST_QUEUED) {
                    ++num_of_waiting;
                    continue;
                }
                if (fileReqSC == TStatusCode.SRM_SUCCESS || fileReqSC == TStatusCode.SRM_RELEASED) {
                    ++num_of_completed;
                    continue;
                }
                if (!RequestStatusTool.isFailedFileRequestStatus(fileReqRS)) continue;
                ++num_of_failed;
                continue;
            }
            catch (Exception e) {
                logger.error(e.toString());
                ++num_of_failed;
            }
        }
        summary.setNumOfFailedFiles(num_of_failed);
        summary.setNumOfCompletedFiles(num_of_completed);
        summary.setNumOfWaitingFiles(num_of_waiting);
        return summary;
    }

    public abstract TRequestType getRequestType();

    public boolean equals(Object o) {
        return o == this;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    @Override
    public void toString(StringBuilder sb, boolean longformat) {
        try {
            sb.append(this.getMethod());
            sb.append(" id: ").append(this.getId());
            sb.append(" created: ").append(this.getUser());
            sb.append(" state: ").append((Object)this.getState());
            if (longformat) {
                sb.append("\ncredential: \"").append(this.getCredential()).append("\"\n");
                sb.append("\nsubmitted: ").append(new Date(this.getCreationTime()));
                sb.append("\nexpires: ").append(new Date(this.getCreationTime() + this.getLifetime()));
                sb.append("\nstatus code: ").append(this.getStatusCode());
                sb.append("\nerror message: ").append(this.getErrorMessage());
                sb.append("\nHistory of State Transitions: \n");
                sb.append(this.getHistory());
                for (FileRequest fr : this.fileRequests) {
                    sb.append("\n");
                    fr.toString(sb, longformat);
                }
            } else {
                sb.append(" number of files:").append(this.fileRequests.size());
            }
        }
        catch (Exception e) {
            logger.error(e.toString());
        }
    }

    public void fileRequestStateChanged(FileRequest request) {
        switch (request.getState()) {
            case RQUEUED: 
            case READY: 
            case DONE: 
            case CANCELED: 
            case FAILED: {
                this._stateChangeCounter.increment();
            }
        }
    }

    public abstract FileRequest getFileRequestBySurl(URI var1) throws SQLException, SRMException;

    public abstract TSURLReturnStatus[] getArrayOfTSURLReturnStatus(URI[] var1) throws SRMException, SQLException;

    public List<FileRequest> getFileRequests() {
        return this.fileRequests;
    }

    protected Date getDateRelativeToNow(long delta) {
        long now = System.currentTimeMillis();
        if (delta >= 0L && now >= Long.MAX_VALUE - delta) {
            return new Date(Long.MAX_VALUE);
        }
        return new Date(now + delta);
    }
}

