/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.srm.request;

import com.google.common.collect.Lists;
import java.net.URI;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.apache.axis.types.URI;
import org.dcache.srm.SRMException;
import org.dcache.srm.SRMFileRequestNotFoundException;
import org.dcache.srm.SRMInvalidRequestException;
import org.dcache.srm.SRMUser;
import org.dcache.srm.request.BringOnlineFileRequest;
import org.dcache.srm.request.ContainerRequest;
import org.dcache.srm.request.FileRequest;
import org.dcache.srm.scheduler.FatalJobFailure;
import org.dcache.srm.scheduler.IllegalStateTransition;
import org.dcache.srm.scheduler.Job;
import org.dcache.srm.scheduler.NonFatalJobFailure;
import org.dcache.srm.scheduler.State;
import org.dcache.srm.v2_2.ArrayOfTBringOnlineRequestFileStatus;
import org.dcache.srm.v2_2.ArrayOfTSURLReturnStatus;
import org.dcache.srm.v2_2.SrmBringOnlineResponse;
import org.dcache.srm.v2_2.SrmReleaseFilesResponse;
import org.dcache.srm.v2_2.SrmStatusOfBringOnlineRequestResponse;
import org.dcache.srm.v2_2.TBringOnlineRequestFileStatus;
import org.dcache.srm.v2_2.TRequestType;
import org.dcache.srm.v2_2.TReturnStatus;
import org.dcache.srm.v2_2.TSURLReturnStatus;
import org.dcache.srm.v2_2.TStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BringOnlineRequest
extends ContainerRequest {
    private static final Logger logger = LoggerFactory.getLogger(BringOnlineRequest.class);
    private final String[] protocols;
    private final long desiredOnlineLifetimeInSeconds;
    public HashSet callbacks_set = new HashSet();
    private static final long serialVersionUID = -3739166738239918248L;

    public BringOnlineRequest(SRMUser user, Long requestCredentialId, URI[] surls, String[] protocols, long lifetime, long desiredOnlineLifetimeInSeconds, long max_update_period, int max_number_of_retries, String description, String client_host) {
        super(user, requestCredentialId, max_number_of_retries, max_update_period, lifetime, description, client_host);
        logger.debug("constructor");
        logger.debug("user = " + user);
        logger.debug("requestCredetialId=" + requestCredentialId);
        if (protocols != null) {
            int len = protocols.length;
            this.protocols = new String[len];
            System.arraycopy(protocols, 0, this.protocols, 0, len);
        } else {
            this.protocols = null;
        }
        this.desiredOnlineLifetimeInSeconds = desiredOnlineLifetimeInSeconds;
        ArrayList requests = Lists.newArrayListWithCapacity((int)surls.length);
        for (URI surl : surls) {
            BringOnlineFileRequest request = new BringOnlineFileRequest(this.getId(), requestCredentialId, surl, lifetime, max_number_of_retries);
            requests.add(request);
        }
        this.setFileRequests(requests);
        this.updateMemoryCache();
    }

    public BringOnlineRequest(Long id, Long nextJobId, long creationTime, long lifetime, int stateId, String errorMessage, SRMUser user, String scheduelerId, long schedulerTimeStamp, int numberOfRetries, int maxNumberOfRetries, long lastStateTransitionTime, Job.JobHistory[] jobHistoryArray, Long credentialId, FileRequest[] fileRequests, int retryDeltaTime, boolean should_updateretryDeltaTime, String description, String client_host, String statusCodeString, String[] protocols) throws SQLException {
        super(id, nextJobId, creationTime, lifetime, stateId, errorMessage, user, scheduelerId, schedulerTimeStamp, numberOfRetries, maxNumberOfRetries, lastStateTransitionTime, jobHistoryArray, credentialId, fileRequests, retryDeltaTime, should_updateretryDeltaTime, description, client_host, statusCodeString);
        this.protocols = protocols;
        this.desiredOnlineLifetimeInSeconds = 0L;
    }

    @Override
    public FileRequest getFileRequestBySurl(URI surl) throws SQLException, SRMException {
        if (surl == null) {
            throw new SRMException("surl is null");
        }
        for (FileRequest request : this.getFileRequests()) {
            if (!((BringOnlineFileRequest)request).getSurl().equals(surl)) continue;
            return request;
        }
        throw new SRMFileRequestNotFoundException("file request for surl =" + surl + " is not found");
    }

    @Override
    public void schedule() throws InterruptedException, IllegalStateTransition {
        this.saveJob(true);
        for (FileRequest request : this.getFileRequests()) {
            request.schedule();
        }
    }

    public String[] getProtocols() {
        if (this.protocols == null) {
            return null;
        }
        String[] copy = new String[this.protocols.length];
        System.arraycopy(this.protocols, 0, copy, 0, this.protocols.length);
        return copy;
    }

    @Override
    public String getMethod() {
        return "BringOnline";
    }

    public boolean shouldStopHandlerIfReady() {
        return false;
    }

    @Override
    public void run() throws NonFatalJobFailure, FatalJobFailure {
    }

    @Override
    protected void stateChanged(State oldState) {
        State state = this.getState();
        if (State.isFinalState(state)) {
            logger.debug("get request state changed to " + (Object)((Object)state));
            for (FileRequest fr : this.getFileRequests()) {
                try {
                    logger.debug("changing fr#" + fr.getId() + " to " + (Object)((Object)state));
                    fr.setState(state, "changing file state because request state has changed");
                }
                catch (IllegalStateTransition ist) {
                    logger.error("Illegal State Transition : " + ist.getMessage());
                }
            }
        }
    }

    public final SrmBringOnlineResponse getSrmBringOnlineResponse(long timeout) throws SRMException, SQLException, InterruptedException {
        Date deadline = this.getDateRelativeToNow(timeout);
        int counter = this._stateChangeCounter.get();
        SrmBringOnlineResponse response = this.getSrmBringOnlineResponse();
        while (response.getReturnStatus().getStatusCode().isProcessing() && this._stateChangeCounter.awaitChangeUntil(counter, deadline)) {
            counter = this._stateChangeCounter.get();
            response = this.getSrmBringOnlineResponse();
        }
        return response;
    }

    public final SrmBringOnlineResponse getSrmBringOnlineResponse() throws SRMException, SQLException {
        SrmBringOnlineResponse response = new SrmBringOnlineResponse();
        response.setReturnStatus(this.getTReturnStatus());
        response.setRequestToken(this.getTRequestToken());
        ArrayOfTBringOnlineRequestFileStatus arrayOfTBringOnlineRequestFileStatus = new ArrayOfTBringOnlineRequestFileStatus();
        arrayOfTBringOnlineRequestFileStatus.setStatusArray(this.getArrayOfTBringOnlineRequestFileStatus(null));
        response.setArrayOfFileStatuses(arrayOfTBringOnlineRequestFileStatus);
        return response;
    }

    public final SrmStatusOfBringOnlineRequestResponse getSrmStatusOfBringOnlineRequestResponse() throws SRMException, SQLException {
        return this.getSrmStatusOfBringOnlineRequestResponse(null);
    }

    public final SrmStatusOfBringOnlineRequestResponse getSrmStatusOfBringOnlineRequestResponse(URI[] surls) throws SRMException, SQLException {
        SrmStatusOfBringOnlineRequestResponse response = new SrmStatusOfBringOnlineRequestResponse();
        response.setReturnStatus(this.getTReturnStatus());
        ArrayOfTBringOnlineRequestFileStatus arrayOfTBringOnlineRequestFileStatus = new ArrayOfTBringOnlineRequestFileStatus();
        arrayOfTBringOnlineRequestFileStatus.setStatusArray(this.getArrayOfTBringOnlineRequestFileStatus(surls));
        response.setArrayOfFileStatuses(arrayOfTBringOnlineRequestFileStatus);
        StringBuilder s = new StringBuilder("getSrmStatusOfBringOnlineRequestResponse:");
        s.append(" StatusCode = " + response.getReturnStatus().getStatusCode());
        for (TBringOnlineRequestFileStatus fs : arrayOfTBringOnlineRequestFileStatus.getStatusArray()) {
            s.append(" FileStatusCode = " + fs.getStatus().getStatusCode());
        }
        logger.debug(s.toString());
        return response;
    }

    private String getTRequestToken() {
        return this.getId().toString();
    }

    private TBringOnlineRequestFileStatus[] getArrayOfTBringOnlineRequestFileStatus(URI[] surls) throws SRMException, SQLException {
        int len = surls == null ? this.getNumOfFileRequest() : surls.length;
        TBringOnlineRequestFileStatus[] getFileStatuses = new TBringOnlineRequestFileStatus[len];
        if (surls == null) {
            List<FileRequest> requests = this.getFileRequests();
            for (int i = 0; i < len; ++i) {
                BringOnlineFileRequest fr = (BringOnlineFileRequest)requests.get(i);
                getFileStatuses[i] = fr.getTGetRequestFileStatus();
            }
        } else {
            for (int i = 0; i < len; ++i) {
                BringOnlineFileRequest fr = (BringOnlineFileRequest)this.getFileRequestBySurl(surls[i]);
                getFileStatuses[i] = fr.getTGetRequestFileStatus();
            }
        }
        return getFileStatuses;
    }

    @Override
    public TSURLReturnStatus[] getArrayOfTSURLReturnStatus(URI[] surls) throws SRMException, SQLException {
        TSURLReturnStatus[] surlLReturnStatuses;
        int len;
        if (surls == null) {
            len = this.getNumOfFileRequest();
            surlLReturnStatuses = new TSURLReturnStatus[len];
        } else {
            len = surls.length;
            surlLReturnStatuses = new TSURLReturnStatus[surls.length];
        }
        if (surls == null) {
            List<FileRequest> requests = this.getFileRequests();
            for (int i = 0; i < len; ++i) {
                BringOnlineFileRequest fr = (BringOnlineFileRequest)requests.get(i);
                surlLReturnStatuses[i] = fr.getTSURLReturnStatus();
            }
        } else {
            for (int i = 0; i < len; ++i) {
                BringOnlineFileRequest fr = (BringOnlineFileRequest)this.getFileRequestBySurl(surls[i]);
                surlLReturnStatuses[i] = fr.getTSURLReturnStatus();
            }
        }
        return surlLReturnStatuses;
    }

    public SrmReleaseFilesResponse releaseFiles(URI[] surls) throws SRMInvalidRequestException {
        BringOnlineFileRequest fr;
        int i;
        TSURLReturnStatus[] surlLReturnStatuses;
        int len;
        logger.debug("releaseFiles");
        if (surls == null) {
            len = this.getNumOfFileRequest();
            surlLReturnStatuses = new TSURLReturnStatus[len];
        } else {
            len = surls.length;
            surlLReturnStatuses = new TSURLReturnStatus[surls.length];
        }
        if (surls == null) {
            logger.debug("releaseFiles, surls is null, releasing all " + len + " files");
            for (i = 0; i < len; ++i) {
                List<FileRequest> requests = this.getFileRequests();
                fr = (BringOnlineFileRequest)requests.get(i);
                surlLReturnStatuses[i] = fr.releaseFile();
            }
        } else {
            for (i = 0; i < len; ++i) {
                TSURLReturnStatus surlStatus;
                org.apache.axis.types.URI surl;
                try {
                    surl = new org.apache.axis.types.URI(surls[i].toASCIIString());
                }
                catch (URI.MalformedURIException e) {
                    throw new SRMInvalidRequestException("Invalid surl: " + e.getMessage());
                }
                logger.debug("releaseFiles, releasing file " + surl);
                try {
                    fr = (BringOnlineFileRequest)this.getFileRequestBySurl(surls[i]);
                }
                catch (SRMFileRequestNotFoundException sfrnfe) {
                    try {
                        SRMUser user = this.getUser();
                        long theId = this.getId();
                        BringOnlineFileRequest.unpinBySURLandRequestId(this.getStorage(), user, theId, surls[i]);
                        TSURLReturnStatus surlStatus2 = new TSURLReturnStatus();
                        TReturnStatus surlReturnStatus = new TReturnStatus();
                        surlReturnStatus.setStatusCode(TStatusCode.SRM_SUCCESS);
                        surlStatus2.setSurl(surl);
                        surlStatus2.setStatus(surlReturnStatus);
                        surlLReturnStatuses[i] = surlStatus2;
                    }
                    catch (Exception e) {
                        TSURLReturnStatus surlStatus3 = new TSURLReturnStatus();
                        TReturnStatus surlReturnStatus = new TReturnStatus();
                        surlReturnStatus.setStatusCode(TStatusCode.SRM_INTERNAL_ERROR);
                        surlReturnStatus.setExplanation("could not release file, neither file request for surl, nor pin is found: " + e);
                        surlStatus3.setSurl(surl);
                        surlStatus3.setStatus(surlReturnStatus);
                        surlLReturnStatuses[i] = surlStatus3;
                    }
                    continue;
                }
                catch (Exception e) {
                    surlStatus = new TSURLReturnStatus();
                    TReturnStatus surlReturnStatus = new TReturnStatus();
                    surlReturnStatus.setStatusCode(TStatusCode.SRM_INVALID_PATH);
                    surlReturnStatus.setExplanation("error retrieving a file request for an surl: " + e);
                    surlStatus.setSurl(surl);
                    surlStatus.setStatus(surlReturnStatus);
                    surlLReturnStatuses[i] = surlStatus;
                    continue;
                }
                try {
                    surlLReturnStatuses[i] = fr.releaseFile();
                    continue;
                }
                catch (Exception e) {
                    surlStatus = new TSURLReturnStatus();
                    TReturnStatus surlReturnStatus = new TReturnStatus();
                    surlReturnStatus.setStatusCode(TStatusCode.SRM_INTERNAL_ERROR);
                    surlReturnStatus.setExplanation("could not releaseFile file: " + e);
                    surlStatus.setSurl(surl);
                    surlStatus.setStatus(surlReturnStatus);
                    surlLReturnStatuses[i] = surlStatus;
                }
            }
        }
        try {
            this.getTReturnStatus();
        }
        catch (Exception e) {
            logger.error(e.toString());
        }
        int errors_cnt = 0;
        for (TSURLReturnStatus surlLReturnStatus : surlLReturnStatuses) {
            if (surlLReturnStatus != null && surlLReturnStatus.getStatus().getStatusCode().equals(TStatusCode.SRM_SUCCESS)) continue;
            ++errors_cnt;
        }
        TReturnStatus status = new TReturnStatus();
        if (errors_cnt == 0) {
            status.setStatusCode(TStatusCode.SRM_SUCCESS);
        } else if (errors_cnt < len) {
            status.setStatusCode(TStatusCode.SRM_PARTIAL_SUCCESS);
        } else {
            status.setStatusCode(TStatusCode.SRM_FAILURE);
        }
        SrmReleaseFilesResponse srmReleaseFilesResponse = new SrmReleaseFilesResponse();
        srmReleaseFilesResponse.setReturnStatus(status);
        srmReleaseFilesResponse.setArrayOfFileStatuses(new ArrayOfTSURLReturnStatus(surlLReturnStatuses));
        return srmReleaseFilesResponse;
    }

    @Override
    public TRequestType getRequestType() {
        return TRequestType.BRING_ONLINE;
    }

    public long getDesiredOnlineLifetimeInSeconds() {
        return this.desiredOnlineLifetimeInSeconds;
    }
}

