/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.srm.request;

import com.google.common.base.Joiner;
import diskCacheV111.srm.RequestFileStatus;
import java.net.URI;
import java.sql.SQLException;
import org.apache.axis.types.UnsignedLong;
import org.dcache.srm.AbstractStorageElement;
import org.dcache.srm.FileMetaData;
import org.dcache.srm.PinCallbacks;
import org.dcache.srm.SRMException;
import org.dcache.srm.SRMInvalidRequestException;
import org.dcache.srm.SRMUser;
import org.dcache.srm.UnpinCallbacks;
import org.dcache.srm.request.BringOnlineRequest;
import org.dcache.srm.request.FileRequest;
import org.dcache.srm.scheduler.FatalJobFailure;
import org.dcache.srm.scheduler.IllegalStateTransition;
import org.dcache.srm.scheduler.Job;
import org.dcache.srm.scheduler.NonFatalJobFailure;
import org.dcache.srm.scheduler.Scheduler;
import org.dcache.srm.scheduler.State;
import org.dcache.srm.v2_2.TBringOnlineRequestFileStatus;
import org.dcache.srm.v2_2.TReturnStatus;
import org.dcache.srm.v2_2.TSURLReturnStatus;
import org.dcache.srm.v2_2.TStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BringOnlineFileRequest
extends FileRequest {
    private static final Logger logger = LoggerFactory.getLogger(BringOnlineFileRequest.class);
    private URI surl;
    private String pinId;
    private String fileId;
    private transient FileMetaData fileMetaData;
    private static final long serialVersionUID = -9155373723705753177L;

    public BringOnlineFileRequest(Long requestId, Long requestCredentalId, URI surl, long lifetime, int maxNumberOfRetries) {
        super(requestId, requestCredentalId, lifetime, maxNumberOfRetries);
        logger.debug("BringOnlineFileRequest, requestId=" + requestId + " fileRequestId = " + this.getId());
        this.surl = surl;
        this.updateMemoryCache();
    }

    public BringOnlineFileRequest(Long id, Long nextJobId, long creationTime, long lifetime, int stateId, String errorMessage, String scheduelerId, long schedulerTimeStamp, int numberOfRetries, int maxNumberOfRetries, long lastStateTransitionTime, Job.JobHistory[] jobHistoryArray, Long requestId, Long requestCredentalId, String statusCodeString, String SURL2, String fileId, String pinId) throws SQLException {
        super(id, nextJobId, creationTime, lifetime, stateId, errorMessage, scheduelerId, schedulerTimeStamp, numberOfRetries, maxNumberOfRetries, lastStateTransitionTime, jobHistoryArray, requestId, requestCredentalId, statusCodeString);
        this.surl = URI.create(SURL2);
        if (fileId != null && !fileId.equalsIgnoreCase("null")) {
            this.fileId = fileId;
        }
        if (pinId != null && !pinId.equalsIgnoreCase("null")) {
            this.pinId = pinId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPinId(String pinId) {
        this.wlock();
        try {
            this.pinId = pinId;
        }
        finally {
            this.wunlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPinId() {
        this.rlock();
        try {
            String string = this.pinId;
            return string;
        }
        finally {
            this.runlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPinned() {
        this.rlock();
        try {
            boolean bl = this.getPinId() != null;
            return bl;
        }
        finally {
            this.runlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URI getSurl() {
        this.rlock();
        try {
            URI uRI = this.surl;
            return uRI;
        }
        finally {
            this.runlock();
        }
    }

    public String getSurlString() {
        return this.getSurl().toASCIIString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFileId() {
        this.rlock();
        try {
            String string = this.fileId;
            return string;
        }
        finally {
            this.runlock();
        }
    }

    @Override
    public RequestFileStatus getRequestFileStatus() {
        State state;
        RequestFileStatus rfs = this.fileMetaData != null ? new RequestFileStatus(this.fileMetaData) : new RequestFileStatus();
        rfs.fileId = this.getId().intValue();
        rfs.SURL = this.getSurlString();
        if (this.isPinned()) {
            rfs.isPinned = true;
            rfs.isCached = true;
        }
        rfs.state = (state = this.getState()) == State.DONE ? "Done" : (state == State.READY ? "Ready" : (state == State.TRANSFERRING ? "Running" : (state == State.FAILED || state == State.CANCELED ? "Failed" : "Pending")));
        return rfs;
    }

    public TBringOnlineRequestFileStatus getTGetRequestFileStatus() throws SQLException, SRMInvalidRequestException {
        TBringOnlineRequestFileStatus fileStatus = new TBringOnlineRequestFileStatus();
        if (this.fileMetaData != null) {
            fileStatus.setFileSize(new UnsignedLong(this.fileMetaData.size));
        }
        try {
            fileStatus.setSourceSURL(new org.apache.axis.types.URI(this.getSurlString()));
        }
        catch (Exception e) {
            logger.error(e.toString());
            throw new SQLException("wrong surl format");
        }
        if (this.isPinned()) {
            fileStatus.setRemainingPinTime((int)(this.getRemainingLifetime() / 1000L));
        }
        fileStatus.setEstimatedWaitTime(this.getRequest().getRetryDeltaTime());
        TReturnStatus returnStatus = this.getReturnStatus();
        fileStatus.setStatus(returnStatus);
        return fileStatus;
    }

    public TSURLReturnStatus getTSURLReturnStatus() throws SQLException {
        TReturnStatus returnStatus = this.getReturnStatus();
        TSURLReturnStatus surlReturnStatus = new TSURLReturnStatus();
        try {
            surlReturnStatus.setSurl(new org.apache.axis.types.URI(this.getSurlString()));
        }
        catch (Exception e) {
            logger.error(e.toString());
            throw new SQLException("wrong surl format");
        }
        surlReturnStatus.setStatus(returnStatus);
        return surlReturnStatus;
    }

    @Override
    public void toString(StringBuilder sb, boolean longformat) {
        sb.append(" BringOnlineFileRequest ");
        sb.append(" id:").append(this.getId());
        sb.append(" priority:").append(this.getPriority());
        sb.append(" creator priority:");
        try {
            sb.append(this.getUser().getPriority());
        }
        catch (SRMInvalidRequestException ire) {
            sb.append("Unknown");
        }
        sb.append(" state:").append((Object)this.getState());
        if (longformat) {
            sb.append('\n').append("   SURL: ").append(this.getSurl());
            sb.append('\n').append("   pinned: ").append(this.isPinned());
            String thePinId = this.getPinId();
            if (thePinId != null) {
                sb.append('\n').append("   pinid: ").append(thePinId);
            }
            sb.append('\n').append("   status code:").append(this.getStatusCode());
            sb.append('\n').append("   error message:").append(this.getErrorMessage());
            sb.append('\n').append("   History of State Transitions: \n");
            sb.append(this.getHistory());
        }
    }

    @Override
    public final void run() throws NonFatalJobFailure, FatalJobFailure {
        logger.debug("run()");
        try {
            if (this.getPinId() == null) {
                logger.debug("pinId is null, asking to pin ");
                this.pinFile();
                if (this.getPinId() == null) {
                    this.setState(State.ASYNCWAIT, "pinning file");
                    logger.debug("BringOnlineFileRequest: waiting async notification about pinId...");
                    return;
                }
            }
        }
        catch (SRMException e) {
            logger.error(e.getMessage());
            throw new NonFatalJobFailure(e.toString());
        }
        catch (IllegalStateTransition ist) {
            throw new NonFatalJobFailure("Illegal State Transition : " + ist.getMessage());
        }
        logger.info("PinId is " + this.getPinId() + " returning, scheduler should change" + " state to \"Ready\"");
    }

    public void askFileId() throws NonFatalJobFailure, FatalJobFailure {
    }

    public void pinFile() throws NonFatalJobFailure, FatalJobFailure, SRMException {
        BringOnlineRequest request = Job.getJob(this.requestId, BringOnlineRequest.class);
        Object[] protocols = request.getProtocols();
        if (protocols != null && !this.isProtocolSupported((String[])protocols)) {
            throw new FatalJobFailure("Transfer protocols not supported: " + Joiner.on((String)", ").join(protocols));
        }
        long desiredPinLifetime = request.getDesiredOnlineLifetimeInSeconds();
        if (desiredPinLifetime != -1L) {
            desiredPinLifetime *= 1000L;
        }
        URI surl = this.getSurl();
        logger.info("Pinning {}", (Object)surl);
        this.getStorage().pinFile(this.getUser(), surl, this.getRequest().getClient_host(), desiredPinLifetime, this.getRequestId(), new ThePinCallbacks(this.getId()));
    }

    @Override
    protected void stateChanged(State oldState) {
        State state = this.getState();
        logger.debug("State changed from " + (Object)((Object)oldState) + " to " + (Object)((Object)this.getState()));
        if (state == State.READY) {
            try {
                this.getRequest().resetRetryDeltaTime();
            }
            catch (SRMInvalidRequestException ire) {
                logger.error(ire.toString());
            }
        }
        if ((state == State.CANCELED || state == State.FAILED) && this.getFileId() != null && this.getPinId() != null) {
            TheUnpinCallbacks callbacks = new TheUnpinCallbacks(this.getId());
            logger.info("state changed to final state, unpinning fileId= " + this.getFileId() + " pinId = " + this.getPinId());
            try {
                this.getStorage().unPinFile(this.getUser(), this.getFileId(), callbacks, this.getPinId());
            }
            catch (SRMInvalidRequestException ire) {
                logger.error(ire.toString());
                return;
            }
        }
        super.stateChanged(oldState);
    }

    public TSURLReturnStatus releaseFile() throws SRMInvalidRequestException {
        TSURLReturnStatus surlReturnStatus = new TSURLReturnStatus();
        TReturnStatus returnStatus = new TReturnStatus();
        try {
            surlReturnStatus.setSurl(new org.apache.axis.types.URI(this.getSurlString()));
        }
        catch (Exception e) {
            logger.error(e.toString());
            returnStatus.setExplanation("wrong surl format");
            returnStatus.setStatusCode(TStatusCode.SRM_INVALID_REQUEST);
            surlReturnStatus.setStatus(returnStatus);
            return surlReturnStatus;
        }
        State state = this.getState();
        if (!State.isFinalState(state)) {
            logger.error("Canceled by the srmReleaseFile");
            try {
                this.setState(State.CANCELED, "Canceled by the srmReleaseFile");
            }
            catch (IllegalStateTransition ist) {
                logger.warn("Illegal State Transition : " + ist.getMessage());
            }
            returnStatus.setExplanation("srmBringOnline for this file has not completed yet, pending srmBringOnline canceled");
            returnStatus.setStatusCode(TStatusCode.SRM_FAILURE);
            surlReturnStatus.setStatus(returnStatus);
            return surlReturnStatus;
        }
        if (this.getFileId() != null && this.getPinId() != null) {
            TheUnpinCallbacks callbacks = new TheUnpinCallbacks(this.getId());
            logger.debug("srmReleaseFile, unpinning fileId= " + this.getFileId() + " pinId = " + this.getPinId());
            this.getStorage().unPinFile(this.getUser(), this.getFileId(), callbacks, this.getPinId());
            try {
                callbacks.waitCompleteion(60000L);
                if (callbacks.success) {
                    this.setPinId(null);
                    this.saveJob();
                    returnStatus.setStatusCode(TStatusCode.SRM_SUCCESS);
                    surlReturnStatus.setStatus(returnStatus);
                    return surlReturnStatus;
                }
            }
            catch (InterruptedException ie) {
                logger.error(ie.toString());
            }
            returnStatus.setExplanation(" srmReleaseFile failed: " + callbacks.getError());
            returnStatus.setStatusCode(TStatusCode.SRM_FAILURE);
            surlReturnStatus.setStatus(returnStatus);
            return surlReturnStatus;
        }
        returnStatus.setExplanation(" srmReleaseFile failed: file is not pinned");
        returnStatus.setStatusCode(TStatusCode.SRM_FAILURE);
        surlReturnStatus.setStatus(returnStatus);
        return surlReturnStatus;
    }

    @Override
    public TReturnStatus getReturnStatus() {
        TReturnStatus returnStatus = new TReturnStatus();
        State state = this.getState();
        returnStatus.setExplanation(state.toString());
        if (this.getStatusCode() != null) {
            returnStatus.setStatusCode(this.getStatusCode());
        } else if (state == State.DONE) {
            if (this.getPinId() != null) {
                returnStatus.setStatusCode(TStatusCode.SRM_SUCCESS);
            } else {
                returnStatus.setStatusCode(TStatusCode.SRM_RELEASED);
            }
        } else if (state == State.READY) {
            returnStatus.setStatusCode(TStatusCode.SRM_FILE_PINNED);
        } else if (state == State.TRANSFERRING) {
            returnStatus.setStatusCode(TStatusCode.SRM_FILE_PINNED);
        } else if (state == State.FAILED) {
            returnStatus.setExplanation("FAILED: " + this.getErrorMessage());
            returnStatus.setStatusCode(TStatusCode.SRM_FAILURE);
        } else if (state == State.CANCELED) {
            returnStatus.setStatusCode(TStatusCode.SRM_ABORTED);
        } else if (state == State.TQUEUED) {
            returnStatus.setStatusCode(TStatusCode.SRM_REQUEST_QUEUED);
        } else if (state == State.RUNNING || state == State.RQUEUED || state == State.ASYNCWAIT) {
            returnStatus.setStatusCode(TStatusCode.SRM_REQUEST_INPROGRESS);
        } else {
            returnStatus.setStatusCode(TStatusCode.SRM_REQUEST_QUEUED);
        }
        return returnStatus;
    }

    @Override
    public long extendLifetime(long newLifetime) throws SRMException {
        long remainingLifetime = this.getRemainingLifetime();
        if (remainingLifetime >= newLifetime) {
            return remainingLifetime;
        }
        long requestLifetime = this.getRequest().extendLifetimeMillis(newLifetime);
        if (requestLifetime < newLifetime) {
            newLifetime = requestLifetime;
        }
        if (remainingLifetime >= newLifetime) {
            return remainingLifetime;
        }
        if (remainingLifetime >= (newLifetime = this.extendLifetimeMillis(newLifetime))) {
            return remainingLifetime;
        }
        if (this.getPinId() == null) {
            return newLifetime;
        }
        SRMUser user = this.getUser();
        this.getStorage().extendPinLifetime(user, this.getFileId(), this.getPinId(), newLifetime);
        return newLifetime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setFileId(String fileId) {
        this.wlock();
        try {
            this.fileId = fileId;
        }
        finally {
            this.wunlock();
        }
    }

    public static void unpinBySURLandRequestId(AbstractStorageElement storage, SRMUser user, long id, URI surl) throws SRMException {
        FileMetaData fmd = storage.getFileMetaData(user, surl, true);
        String fileId = fmd.fileId;
        if (fileId != null) {
            TheUnpinCallbacks unpinCallbacks = new TheUnpinCallbacks(null);
            storage.unPinFileBySrmRequestId(user, fileId, unpinCallbacks, id);
            try {
                unpinCallbacks.waitCompleteion(60000L);
                if (unpinCallbacks.isDone()) {
                    if (unpinCallbacks.isSuccess()) {
                        return;
                    }
                    throw new SRMException("unpinning of " + surl + " by SrmRequestId " + id + " failed :" + unpinCallbacks.getError());
                }
                throw new SRMException("unpinning of " + surl + " by SrmRequestId " + id + " took too long");
            }
            catch (InterruptedException ie) {
                logger.error(ie.toString());
                throw new SRMException("unpinning of " + surl + " by SrmRequestId " + id + " got interrupted");
            }
        }
    }

    public static void unpinBySURL(AbstractStorageElement storage, SRMUser user, URI surl) throws SRMException {
        FileMetaData fmd = storage.getFileMetaData(user, surl, true);
        String fileId = fmd.fileId;
        if (fileId != null) {
            TheUnpinCallbacks unpinCallbacks = new TheUnpinCallbacks(null);
            storage.unPinFile(user, fileId, unpinCallbacks);
            try {
                unpinCallbacks.waitCompleteion(60000L);
                if (unpinCallbacks.isDone()) {
                    if (unpinCallbacks.isSuccess()) {
                        return;
                    }
                    throw new SRMException("unpinning of " + surl + " failed :" + unpinCallbacks.getError());
                }
                throw new SRMException("unpinning of " + surl + " took too long");
            }
            catch (InterruptedException ie) {
                logger.error(ie.toString());
                throw new SRMException("unpinning of " + surl + " got interrupted");
            }
        }
    }

    private static class TheUnpinCallbacks
    implements UnpinCallbacks {
        Long fileRequestJobId;
        private boolean done = false;
        private boolean success = true;
        private String error;

        public TheUnpinCallbacks(Long fileRequestJobId) {
            this.fileRequestJobId = fileRequestJobId;
        }

        public BringOnlineFileRequest getBringOnlineFileRequest() throws SQLException, SRMInvalidRequestException {
            if (this.fileRequestJobId != null) {
                return Job.getJob(this.fileRequestJobId, BringOnlineFileRequest.class);
            }
            return null;
        }

        @Override
        public void Error(String error) {
            try {
                BringOnlineFileRequest fr = this.getBringOnlineFileRequest();
                this.error = "TheUnpinCallbacks error: " + error;
                if (fr != null) {
                    logger.error(this.error);
                }
                this.success = false;
                this.done();
            }
            catch (Exception e) {
                logger.error(e.toString());
                this.done();
            }
        }

        @Override
        public void Exception(Exception e) {
            try {
                BringOnlineFileRequest fr = this.getBringOnlineFileRequest();
                if (fr != null) {
                    logger.error("TheUnpinCallbacks exception", (Throwable)e);
                }
                this.error = "TheUnpinCallbacks exception: " + e.toString();
                this.success = false;
                this.done();
            }
            catch (Exception e1) {
                logger.error(e1.toString());
                this.done();
            }
        }

        @Override
        public void Timeout() {
            try {
                BringOnlineFileRequest fr = this.getBringOnlineFileRequest();
                this.error = "TheUnpinCallbacks Timeout";
                if (fr != null) {
                    logger.error(this.error);
                }
                this.success = false;
                this.done();
            }
            catch (Exception e) {
                logger.error(e.toString());
                this.done();
            }
        }

        @Override
        public void Unpinned(String pinId) {
            try {
                BringOnlineFileRequest fr = this.getBringOnlineFileRequest();
                if (fr != null) {
                    logger.debug("TheUnpinCallbacks: Unpinned() pinId:" + pinId);
                    State state = fr.getState();
                    if (state == State.ASYNCWAIT) {
                        fr.setPinId(pinId);
                        Scheduler scheduler = Scheduler.getScheduler(fr.getSchedulerId());
                        try {
                            scheduler.schedule(fr);
                        }
                        catch (Exception ie) {
                            logger.error(ie.toString());
                        }
                    }
                }
                this.success = true;
                this.done();
            }
            catch (Exception e) {
                logger.error(e.toString());
                this.done();
            }
        }

        @Override
        public void UnpinningFailed(String reason) {
            try {
                BringOnlineFileRequest fr = this.getBringOnlineFileRequest();
                this.error = "TheUnpinCallbacks error: " + reason;
                if (fr != null) {
                    logger.error(this.error);
                }
                this.success = false;
                this.done();
            }
            catch (Exception e) {
                logger.error(e.toString());
                this.done();
            }
        }

        public synchronized boolean isSuccess() {
            return this.done && this.success;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean waitCompleteion(long timeout) throws InterruptedException {
            long starttime = System.currentTimeMillis();
            while (true) {
                TheUnpinCallbacks theUnpinCallbacks = this;
                synchronized (theUnpinCallbacks) {
                    this.wait(1000L);
                    if (this.done) {
                        return this.success;
                    }
                    if (System.currentTimeMillis() - starttime > timeout) {
                        this.error = " TheUnpinCallbacks Timeout";
                        return false;
                    }
                }
            }
        }

        public synchronized void done() {
            this.done = true;
            this.notifyAll();
        }

        public String getError() {
            return this.error;
        }

        public synchronized boolean isDone() {
            return this.done;
        }
    }

    private static class ThePinCallbacks
    implements PinCallbacks {
        Long fileRequestJobId;

        public ThePinCallbacks(Long fileRequestJobId) {
            this.fileRequestJobId = fileRequestJobId;
        }

        public BringOnlineFileRequest getBringOnlineFileRequest() throws SRMInvalidRequestException {
            return Job.getJob(this.fileRequestJobId, BringOnlineFileRequest.class);
        }

        @Override
        public void FileNotFound(String reason) {
            try {
                BringOnlineFileRequest fr = this.getBringOnlineFileRequest();
                try {
                    fr.setStateAndStatusCode(State.FAILED, reason, TStatusCode.SRM_INVALID_PATH);
                }
                catch (IllegalStateTransition ist) {
                    logger.warn("Illegal State Transition : " + ist.getMessage());
                }
                logger.warn("GetCallbacks error: " + reason);
            }
            catch (Exception e) {
                logger.error(e.toString());
            }
        }

        @Override
        public void Unavailable(String reason) {
            try {
                BringOnlineFileRequest fr = this.getBringOnlineFileRequest();
                try {
                    fr.setStateAndStatusCode(State.FAILED, reason, TStatusCode.SRM_FILE_UNAVAILABLE);
                }
                catch (IllegalStateTransition ist) {
                    logger.warn("Illegal State Transition : " + ist.getMessage());
                }
                logger.warn("ThePinCallbacks error: " + reason);
            }
            catch (Exception e) {
                logger.error(e.toString());
            }
        }

        @Override
        public void Error(String error) {
            try {
                BringOnlineFileRequest fr = this.getBringOnlineFileRequest();
                try {
                    fr.setState(State.FAILED, error);
                }
                catch (IllegalStateTransition ist) {
                    logger.warn("Illegal State Transition : " + ist.getMessage());
                }
                logger.error("ThePinCallbacks error: " + error);
            }
            catch (Exception e) {
                logger.error(e.toString());
            }
        }

        @Override
        public void Exception(Exception e) {
            try {
                BringOnlineFileRequest fr = this.getBringOnlineFileRequest();
                try {
                    fr.setState(State.FAILED, e.toString());
                }
                catch (IllegalStateTransition ist) {
                    logger.warn("Illegal State Transition : " + ist.getMessage());
                }
                logger.error("ThePinCallbacks exception", (Throwable)e);
            }
            catch (Exception e1) {
                logger.error(e1.toString());
            }
        }

        @Override
        public void Timeout() {
            try {
                BringOnlineFileRequest fr = this.getBringOnlineFileRequest();
                logger.info("Pin request timed out");
                if (!fr.getState().isFinalState()) {
                    fr.pinFile();
                }
            }
            catch (Exception e) {
                logger.error(e.toString());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void Pinned(FileMetaData fileMetaData, String pinId) {
            try {
                logger.debug("File pinned (pinId={})", (Object)pinId);
                BringOnlineFileRequest fr = this.getBringOnlineFileRequest();
                fr.wlock();
                try {
                    State state = fr.getState();
                    if (state == State.ASYNCWAIT || state == State.RUNNING) {
                        fr.setFileId(fileMetaData.fileId);
                        fr.fileMetaData = fileMetaData;
                        fr.setPinId(pinId);
                        fr.setState(State.DONE, " file is pinned, pinId=" + pinId);
                    }
                }
                finally {
                    fr.wunlock();
                }
            }
            catch (SRMInvalidRequestException e) {
                logger.error("BringOnlineFileRequest failed: {}", (Object)e.getMessage());
            }
            catch (IllegalStateTransition e) {
                logger.warn("Illegal State Transition: {}", (Object)e.getMessage());
            }
        }

        @Override
        public void PinningFailed(String reason) {
            try {
                BringOnlineFileRequest fr = this.getBringOnlineFileRequest();
                try {
                    fr.setState(State.FAILED, reason);
                }
                catch (IllegalStateTransition ist) {
                    logger.warn("Illegal State Transition : " + ist.getMessage());
                }
                logger.error("ThePinCallbacks error: " + reason);
            }
            catch (Exception e) {
                logger.error(e.toString());
            }
        }
    }
}

