/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.srm.request;

import com.google.common.collect.ImmutableMap;
import org.dcache.srm.v2_2.TAccessLatency;

public enum AccessLatency {
    ONLINE(TAccessLatency.ONLINE),
    NEARLINE(TAccessLatency.NEARLINE);

    private final TAccessLatency _latency;
    private static final ImmutableMap<TAccessLatency, AccessLatency> MAP;
    private static final String ERROR_MESSAGE;

    private AccessLatency(TAccessLatency latency) {
        this._latency = latency;
    }

    public TAccessLatency toTAccessLatency() {
        return this._latency;
    }

    public static AccessLatency fromTAccessLatency(TAccessLatency latency) {
        if (latency == null) {
            return null;
        }
        return (AccessLatency)((Object)MAP.get((Object)latency));
    }

    public static AccessLatency fromString(String txt) throws IllegalArgumentException {
        try {
            TAccessLatency latency = TAccessLatency.fromString(txt);
            return AccessLatency.fromTAccessLatency(latency);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format(ERROR_MESSAGE, txt));
        }
    }

    static {
        StringBuilder sb = new StringBuilder();
        sb.append("Unknown AccessLatency: \"%s\".");
        sb.append(" Supported values :");
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (AccessLatency value : AccessLatency.values()) {
            builder.put((Object)value._latency, (Object)value);
            sb.append(" \"").append(value._latency).append("\"");
        }
        MAP = builder.build();
        ERROR_MESSAGE = sb.toString();
    }
}

