/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.srm.qos.lambdastation;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import org.dcache.srm.AbstractStorageElement;
import org.dcache.srm.qos.QOSPlugin;
import org.dcache.srm.qos.QOSTicket;
import org.dcache.srm.qos.lambdastation.LambdaStationMap;
import org.dcache.srm.qos.lambdastation.LambdaStationTicket;
import org.dcache.srm.util.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LambdaStationPlugin
implements QOSPlugin {
    private static final Logger logger = LoggerFactory.getLogger(LambdaStationPlugin.class);
    private LambdaStationMap lambdaStationMap = null;
    private String lambdaStationConf = null;
    private String lambdaStationScript = null;
    private AbstractStorageElement storage = null;
    private ArrayList<LambdaStationTicket> tickets = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSrmConfiguration(Configuration configuration) {
        FileInputStream fis;
        this.lambdaStationConf = configuration.getQosConfigFile();
        this.storage = configuration.getStorage();
        Properties properties = new Properties();
        try {
            fis = new FileInputStream(this.lambdaStationConf);
        }
        catch (FileNotFoundException ex) {
            logger.error(ex.toString());
            return;
        }
        try {
            properties.load(fis);
        }
        catch (IOException ex) {
            logger.error("failed to load configuration ", (Throwable)ex);
            return;
        }
        finally {
            try {
                fis.close();
            }
            catch (IOException ex) {
                logger.error("failed to close " + this.lambdaStationConf, (Throwable)ex);
            }
        }
        this.lambdaStationScript = properties.getProperty("l_station_script", "/opt/d-cache/conf/l_station_script.sh");
        this.lambdaStationMap = new LambdaStationMap(properties.getProperty("l_station_map", "/opt/d-cache/conf/l_station_map.xml"));
    }

    @Override
    public QOSTicket createTicket(String credential, Long bytes, String srcURL, int srcPortMin, int srcPortMax, String srcProtocol, String dstURL, int dstPortMin, int dstPortMax, String dstProtocol) {
        LambdaStationTicket ticket = new LambdaStationTicket(credential, dstURL, null, srcURL, null, 600, this.lambdaStationMap);
        ticket.bytes = bytes;
        return ticket;
    }

    @Override
    public void addTicket(QOSTicket qosTicket) {
        if (qosTicket instanceof LambdaStationTicket) {
            LambdaStationTicket ls_ticket = (LambdaStationTicket)qosTicket;
            this.tickets.add(ls_ticket);
        }
    }

    @Override
    public boolean submit() {
        boolean result = true;
        for (LambdaStationTicket ls_ticket : this.tickets) {
            ls_ticket.OpenTicket(this.lambdaStationScript);
            result = !result ? this.isTicketEnabled(ls_ticket) : result;
        }
        return result;
    }

    private boolean isTicketEnabled(QOSTicket qosTicket) {
        if (qosTicket instanceof LambdaStationTicket) {
            LambdaStationTicket ls_ticket = (LambdaStationTicket)qosTicket;
            boolean sEnabled = ls_ticket.srcEnabled();
            boolean dEnabled = ls_ticket.dstEnabled();
            logger.debug("src enabled=" + sEnabled + " dst enabled=" + dEnabled);
            return sEnabled && dEnabled && ls_ticket.getLocalTicketID() != 0;
        }
        return false;
    }

    @Override
    public void sayStatus(QOSTicket qosTicket) {
        if (qosTicket instanceof LambdaStationTicket) {
            LambdaStationTicket ls_ticket = (LambdaStationTicket)qosTicket;
            if (this.isTicketEnabled(qosTicket)) {
                long extend_time;
                Date now = new Date();
                long t = now.getTime();
                long time_left = ls_ticket.getActualEndTime() - t / 1000L;
                logger.debug("End time=" + ls_ticket.getActualEndTime() + " Travel Time=" + ls_ticket.TravelTime + " now=" + t + " expires in " + time_left);
                long transfer_time = 0L;
                long rate_MB = 100000000L;
                if (ls_ticket.bytes != null) {
                    transfer_time = ls_ticket.bytes / rate_MB;
                }
                if (time_left - (extend_time = Math.max(transfer_time, 600L)) < 0L) {
                    logger.debug("AM: will extend end time by " + extend_time);
                } else {
                    logger.debug("AM: no need to extend end time");
                }
            }
        }
    }
}

