/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.srm.handler;

import java.net.URI;
import java.net.URISyntaxException;
import org.dcache.srm.AbstractStorageElement;
import org.dcache.srm.FileMetaData;
import org.dcache.srm.SRM;
import org.dcache.srm.SRMException;
import org.dcache.srm.SRMUser;
import org.dcache.srm.handler.PermissionMaskToTPermissionMode;
import org.dcache.srm.request.RequestCredential;
import org.dcache.srm.v2_2.ArrayOfTGroupPermission;
import org.dcache.srm.v2_2.ArrayOfTUserPermission;
import org.dcache.srm.v2_2.SrmSetPermissionRequest;
import org.dcache.srm.v2_2.SrmSetPermissionResponse;
import org.dcache.srm.v2_2.TGroupPermission;
import org.dcache.srm.v2_2.TPermissionMode;
import org.dcache.srm.v2_2.TPermissionType;
import org.dcache.srm.v2_2.TReturnStatus;
import org.dcache.srm.v2_2.TStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SrmSetPermission {
    private static Logger logger = LoggerFactory.getLogger(SrmSetPermission.class);
    AbstractStorageElement storage;
    SrmSetPermissionRequest request;
    SrmSetPermissionResponse response;
    SRMUser user;

    public SrmSetPermission(SRMUser user, RequestCredential credential, SrmSetPermissionRequest request, AbstractStorageElement storage, SRM srm, String client_host) {
        this.request = request;
        this.user = user;
        this.storage = storage;
    }

    public SrmSetPermissionResponse getResponse() {
        if (this.response != null) {
            return this.response;
        }
        try {
            this.response = this.srmSetPermission();
        }
        catch (URISyntaxException e) {
            logger.debug(" malformed uri : " + e.getMessage());
            this.response = SrmSetPermission.getFailedResponse(" malformed uri : " + e.getMessage(), TStatusCode.SRM_INVALID_REQUEST);
        }
        catch (SRMException srme) {
            logger.error(srme.toString());
            this.response = SrmSetPermission.getFailedResponse(srme.toString());
        }
        return this.response;
    }

    public static final SrmSetPermissionResponse getFailedResponse(String error) {
        return SrmSetPermission.getFailedResponse(error, null);
    }

    public static final SrmSetPermissionResponse getFailedResponse(String error, TStatusCode statusCode) {
        if (statusCode == null) {
            statusCode = TStatusCode.SRM_FAILURE;
        }
        TReturnStatus status = new TReturnStatus();
        status.setStatusCode(statusCode);
        status.setExplanation(error);
        SrmSetPermissionResponse response = new SrmSetPermissionResponse();
        response.setReturnStatus(status);
        return response;
    }

    public SrmSetPermissionResponse srmSetPermission() throws SRMException, URISyntaxException {
        SrmSetPermissionResponse response = new SrmSetPermissionResponse();
        TReturnStatus returnStatus = new TReturnStatus();
        returnStatus.setStatusCode(TStatusCode.SRM_SUCCESS);
        response.setReturnStatus(returnStatus);
        if (this.request == null) {
            return SrmSetPermission.getFailedResponse(" null request passed to SrmSetPermission()");
        }
        URI surl = new URI(this.request.getSURL().toString());
        try {
            int newPermissions;
            FileMetaData fmd = this.storage.getFileMetaData(this.user, surl, false);
            String owner = fmd.owner;
            int permissions = fmd.permMode;
            int groupid = Integer.parseInt(fmd.group);
            if (!fmd.isOwner(this.user)) {
                return SrmSetPermission.getFailedResponse("user " + this.user + " does not own file " + this.request.getSURL() + " Can't set permission", TStatusCode.SRM_AUTHORIZATION_FAILURE);
            }
            TPermissionType permissionType = this.request.getPermissionType();
            TPermissionMode ownerPermission = this.request.getOwnerPermission();
            ArrayOfTUserPermission arrayOfUserPermissions = this.request.getArrayOfUserPermissions();
            ArrayOfTGroupPermission arrayOfGroupPermissions = this.request.getArrayOfGroupPermissions();
            TPermissionMode otherPermission = this.request.getOtherPermission();
            TGroupPermission groupPermission = null;
            if (arrayOfUserPermissions != null) {
                return SrmSetPermission.getFailedResponse("ACLs are not supported by the dCACHE", TStatusCode.SRM_NOT_SUPPORTED);
            }
            if (arrayOfGroupPermissions != null && arrayOfGroupPermissions.getGroupPermissionArray() != null && arrayOfGroupPermissions.getGroupPermissionArray().length > 1) {
                return SrmSetPermission.getFailedResponse("ACLs are not supported by the dCACHE", TStatusCode.SRM_NOT_SUPPORTED);
            }
            if (arrayOfGroupPermissions != null && arrayOfGroupPermissions.getGroupPermissionArray() != null && arrayOfGroupPermissions.getGroupPermissionArray()[0] != null) {
                groupPermission = arrayOfGroupPermissions.getGroupPermissionArray()[0];
            }
            int iowner = permissions >> 6 & 7;
            int igroup = permissions >> 3 & 7;
            int iother = permissions & 7;
            int requestOwner = iowner;
            int requestGroup = igroup;
            int requestOther = iother;
            if (permissionType == TPermissionType.REMOVE) {
                requestOwner = 0;
                requestGroup = 0;
                requestOther = 0;
            }
            if (ownerPermission != null) {
                requestOwner = PermissionMaskToTPermissionMode.permissionModetoMask(ownerPermission);
            }
            if (otherPermission != null) {
                requestOther = PermissionMaskToTPermissionMode.permissionModetoMask(otherPermission);
            }
            if (groupPermission != null) {
                requestGroup = PermissionMaskToTPermissionMode.permissionModetoMask(groupPermission.getMode());
            }
            if (permissionType == TPermissionType.CHANGE) {
                iowner = requestOwner;
                igroup = requestGroup;
                iother = requestOther;
            } else if (permissionType == TPermissionType.ADD) {
                iowner |= requestOwner;
                igroup |= requestGroup;
                iother |= requestOther;
            } else if (permissionType == TPermissionType.REMOVE) {
                if (requestGroup != 0) {
                    igroup ^= requestGroup;
                }
                if (requestOther != 0) {
                    iother ^= requestOther;
                }
                if (requestOwner != 0) {
                    iowner ^= requestOwner;
                }
            }
            if ((permissionType == TPermissionType.ADD || permissionType == TPermissionType.CHANGE) && ownerPermission == null && otherPermission == null && groupPermission == null) {
                ownerPermission = TPermissionMode.R;
                otherPermission = TPermissionMode.R;
                iowner = PermissionMaskToTPermissionMode.permissionModetoMask(ownerPermission);
                iother = PermissionMaskToTPermissionMode.permissionModetoMask(otherPermission);
                if (arrayOfGroupPermissions != null && arrayOfGroupPermissions.getGroupPermissionArray() != null && arrayOfGroupPermissions.getGroupPermissionArray()[0] == null) {
                    groupPermission = new TGroupPermission(fmd.group, TPermissionMode.R);
                    igroup = PermissionMaskToTPermissionMode.permissionModetoMask(groupPermission.getMode());
                }
            }
            fmd.permMode = newPermissions = iowner << 6 | igroup << 3 | iother;
            try {
                this.storage.setFileMetaData(this.user, fmd);
            }
            catch (SRMException e) {
                logger.warn(e.toString());
                return SrmSetPermission.getFailedResponse(e.getMessage(), TStatusCode.SRM_FAILURE);
            }
        }
        catch (SRMException srme) {
            logger.warn(srme.toString());
            return SrmSetPermission.getFailedResponse(srme.getMessage(), TStatusCode.SRM_FAILURE);
        }
        response.getReturnStatus().setStatusCode(TStatusCode.SRM_SUCCESS);
        response.getReturnStatus().setExplanation("success");
        return response;
    }
}

