/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.srm.handler;

import org.apache.axis.types.URI;
import org.apache.axis.types.UnsignedLong;
import org.dcache.srm.AbstractStorageElement;
import org.dcache.srm.SRM;
import org.dcache.srm.SRMException;
import org.dcache.srm.SRMUser;
import org.dcache.srm.request.PutRequest;
import org.dcache.srm.request.RequestCredential;
import org.dcache.srm.util.Configuration;
import org.dcache.srm.util.Tools;
import org.dcache.srm.v2_2.ArrayOfTPutRequestFileStatus;
import org.dcache.srm.v2_2.SrmPrepareToPutRequest;
import org.dcache.srm.v2_2.SrmPrepareToPutResponse;
import org.dcache.srm.v2_2.TAccessLatency;
import org.dcache.srm.v2_2.TExtraInfo;
import org.dcache.srm.v2_2.TFileStorageType;
import org.dcache.srm.v2_2.TOverwriteMode;
import org.dcache.srm.v2_2.TPutFileRequest;
import org.dcache.srm.v2_2.TPutRequestFileStatus;
import org.dcache.srm.v2_2.TRetentionPolicy;
import org.dcache.srm.v2_2.TReturnStatus;
import org.dcache.srm.v2_2.TStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SrmPrepareToPut {
    private static Logger logger = LoggerFactory.getLogger(SrmPrepareToPut.class);
    private static final String SFN_STRING = "?SFN=";
    AbstractStorageElement storage;
    SrmPrepareToPutRequest request;
    SrmPrepareToPutResponse response;
    SRMUser user;
    RequestCredential credential;
    Configuration configuration;
    String client_host;
    boolean longFormat = false;
    String servicePathAndSFNPart = "";
    int port;
    String host;
    private static final String[] emptyArr = new String[0];

    public SrmPrepareToPut(SRMUser user, RequestCredential credential, SrmPrepareToPutRequest request, AbstractStorageElement storage, SRM srm, String client_host) {
        if (request == null) {
            throw new NullPointerException("request is null");
        }
        this.request = request;
        this.user = user;
        this.credential = credential;
        if (storage == null) {
            throw new NullPointerException("storage is null");
        }
        this.storage = storage;
        this.configuration = srm.getConfiguration();
        if (this.configuration == null) {
            throw new NullPointerException("configuration is null");
        }
        this.client_host = client_host;
    }

    public SrmPrepareToPutResponse getResponse() {
        if (this.response != null) {
            return this.response;
        }
        try {
            this.response = this.srmPrepareToPut();
        }
        catch (URI.MalformedURIException mue) {
            logger.debug(" malformed uri : " + mue.getMessage());
            this.response = SrmPrepareToPut.getFailedResponse(" malformed uri : " + mue.getMessage(), TStatusCode.SRM_INVALID_REQUEST);
        }
        catch (SRMException srme) {
            logger.error(srme.toString());
            this.response = SrmPrepareToPut.getFailedResponse(srme.toString());
        }
        return this.response;
    }

    public static final SrmPrepareToPutResponse getFailedResponse(String error) {
        return SrmPrepareToPut.getFailedResponse(error, null);
    }

    public static final SrmPrepareToPutResponse getFailedResponse(String error, TStatusCode statusCode) {
        if (statusCode == null) {
            statusCode = TStatusCode.SRM_FAILURE;
        }
        TReturnStatus status = new TReturnStatus();
        status.setStatusCode(statusCode);
        status.setExplanation(error);
        SrmPrepareToPutResponse srmPrepareToPutResponse = new SrmPrepareToPutResponse();
        srmPrepareToPutResponse.setReturnStatus(status);
        return srmPrepareToPutResponse;
    }

    public SrmPrepareToPutResponse srmPrepareToPut() throws SRMException, URI.MalformedURIException {
        int i;
        TOverwriteMode overwriteMode;
        long reqLifetime;
        String[] clientNetworks;
        TFileStorageType storageType = this.request.getDesiredFileStorageType();
        if (storageType != null && !storageType.equals(TFileStorageType.PERMANENT)) {
            return SrmPrepareToPut.getFailedResponse("DesiredFileStorageType " + storageType + " is not supported", TStatusCode.SRM_NOT_SUPPORTED);
        }
        String[] protocols = null;
        if (this.request.getTransferParameters() != null && this.request.getTransferParameters().getArrayOfTransferProtocols() != null) {
            protocols = this.request.getTransferParameters().getArrayOfTransferProtocols().getStringArray();
        }
        if ((protocols = Tools.trimStringArray(protocols)) == null || protocols.length < 1) {
            return SrmPrepareToPut.getFailedResponse("request contains no transfer protocols");
        }
        if (this.request.getTransferParameters() != null && this.request.getTransferParameters().getArrayOfClientNetworks() != null && (clientNetworks = this.request.getTransferParameters().getArrayOfClientNetworks().getStringArray()) != null && clientNetworks.length > 0 && clientNetworks[0] != null) {
            this.client_host = clientNetworks[0];
        }
        String spaceToken = this.request.getTargetSpaceToken();
        TRetentionPolicy retentionPolicy = null;
        TAccessLatency accessLatency = null;
        if (this.request.getTargetFileRetentionPolicyInfo() != null) {
            retentionPolicy = this.request.getTargetFileRetentionPolicyInfo().getRetentionPolicy();
            accessLatency = this.request.getTargetFileRetentionPolicyInfo().getAccessLatency();
        }
        TPutFileRequest[] fileRequests = null;
        if (this.request.getArrayOfFileRequests() != null) {
            fileRequests = this.request.getArrayOfFileRequests().getRequestArray();
        }
        if (fileRequests == null || fileRequests.length < 1) {
            return SrmPrepareToPut.getFailedResponse("request contains no file requests");
        }
        String[] srcFileNames = new String[fileRequests.length];
        String[] destUrls = new String[fileRequests.length];
        long[] sizes = new long[fileRequests.length];
        boolean[] wantPermanent = new boolean[fileRequests.length];
        long lifetimeInSeconds = 0L;
        if (this.request.getDesiredTotalRequestTime() != null && lifetimeInSeconds < (reqLifetime = (long)this.request.getDesiredTotalRequestTime().intValue())) {
            lifetimeInSeconds = reqLifetime;
        }
        if ((overwriteMode = this.request.getOverwriteOption()) != null && overwriteMode.equals(TOverwriteMode.WHEN_FILES_ARE_DIFFERENT)) {
            return SrmPrepareToPut.getFailedResponse("Overwrite Mode WHEN_FILES_ARE_DIFFERENT is not supported", TStatusCode.SRM_NOT_SUPPORTED);
        }
        String[] supportedProtocols = this.storage.supportedPutProtocols();
        boolean foundMatchedProtocol = false;
        block2: for (i = 0; i < supportedProtocols.length; ++i) {
            for (int j = 0; j < protocols.length; ++j) {
                if (!supportedProtocols[i].equals(protocols[j])) continue;
                foundMatchedProtocol = true;
                continue block2;
            }
        }
        if (!foundMatchedProtocol) {
            TReturnStatus status = new TReturnStatus();
            status.setStatusCode(TStatusCode.SRM_NOT_SUPPORTED);
            StringBuffer errorsb = new StringBuffer("Protocol(s) specified not supported: [ ");
            for (String protocol : protocols) {
                errorsb.append(protocol).append(' ');
            }
            errorsb.append(']');
            status.setExplanation(errorsb.toString());
            SrmPrepareToPutResponse srmPrepareToPutResponse = new SrmPrepareToPutResponse();
            srmPrepareToPutResponse.setReturnStatus(status);
            TPutRequestFileStatus[] statusArray = new TPutRequestFileStatus[fileRequests.length];
            for (int i2 = 0; i2 < fileRequests.length; ++i2) {
                TPutFileRequest fr = fileRequests[i2];
                if (fr == null || fr.getTargetSURL() == null) continue;
                TPutRequestFileStatus fileStatus = new TPutRequestFileStatus();
                TReturnStatus fileReturnStatus = new TReturnStatus();
                fileReturnStatus.setStatusCode(TStatusCode.SRM_FAILURE);
                fileReturnStatus.setExplanation(errorsb.toString());
                fileStatus.setSURL(fr.getTargetSURL());
                fileStatus.setStatus(fileReturnStatus);
                statusArray[i2] = fileStatus;
            }
            ArrayOfTPutRequestFileStatus arrayOfFileStatuses = new ArrayOfTPutRequestFileStatus(statusArray);
            srmPrepareToPutResponse.setArrayOfFileStatuses(arrayOfFileStatuses);
            return srmPrepareToPutResponse;
        }
        for (i = 0; i < fileRequests.length; ++i) {
            TPutFileRequest nextRequest = fileRequests[i];
            if (nextRequest == null) {
                return SrmPrepareToPut.getFailedResponse("file request #" + i + " is null");
            }
            String nextSurl = null;
            if (nextRequest.getTargetSURL() != null) {
                nextSurl = nextRequest.getTargetSURL().toString();
            }
            if (nextSurl == null) {
                return SrmPrepareToPut.getFailedResponse("can't get surl of file request #" + i + "  null");
            }
            UnsignedLong knownSize = nextRequest.getExpectedFileSize();
            if (knownSize != null) {
                sizes[i] = knownSize.longValue();
            }
            wantPermanent[i] = true;
            srcFileNames[i] = nextSurl;
            destUrls[i] = nextSurl;
        }
        long lifetime = lifetimeInSeconds > 0L ? (lifetimeInSeconds * 1000L > this.configuration.getPutLifetime() ? this.configuration.getPutLifetime() : lifetimeInSeconds * 1000L) : this.configuration.getPutLifetime();
        try {
            PutRequest r = new PutRequest(this.user, this.credential.getId(), srcFileNames, destUrls, sizes, wantPermanent, protocols, lifetime, this.configuration.getGetRetryTimeout(), this.configuration.getGetMaxNumOfRetries(), this.client_host, spaceToken, retentionPolicy, accessLatency, this.request.getUserRequestDescription());
            if (this.request.getStorageSystemInfo() != null && this.request.getStorageSystemInfo().getExtraInfoArray() != null && this.request.getStorageSystemInfo().getExtraInfoArray().length > 0) {
                for (int i3 = 0; i3 < this.request.getStorageSystemInfo().getExtraInfoArray().length; ++i3) {
                    TExtraInfo extraInfo = this.request.getStorageSystemInfo().getExtraInfoArray()[i3];
                    if (!extraInfo.getKey().equals("priority")) continue;
                    int priority = Integer.parseInt(extraInfo.getValue());
                    r.setPriority(priority);
                }
            }
            if (overwriteMode != null) {
                r.setOverwriteMode(overwriteMode);
            }
            r.schedule();
            return r.getSrmPrepareToPutResponse(this.configuration.getPutSwitchToAsynchronousModeDelay());
        }
        catch (Exception e) {
            logger.warn(e.toString());
            return SrmPrepareToPut.getFailedResponse(e.toString());
        }
    }
}

