/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.srm.handler;

import org.apache.axis.types.URI;
import org.dcache.srm.AbstractStorageElement;
import org.dcache.srm.SRM;
import org.dcache.srm.SRMException;
import org.dcache.srm.SRMUser;
import org.dcache.srm.request.GetRequest;
import org.dcache.srm.request.RequestCredential;
import org.dcache.srm.util.Configuration;
import org.dcache.srm.util.Tools;
import org.dcache.srm.v2_2.ArrayOfTGetRequestFileStatus;
import org.dcache.srm.v2_2.SrmPrepareToGetRequest;
import org.dcache.srm.v2_2.SrmPrepareToGetResponse;
import org.dcache.srm.v2_2.TExtraInfo;
import org.dcache.srm.v2_2.TGetFileRequest;
import org.dcache.srm.v2_2.TGetRequestFileStatus;
import org.dcache.srm.v2_2.TReturnStatus;
import org.dcache.srm.v2_2.TStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SrmPrepareToGet {
    private static Logger logger = LoggerFactory.getLogger(SrmPrepareToGet.class);
    private static final String SFN_STRING = "?SFN=";
    AbstractStorageElement storage;
    SrmPrepareToGetRequest request;
    SrmPrepareToGetResponse response;
    SRMUser user;
    RequestCredential credential;
    Configuration configuration;
    private int results_num;
    private int max_results_num;
    int numOfLevels = 0;
    private String client_host;
    boolean longFormat = false;
    String servicePathAndSFNPart = "";
    int port;
    String host;
    private static final String[] emptyArr = new String[0];

    public SrmPrepareToGet(SRMUser user, RequestCredential credential, SrmPrepareToGetRequest request, AbstractStorageElement storage, SRM srm, String client_host) {
        if (request == null) {
            throw new NullPointerException("request is null");
        }
        this.request = request;
        this.user = user;
        this.credential = credential;
        this.client_host = client_host;
        if (storage == null) {
            throw new NullPointerException("storage is null");
        }
        this.storage = storage;
        this.configuration = srm.getConfiguration();
        if (this.configuration == null) {
            throw new NullPointerException("configuration is null");
        }
    }

    public SrmPrepareToGetResponse getResponse() {
        if (this.response != null) {
            return this.response;
        }
        try {
            this.response = this.srmPrepareToGet();
        }
        catch (URI.MalformedURIException mue) {
            logger.debug(" malformed uri : " + mue.getMessage());
            this.response = SrmPrepareToGet.getFailedResponse(" malformed uri : " + mue.getMessage(), TStatusCode.SRM_INVALID_REQUEST);
        }
        catch (SRMException srme) {
            logger.error(srme.toString());
            this.response = SrmPrepareToGet.getFailedResponse(srme.toString());
        }
        return this.response;
    }

    public static final SrmPrepareToGetResponse getFailedResponse(String error) {
        return SrmPrepareToGet.getFailedResponse(error, null);
    }

    public static final SrmPrepareToGetResponse getFailedResponse(String error, TStatusCode statusCode) {
        if (statusCode == null) {
            statusCode = TStatusCode.SRM_FAILURE;
        }
        TReturnStatus status = new TReturnStatus();
        status.setStatusCode(statusCode);
        status.setExplanation(error);
        SrmPrepareToGetResponse srmPrepareToGetResponse = new SrmPrepareToGetResponse();
        srmPrepareToGetResponse.setReturnStatus(status);
        return srmPrepareToGetResponse;
    }

    public SrmPrepareToGetResponse srmPrepareToGet() throws SRMException, URI.MalformedURIException {
        int i;
        long reqLifetime;
        String[] clientNetworks;
        String[] protocols = null;
        if (this.request.getTransferParameters() != null && this.request.getTransferParameters().getArrayOfTransferProtocols() != null) {
            protocols = this.request.getTransferParameters().getArrayOfTransferProtocols().getStringArray();
        }
        if ((protocols = Tools.trimStringArray(protocols)) == null || protocols.length < 1) {
            return SrmPrepareToGet.getFailedResponse("request contains no transfer protocols");
        }
        if (this.request.getTransferParameters() != null && this.request.getTransferParameters().getArrayOfClientNetworks() != null && (clientNetworks = this.request.getTransferParameters().getArrayOfClientNetworks().getStringArray()) != null && clientNetworks.length > 0 && clientNetworks[0] != null) {
            this.client_host = clientNetworks[0];
        }
        TGetFileRequest[] fileRequests = null;
        if (this.request.getArrayOfFileRequests() != null) {
            fileRequests = this.request.getArrayOfFileRequests().getRequestArray();
        }
        if (fileRequests == null || fileRequests.length < 1) {
            return SrmPrepareToGet.getFailedResponse("request contains no file requests");
        }
        String[] surls = new String[fileRequests.length];
        long lifetimeInSeconds = 0L;
        if (this.request.getDesiredTotalRequestTime() != null && lifetimeInSeconds < (reqLifetime = (long)this.request.getDesiredTotalRequestTime().intValue())) {
            lifetimeInSeconds = reqLifetime;
        }
        String[] supportedProtocols = this.storage.supportedGetProtocols();
        boolean foundMatchedProtocol = false;
        block2: for (i = 0; i < supportedProtocols.length; ++i) {
            for (int j = 0; j < protocols.length; ++j) {
                if (!supportedProtocols[i].equals(protocols[j])) continue;
                foundMatchedProtocol = true;
                continue block2;
            }
        }
        if (!foundMatchedProtocol) {
            TReturnStatus status = new TReturnStatus();
            status.setStatusCode(TStatusCode.SRM_NOT_SUPPORTED);
            StringBuffer errorsb = new StringBuffer("Protocol(s) specified not supported: [ ");
            for (String protocol : protocols) {
                errorsb.append(protocol).append(' ');
            }
            errorsb.append(']');
            status.setExplanation(errorsb.toString());
            SrmPrepareToGetResponse srmPrepareToGetResponse = new SrmPrepareToGetResponse();
            srmPrepareToGetResponse.setReturnStatus(status);
            TGetRequestFileStatus[] statusArray = new TGetRequestFileStatus[fileRequests.length];
            for (int i2 = 0; i2 < fileRequests.length; ++i2) {
                TGetFileRequest fr = fileRequests[i2];
                if (fr == null || fr.getSourceSURL() == null) continue;
                TGetRequestFileStatus fileStatus = new TGetRequestFileStatus();
                TReturnStatus fileReturnStatus = new TReturnStatus();
                fileReturnStatus.setStatusCode(TStatusCode.SRM_FAILURE);
                fileReturnStatus.setExplanation(errorsb.toString());
                fileStatus.setSourceSURL(fr.getSourceSURL());
                fileStatus.setStatus(fileReturnStatus);
                statusArray[i2] = fileStatus;
            }
            ArrayOfTGetRequestFileStatus arrayOfFileStatuses = new ArrayOfTGetRequestFileStatus(statusArray);
            srmPrepareToGetResponse.setArrayOfFileStatuses(arrayOfFileStatuses);
            return srmPrepareToGetResponse;
        }
        for (i = 0; i < fileRequests.length; ++i) {
            TGetFileRequest nextRequest = fileRequests[i];
            if (nextRequest == null) {
                return SrmPrepareToGet.getFailedResponse("file request #" + i + " is null", TStatusCode.SRM_INVALID_REQUEST);
            }
            String nextSurl = null;
            if (nextRequest.getSourceSURL() != null) {
                nextSurl = nextRequest.getSourceSURL().toString();
            }
            if (nextSurl == null) {
                return SrmPrepareToGet.getFailedResponse("can't get surl of file request #" + i + "  null", TStatusCode.SRM_INVALID_REQUEST);
            }
            surls[i] = nextSurl;
        }
        long lifetime = lifetimeInSeconds > 0L ? (lifetimeInSeconds * 1000L > this.configuration.getGetLifetime() ? this.configuration.getGetLifetime() : lifetimeInSeconds * 1000L) : this.configuration.getGetLifetime();
        try {
            GetRequest r = new GetRequest(this.user, this.credential.getId(), surls, protocols, lifetime, this.configuration.getGetRetryTimeout(), this.configuration.getGetMaxNumOfRetries(), this.request.getUserRequestDescription(), this.client_host);
            if (this.request.getStorageSystemInfo() != null && this.request.getStorageSystemInfo().getExtraInfoArray() != null && this.request.getStorageSystemInfo().getExtraInfoArray().length > 0) {
                for (int i3 = 0; i3 < this.request.getStorageSystemInfo().getExtraInfoArray().length; ++i3) {
                    TExtraInfo extraInfo = this.request.getStorageSystemInfo().getExtraInfoArray()[i3];
                    if (!extraInfo.getKey().equals("priority")) continue;
                    int priority = Integer.parseInt(extraInfo.getValue());
                    r.setPriority(priority);
                }
            }
            r.schedule();
            return r.getSrmPrepareToGetResponse(this.configuration.getGetSwitchToAsynchronousModeDelay());
        }
        catch (Exception e) {
            logger.warn(e.toString());
            return SrmPrepareToGet.getFailedResponse(e.toString());
        }
    }
}

