/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.srm.handler;

import org.dcache.srm.AbstractStorageElement;
import org.dcache.srm.SRM;
import org.dcache.srm.SRMUser;
import org.dcache.srm.request.RequestCredential;
import org.dcache.srm.v2_2.ArrayOfTExtraInfo;
import org.dcache.srm.v2_2.SrmPingRequest;
import org.dcache.srm.v2_2.SrmPingResponse;
import org.dcache.srm.v2_2.TExtraInfo;
import org.dcache.srm.v2_2.TStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SrmPing {
    private static Logger logger = LoggerFactory.getLogger(SrmPing.class);
    private static final String SFN_STRING = "?SFN=";
    AbstractStorageElement storage;
    SRMUser user;
    RequestCredential credential;
    SrmPingRequest request;
    SrmPingResponse response;

    public SrmPing(SRMUser user, RequestCredential credential, SrmPingRequest request, AbstractStorageElement storage, SRM srm, String client_host) {
        if (request == null) {
            throw new NullPointerException("request is null");
        }
        this.request = request;
        this.user = user;
        this.credential = credential;
        if (storage == null) {
            throw new NullPointerException("storage is null");
        }
        this.storage = storage;
    }

    public SrmPingResponse getResponse() {
        if (this.response != null) {
            return this.response;
        }
        this.response = new SrmPingResponse();
        this.response.setVersionInfo("v2.2");
        this.response.setOtherInfo(new ArrayOfTExtraInfo(new TExtraInfo[]{new TExtraInfo("backend_type", "dCache"), new TExtraInfo("backend_version", this.storage.getStorageBackendVersion())}));
        return this.response;
    }

    public static final SrmPingResponse getFailedResponse(String text) {
        return SrmPing.getFailedResponse(text, null);
    }

    public static final SrmPingResponse getFailedResponse(String text, TStatusCode statusCode) {
        if (statusCode == null) {
            statusCode = TStatusCode.SRM_FAILURE;
        }
        SrmPingResponse response = new SrmPingResponse();
        response.setVersionInfo("v2.2");
        response.setOtherInfo(new ArrayOfTExtraInfo(new TExtraInfo[]{new TExtraInfo("backend_type", "dCache")}));
        return response;
    }
}

