/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.srm.handler;

import java.sql.SQLException;
import org.apache.axis.types.URI;
import org.dcache.srm.AbstractStorageElement;
import org.dcache.srm.SRM;
import org.dcache.srm.SRMException;
import org.dcache.srm.SRMInvalidRequestException;
import org.dcache.srm.SRMUser;
import org.dcache.srm.request.ContainerRequest;
import org.dcache.srm.request.RequestCredential;
import org.dcache.srm.scheduler.IllegalStateTransition;
import org.dcache.srm.scheduler.Job;
import org.dcache.srm.util.Configuration;
import org.dcache.srm.v2_2.ArrayOfTRequestSummary;
import org.dcache.srm.v2_2.SrmGetRequestSummaryRequest;
import org.dcache.srm.v2_2.SrmGetRequestSummaryResponse;
import org.dcache.srm.v2_2.TRequestSummary;
import org.dcache.srm.v2_2.TReturnStatus;
import org.dcache.srm.v2_2.TStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SrmGetRequestSummary {
    private static Logger logger = LoggerFactory.getLogger(SrmGetRequestSummary.class);
    private static final String SFN_STRING = "?SFN=";
    AbstractStorageElement storage;
    SrmGetRequestSummaryRequest srmGetRequestSummaryRequest;
    SrmGetRequestSummaryResponse response;
    SRMUser user;
    RequestCredential credential;
    Configuration configuration;
    private int results_num;
    private int max_results_num;
    int numOfLevels = 0;
    boolean longFormat = false;
    String servicePathAndSFNPart = "";
    int port;
    String host;

    public SrmGetRequestSummary(SRMUser user, RequestCredential credential, SrmGetRequestSummaryRequest srmGetRequestSummaryRequest, AbstractStorageElement storage, SRM srm, String client_host) {
        this.srmGetRequestSummaryRequest = srmGetRequestSummaryRequest;
        this.user = user;
        this.credential = credential;
        this.storage = storage;
        this.configuration = srm.getConfiguration();
    }

    public SrmGetRequestSummaryResponse getResponse() {
        if (this.response != null) {
            return this.response;
        }
        try {
            this.response = this.srmGetRequestSummary();
        }
        catch (URI.MalformedURIException mue) {
            logger.debug(" malformed uri : " + mue.getMessage());
            this.response = SrmGetRequestSummary.getFailedResponse(" malformed uri : " + mue.getMessage(), TStatusCode.SRM_INVALID_REQUEST);
        }
        catch (SQLException sqle) {
            logger.error(sqle.toString());
            this.response = SrmGetRequestSummary.getFailedResponse("sql error " + sqle.getMessage(), TStatusCode.SRM_INTERNAL_ERROR);
        }
        catch (SRMInvalidRequestException e) {
            logger.debug(e.getMessage());
            this.response = SrmGetRequestSummary.getFailedResponse(e.getMessage(), TStatusCode.SRM_INVALID_REQUEST);
        }
        catch (SRMException srme) {
            logger.error(srme.toString());
            this.response = SrmGetRequestSummary.getFailedResponse(srme.toString());
        }
        catch (IllegalStateTransition ist) {
            logger.error("Illegal State Transition : " + ist.getMessage());
            this.response = SrmGetRequestSummary.getFailedResponse("Illegal State Transition : " + ist.getMessage());
        }
        return this.response;
    }

    public static final SrmGetRequestSummaryResponse getFailedResponse(String error) {
        return SrmGetRequestSummary.getFailedResponse(error, null);
    }

    public static final SrmGetRequestSummaryResponse getFailedResponse(String error, TStatusCode statusCode) {
        if (statusCode == null) {
            statusCode = TStatusCode.SRM_FAILURE;
        }
        TReturnStatus status = new TReturnStatus();
        status.setStatusCode(statusCode);
        status.setExplanation(error);
        SrmGetRequestSummaryResponse srmGetRequestSummaryResponse = new SrmGetRequestSummaryResponse();
        srmGetRequestSummaryResponse.setReturnStatus(status);
        return srmGetRequestSummaryResponse;
    }

    public SrmGetRequestSummaryResponse srmGetRequestSummary() throws SRMException, URI.MalformedURIException, SQLException, IllegalStateTransition {
        String[] requestTokens = this.srmGetRequestSummaryRequest.getArrayOfRequestTokens().getStringArray();
        if (requestTokens == null) {
            return SrmGetRequestSummary.getFailedResponse("request contains no request tokens");
        }
        Long[] requestIds = new Long[requestTokens.length];
        TRequestSummary[] requestSummaries = new TRequestSummary[requestTokens.length];
        for (int i = 0; i < requestTokens.length; ++i) {
            String requestToken = requestTokens[i];
            try {
                requestIds[i] = new Long(requestToken);
                ContainerRequest request = Job.getJob(requestIds[i], ContainerRequest.class);
                requestSummaries[i] = request.getRequestSummary();
                continue;
            }
            catch (NumberFormatException nfe) {
                requestSummaries[i].setStatus(new TReturnStatus(TStatusCode.SRM_INVALID_REQUEST, " requestToken \"" + requestToken + "\" is not valid"));
                continue;
            }
            catch (SRMInvalidRequestException e) {
                requestSummaries[i].setStatus(new TReturnStatus(TStatusCode.SRM_INVALID_REQUEST, e.getMessage()));
            }
        }
        SrmGetRequestSummaryResponse response = new SrmGetRequestSummaryResponse();
        TReturnStatus status = new TReturnStatus();
        status.setStatusCode(TStatusCode.SRM_SUCCESS);
        response.setArrayOfRequestSummaries(new ArrayOfTRequestSummary(requestSummaries));
        response.setReturnStatus(status);
        return response;
    }
}

