/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.srm.handler;

import java.net.URI;
import java.net.URISyntaxException;
import org.dcache.srm.AbstractStorageElement;
import org.dcache.srm.SRM;
import org.dcache.srm.SRMException;
import org.dcache.srm.SRMUser;
import org.dcache.srm.request.BringOnlineRequest;
import org.dcache.srm.request.RequestCredential;
import org.dcache.srm.util.Configuration;
import org.dcache.srm.util.Tools;
import org.dcache.srm.v2_2.SrmBringOnlineRequest;
import org.dcache.srm.v2_2.SrmBringOnlineResponse;
import org.dcache.srm.v2_2.TExtraInfo;
import org.dcache.srm.v2_2.TGetFileRequest;
import org.dcache.srm.v2_2.TReturnStatus;
import org.dcache.srm.v2_2.TStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SrmBringOnline {
    private static Logger logger = LoggerFactory.getLogger(SrmBringOnline.class);
    private static final String SFN_STRING = "?SFN=";
    AbstractStorageElement storage;
    SrmBringOnlineRequest request;
    SrmBringOnlineResponse response;
    SRMUser user;
    RequestCredential credential;
    Configuration configuration;
    private int results_num;
    private int max_results_num;
    int numOfLevels = 0;
    String client_host;
    boolean longFormat = false;
    String servicePathAndSFNPart = "";
    int port;
    String host;

    public SrmBringOnline(SRMUser user, RequestCredential credential, SrmBringOnlineRequest request, AbstractStorageElement storage, SRM srm, String client_host) {
        if (request == null) {
            throw new NullPointerException("request is null");
        }
        this.request = request;
        this.user = user;
        this.client_host = client_host;
        this.credential = credential;
        if (storage == null) {
            throw new NullPointerException("storage is null");
        }
        this.storage = storage;
        this.configuration = srm.getConfiguration();
        if (this.configuration == null) {
            throw new NullPointerException("configuration is null");
        }
    }

    public SrmBringOnlineResponse getResponse() {
        if (this.response != null) {
            return this.response;
        }
        try {
            this.response = this.srmBringOnline();
        }
        catch (URISyntaxException e) {
            logger.debug(" malformed uri : " + e.getMessage());
            this.response = SrmBringOnline.getFailedResponse(" malformed uri : " + e.getMessage(), TStatusCode.SRM_INVALID_REQUEST);
        }
        catch (SRMException srme) {
            logger.error(srme.toString());
            this.response = SrmBringOnline.getFailedResponse(srme.toString());
        }
        return this.response;
    }

    public static final SrmBringOnlineResponse getFailedResponse(String error) {
        return SrmBringOnline.getFailedResponse(error, null);
    }

    public static final SrmBringOnlineResponse getFailedResponse(String error, TStatusCode statusCode) {
        if (statusCode == null) {
            statusCode = TStatusCode.SRM_FAILURE;
        }
        TReturnStatus status = new TReturnStatus();
        status.setStatusCode(statusCode);
        status.setExplanation(error);
        SrmBringOnlineResponse srmBringOnlineResponse = new SrmBringOnlineResponse();
        srmBringOnlineResponse.setReturnStatus(status);
        return srmBringOnlineResponse;
    }

    public SrmBringOnlineResponse srmBringOnline() throws SRMException, URISyntaxException {
        long lifetime;
        long reqLifetime;
        String[] clientNetworks;
        String[] protocols = null;
        if (this.request.getTransferParameters() != null && this.request.getTransferParameters().getArrayOfTransferProtocols() != null) {
            protocols = this.request.getTransferParameters().getArrayOfTransferProtocols().getStringArray();
        }
        protocols = Tools.trimStringArray(protocols);
        if (this.request.getTransferParameters() != null && this.request.getTransferParameters().getArrayOfClientNetworks() != null && (clientNetworks = this.request.getTransferParameters().getArrayOfClientNetworks().getStringArray()) != null && clientNetworks.length > 0 && clientNetworks[0] != null) {
            this.client_host = clientNetworks[0];
        }
        TGetFileRequest[] fileRequests = null;
        if (this.request.getArrayOfFileRequests() != null) {
            fileRequests = this.request.getArrayOfFileRequests().getRequestArray();
        }
        if (fileRequests == null || fileRequests.length < 1) {
            return SrmBringOnline.getFailedResponse("request contains no file requests", TStatusCode.SRM_INVALID_REQUEST);
        }
        URI[] surls = new URI[fileRequests.length];
        long lifetimeInSeconds = 0L;
        if (this.request.getDesiredTotalRequestTime() != null && lifetimeInSeconds < (reqLifetime = (long)this.request.getDesiredTotalRequestTime().intValue())) {
            lifetimeInSeconds = reqLifetime;
        }
        long l = lifetime = lifetimeInSeconds > 0L ? lifetimeInSeconds * 1000L : this.configuration.getBringOnlineLifetime();
        long desiredLietimeInSeconds = this.request.getDesiredLifeTime() != null && this.request.getDesiredLifeTime() != 0 ? (long)this.request.getDesiredLifeTime().intValue() : (lifetimeInSeconds > 0L ? lifetimeInSeconds : this.configuration.getBringOnlineLifetime() / 1000L);
        for (int i = 0; i < fileRequests.length; ++i) {
            TGetFileRequest nextRequest = fileRequests[i];
            if (nextRequest == null) {
                return SrmBringOnline.getFailedResponse("file request #" + i + " is null", TStatusCode.SRM_INVALID_REQUEST);
            }
            if (nextRequest.getSourceSURL() == null) {
                return SrmBringOnline.getFailedResponse("can't get surl of file request #" + i + "  null", TStatusCode.SRM_INVALID_REQUEST);
            }
            surls[i] = new URI(nextRequest.getSourceSURL().toString());
        }
        try {
            BringOnlineRequest r = new BringOnlineRequest(this.user, this.credential.getId(), surls, protocols, lifetime, desiredLietimeInSeconds, this.configuration.getGetRetryTimeout(), this.configuration.getGetMaxNumOfRetries(), this.request.getUserRequestDescription(), this.client_host);
            if (this.request.getStorageSystemInfo() != null && this.request.getStorageSystemInfo().getExtraInfoArray() != null && this.request.getStorageSystemInfo().getExtraInfoArray().length > 0) {
                for (int i = 0; i < this.request.getStorageSystemInfo().getExtraInfoArray().length; ++i) {
                    TExtraInfo extraInfo = this.request.getStorageSystemInfo().getExtraInfoArray()[i];
                    if (!extraInfo.getKey().equals("priority")) continue;
                    int priority = Integer.parseInt(extraInfo.getValue());
                    r.setPriority(priority);
                }
            }
            r.schedule();
            return r.getSrmBringOnlineResponse(this.configuration.getBringOnlineSwitchToAsynchronousModeDelay());
        }
        catch (Exception e) {
            logger.error(e.toString());
            return SrmBringOnline.getFailedResponse(e.toString());
        }
    }
}

