/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.srm.client;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.dcache.srm.AbstractStorageElement;
import org.dcache.srm.SRMException;
import org.dcache.srm.client.RequestFailedEvent;
import org.dcache.srm.client.TURLsArrivedEvent;
import org.dcache.srm.client.TURLsGetFailedEvent;
import org.dcache.srm.request.RequestCredential;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TurlGetterPutter
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(TurlGetterPutter.class);
    private PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);
    protected AbstractStorageElement storage;
    protected RequestCredential credential;
    protected String[] protocols;
    private boolean stopped = false;

    public void notifyOfTURL(String SURL2, String TURL, String requestId, String fileId, Long size) {
        logger.debug("notifyOfTURL( surl=" + SURL2 + " , turl=" + TURL + ")");
        this.changeSupport.firePropertyChange(new TURLsArrivedEvent(this, SURL2, TURL, requestId, fileId, size));
    }

    public void notifyOfFailure(String SURL2, Object reason, String requestId, String fileId) {
        this.changeSupport.firePropertyChange(new TURLsGetFailedEvent(this, SURL2, reason, requestId, fileId));
    }

    public void notifyOfFailure(Object reason) {
        this.changeSupport.firePropertyChange(new RequestFailedEvent(this, reason));
    }

    public void addListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public TurlGetterPutter(AbstractStorageElement storage, RequestCredential credential, String[] protocols) {
        this.storage = storage;
        this.credential = credential;
        this.protocols = protocols;
    }

    public abstract void getInitialRequest() throws SRMException;

    public boolean isStopped() {
        return this.stopped;
    }

    public void stop() {
        this.stopped = true;
    }
}

