/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.srm.client;

public enum Transport {
    TCP,
    GSI,
    SSL;

    private static final String COMMA_SEPARATED_LIST;

    public static Transport transportFor(String name) {
        for (Transport t : Transport.values()) {
            if (!t.name().equalsIgnoreCase(name)) continue;
            return t;
        }
        throw new IllegalArgumentException("Unknown Transport " + name + ", value not from {" + COMMA_SEPARATED_LIST + "}");
    }

    static {
        StringBuilder sb = new StringBuilder();
        Transport[] transports = Transport.values();
        Transport lastTransport = transports[transports.length - 1];
        for (Transport transport : transports) {
            sb.append(transport.name());
            if (transport == lastTransport) continue;
            sb.append(", ");
        }
        COMMA_SEPARATED_LIST = sb.toString();
    }
}

