/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.srm.client;

import diskCacheV111.srm.ISRM;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.rmi.RemoteException;
import javax.xml.rpc.ServiceException;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.Handler;
import org.apache.axis.SimpleTargetedChain;
import org.apache.axis.client.Stub;
import org.apache.axis.configuration.SimpleProvider;
import org.apache.axis.transport.http.HTTPSender;
import org.dcache.srm.client.ConvertUtil;
import org.dcache.srm.client.PromiscuousHostAuthorization;
import org.dcache.srm.client.Transport;
import org.dcache.srm.client.TransportUtil;
import org.dcache.srm.client.axis.FileMetaData;
import org.dcache.srm.client.axis.ISRM_PortType;
import org.dcache.srm.client.axis.RequestStatus;
import org.dcache.srm.client.axis.SRMServerV1Locator;
import org.globus.axis.transport.GSIHTTPSender;
import org.globus.axis.util.Util;
import org.globus.util.GlobusURL;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SRMClientV1
implements ISRM {
    private static final Logger logger = LoggerFactory.getLogger(SRMClientV1.class);
    private static final String SFN_STRING = "?SFN=";
    private static final String WEB_SERVICE_PATH = "srm/managerv1";
    private static final String GSS_EXPECTED_NAME = "host";
    private int retries;
    private long retrytimeout;
    private final ISRM_PortType axis_isrm;
    private GSSCredential user_cred;
    private String service_url;
    private String host;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String unwrapHttpRedirection(String http_url) {
        if (http_url == null || !http_url.startsWith("http://")) {
            return http_url;
        }
        HttpURLConnection http_connection = null;
        InputStream in = null;
        try {
            URL http_URL = new URL(http_url);
            URLConnection connection = http_URL.openConnection();
            connection.setDoInput(true);
            connection.setDoOutput(false);
            if (connection instanceof HttpURLConnection) {
                http_connection = (HttpURLConnection)connection;
                http_connection.setInstanceFollowRedirects(true);
                in = http_connection.getInputStream();
                URL new_url = http_connection.getURL();
                String string = new_url.toString();
                return string;
            }
        }
        catch (IOException ioe) {
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (http_connection != null) {
                    http_connection.disconnect();
                }
            }
            catch (IOException ioe) {}
        }
        return http_url;
    }

    public SRMClientV1(GlobusURL srmurl, GSSCredential user_cred, long retrytimeout, int numberofretries, boolean do_delegation, boolean full_delegation, Transport transport) throws IOException, InterruptedException, ServiceException {
        this(srmurl, user_cred, retrytimeout, numberofretries, do_delegation, full_delegation, GSS_EXPECTED_NAME, WEB_SERVICE_PATH, transport);
    }

    public SRMClientV1(GlobusURL srmurl, GSSCredential user_cred, long retrytimeout, int numberofretries, boolean do_delegation, boolean full_delegation, String gss_expected_name, String webservice_path, Transport transport) throws IOException, InterruptedException, ServiceException {
        String path;
        this.retrytimeout = retrytimeout;
        this.retries = numberofretries;
        this.user_cred = user_cred;
        if (user_cred == null) {
            throw new NullPointerException("user credential is null");
        }
        try {
            logger.debug("user credentials are: {} ", (Object)user_cred.getName());
            if (user_cred.getRemainingLifetime() < 60) {
                throw new IOException("credential remaining lifetime is less then a minute ");
            }
        }
        catch (GSSException gsse) {
            throw new IOException(gsse.toString());
        }
        this.host = srmurl.getHost();
        this.host = InetAddress.getByName(this.host).getCanonicalHostName();
        int port = srmurl.getPort();
        if (port == 80) {
            transport = Transport.TCP;
        }
        if ((path = srmurl.getPath()) == null) {
            path = "/";
        }
        this.service_url = TransportUtil.uriSchemaFor(transport) + "://" + this.host + ":" + port;
        int indx = path.indexOf(SFN_STRING);
        if (indx > 0) {
            String service_postfix = path.substring(0, indx);
            if (!service_postfix.startsWith("/")) {
                this.service_url = this.service_url + "/";
            }
            this.service_url = this.service_url + service_postfix;
        } else {
            this.service_url = this.service_url + "/" + webservice_path;
        }
        logger.debug("SRMClientV1 calling org.globus.axis.util.Util.registerTransport() ");
        Util.registerTransport();
        SimpleProvider provider = new SimpleProvider();
        SimpleTargetedChain c = null;
        c = new SimpleTargetedChain((Handler)new GSIHTTPSender());
        provider.deployTransport("httpg", (Handler)c);
        c = new SimpleTargetedChain((Handler)new HTTPSender());
        provider.deployTransport("http", (Handler)c);
        SRMServerV1Locator sl = new SRMServerV1Locator((EngineConfiguration)provider);
        URL url = new URL(this.service_url);
        logger.debug("connecting to srm at {}", (Object)this.service_url);
        this.axis_isrm = sl.getISRM(url);
        if (this.axis_isrm instanceof Stub) {
            Stub axis_isrm_as_stub = (Stub)this.axis_isrm;
            axis_isrm_as_stub._setProperty("org.globus.gsi.credentials", (Object)user_cred);
            axis_isrm_as_stub._setProperty("org.globus.gsi.authorization", (Object)new PromiscuousHostAuthorization());
            if (TransportUtil.hasGsiMode(transport)) {
                String gsiMode = TransportUtil.gsiModeFor(transport, do_delegation, full_delegation);
                axis_isrm_as_stub._setProperty("org.globus.gsi.mode", (Object)gsiMode);
            }
        } else {
            throw new IOException("can't set properties to the axis_isrm");
        }
    }

    @Override
    public diskCacheV111.srm.RequestStatus put(String[] sources, String[] dests, long[] sizes, boolean[] wantPerm, String[] protocols) {
        logger.debug(" put, contacting service {} ", (Object)this.service_url);
        int i = 0;
        try {
            if (this.user_cred.getRemainingLifetime() < 60) {
                throw new RuntimeException("credential remaining lifetime is less than one minute ");
            }
        }
        catch (GSSException gsse) {
            throw new RuntimeException(gsse);
        }
        try {
            try {
                RequestStatus rs = this.axis_isrm.put(sources, dests, sizes, wantPerm, protocols);
                return ConvertUtil.axisRS2RS(rs);
            }
            catch (RemoteException re) {
                throw new RuntimeException(re);
            }
        }
        catch (RuntimeException e) {
            logger.error("put: try #  {} failed with error {}", (Object)i, (Object)e.getMessage());
            throw e;
        }
    }

    @Override
    public diskCacheV111.srm.RequestStatus get(String[] surls, String[] protocols) {
        int i = 0;
        try {
            if (this.user_cred.getRemainingLifetime() < 60) {
                throw new RuntimeException("credential remaining lifetime is less then a minute ");
            }
        }
        catch (GSSException gsse) {
            throw new RuntimeException(gsse);
        }
        try {
            try {
                RequestStatus rs = this.axis_isrm.get(surls, protocols);
                return ConvertUtil.axisRS2RS(rs);
            }
            catch (RemoteException re) {
                logger.debug(re.toString());
                throw new RuntimeException(re.toString());
            }
        }
        catch (RuntimeException e) {
            logger.error("get : try # " + i + " failed with error " + e.getMessage());
            throw e;
        }
    }

    @Override
    public diskCacheV111.srm.RequestStatus copy(String[] srcSURLS, String[] destSURLS, boolean[] wantPerm) {
        logger.debug(" copy, contacting service {} ", (Object)this.service_url);
        int i = 0;
        try {
            if (this.user_cred.getRemainingLifetime() < 60) {
                throw new RuntimeException("credential remaining lifetime is less then a minute ");
            }
        }
        catch (GSSException gsse) {
            throw new RuntimeException(gsse);
        }
        try {
            try {
                RequestStatus rs = this.axis_isrm.copy(srcSURLS, destSURLS, wantPerm);
                return ConvertUtil.axisRS2RS(rs);
            }
            catch (RemoteException re) {
                throw new RuntimeException(re.toString());
            }
        }
        catch (RuntimeException e) {
            logger.error("copy: try #  {} failed with error {} ", (Object)i, (Object)e.getMessage());
            throw e;
        }
    }

    @Override
    public diskCacheV111.srm.RequestStatus getRequestStatus(int requestId) {
        int i = 0;
        while (true) {
            try {
                if (this.user_cred.getRemainingLifetime() < 60) {
                    throw new RuntimeException("credential remaining lifetime is less then a minute ");
                }
            }
            catch (GSSException gsse) {
                throw new RuntimeException(gsse);
            }
            try {
                try {
                    RequestStatus rs = this.axis_isrm.getRequestStatus(requestId);
                    return ConvertUtil.axisRS2RS(rs);
                }
                catch (RemoteException re) {
                    throw new RuntimeException(re.toString());
                }
            }
            catch (RuntimeException e) {
                logger.error("getRequestStatus: try # {} failed with error ", (Object)i, (Object)e.getMessage());
                if (i < this.retries) {
                    ++i;
                } else {
                    throw e;
                }
                logger.error("getRequestStatus: try again");
                try {
                    long timeout = this.retrytimeout * (long)i;
                    logger.debug("sleeping for {} milliseconds before retrying", (Object)timeout);
                    Thread.sleep(timeout);
                }
                catch (InterruptedException interruptedException) {
                }
                continue;
            }
            break;
        }
    }

    @Override
    public boolean ping() {
        logger.debug(" ping, contacting service {} ", (Object)this.service_url);
        int i = 0;
        while (true) {
            try {
                if (this.user_cred.getRemainingLifetime() < 60) {
                    throw new RuntimeException("credential remaining lifetime is less then a minute ");
                }
            }
            catch (GSSException gsse) {
                throw new RuntimeException(gsse);
            }
            try {
                try {
                    return this.axis_isrm.ping();
                }
                catch (RemoteException re) {
                    throw new RuntimeException(re.toString());
                }
            }
            catch (RuntimeException e) {
                logger.error("ping: try # {} failed with error {}", (Object)i, (Object)e.getMessage());
                if (i < this.retries) {
                    ++i;
                } else {
                    throw e;
                }
                logger.error("ping: try again");
                try {
                    long timeout = this.retrytimeout * (long)i;
                    logger.debug("sleeping for {} milliseconds before retrying", (Object)timeout);
                    Thread.sleep(timeout);
                }
                catch (InterruptedException interruptedException) {
                }
                continue;
            }
            break;
        }
    }

    @Override
    public diskCacheV111.srm.RequestStatus mkPermanent(String[] SURLS) {
        throw new UnsupportedOperationException("Not Implemented");
    }

    @Override
    public diskCacheV111.srm.RequestStatus pin(String[] TURLS) {
        throw new UnsupportedOperationException("Not Implemented");
    }

    @Override
    public diskCacheV111.srm.RequestStatus unPin(String[] TURLS, int requestID) {
        throw new UnsupportedOperationException("Not Implemented");
    }

    @Override
    public diskCacheV111.srm.RequestStatus getEstGetTime(String[] SURLS, String[] protocols) {
        throw new UnsupportedOperationException("Not Implemented");
    }

    @Override
    public diskCacheV111.srm.RequestStatus getEstPutTime(String[] src_names, String[] dest_names, long[] sizes, boolean[] wantPermanent, String[] protocols) {
        throw new UnsupportedOperationException("Not Implemented");
    }

    @Override
    public diskCacheV111.srm.FileMetaData[] getFileMetaData(String[] SURLS) {
        if (this.axis_isrm == null) {
            throw new NullPointerException("both isrms are null!!!!");
        }
        logger.debug(" getFileMetaData, contacting service {}", (Object)this.service_url);
        int i = 0;
        while (true) {
            try {
                if (this.user_cred.getRemainingLifetime() < 60) {
                    throw new RuntimeException("credential remaining lifetime is less then a minute ");
                }
            }
            catch (GSSException gsse) {
                throw new RuntimeException(gsse);
            }
            try {
                try {
                    FileMetaData[] fmd = this.axis_isrm.getFileMetaData(SURLS);
                    return ConvertUtil.axisFMDs2FMDs(fmd);
                }
                catch (RemoteException re) {
                    throw new RuntimeException(re.toString());
                }
            }
            catch (RuntimeException e) {
                logger.error("copy: try # {} failed with error {}", (Object)i, (Object)e.getMessage());
                if (i < this.retries) {
                    ++i;
                } else {
                    throw e;
                }
                logger.error("copy: try again");
                try {
                    long timeout = this.retrytimeout * (long)i;
                    logger.debug("sleeping for {} milliseconds before retrying", (Object)timeout);
                    Thread.sleep(timeout);
                }
                catch (InterruptedException interruptedException) {
                }
                continue;
            }
            break;
        }
    }

    @Override
    public diskCacheV111.srm.RequestStatus setFileStatus(int requestId, int fileId, String state) {
        int i = 0;
        try {
            if (this.user_cred.getRemainingLifetime() < 60) {
                throw new RuntimeException("credential remaining lifetime is less then a minute ");
            }
        }
        catch (GSSException gsse) {
            throw new RuntimeException(gsse);
        }
        try {
            try {
                RequestStatus rs = this.axis_isrm.setFileStatus(requestId, fileId, state);
                return ConvertUtil.axisRS2RS(rs);
            }
            catch (RemoteException re) {
                throw new RuntimeException(re.toString());
            }
        }
        catch (RuntimeException e) {
            logger.error("getRequestStatus: try # {} failed with error ", (Object)i, (Object)e.getMessage());
            throw e;
        }
    }

    @Override
    public void advisoryDelete(String[] SURLS) {
        logger.debug(" advisoryDelete, contacting service {}", (Object)this.service_url);
        try {
            if (this.user_cred.getRemainingLifetime() < 60) {
                throw new RuntimeException("credential remaining lifetime is less then a minute ");
            }
        }
        catch (GSSException gsse) {
            throw new RuntimeException(gsse);
        }
        try {
            this.axis_isrm.advisoryDelete(SURLS);
            return;
        }
        catch (RemoteException re) {
            String message = re.getMessage();
            if (message != null) {
                throw new RuntimeException(message);
            }
            throw new RuntimeException(re);
        }
    }

    @Override
    public String[] getProtocols() {
        logger.debug(" getProtocols, contacting service " + this.service_url);
        int i = 0;
        while (true) {
            try {
                if (this.user_cred.getRemainingLifetime() < 60) {
                    throw new RuntimeException("credential remaining lifetime is less then a minute ");
                }
            }
            catch (GSSException gsse) {
                throw new RuntimeException(gsse);
            }
            try {
                try {
                    String[] protocols = this.axis_isrm.getProtocols();
                    return protocols;
                }
                catch (RemoteException re) {
                    throw new RuntimeException(re.toString());
                }
            }
            catch (RuntimeException e) {
                logger.error("getProtocols: try # {} failed with error ", (Object)i, (Object)e.getMessage());
                if (i < this.retries) {
                    ++i;
                } else {
                    throw e;
                }
                logger.error("getProtocols: try again");
                try {
                    long timeout = this.retrytimeout * (long)i;
                    logger.debug("sleeping for {} milliseconds before retrying", (Object)timeout);
                    Thread.sleep(timeout);
                }
                catch (InterruptedException interruptedException) {
                }
                continue;
            }
            break;
        }
    }
}

