/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.srm;

import diskCacheV111.srm.RequestStatus;
import diskCacheV111.srm.StorageElementInfo;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.URI;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dcache.commons.stats.MonitoringProxy;
import org.dcache.commons.stats.RequestCounters;
import org.dcache.commons.stats.RequestExecutionTimeGauges;
import org.dcache.commons.stats.rrd.RrdRequestCounters;
import org.dcache.commons.stats.rrd.RrdRequestExecutionTimeGauges;
import org.dcache.srm.AbstractStorageElement;
import org.dcache.srm.AdvisoryDeleteCallbacks;
import org.dcache.srm.FileMetaData;
import org.dcache.srm.SRMException;
import org.dcache.srm.SRMInvalidRequestException;
import org.dcache.srm.SRMProtocol;
import org.dcache.srm.SRMUser;
import org.dcache.srm.request.BringOnlineFileRequest;
import org.dcache.srm.request.BringOnlineRequest;
import org.dcache.srm.request.ContainerRequest;
import org.dcache.srm.request.CopyFileRequest;
import org.dcache.srm.request.CopyRequest;
import org.dcache.srm.request.FileRequest;
import org.dcache.srm.request.GetFileRequest;
import org.dcache.srm.request.GetRequest;
import org.dcache.srm.request.LsFileRequest;
import org.dcache.srm.request.LsRequest;
import org.dcache.srm.request.PutFileRequest;
import org.dcache.srm.request.PutRequest;
import org.dcache.srm.request.Request;
import org.dcache.srm.request.RequestCredential;
import org.dcache.srm.request.RequestCredentialStorage;
import org.dcache.srm.request.ReserveSpaceRequest;
import org.dcache.srm.request.sql.DatabaseJobStorageFactory;
import org.dcache.srm.request.sql.DatabaseRequestCredentialStorage;
import org.dcache.srm.request.sql.DatabaseRequestStorage;
import org.dcache.srm.request.sql.JdbcConnectionPool;
import org.dcache.srm.request.sql.RequestsPropertyStorage;
import org.dcache.srm.scheduler.IllegalStateTransition;
import org.dcache.srm.scheduler.Job;
import org.dcache.srm.scheduler.JobStorage;
import org.dcache.srm.scheduler.JobStorageFactory;
import org.dcache.srm.scheduler.Scheduler;
import org.dcache.srm.scheduler.SchedulerFactory;
import org.dcache.srm.scheduler.State;
import org.dcache.srm.util.Configuration;
import org.dcache.srm.v2_2.TFileStorageType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SRM {
    private static final Logger logger = LoggerFactory.getLogger(SRM.class);
    private final InetAddress host;
    private final Configuration configuration;
    private final RequestCredentialStorage requestCredentialStorage;
    private AbstractStorageElement storage;
    private final RequestCounters<Class<?>> srmServerV2Counters;
    private final RequestCounters<String> srmServerV1Counters;
    private final RequestCounters<Method> abstractStorageElementCounters;
    private RrdRequestCounters<?> rrdSrmServerV2Counters;
    private RrdRequestCounters<?> rrdSrmServerV1Counters;
    private RrdRequestCounters<?> rrdAstractStorageElementCounters;
    private final RequestExecutionTimeGauges<Class<?>> srmServerV2Gauges;
    private final RequestExecutionTimeGauges<String> srmServerV1Gauges;
    private final RequestExecutionTimeGauges<Method> abstractStorageElementGauges;
    private RrdRequestExecutionTimeGauges<?> rrdSrmServerV2Gauges;
    private RrdRequestExecutionTimeGauges<?> rrdSrmServerV1Gauges;
    private RrdRequestExecutionTimeGauges<?> rrdAstractStorageElementGauges;
    private static SRM srm;

    private SRM(Configuration config, String name) throws IOException, SQLException, InterruptedException, IllegalStateTransition {
        Object rrddir;
        this.configuration = config;
        this.storage = config.getStorage();
        this.abstractStorageElementCounters = new RequestCounters(this.storage.getClass().getName());
        this.abstractStorageElementGauges = new RequestExecutionTimeGauges(this.storage.getClass().getName());
        this.storage = (AbstractStorageElement)MonitoringProxy.decorateWithMonitoringProxy((Class[])new Class[]{AbstractStorageElement.class}, (Object)this.storage, this.abstractStorageElementCounters, this.abstractStorageElementGauges);
        config.setStorage(this.storage);
        this.srmServerV2Counters = new RequestCounters("SRMServerV2");
        this.srmServerV1Counters = new RequestCounters("SRMServerV1");
        if (this.configuration.getCounterRrdDirectory() != null) {
            rrddir = this.configuration.getCounterRrdDirectory() + File.separatorChar + "srmv1";
            this.rrdSrmServerV1Counters = new RrdRequestCounters(this.srmServerV1Counters, (String)rrddir);
            this.rrdSrmServerV1Counters.startRrdUpdates();
            this.rrdSrmServerV1Counters.startRrdGraphPlots();
            rrddir = this.configuration.getCounterRrdDirectory() + File.separatorChar + "srmv2";
            this.rrdSrmServerV2Counters = new RrdRequestCounters(this.srmServerV2Counters, (String)rrddir);
            this.rrdSrmServerV2Counters.startRrdUpdates();
            this.rrdSrmServerV2Counters.startRrdGraphPlots();
            rrddir = this.configuration.getCounterRrdDirectory() + File.separatorChar + "storage";
            this.rrdAstractStorageElementCounters = new RrdRequestCounters(this.abstractStorageElementCounters, (String)rrddir);
            this.rrdAstractStorageElementCounters.startRrdUpdates();
            this.rrdAstractStorageElementCounters.startRrdGraphPlots();
        }
        this.srmServerV2Gauges = new RequestExecutionTimeGauges("SRMServerV2");
        this.srmServerV1Gauges = new RequestExecutionTimeGauges("SRMServerV1");
        if (this.configuration.getGaugeRrdDirectory() != null) {
            rrddir = new File(this.configuration.getGaugeRrdDirectory() + File.separatorChar + "srmv1");
            this.rrdSrmServerV1Gauges = new RrdRequestExecutionTimeGauges(this.srmServerV1Gauges, (File)rrddir);
            this.rrdSrmServerV1Gauges.startRrdUpdates();
            this.rrdSrmServerV1Gauges.startRrdGraphPlots();
            rrddir = new File(this.configuration.getGaugeRrdDirectory() + File.separatorChar + "srmv2");
            this.rrdSrmServerV2Gauges = new RrdRequestExecutionTimeGauges(this.srmServerV2Gauges, (File)rrddir);
            this.rrdSrmServerV2Gauges.startRrdUpdates();
            this.rrdSrmServerV2Gauges.startRrdGraphPlots();
            rrddir = new File(this.configuration.getGaugeRrdDirectory() + File.separatorChar + "storage");
            this.rrdAstractStorageElementGauges = new RrdRequestExecutionTimeGauges(this.abstractStorageElementGauges, (File)rrddir);
            this.rrdAstractStorageElementGauges.startRrdUpdates();
            this.rrdAstractStorageElementGauges.startRrdGraphPlots();
        }
        if (this.configuration.getMaxQueuedJdbcTasksNum() != null) {
            logger.debug("setMaxJdbcTasksNum to " + this.configuration.getMaxQueuedJdbcTasksNum());
            JdbcConnectionPool.setMaxQueuedJdbcTasksNum(this.configuration.getMaxQueuedJdbcTasksNum());
        }
        if (this.configuration.getJdbcExecutionThreadNum() != null) {
            logger.debug("set JDBC ExecutionThreadNum to " + this.configuration.getJdbcExecutionThreadNum());
            JdbcConnectionPool.setExecutionThreadNum(this.configuration.getJdbcExecutionThreadNum());
        }
        if (config.isGsissl()) {
            String protocol_property = System.getProperty("java.protocol.handler.pkgs");
            protocol_property = protocol_property == null ? "org.globus.net.protocol" : protocol_property + "|org.globus.net.protocol";
            System.setProperty("java.protocol.handler.pkgs", protocol_property);
        }
        try {
            RequestsPropertyStorage.initPropertyStorage(config.getJdbcUrl(), config.getJdbcClass(), config.getJdbcUser(), config.getJdbcPass(), config.getNextRequestIdStorageTable());
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.requestCredentialStorage = new DatabaseRequestCredentialStorage(config);
        RequestCredential.registerRequestCredentialStorage(this.requestCredentialStorage);
        SchedulerFactory.initSchedulerFactory(config, name);
        JobStorageFactory.initJobStorageFactory(new DatabaseJobStorageFactory(this.configuration));
        this.host = InetAddress.getLocalHost();
        this.configuration.addSrmHost(this.host.getCanonicalHostName());
        logger.debug("srm started :\n\t" + this.configuration.toString());
    }

    public static final synchronized SRM getSRM(Configuration configuration, String name) throws IOException, SQLException, InterruptedException, IllegalStateTransition {
        if (srm != null) {
            return srm;
        }
        srm = new SRM(configuration, name);
        SRM.class.notifyAll();
        return srm;
    }

    public static final synchronized SRM getInstance(long timeout) throws InterruptedException, TimeoutException {
        long time_expired = 0L;
        long wait_period = 1000L;
        while (srm == null) {
            System.out.println(new Date() + " Waiting for srm initialization to complete.");
            SRM.class.wait(wait_period);
            if ((time_expired += wait_period) <= timeout) continue;
            throw new TimeoutException("startup takes longer then timeout");
        }
        return srm;
    }

    public static final synchronized SRM getSRM() {
        return srm;
    }

    public void stop() {
        Job.shutdown();
        SchedulerFactory.getSchedulerFactory().shutdown();
    }

    public InetAddress getHost() {
        return this.host;
    }

    public int getPort() {
        return this.configuration.getPort();
    }

    public RequestCounters<Class<?>> getSrmServerV2Counters() {
        return this.srmServerV2Counters;
    }

    public RequestCounters<String> getSrmServerV1Counters() {
        return this.srmServerV1Counters;
    }

    public RequestExecutionTimeGauges<Class<?>> getSrmServerV2Gauges() {
        return this.srmServerV2Gauges;
    }

    public RequestExecutionTimeGauges<String> getSrmServerV1Gauges() {
        return this.srmServerV1Gauges;
    }

    public final AbstractStorageElement getStorage() {
        return this.storage;
    }

    public RequestCounters<Method> getAbstractStorageElementCounters() {
        return this.abstractStorageElementCounters;
    }

    public RequestExecutionTimeGauges<Method> getAbstractStorageElementGauges() {
        return this.abstractStorageElementGauges;
    }

    public void advisoryDelete(SRMUser user, RequestCredential credential, String[] SURLS) {
        logger.debug("SRM.advisoryDelete");
        if (user == null) {
            String error = "advisoryDelete: user is unknown, user needs authorization to delete ";
            logger.error(error);
            throw new IllegalArgumentException(error);
        }
        TheAdvisoryDeleteCallbacks[] callabacks_array = new TheAdvisoryDeleteCallbacks[SURLS.length];
        for (int i = 0; i < SURLS.length; ++i) {
            try {
                URI surl = new URI(SURLS[i]);
                callabacks_array[i] = new TheAdvisoryDeleteCallbacks(user, surl);
                this.storage.advisoryDelete(user, surl, callabacks_array[i]);
                continue;
            }
            catch (RuntimeException re) {
                logger.error(re.toString());
                throw re;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        boolean failed = false;
        StringBuilder errorsb = new StringBuilder();
        try {
            for (int i = 0; i < SURLS.length; ++i) {
                if (callabacks_array[i].waitCompleteion(180000L)) continue;
                failed = true;
                errorsb.append(callabacks_array[i].getError()).append('\n');
            }
        }
        catch (InterruptedException ie) {
            throw new RuntimeException(ie);
        }
        if (failed) {
            throw new RuntimeException(errorsb.toString());
        }
    }

    public RequestStatus copy(SRMUser user, RequestCredential credential, String[] srcSURLS, String[] destSURLS, boolean[] wantPerm, String client_host) {
        try {
            int j;
            long cred_lifetime = credential.getDelegatedCredentialRemainingLifetime() - 600000L;
            if (cred_lifetime < 0L) {
                return this.createFailedRequestStatus("delegated credentials lifetime is too short:" + credential.getDelegatedCredentialRemainingLifetime() + " ms");
            }
            if (srcSURLS == null || srcSURLS.length == 0 || destSURLS == null || destSURLS.length == 0) {
                String error = " number of source or destination SURLs is zero";
                logger.error(error);
                return this.createFailedRequestStatus(error);
            }
            String[] from_urls = srcSURLS;
            String[] to_urls = destSURLS;
            int src_num = from_urls.length;
            int dst_num = to_urls.length;
            StringBuilder sb = new StringBuilder(" copy (");
            for (j = 0; j < src_num; ++j) {
                sb.append("from_urls[").append(j).append("]=").append(from_urls[j]).append(",");
            }
            for (j = 0; j < dst_num; ++j) {
                sb.append("to_urls[").append(j).append("]=").append(to_urls[j]).append(",");
            }
            sb.append(")");
            logger.debug(sb.toString());
            if (src_num != dst_num) {
                return this.createFailedRequestStatus("number of from and to urls do not match");
            }
            for (int i = 0; i < dst_num; ++i) {
                for (int j2 = 0; j2 < dst_num; ++j2) {
                    if (i == j2 || !to_urls[i].equals(to_urls[j2])) continue;
                    return this.createFailedRequestStatus("list of sources contains the same url twice url#" + i + " is " + to_urls[i] + " and url#" + j2 + " is " + to_urls[j2]);
                }
            }
            long lifetime = this.configuration.getCopyLifetime();
            if (cred_lifetime < lifetime) {
                logger.debug("credential lifetime is less than default lifetime, using credential lifetime =" + cred_lifetime);
                lifetime = cred_lifetime;
            }
            logger.debug("calling Request.createCopyRequest()");
            CopyRequest r = new CopyRequest(user, credential.getId(), from_urls, to_urls, null, lifetime, this.configuration.getCopyRetryTimeout(), this.configuration.getCopyMaxNumOfRetries(), SRMProtocol.V1_1, TFileStorageType.PERMANENT, null, null, null, client_host, null);
            logger.debug(" Copy Request = " + r);
            r.schedule();
            RequestStatus rs = r.getRequestStatus();
            logger.debug(" copy returns RequestStatus = " + rs);
            return rs;
        }
        catch (Exception e) {
            logger.error(e.toString());
            return this.createFailedRequestStatus("copy request generated error : " + e);
        }
    }

    public RequestStatus get(SRMUser user, RequestCredential credential, String[] surls, String[] protocols, String client_host) {
        try {
            logger.debug("get(): user = " + user);
            String[] supportedProtocols = this.storage.supportedGetProtocols();
            boolean foundMatchedProtocol = false;
            block2: for (String supportedProtocol : supportedProtocols) {
                for (String protocol : protocols) {
                    if (!supportedProtocol.equals(protocol)) continue;
                    foundMatchedProtocol = true;
                    continue block2;
                }
            }
            if (!foundMatchedProtocol) {
                StringBuilder errorsb = new StringBuilder("Protocol(s) specified not supported: [ ");
                for (String protocol : protocols) {
                    errorsb.append(protocol).append(' ');
                }
                errorsb.append(']');
                return this.createFailedRequestStatus(errorsb.toString());
            }
            GetRequest r = new GetRequest(user, credential.getId(), surls, protocols, this.configuration.getGetLifetime(), this.configuration.getGetRetryTimeout(), this.configuration.getGetMaxNumOfRetries(), null, client_host);
            ((Job)r).schedule();
            RequestStatus rs = r.getRequestStatus();
            logger.debug("get() initial RequestStatus = " + rs);
            return rs;
        }
        catch (Exception e) {
            logger.error(e.toString());
            return this.createFailedRequestStatus("get error " + e);
        }
    }

    public RequestStatus getEstGetTime(SRMUser user, RequestCredential credential, String[] SURLS, String[] protocols) {
        return this.createFailedRequestStatus("time is unknown");
    }

    public RequestStatus getEstPutTime(SRMUser user, RequestCredential credential, String[] src_names, String[] dest_names, long[] sizes, boolean[] wantPermanent, String[] protocols) {
        return this.createFailedRequestStatus("time is unknown");
    }

    public diskCacheV111.srm.FileMetaData[] getFileMetaData(SRMUser user, RequestCredential credential, String[] SURLS) {
        StringBuilder sb = new StringBuilder();
        sb.append("getFileMetaData(");
        if (SURLS == null) {
            sb.append("SURLS are null)");
            logger.debug(sb.toString());
            throw new IllegalArgumentException(sb.toString());
        }
        int len = SURLS.length;
        for (int i = 0; i < len; ++i) {
            sb.append(SURLS[i] + ",");
        }
        sb.append(")");
        logger.debug(sb.toString());
        diskCacheV111.srm.FileMetaData[] fmds = new diskCacheV111.srm.FileMetaData[len];
        for (int i = 0; i < len; ++i) {
            try {
                URI surl = new URI(SURLS[i]);
                logger.debug("getFileMetaData(String[]) calling FileMetaData({})", (Object)surl);
                FileMetaData fmd = this.storage.getFileMetaData(user, surl, false);
                fmd.SURL = SURLS[i];
                fmds[i] = new diskCacheV111.srm.FileMetaData(fmd);
                logger.debug("FileMetaData[" + i + "]=" + fmds[i]);
                continue;
            }
            catch (Exception e) {
                logger.error("getFileMetaData failed to parse SURL: " + e);
                throw new IllegalArgumentException("getFileMetaData failed to parse SURL: " + e);
            }
        }
        return fmds;
    }

    public String[] getProtocols(SRMUser user, RequestCredential credential) {
        try {
            return this.storage.supportedGetProtocols();
        }
        catch (SRMException srme) {
            return new String[0];
        }
    }

    public RequestStatus getRequestStatus(SRMUser user, RequestCredential credential, int requestId) {
        logger.debug(" getRequestStatus(" + user + "," + requestId + ")");
        try {
            logger.debug("getRequestStatus() Request.getRequest(" + requestId + ");");
            ContainerRequest r = Job.getJob(Long.valueOf(requestId), ContainerRequest.class);
            logger.debug("getRequestStatus() received Request  ");
            if (r != null) {
                SRMUser requestUser = r.getUser();
                if (requestUser == null || requestUser.equals(user)) {
                    RequestStatus rs = r.getRequestStatus();
                    logger.debug("obtained request status, returning rs for request id=" + requestId);
                    return rs;
                }
                return this.createFailedRequestStatus("getRequestStatus(): request #" + requestId + " owned by " + requestUser + " does not belong to user " + user, requestId);
            }
            return this.createFailedRequestStatus("getRequestStatus() request #" + requestId + " was not found", requestId);
        }
        catch (Exception e) {
            logger.error(e.toString());
            return this.createFailedRequestStatus("getting request #" + requestId + " generated error : " + e, requestId);
        }
    }

    public RequestStatus mkPermanent(SRMUser user, RequestCredential credential, String[] SURLS) {
        return this.createFailedRequestStatus("not supported, all files are already permanent");
    }

    public RequestStatus pin(SRMUser user, RequestCredential credential, String[] TURLS) {
        return this.createFailedRequestStatus("pins by users are not supported, use get instead");
    }

    public boolean ping(SRMUser user, RequestCredential credential) {
        return true;
    }

    public RequestStatus put(SRMUser user, RequestCredential credential, String[] sources, String[] dests, long[] sizes, boolean[] wantPerm, String[] protocols, String clientHost) {
        int i;
        int len = dests.length;
        String[] dests_urls = new String[len];
        for (i = 0; i < len; ++i) {
            for (int j = 0; j < len; ++j) {
                if (i == j || !dests[i].equals(dests[j])) continue;
                return this.createFailedRequestStatus("put(): list of sources contains the same url twice url#" + i + " is " + dests[i] + " and url#" + j + " is " + dests[j]);
            }
        }
        String srmprefix = "srm://" + this.configuration.getSrmHost() + ":" + this.configuration.getPort() + "/";
        for (i = 0; i < len; ++i) {
            dests_urls[i] = dests[i].startsWith("srm://") ? dests[i] : srmprefix + dests[i];
        }
        try {
            String[] supportedProtocols = this.storage.supportedPutProtocols();
            boolean foundMatchedProtocol = false;
            block5: for (String supportedProtocol : supportedProtocols) {
                for (String protocol : protocols) {
                    if (!supportedProtocol.equals(protocol)) continue;
                    foundMatchedProtocol = true;
                    continue block5;
                }
            }
            if (!foundMatchedProtocol) {
                StringBuilder errorsb = new StringBuilder("Protocol(s) specified not supported: [ ");
                for (String protocol : protocols) {
                    errorsb.append(protocol).append(' ');
                }
                errorsb.append(']');
                return this.createFailedRequestStatus(errorsb.toString());
            }
            PutRequest r = new PutRequest(user, credential.getId(), sources, dests_urls, sizes, wantPerm, protocols, this.configuration.getPutLifetime(), this.configuration.getPutRetryTimeout(), this.configuration.getPutMaxNumOfRetries(), clientHost, null, null, null, null);
            ((Job)r).schedule();
            return r.getRequestStatus();
        }
        catch (Exception e) {
            logger.error(e.toString());
            return this.createFailedRequestStatus("put(): error " + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RequestStatus setFileStatus(SRMUser user, RequestCredential credential, int requestId, int fileRequestId, String state) {
        try {
            logger.debug(" setFileStatus(" + requestId + "," + fileRequestId + "," + state + ");");
            if (!state.equalsIgnoreCase("done") && !state.equalsIgnoreCase("running")) {
                return this.createFailedRequestStatus("setFileStatus(): incorrect state " + state);
            }
            ContainerRequest r = Job.getJob(Long.valueOf(requestId), ContainerRequest.class);
            SRMUser req_user = r.getUser();
            if (req_user != null && !req_user.equals(user)) {
                return this.createFailedRequestStatus("request #" + requestId + " owned by " + req_user + " does not belong to user " + user);
            }
            FileRequest fr = r.getFileRequest(fileRequestId);
            if (fr == null) {
                return this.createFailedRequestStatus("request #" + requestId + " does not contain file request #" + fileRequestId);
            }
            FileRequest fileRequest = fr;
            synchronized (fileRequest) {
                block17: {
                    State s = fr.getState();
                    if (s.isFinalState()) {
                        logger.debug("can not set status, the file status is already " + (Object)((Object)s));
                    } else if (state.equalsIgnoreCase("done") && fr instanceof PutFileRequest && (s == State.READY || s == State.RUNNING)) {
                        PutFileRequest pfr = (PutFileRequest)fr;
                        if (pfr.getTurlString() != null) {
                            try {
                                if (this.storage.exists(user, pfr.getSurl())) {
                                    fr.setStatus(state);
                                    break block17;
                                }
                                pfr.setState(State.FAILED, "file transfer was not performed on SURL");
                            }
                            catch (SRMException srme) {
                                pfr.setState(State.FAILED, "file transfer was not performed on SURL");
                            }
                        }
                    } else {
                        logger.debug(" calling fr.setStatus(\"" + state + "\")");
                        fr.setStatus(state);
                    }
                }
            }
            return r.getRequestStatus();
        }
        catch (SRMInvalidRequestException e) {
            return this.createFailedRequestStatus(e.getMessage());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public RequestStatus unPin(SRMUser user, RequestCredential credential, String[] TURLS, int requestId) {
        return this.createFailedRequestStatus("pins by users are not supported, use get instead");
    }

    public ContainerRequest getRequest(Integer id) {
        try {
            return Job.getJob((Long)((Object)id), ContainerRequest.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private RequestStatus createFailedRequestStatus(String error) {
        logger.error("creating a failed request status with a message: " + error);
        RequestStatus rs = new RequestStatus();
        rs.requestId = -1;
        rs.errorMessage = error;
        rs.state = "Failed";
        return rs;
    }

    private RequestStatus createFailedRequestStatus(String error, int requestId) {
        logger.error("creating a failed request status with a message: " + error);
        RequestStatus rs = new RequestStatus();
        rs.requestId = requestId;
        rs.errorMessage = error;
        rs.state = "Failed";
        return rs;
    }

    public StorageElementInfo getStorageElementInfo(SRMUser user, RequestCredential credential) throws SRMException {
        return this.storage.getStorageElementInfo(user);
    }

    public void listGetRequests(StringBuilder sb) throws SQLException {
        this.listRequests(sb, GetRequest.class);
    }

    public Set<Long> getGetRequestIds(SRMUser user, String description) throws SQLException {
        return SRM.getActiveJobIds(GetRequest.class, description);
    }

    public Set<Long> getLsRequestIds(SRMUser user, String description) throws SQLException {
        return SRM.getActiveJobIds(LsRequest.class, description);
    }

    public void listLatestCompletedGetRequests(StringBuilder sb, int maxCount) throws SQLException {
        Set<Long> requestIds = this.getGetStorage().getLatestCompletedRequestIds(maxCount);
        this.listRequests(sb, requestIds, GetRequest.class);
    }

    public void listLatestFailedGetRequests(StringBuilder sb, int maxCount) throws SQLException {
        Set<Long> requestIds = this.getGetStorage().getLatestFailedRequestIds(maxCount);
        this.listRequests(sb, requestIds, GetRequest.class);
    }

    public void listLatestDoneGetRequests(StringBuilder sb, int maxCount) throws SQLException {
        Set<Long> requestIds = this.getGetStorage().getLatestDoneRequestIds(maxCount);
        this.listRequests(sb, requestIds, GetRequest.class);
    }

    public void listLatestCanceledGetRequests(StringBuilder sb, int maxCount) throws SQLException {
        Set<Long> requestIds = this.getGetStorage().getLatestCanceledRequestIds(maxCount);
        this.listRequests(sb, requestIds, GetRequest.class);
    }

    public void printGetSchedulerInfo(StringBuilder sb) throws SQLException {
        this.getGetRequestScheduler().getInfo(sb);
    }

    public void printLsSchedulerInfo(StringBuilder sb) throws SQLException {
        this.getLsRequestScheduler().getInfo(sb);
    }

    public void printGetSchedulerThreadQueue(StringBuilder sb) throws SQLException {
        this.getGetRequestScheduler().printThreadQueue(sb);
    }

    public void printGetSchedulerPriorityThreadQueue(StringBuilder sb) throws SQLException {
        this.getGetRequestScheduler().printPriorityThreadQueue(sb);
    }

    public void printGetSchedulerReadyThreadQueue(StringBuilder sb) throws SQLException {
        this.getGetRequestScheduler().printReadyQueue(sb);
    }

    public void printLsSchedulerThreadQueue(StringBuilder sb) throws SQLException {
        this.getLsRequestScheduler().printThreadQueue(sb);
    }

    public void printLsSchedulerPriorityThreadQueue(StringBuilder sb) throws SQLException {
        this.getLsRequestScheduler().printPriorityThreadQueue(sb);
    }

    public void printLsSchedulerReadyThreadQueue(StringBuilder sb) throws SQLException {
        this.getLsRequestScheduler().printReadyQueue(sb);
    }

    public void listPutRequests(StringBuilder sb) throws SQLException {
        this.listRequests(sb, PutRequest.class);
    }

    public Set<Long> getPutRequestIds(SRMUser user, String description) throws SQLException {
        return SRM.getActiveJobIds(PutRequest.class, description);
    }

    public void listLatestCompletedPutRequests(StringBuilder sb, int maxCount) throws SQLException {
        Set<Long> requestIds = this.getPutStorage().getLatestCompletedRequestIds(maxCount);
        this.listRequests(sb, requestIds, PutRequest.class);
    }

    public void listLatestFailedPutRequests(StringBuilder sb, int maxCount) throws SQLException {
        Set<Long> requestIds = this.getPutStorage().getLatestFailedRequestIds(maxCount);
        this.listRequests(sb, requestIds, PutRequest.class);
    }

    public void listLatestCanceledPutRequests(StringBuilder sb, int maxCount) throws SQLException {
        Set<Long> requestIds = this.getPutStorage().getLatestCanceledRequestIds(maxCount);
        this.listRequests(sb, requestIds, PutRequest.class);
    }

    public void listLatestDonePutRequests(StringBuilder sb, int maxCount) throws SQLException {
        Set<Long> requestIds = this.getPutStorage().getLatestDoneRequestIds(maxCount);
        this.listRequests(sb, requestIds, PutRequest.class);
    }

    public void printPutSchedulerInfo(StringBuilder sb) throws SQLException {
        this.getPutRequestScheduler().getInfo(sb);
    }

    public void printPutSchedulerThreadQueue(StringBuilder sb) throws SQLException {
        this.getPutRequestScheduler().printThreadQueue(sb);
    }

    public void printPutSchedulerPriorityThreadQueue(StringBuilder sb) throws SQLException {
        this.getPutRequestScheduler().printPriorityThreadQueue(sb);
    }

    public void printPutSchedulerReadyThreadQueue(StringBuilder sb) throws SQLException {
        this.getPutRequestScheduler().printReadyQueue(sb);
    }

    public void listCopyRequests(StringBuilder sb) throws SQLException {
        this.listRequests(sb, CopyRequest.class);
    }

    public Set<Long> getCopyRequestIds(SRMUser user, String description) throws SQLException {
        return SRM.getActiveJobIds(CopyRequest.class, description);
    }

    public void listLatestCompletedCopyRequests(StringBuilder sb, int maxCount) throws SQLException {
        Set<Long> requestIds = this.getCopyStorage().getLatestCompletedRequestIds(maxCount);
        this.listRequests(sb, requestIds, CopyRequest.class);
    }

    public void listLatestFailedCopyRequests(StringBuilder sb, int maxCount) throws SQLException {
        Set<Long> requestIds = this.getCopyStorage().getLatestFailedRequestIds(maxCount);
        this.listRequests(sb, requestIds, CopyRequest.class);
    }

    public void listLatestCanceledCopyRequests(StringBuilder sb, int maxCount) throws SQLException {
        Set<Long> requestIds = this.getCopyStorage().getLatestCanceledRequestIds(maxCount);
        this.listRequests(sb, requestIds, CopyRequest.class);
    }

    public void listLatestDoneCopyRequests(StringBuilder sb, int maxCount) throws SQLException {
        Set<Long> requestIds = this.getCopyStorage().getLatestDoneRequestIds(maxCount);
        this.listRequests(sb, requestIds, CopyRequest.class);
    }

    public void printCopySchedulerInfo(StringBuilder sb) throws SQLException {
        this.getCopyRequestScheduler().getInfo(sb);
    }

    public void printCopySchedulerThreadQueue(StringBuilder sb) throws SQLException {
        this.getCopyRequestScheduler().printThreadQueue(sb);
    }

    public void printCopySchedulerPriorityThreadQueue(StringBuilder sb) throws SQLException {
        this.getCopyRequestScheduler().printPriorityThreadQueue(sb);
    }

    public void printCopySchedulerReadyThreadQueue(StringBuilder sb) throws SQLException {
        this.getCopyRequestScheduler().printReadyQueue(sb);
    }

    public void listBringOnlineRequests(StringBuilder sb) throws SQLException {
        this.listRequests(sb, BringOnlineRequest.class);
    }

    public Set<Long> getBringOnlineRequestIds(SRMUser user, String description) throws SQLException {
        return SRM.getActiveJobIds(BringOnlineRequest.class, description);
    }

    public void listLatestCompletedBringOnlineRequests(StringBuilder sb, int maxCount) throws SQLException {
        Set<Long> requestIds = this.getBringOnlineStorage().getLatestCompletedRequestIds(maxCount);
        this.listRequests(sb, requestIds, BringOnlineRequest.class);
    }

    public void listLatestFailedBringOnlineRequests(StringBuilder sb, int maxCount) throws SQLException {
        Set<Long> requestIds = this.getBringOnlineStorage().getLatestFailedRequestIds(maxCount);
        this.listRequests(sb, requestIds, BringOnlineRequest.class);
    }

    public void listLatestCanceledBringOnlineRequests(StringBuilder sb, int maxCount) throws SQLException {
        Set<Long> requestIds = this.getBringOnlineStorage().getLatestCanceledRequestIds(maxCount);
        this.listRequests(sb, requestIds, BringOnlineRequest.class);
    }

    public void listLatestDoneBringOnlineRequests(StringBuilder sb, int maxCount) throws SQLException {
        Set<Long> requestIds = this.getBringOnlineStorage().getLatestDoneRequestIds(maxCount);
        this.listRequests(sb, requestIds, BringOnlineRequest.class);
    }

    public void printBringOnlineSchedulerInfo(StringBuilder sb) throws SQLException {
        this.getBringOnlineRequestScheduler().getInfo(sb);
    }

    public void printBringOnlineSchedulerThreadQueue(StringBuilder sb) throws SQLException {
        this.getBringOnlineRequestScheduler().printThreadQueue(sb);
    }

    public void printBringOnlineSchedulerPriorityThreadQueue(StringBuilder sb) throws SQLException {
        this.getBringOnlineRequestScheduler().printPriorityThreadQueue(sb);
    }

    public void printBringOnlineSchedulerReadyThreadQueue(StringBuilder sb) throws SQLException {
        this.getBringOnlineRequestScheduler().printReadyQueue(sb);
    }

    private Scheduler getScheduler(Class<? extends Job> requestType) {
        return SchedulerFactory.getSchedulerFactory().getScheduler(requestType);
    }

    public void listReserveSpaceRequests(StringBuilder sb) throws SQLException {
        this.listRequests(sb, ReserveSpaceRequest.class);
    }

    public void listLsRequests(StringBuilder sb) throws SQLException {
        this.listRequests(sb, LsRequest.class);
    }

    private final <T extends Job> void listRequests(StringBuilder sb, Set<Long> requestIds, Class<T> type) throws SQLException {
        for (Long requestId : requestIds) {
            try {
                T request = Job.getJob(requestId, type);
                sb.append(request).append('\n');
            }
            catch (SRMInvalidRequestException ire) {
                logger.error(ire.toString());
            }
        }
    }

    private <T extends Request> void listRequests(StringBuilder sb, Class<T> clazz) throws SQLException {
        Set<Request> requests = Job.getActiveJobs(clazz);
        for (Request request : requests) {
            request.toString(sb, false);
            sb.append('\n');
        }
    }

    public double getLoad() {
        int copyRunning = this.getCopyRequestScheduler().getTotalRunningThreads();
        int maxCopyRunning = this.getCopyRequestScheduler().getThreadPoolSize();
        int getRunning = this.getGetRequestScheduler().getTotalRunningThreads();
        int maxGetRunning = this.getGetRequestScheduler().getThreadPoolSize();
        int putRunning = this.getPutRequestScheduler().getTotalRunningThreads();
        int maxPutRunning = this.getPutRequestScheduler().getThreadPoolSize();
        double load = (double)copyRunning / (double)maxCopyRunning / 3.0 + (double)getRunning / (double)maxGetRunning / 3.0 + (double)putRunning / (double)maxPutRunning / 3.0;
        return load;
    }

    public void listRequest(StringBuilder sb, Long requestId, boolean longformat) throws SQLException, SRMInvalidRequestException {
        Job job = Job.getJob(requestId, Job.class);
        if (job == null) {
            sb.append("request with reqiest id " + requestId + " is not found\n");
            return;
        }
        job.toString(sb, longformat);
    }

    public void cancelRequest(StringBuilder sb, Long requestId) throws SQLException, SRMInvalidRequestException {
        Job job = Job.getJob(requestId, Job.class);
        if (job == null || !(job instanceof ContainerRequest)) {
            sb.append("request with reqiest id " + requestId + " is not found\n");
            return;
        }
        ContainerRequest r = (ContainerRequest)job;
        try {
            r.setState(State.CANCELED, "Canceled by admin through cancel command");
            sb.append("state changed, no guarantee that the proccess will end immediately\n");
            sb.append(r.toString(false)).append('\n');
        }
        catch (IllegalStateTransition ist) {
            sb.append("Illegal State Transition : " + ist.getMessage());
            logger.error("Illegal State Transition : " + ist.getMessage());
        }
    }

    public void cancelAllGetRequest(StringBuilder sb, String pattern) throws SQLException, SRMInvalidRequestException {
        this.cancelAllRequest(sb, pattern, this.getGetRequestScheduler(), this.getGetStorage());
    }

    public void cancelAllBringOnlineRequest(StringBuilder sb, String pattern) throws SQLException, SRMInvalidRequestException {
        this.cancelAllRequest(sb, pattern, this.getBringOnlineRequestScheduler(), this.getBringOnlineStorage());
    }

    public void cancelAllPutRequest(StringBuilder sb, String pattern) throws SQLException, SRMInvalidRequestException {
        this.cancelAllRequest(sb, pattern, this.getPutRequestScheduler(), this.getPutStorage());
    }

    public void cancelAllCopyRequest(StringBuilder sb, String pattern) throws SQLException, SRMInvalidRequestException {
        this.cancelAllRequest(sb, pattern, this.getCopyRequestScheduler(), this.getCopyStorage());
    }

    public void cancelAllReserveSpaceRequest(StringBuilder sb, String pattern) throws SQLException, SRMInvalidRequestException {
        this.cancelAllRequest(sb, pattern, this.getReserveSpaceScheduler(), this.getReserveSpaceRequestStorage());
    }

    public void cancelAllLsRequests(StringBuilder sb, String pattern) throws SQLException, SRMInvalidRequestException {
        this.cancelAllRequest(sb, pattern, this.getLsRequestScheduler(), this.getLsRequestStorage());
    }

    private void cancelAllRequest(StringBuilder sb, String pattern, Scheduler scheduler, DatabaseRequestStorage storage) throws SQLException, SRMInvalidRequestException {
        HashSet<Long> jobsToKill = new HashSet<Long>();
        Pattern p = Pattern.compile(pattern);
        Set<Long> activeRequestIds = storage.getActiveRequestIds(scheduler.getId());
        for (Long requestId : activeRequestIds) {
            Matcher m = p.matcher(requestId.toString());
            if (!m.matches()) continue;
            logger.debug("cancelAllRequest: request Id #" + requestId + " in " + scheduler + " matches pattern!");
            jobsToKill.add(requestId);
        }
        if (jobsToKill.isEmpty()) {
            sb.append("no requests match the pattern=\"" + pattern + " in scheduler " + scheduler + "\n");
            return;
        }
        for (Long requestId : jobsToKill) {
            try {
                final ContainerRequest job = Job.getJob(requestId, ContainerRequest.class);
                sb.append("request #" + requestId + " matches pattern=\"" + pattern + "\"; canceling request \n");
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            job.setState(State.CANCELED, "Canceled by admin through cancelall command");
                        }
                        catch (IllegalStateTransition ist) {
                            logger.error("Illegal State Transition : " + ist.getMessage());
                        }
                    }
                }).start();
            }
            catch (SRMInvalidRequestException e) {
                logger.error(" request with request id " + requestId + " is not found\n");
            }
        }
    }

    public final Configuration getConfiguration() {
        return this.configuration;
    }

    public RequestCredentialStorage getRequestCredentialStorage() {
        return this.requestCredentialStorage;
    }

    public Scheduler getGetRequestScheduler() {
        return this.getScheduler(GetFileRequest.class);
    }

    public Scheduler getBringOnlineRequestScheduler() {
        return this.getScheduler(BringOnlineFileRequest.class);
    }

    public Scheduler getPutRequestScheduler() {
        return this.getScheduler(PutFileRequest.class);
    }

    public Scheduler getCopyRequestScheduler() {
        return this.getScheduler(CopyRequest.class);
    }

    public DatabaseRequestStorage getReserveSpaceRequestStorage() {
        return (DatabaseRequestStorage)JobStorageFactory.getJobStorageFactory().getJobStorage(ReserveSpaceRequest.class);
    }

    public DatabaseRequestStorage getLsRequestStorage() {
        return (DatabaseRequestStorage)JobStorageFactory.getJobStorageFactory().getJobStorage(LsRequest.class);
    }

    public JobStorage getLsFileRequestStorage() {
        return JobStorageFactory.getJobStorageFactory().getJobStorage(LsFileRequest.class);
    }

    public DatabaseRequestStorage getBringOnlineStorage() {
        return (DatabaseRequestStorage)JobStorageFactory.getJobStorageFactory().getJobStorage(BringOnlineRequest.class);
    }

    public DatabaseRequestStorage getGetStorage() {
        return (DatabaseRequestStorage)JobStorageFactory.getJobStorageFactory().getJobStorage(GetRequest.class);
    }

    public DatabaseRequestStorage getPutStorage() {
        return (DatabaseRequestStorage)JobStorageFactory.getJobStorageFactory().getJobStorage(PutRequest.class);
    }

    public DatabaseRequestStorage getCopyStorage() {
        return (DatabaseRequestStorage)JobStorageFactory.getJobStorageFactory().getJobStorage(CopyRequest.class);
    }

    public JobStorage getBringOnlineFileRequestStorage() {
        return JobStorageFactory.getJobStorageFactory().getJobStorage(BringOnlineFileRequest.class);
    }

    public JobStorage getGetFileRequestStorage() {
        return JobStorageFactory.getJobStorageFactory().getJobStorage(GetFileRequest.class);
    }

    public JobStorage getPutFileRequestStorage() {
        return JobStorageFactory.getJobStorageFactory().getJobStorage(PutFileRequest.class);
    }

    public JobStorage getCopyFileRequestStorage() {
        return JobStorageFactory.getJobStorageFactory().getJobStorage(CopyFileRequest.class);
    }

    public Scheduler getReserveSpaceScheduler() {
        return this.getScheduler(ReserveSpaceRequest.class);
    }

    public Scheduler getLsRequestScheduler() {
        return this.getScheduler(LsFileRequest.class);
    }

    public static <T extends Job> Set<Long> getActiveJobIds(Class<T> type, String description) {
        Set<Job> jobs = Job.getActiveJobs(type);
        HashSet<Long> ids = new HashSet<Long>();
        for (Job job : jobs) {
            if (description != null) {
                Request r;
                if (!(job instanceof Request) || !description.equals((r = (Request)job).getDescription())) continue;
                ids.add(job.getId());
                continue;
            }
            ids.add(job.getId());
        }
        return ids;
    }

    private class TheAdvisoryDeleteCallbacks
    implements AdvisoryDeleteCallbacks {
        private boolean done = false;
        private boolean success = true;
        SRMUser user;
        URI surl;
        String error;

        public TheAdvisoryDeleteCallbacks(SRMUser user, URI surl) {
            this.user = user;
            this.surl = surl;
        }

        @Override
        public void AdvisoryDeleteFailed(String reason) {
            this.error = " advisoryDelete(" + this.user + "," + this.surl + ") AdvisoryDeleteFailed: " + reason;
            this.success = false;
            logger.error(this.error);
            this.done();
        }

        @Override
        public void AdvisoryDeleteSuccesseded() {
            logger.debug(" advisoryDelete(" + this.user + "," + this.surl + ") AdvisoryDeleteSuccesseded");
            this.done();
        }

        @Override
        public void Exception(Exception e) {
            this.error = " advisoryDelete(" + this.user + "," + this.surl + ") Exception :" + e;
            logger.error(this.error);
            this.success = false;
            this.done();
        }

        @Override
        public void Timeout() {
            this.error = " advisoryDelete(" + this.user + "," + this.surl + ") Timeout ";
            logger.error(this.error);
            this.success = false;
            this.done();
        }

        @Override
        public void Error(String error) {
            this.error = " advisoryDelete(" + this.user + "," + this.surl + ") Error " + error;
            logger.error(this.error);
            this.success = false;
            this.done();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean waitCompleteion(long timeout) throws InterruptedException {
            long starttime = System.currentTimeMillis();
            while (true) {
                TheAdvisoryDeleteCallbacks theAdvisoryDeleteCallbacks = this;
                synchronized (theAdvisoryDeleteCallbacks) {
                    this.wait(1000L);
                    if (this.done) {
                        return this.success;
                    }
                    if (System.currentTimeMillis() - starttime > timeout) {
                        this.error = " advisoryDelete(" + this.user + "," + this.surl + ") Timeout";
                        return false;
                    }
                }
            }
        }

        public synchronized void done() {
            this.done = true;
            this.notifyAll();
        }

        public String getError() {
            return this.error;
        }
    }
}

