/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.core.UnsupportedDatabase;
import liquibase.exception.DatabaseException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.logging.LogFactory;
import liquibase.servicelocator.ServiceLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseFactory {
    private static DatabaseFactory instance;
    private List<Database> implementedDatabases = new ArrayList<Database>();

    protected DatabaseFactory() {
        try {
            Class[] classes;
            for (Class clazz : classes = ServiceLocator.getInstance().findClasses(Database.class)) {
                this.register((Database)clazz.getConstructor(new Class[0]).newInstance(new Object[0]));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static DatabaseFactory getInstance() {
        if (instance == null) {
            instance = new DatabaseFactory();
        }
        return instance;
    }

    public static void reset() {
        instance = new DatabaseFactory();
    }

    public List<Database> getImplementedDatabases() {
        return this.implementedDatabases;
    }

    public void register(Database database) {
        this.implementedDatabases.add(0, database);
    }

    public Database findCorrectDatabaseImplementation(DatabaseConnection connection) throws DatabaseException {
        Database returnDatabase;
        TreeSet<Database> foundDatabases = new TreeSet<Database>(new Comparator<Database>(){

            @Override
            public int compare(Database o1, Database o2) {
                return -1 * new Integer(o1.getPriority()).compareTo(o2.getPriority());
            }
        });
        for (Database implementedDatabase : this.getImplementedDatabases()) {
            if (!implementedDatabase.isCorrectDatabaseImplementation(connection)) continue;
            foundDatabases.add(implementedDatabase);
        }
        if (foundDatabases.size() == 0) {
            LogFactory.getLogger().warning("Unknown database: " + connection.getDatabaseProductName());
            return new UnsupportedDatabase();
        }
        try {
            returnDatabase = (Database)((Database)foundDatabases.iterator().next()).getClass().newInstance();
        }
        catch (Exception e) {
            throw new UnexpectedLiquibaseException(e);
        }
        returnDatabase.setConnection(connection);
        return returnDatabase;
    }

    public String findDefaultDriver(String url) {
        for (Database database : this.getImplementedDatabases()) {
            String defaultDriver = database.getDefaultDriver(url);
            if (defaultDriver == null) continue;
            return defaultDriver;
        }
        return null;
    }

    public void clearRegistry() {
        this.implementedDatabases.clear();
    }
}

