/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.nis;

import com.sun.jndi.internal.onc.yp.domainname;
import com.sun.jndi.internal.onc.yp.service2;
import com.sun.jndi.internal.onc.yp.ypmaplist;
import com.sun.jndi.internal.onc.yp.ypresp_maplist;
import com.sun.jndi.nis.NISBaseCtx;
import com.sun.jndi.nis.NISCtx;
import com.sun.jndi.nis.NISCtxFactory;
import com.sun.jndi.nis.NISDomainServerPair;
import com.sun.jndi.nis.NISMap;
import com.sun.jndi.toolkit.ctx.Continuation;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.ConfigurationException;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.spi.DirectoryManager;

final class NISMapList
extends NISBaseCtx {
    private String domainName = null;
    private String hostName = null;
    private Vector maplist;
    private static Hashtable preDefinedMaps = new Hashtable();
    static /* synthetic */ Class class$com$sun$jndi$nis$NISCtx;

    static {
        preDefinedMaps.put("mail", "mail.aliases");
        preDefinedMaps.put("netmasks", "netmasks.byaddr");
        preDefinedMaps.put("bootparams", "bootparams");
        preDefinedMaps.put("ethers", "ethers.byname");
        preDefinedMaps.put("group", "group.byname");
        preDefinedMaps.put("hosts", "hosts.byname");
        preDefinedMaps.put("locale", "locale");
        preDefinedMaps.put("netgroup", "netgroup");
        preDefinedMaps.put("networks", "networks.byname");
        preDefinedMaps.put("passwd", "passwd.byname");
        preDefinedMaps.put("printers", "printers.conf.byname");
        preDefinedMaps.put("printers.conf", "printers.conf.byname");
        preDefinedMaps.put("protocols", "protocols.byname");
        preDefinedMaps.put("rpc", "rpc.bynumber");
        preDefinedMaps.put("services", "services.byname");
        preDefinedMaps.put("timezone", "timezone.byname");
    }

    NISMapList(String string, String string2, Hashtable hashtable) throws NamingException {
        super(hashtable);
        this.domainName = string;
        this.hostName = string2;
        if (this.domainName == null) {
            throw new ConfigurationException("Unspecified NIS domainname");
        }
        if (this.hostName == null && (this.hostName = NISDomainServerPair.broadcastForServer(this.domainName)) == null) {
            throw new ConfigurationException("Unspecified NIS server");
        }
    }

    protected Object c_lookup(Name name, Continuation continuation) throws NamingException {
        if (name.isEmpty()) {
            return this;
        }
        String string = this.checkMapExist(name.toString());
        if (string != null) {
            continuation.setSuccess();
            NISCtx nISCtx = NISCtxFactory.getNISCtxInstance(this.domainName, this.hostName, string, this.environment);
            try {
                return DirectoryManager.getObjectInstance(nISCtx, name, this, this.environment, null);
            }
            catch (NamingException namingException) {
                throw continuation.fillInException(namingException);
            }
            catch (Exception exception) {
                NamingException namingException = new NamingException("problem generating object using object factory");
                namingException.setRootCause(exception);
                throw continuation.fillInException(namingException);
            }
        }
        continuation.setError((Object)this, name);
        NameNotFoundException nameNotFoundException = new NameNotFoundException();
        throw continuation.fillInException(nameNotFoundException);
    }

    private String checkMapExist(String string) throws NamingException {
        String string2;
        String string3 = (String)preDefinedMaps.get(string);
        if (string3 != null) {
            return string3;
        }
        if (NISMap.checkMap(this.domainName, this.hostName, string)) {
            return string;
        }
        if (string.indexOf(46) < 0 && NISMap.checkMap(this.domainName, this.hostName, string2 = String.valueOf(string) + ".byname")) {
            return string2;
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected NamingEnumeration getBindingList(boolean bl) throws NamingException {
        return new NISBindingList(this.getMapList(), bl);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized Vector getMapList() throws NamingException {
        service2 service22;
        block12: {
            Vector vector;
            block11: {
                if (this.maplist != null) {
                    return this.maplist;
                }
                service22 = null;
                try {
                    try {
                        service22 = new service2(this.hostName, true);
                        service22.YPPROC_NULL();
                        domainname domainname2 = new domainname();
                        domainname2.data = this.domainName;
                        ypresp_maplist ypresp_maplist2 = service22.YPPROC_MAPLIST(domainname2);
                        if (ypresp_maplist2.stat.value == 1) {
                            vector = this.maplist = this.sanitizeMapNames(ypresp_maplist2.maps);
                            Object var4_7 = null;
                            if (service22 == null) return vector;
                            break block11;
                        }
                        NamingException namingException = NISMap.mapStatusToException(ypresp_maplist2.stat.value);
                        if (namingException != null) {
                            throw namingException;
                        }
                        break block12;
                    }
                    catch (IOException iOException) {
                        NamingException namingException = new NamingException();
                        namingException.setRootCause(iOException);
                        throw namingException;
                    }
                }
                catch (Throwable throwable) {
                    Object var4_9 = null;
                    if (service22 == null) throw throwable;
                    try {
                        service22.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
            }
            try {}
            catch (IOException iOException) {}
            service22.close();
            return vector;
        }
        Object var4_8 = null;
        if (service22 == null) return null;
        try {}
        catch (IOException iOException) {
            return null;
        }
        service22.close();
        return null;
    }

    protected String getMyName() {
        return "system";
    }

    protected NamingEnumeration getNameClassList() throws NamingException {
        return new NISNCList(this.getMapList());
    }

    public String getNameInNamespace() {
        return "system";
    }

    private Vector sanitizeMapNames(ypmaplist ypmaplist2) {
        Vector<String> vector = new Vector<String>();
        ypmaplist ypmaplist3 = ypmaplist2;
        while (ypmaplist3 != null) {
            String string = ypmaplist3.map.data;
            if (!vector.contains(string)) {
                vector.addElement(string);
            }
            ypmaplist3 = ypmaplist3.next;
        }
        return vector;
    }

    class NISNCList
    extends NISBaseCtx.NISEnum {
        protected Enumeration maps;

        NISNCList(Vector vector) {
            this.maps = vector.elements();
        }

        public void close() {
            this.maps = null;
        }

        public boolean hasMore() throws NamingException {
            return this.maps.hasMoreElements();
        }

        public Object next() throws NamingException {
            String string = (String)this.maps.nextElement();
            return new NameClassPair(string, (class$com$sun$jndi$nis$NISCtx != null ? class$com$sun$jndi$nis$NISCtx : (class$com$sun$jndi$nis$NISCtx = NISMapList.class$("com.sun.jndi.nis.NISCtx"))).getName());
        }
    }

    class NISBindingList
    extends NISNCList {
        private boolean callNamingManager;

        NISBindingList(Vector vector, boolean bl) {
            super(vector);
            this.callNamingManager = bl;
        }

        public Object next() throws NamingException {
            String string = (String)this.maps.nextElement();
            Object object = NISCtxFactory.getNISCtxInstance(NISMapList.this.domainName, NISMapList.this.hostName, string, NISMapList.this.environment);
            if (this.callNamingManager) {
                try {
                    CompositeName compositeName = new CompositeName();
                    compositeName.add(string);
                    object = DirectoryManager.getObjectInstance(object, compositeName, NISMapList.this, NISMapList.this.environment, null);
                }
                catch (NamingException namingException) {
                    throw namingException;
                }
                catch (Exception exception) {
                    NamingException namingException = new NamingException("problem generating object using object factory");
                    namingException.setRootCause(exception);
                    throw namingException;
                }
            }
            return new Binding(string, object);
        }
    }
}

