/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.nis;

import com.sun.jndi.internal.onc.yp.domainname;
import com.sun.jndi.internal.onc.yp.service2;
import com.sun.jndi.nis.NISBaseCtx;
import com.sun.jndi.nis.NISCtxFactory;
import com.sun.jndi.nis.NISDomainServerPair;
import com.sun.jndi.nis.NISMapList;
import com.sun.jndi.toolkit.ctx.Continuation;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.ConfigurationException;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.ServiceUnavailableException;
import javax.naming.spi.DirectoryManager;

public final class NISInitCtx
extends NISBaseCtx {
    private Hashtable initTab = new Hashtable(11);
    static String nisRootName = "system";
    private String domain;
    private String server;

    public NISInitCtx(String string, String string2, Hashtable hashtable) {
        super(hashtable);
        try {
            this.init(string, string2, hashtable, false);
        }
        catch (NamingException namingException) {}
    }

    public NISInitCtx(String string, Hashtable hashtable, boolean bl, boolean bl2) throws NamingException {
        super(hashtable);
        this.createUsingURL(string, hashtable, bl, bl2);
    }

    public NISInitCtx(Hashtable hashtable) throws NamingException {
        this(hashtable, false);
    }

    public NISInitCtx(Hashtable hashtable, boolean bl) throws NamingException {
        super(hashtable);
        String string;
        String string2 = string = hashtable != null ? (String)hashtable.get("java.naming.provider.url") : null;
        if (string == null) {
            throw new ConfigurationException("NIS requires specification of a NIS domain name");
        }
        this.createUsingURL(string, hashtable, false, bl);
    }

    protected Object c_lookup(Name name, Continuation continuation) throws NamingException {
        if (name.isEmpty()) {
            continuation.setSuccess();
            return this;
        }
        String string = name.toString();
        Object v = this.initTab.get(string);
        if (v != null) {
            continuation.setSuccess();
            try {
                return DirectoryManager.getObjectInstance(v, name, this, this.environment, null);
            }
            catch (NamingException namingException) {
                throw continuation.fillInException(namingException);
            }
            catch (Exception exception) {
                NamingException namingException = new NamingException("problem generating object using object factory");
                namingException.setRootCause(exception);
                throw continuation.fillInException(namingException);
            }
        }
        continuation.setError((Object)this, name);
        NameNotFoundException nameNotFoundException = new NameNotFoundException();
        throw continuation.fillInException(nameNotFoundException);
    }

    private void createUsingURL(String string, Hashtable hashtable, boolean bl, boolean bl2) throws NamingException {
        String string2;
        NISDomainServerPair nISDomainServerPair = NISDomainServerPair.parseURL(string);
        if (nISDomainServerPair == null) {
            throw new ConfigurationException("Invalid NIS URL: " + string);
        }
        if (nISDomainServerPair.domain == null) {
            throw new ConfigurationException("Unspecified NIS domain: " + string);
        }
        if ((nISDomainServerPair.server == null || bl) && (string2 = NISDomainServerPair.broadcastForServer(nISDomainServerPair.domain)) != null) {
            this.init(nISDomainServerPair.domain, string2, hashtable, false);
            return;
        }
        if (nISDomainServerPair.server == null) {
            throw new ConfigurationException("Unspecified NIS server: " + string);
        }
        this.init(nISDomainServerPair.domain, nISDomainServerPair.server, hashtable, bl2);
    }

    protected NamingEnumeration getBindingList(boolean bl) throws NamingException {
        return new NISBindingList(bl);
    }

    protected String getMyName() {
        return "";
    }

    protected NamingEnumeration getNameClassList() throws NamingException {
        return new NISNCList();
    }

    public String getNameInNamespace() {
        return "";
    }

    private void init(String string, String string2, Hashtable hashtable, boolean bl) throws NamingException {
        if (bl) {
            domainname domainname2 = new domainname();
            domainname2.data = string;
            boolean bl2 = false;
            try {
                service2 service22 = new service2(string2, false);
                bl2 = service22.YPPROC_DOMAIN(domainname2);
                service22.close();
            }
            catch (IOException iOException) {}
            if (!bl2) {
                throw new ServiceUnavailableException(String.valueOf(string2) + " for " + string + " not responding");
            }
        }
        this.domain = string;
        this.server = string2;
        if (this.environment == null) {
            this.environment = new Hashtable(5, 0.75f);
        }
        this.environment.put("java.naming.provider.url", "nis://" + string2 + "/" + string);
        this.initTab.put(nisRootName, new NISMapList(this.domain, this.server, this.environment));
        this.initTab.put("user", NISCtxFactory.getNISCtxInstance(this.domain, this.server, "passwd", this.environment));
        this.initTab.put("host", NISCtxFactory.getNISCtxInstance(this.domain, this.server, "hosts", this.environment));
    }

    class NISNCList
    extends NISBaseCtx.NISEnum {
        protected Enumeration list;

        NISNCList() {
            this.list = NISInitCtx.this.initTab.keys();
        }

        public void close() {
            this.list = null;
        }

        public boolean hasMore() throws NamingException {
            return this.list.hasMoreElements();
        }

        public Object next() throws NamingException {
            String string = (String)this.list.nextElement();
            Object v = NISInitCtx.this.initTab.get(string);
            return new NameClassPair(string, v == null ? null : v.getClass().getName());
        }
    }

    class NISBindingList
    extends NISNCList {
        private boolean callNamingManager;

        NISBindingList(boolean bl) {
            this.callNamingManager = bl;
        }

        public Object next() throws NamingException {
            String string = (String)this.list.nextElement();
            Object object = NISInitCtx.this.initTab.get(string);
            if (this.callNamingManager) {
                try {
                    CompositeName compositeName = new CompositeName();
                    compositeName.add(string);
                    object = DirectoryManager.getObjectInstance(object, compositeName, NISInitCtx.this, NISInitCtx.this.environment, null);
                }
                catch (NamingException namingException) {
                    throw namingException;
                }
                catch (Exception exception) {
                    NamingException namingException = new NamingException("problem generating object using object factory");
                    namingException.setRootCause(exception);
                    throw namingException;
                }
            }
            return new Binding(string, object);
        }
    }
}

